cc ------------ dpmjet3.4 - authors: S.Roesler, R.Engel, J.Ranft -------
cc -------- phojet1.12-40 - authors: S.Roesler, R.Engel, J.Ranft -------
cc                                                      - oct'13 -------
cc ----------- pythia-6.4 - authors: Torbjorn Sjostrand, Lund'10 -------
cc ---------------------------------------------------------------------
cc                                  converted for use with FLUKA -------
cc                                                      - oct'13 -------
 
C...PYGFXX
C...Auxiliary to PYRGHM.
 
      SUBROUTINE PYGFXX(MA,TANB,MQ,MUR,MD,MTOP,AT,AB,XMU,XMGL,VH,
     *  STOP1,STOP2,SBOT1,SBOT2,DELTAMT,DELTAMB)
      IMPLICIT DOUBLE PRECISION(A-H,M,O-Z)
      DIMENSION VH(2,2),VH3T(2,2),VH3B(2,2),AL(2,2)
C...Commonblocks.
      include 'inc/pydat1'
      include 'inc/pydat2'
 
      G(X,Y) = 2.D0 - (X+Y)/(X-Y)*DLOG(X/Y)
 
      T(X,Y,Z) = (X**2*Y**2*LOG(X**2/Y**2) + X**2*Z**2*LOG(Z**2/X**2)
     * + Y**2*Z**2*LOG(Y**2/Z**2))/((X**2-Y**2)*(Y**2-Z**2)*(X**2-Z**2))
 
      IF(ABS(XMU).LT.0.000001D0) XMU = 0.000001D0
      MQ2 = MQ**2
      MUR2 = MUR**2
      MD2 = MD**2
      TANBA = TANB
      SINBA = TANBA/SQRT(TANBA**2+1D0)
      COSBA = SINBA/TANBA
 
      SINB = TANB/SQRT(TANB**2+1D0)
      COSB = SINB/TANB
 
      PI = PARU(1)
      MZ = PMAS(23,1)
      MW = PMAS(24,1)
      SW = 1D0-MW**2/MZ**2
      V  = 174.1D0
 
      ALPHA3 = 0.12D0/(1D0+23/12D0/PI*0.12D0*LOG(MTOP**2/MZ**2))
      G2 = SQRT(0.0336D0*4D0*PI)
      G1 = SQRT(0.0101D0*4D0*PI)
 
      IF(MQ.GT.MUR) MST = MQ
      IF(MUR.GT.MQ.OR.MUR.EQ.MQ) MST = MUR
 
      MSUSYT = SQRT(MST**2  + MTOP**2)
 
      IF(MQ.GT.MD) MSB = MQ
      IF(MD.GT.MQ.OR.MD.EQ.MQ) MSB = MD
 
      MB = PYMRUN(5,MSB**2)
      MSUSYB = SQRT(MSB**2 + MB**2)
      TT = LOG(MSUSYT**2/MTOP**2)
      TB = LOG(MSUSYB**2/MTOP**2)
 
      RMTOP = MTOP/(1D0+4D0*ALPHA3/3D0/PI)
      HT = RMTOP/(V*SINB)
      HTST = RMTOP/V
      HB = MB/V/COSB
      G32 = ALPHA3*4D0*PI
      BT2 = -(8D0*G32 - 9D0*HT**2/2D0 - HB**2/2D0)/(4D0*PI)**2
      BB2 = -(8D0*G32 - 9D0*HB**2/2D0 - HT**2/2D0)/(4D0*PI)**2
      AL2 = 3D0/8D0/PI**2*HT**2
C      BT2ST = -(8.*G32 - 9.*HTST**2/2.)/(4.*PI)**2
C      ALST = 3./8./PI**2*HTST**2
      AL1 = 3D0/8D0/PI**2*HB**2
 
      AL(1,1) = AL1
      AL(1,2) = (AL2+AL1)/2D0
      AL(2,1) = (AL2+AL1)/2D0
      AL(2,2) = AL2
 
      IF(MA.GT.MTOP) THEN
        VI = V*(1D0 + 3D0/32D0/PI**2*HTST**2*
     *        LOG(MTOP**2/MA**2))
        H1I = VI* COSBA
        H2I = VI*SINBA
        H1T = H1I*(1D0+3D0/8D0/PI**2*HB**2*LOG(MA**2/MSUSYT**2))**.25D0
        H2T = H2I*(1D0+3D0/8D0/PI**2*HT**2*LOG(MA**2/MSUSYT**2))**.25D0
        H1B = H1I*(1D0+3D0/8D0/PI**2*HB**2*LOG(MA**2/MSUSYB**2))**.25D0
        H2B = H2I*(1D0+3D0/8D0/PI**2*HT**2*LOG(MA**2/MSUSYB**2))**.25D0
      ELSE
        VI = V
        H1I = VI*COSB
        H2I = VI*SINB
        H1T=H1I*(1D0+3D0/8D0/PI**2*HB**2*LOG(MTOP**2/MSUSYT**2))**.25D0
        H2T=H2I*(1D0+3D0/8D0/PI**2*HT**2*LOG(MTOP**2/MSUSYT**2))**.25D0
        H1B=H1I*(1D0+3D0/8D0/PI**2*HB**2*LOG(MTOP**2/MSUSYB**2))**.25D0
        H2B=H2I*(1D0+3D0/8D0/PI**2*HT**2*LOG(MTOP**2/MSUSYB**2))**.25D0
      ENDIF
 
      TANBST = H2T/H1T
      SINBT = TANBST/SQRT(1D0+TANBST**2)
 
      TANBSB = H2B/H1B
      SINBB = TANBSB/SQRT(1D0+TANBSB**2)
      COSBB = SINBB/TANBSB
 
      DELTAMT = 0D0
      DELTAMB = 0D0
 
      MTOP4 = RMTOP**4*(1D0+2D0*BT2*TT- AL2*TT - 4D0*DELTAMT)
      MTOP2 = SQRT(MTOP4)
      MBOT4 = MB**4*(1D0+2D0*BB2*TB - AL1*TB)
     * /(1D0+DELTAMB)**4
      MBOT2 = SQRT(MBOT4)
 
      STOP12 = (MQ2 + MUR2)*.5D0 + MTOP2
     *  +1D0/8D0*(G2**2+G1**2)*(H1T**2-H2T**2)
     *  +SQRT(((G2**2-5D0*G1**2/3D0)/4D0*(H1T**2-H2T**2) +
     *  MQ2 - MUR2)**2*0.25D0 + MTOP2*(AT-XMU/TANBST)**2)
      STOP22 = (MQ2 + MUR2)*.5D0 + MTOP2
     *  +1D0/8D0*(G2**2+G1**2)*(H1T**2-H2T**2)
     *   - SQRT(((G2**2-5D0*G1**2/3D0)/4D0*(H1T**2-H2T**2) +
     *  MQ2 - MUR2)**2*0.25D0
     *  + MTOP2*(AT-XMU/TANBST)**2)
      IF(STOP22.LT.0.) GOTO 120
      SBOT12 = (MQ2 + MD2)*.5D0
     *   - 1D0/8D0*(G2**2+G1**2)*(H1B**2-H2B**2)
     *  + SQRT(((G1**2/3D0-G2**2)/4D0*(H1B**2-H2B**2) +
     *  MQ2 - MD2)**2*0.25D0 + MBOT2*(AB-XMU*TANBSB)**2)
      SBOT22 = (MQ2 + MD2)*.5D0
     *   - 1D0/8D0*(G2**2+G1**2)*(H1B**2-H2B**2)
     *   - SQRT(((G1**2/3D0-G2**2)/4D0*(H1B**2-H2B**2) +
     *   MQ2 - MD2)**2*0.25D0 + MBOT2*(AB-XMU*TANBSB)**2)
      IF(SBOT22.LT.0.) SBOT22 = 10000D0
 
      STOP1 = SQRT(STOP12)
      STOP2 = SQRT(STOP22)
      SBOT1 = SQRT(SBOT12)
      SBOT2 = SQRT(SBOT22)
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     HERE IS THE DEFINITION OF DELTAMB AND DELTAMT, WHICH
C     ARE THE VERTEX CORRECTIONS TO THE BOTTOM AND TOP QUARK
C     MASS, KEEPING THE DOMINANT QCD AND TOP YUKAWA COUPLING
C     INDUCED CORRECTIONS.
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 
      X=SBOT1
      Y=SBOT2
      Z=XMGL
      IF(X.EQ.Y) X = X - 0.00001D0
      IF(X.EQ.Z) X = X - 0.00002D0
      IF(Y.EQ.Z) Y = Y - 0.00003D0
 
      T1=T(X,Y,Z)
      X=STOP1
      Y=STOP2
      Z=XMU
      IF(X.EQ.Y) X = X - 0.00001D0
      IF(X.EQ.Z) X = X - 0.00002D0
      IF(Y.EQ.Z) Y = Y - 0.00003D0
      T2=T(X,Y,Z)
      DELTAMB = -2*ALPHA3/3D0/PI*XMGL*(AB-XMU*TANB)*T1
     *  + HT**2/(4D0*PI)**2*(AT-XMU/TANB)*XMU*TANB*T2
      X=STOP1
      Y=STOP2
      Z=XMGL
      IF(X.EQ.Y) X = X - 0.00001D0
      IF(X.EQ.Z) X = X - 0.00002D0
      IF(Y.EQ.Z) Y = Y - 0.00003D0
      T3=T(X,Y,Z)
      DELTAMT = -2D0*ALPHA3/3D0/PI*(AT-XMU/TANB)*XMGL*T3
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C   HERE THE NEW VALUES OF THE TOP AND BOTTOM QUARK MASSES AT
C   THE SCALE MS ARE DEFINED, TO BE USED IN THE EFFECTIVE
C   POTENTIAL APPROXIMATION. THEY ARE JUST THE OLD ONES, BUT
C   INCLUDING THE FINITE CORRECTIONS DELTAMT AND DELTAMB.
C   THE DELTAMB CORRECTIONS CAN BECOME LARGE AND ARE RESUMMED
C   TO ALL ORDERS, AS SUGGESTED IN THE TWO RECENT WORKS BY M. CARENA,
C   S. MRENNA AND C.E.M. WAGNER, AS WELL AS IN THE WORK BY M. CARENA,
C   D. GARCIA, U. NIERSTE AND C.E.M. WAGNER, TO APPEAR. THE TOP
C   QUARK MASS CORRECTIONS ARE SMALL AND ARE KEPT IN THE PERTURBATIVE
C   FORMULATION.  THE FUNCTION T(X,Y,Z) IS NECESSARY FOR THE
C   CALCULATION. THE ENTRIES ARE MASSES AND NOT THEIR SQUARES !
C
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 
      MTOP4 = RMTOP**4*(1D0+2D0*BT2*TT- AL2*TT - 4D0*DELTAMT)
      MTOP2 = SQRT(MTOP4)
      MBOT4 = MB**4*(1D0+2D0*BB2*TB - AL1*TB)
     * /(1D0+DELTAMB)**4
      MBOT2 = SQRT(MBOT4)
 
      STOP12 = (MQ2 + MUR2)*.5D0 + MTOP2
     *   +1D0/8D0*(G2**2+G1**2)*(H1T**2-H2T**2)
     *   +SQRT(((G2**2-5D0*G1**2/3D0)/4D0*(H1T**2-H2T**2) +
     *   MQ2 - MUR2)**2*0.25D0 + MTOP2*(AT-XMU/TANBST)**2)
      STOP22 = (MQ2 + MUR2)*.5D0 + MTOP2
     *  +1D0/8D0*(G2**2+G1**2)*(H1T**2-H2T**2)
     *   - SQRT(((G2**2-5D0*G1**2/3D0)/4D0*(H1T**2-H2T**2) +
     *  MQ2 - MUR2)**2*0.25D0
     *  + MTOP2*(AT-XMU/TANBST)**2)
 
      IF(STOP22.LT.0.) GOTO 120
      SBOT12 = (MQ2 + MD2)*.5D0
     *   - 1D0/8D0*(G2**2+G1**2)*(H1B**2-H2B**2)
     *  + SQRT(((G1**2/3D0-G2**2)/4D0*(H1B**2-H2B**2) +
     *  MQ2 - MD2)**2*0.25D0 + MBOT2*(AB-XMU*TANBSB)**2)
      SBOT22 = (MQ2 + MD2)*.5D0
     *   - 1D0/8D0*(G2**2+G1**2)*(H1B**2-H2B**2)
     *   - SQRT(((G1**2/3D0-G2**2)/4D0*(H1B**2-H2B**2) +
     *   MQ2 - MD2)**2*0.25D0 + MBOT2*(AB-XMU*TANBSB)**2)
      IF(SBOT22.LT.0.) GOTO 120
 
 
      STOP1 = SQRT(STOP12)
      STOP2 = SQRT(STOP22)
      SBOT1 = SQRT(SBOT12)
      SBOT2 = SQRT(SBOT22)
 
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCC   D-TERMS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      STW=SW
 
      F1T=(MQ2-MUR2)/(STOP12-STOP22)*(.5D0-4D0/3D0*STW)*
     *         LOG(STOP1/STOP2)
     *        +(.5D0-2D0/3D0*STW)*LOG(STOP1*STOP2/(MQ2+MTOP2))
     *        + 2D0/3D0*STW*LOG(STOP1*STOP2/(MUR2+MTOP2))
 
      F1B=(MQ2-MD2)/(SBOT12-SBOT22)*(-.5D0+2D0/3D0*STW)*
     *        LOG(SBOT1/SBOT2)
     *        +(-.5D0+1D0/3D0*STW)*LOG(SBOT1*SBOT2/(MQ2+MBOT2))
     *        - 1D0/3D0*STW*LOG(SBOT1*SBOT2/(MD2+MBOT2))
 
      F2T=SQRT(MTOP2)*(AT-XMU/TANBST)/(STOP12-STOP22)*
     *         (-.5D0*LOG(STOP12/STOP22)
     *        +(4D0/3D0*STW-.5D0)*(MQ2-MUR2)/(STOP12-STOP22)*
     *         G(STOP12,STOP22))
 
      F2B=SQRT(MBOT2)*(AB-XMU*TANBSB)/(SBOT12-SBOT22)*
     *         (.5D0*LOG(SBOT12/SBOT22)
     *        +(-2D0/3D0*STW+.5D0)*(MQ2-MD2)/(SBOT12-SBOT22)*
     *        G(SBOT12,SBOT22))
 
      VH3B(1,1) = MBOT4/(COSBB**2)*(LOG(SBOT1**2*SBOT2**2/
     *  (MQ2+MBOT2)/(MD2+MBOT2))
     *  + 2D0*(AB*(AB-XMU*TANBSB)/(SBOT1**2-SBOT2**2))*
     *  LOG(SBOT1**2/SBOT2**2)) +
     *  MBOT4/(COSBB**2)*(AB*(AB-XMU*TANBSB)/
     *  (SBOT1**2-SBOT2**2))**2*G(SBOT12,SBOT22)
 
      VH3T(1,1) =
     *  MTOP4/(SINBT**2)*(XMU*(-AT+XMU/TANBST)/(STOP1**2
     * -STOP2**2))**2*G(STOP12,STOP22)
 
      VH3B(1,1)=VH3B(1,1)+
     *    MZ**2*(2*MBOT2*F1B-SQRT(MBOT2)*AB*F2B)
 
      VH3T(1,1) = VH3T(1,1) +
     *  MZ**2*(SQRT(MTOP2)*XMU/TANBST*F2T)
 
      VH3T(2,2) = MTOP4/(SINBT**2)*(LOG(STOP1**2*STOP2**2/
     *  (MQ2+MTOP2)/(MUR2+MTOP2))
     *  + 2D0*(AT*(AT-XMU/TANBST)/(STOP1**2-STOP2**2))*
     *  LOG(STOP1**2/STOP2**2)) +
     *  MTOP4/(SINBT**2)*(AT*(AT-XMU/TANBST)/
     *  (STOP1**2-STOP2**2))**2*G(STOP12,STOP22)
 
      VH3B(2,2) =
     *  MBOT4/(COSBB**2)*(XMU*(-AB+XMU*TANBSB)/(SBOT1**2
     * -SBOT2**2))**2*G(SBOT12,SBOT22)
 
      VH3T(2,2)=VH3T(2,2)+
     *    MZ**2*(-2*MTOP2*F1T+SQRT(MTOP2)*AT*F2T)
      VH3B(2,2) = VH3B(2,2) -MZ**2*SQRT(MBOT2)*XMU*TANBSB*F2B
      VH3T(1,2) = -
     *   MTOP4/(SINBT**2)*XMU*(AT-XMU/TANBST)/
     * (STOP1**2-STOP2**2)*(LOG(STOP1**2/STOP2**2) + AT*
     * (AT - XMU/TANBST)/(STOP1**2-STOP2**2)*G(STOP12,STOP22))
 
      VH3B(1,2) =
     * - MBOT4/(COSBB**2)*XMU*(AB-XMU*TANBSB)/
     * (SBOT1**2-SBOT2**2)*(LOG(SBOT1**2/SBOT2**2) + AB*
     * (AB - XMU*TANBSB)/(SBOT1**2-SBOT2**2)*G(SBOT12,SBOT22))
 
 
      VH3T(1,2)=VH3T(1,2) +
     *MZ**2*(MTOP2/TANBST*F1T-SQRT(MTOP2)*(AT/TANBST+XMU)/2D0*F2T)
 
      VH3B(1,2)=VH3B(1,2) +
     *MZ**2*(-MBOT2*TANBSB*F1B+SQRT(MBOT2)*(AB*TANBSB+XMU)/2D0*F2B)
 
      VH3T(2,1) = VH3T(1,2)
      VH3B(2,1) = VH3B(1,2)
 
C      TQ = LOG((MQ2 + MTOP2)/MTOP2)
C      TU = LOG((MUR2+MTOP2)/MTOP2)
C      TQD = LOG((MQ2 + MB**2)/MB**2)
C      TD = LOG((MD2+MB**2)/MB**2)
 
      DO 110 I = 1,2
        DO 100 J = 1,2
          VH(I,J) =
     *   6D0/(8D0*PI**2*(H1T**2+H2T**2))
     *   *VH3T(I,J)*0.5D0*(1D0-AL(I,J)*TT/2D0) +
     *   6D0/(8D0*PI**2*(H1B**2+H2B**2))
     *   *VH3B(I,J)*0.5D0*(1D0-AL(I,J)*TB/2D0)
  100   CONTINUE
  110 CONTINUE
 
      GOTO 150
  120 DO 140 I =1,2
        DO 130 J = 1,2
          VH(I,J) = -1D15
  130   CONTINUE
  140 CONTINUE
 
 
  150 RETURN
      END
