"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalAuroraRDSSlaveInfra = exports.GlobalAuroraRDSMaster = exports.InstanceTypeEnum = exports.MySQLtimeZone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const ec2 = require("aws-cdk-lib/aws-ec2");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const rds = require("aws-cdk-lib/aws-rds");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
var MySQLtimeZone;
(function (MySQLtimeZone) {
    /**
     * TIME ZONE UTC
     */
    MySQLtimeZone["UTC"] = "UTC";
    /**
     * TIME ZONE Asia/Taipei
     */
    MySQLtimeZone["ASIA_TAIPEI"] = "Asia/Taipei";
    /**
     * TIME ZONE Africa/Cairo
     */
    MySQLtimeZone["AFRICA_CAIRO"] = "Africa/Cairo";
    /**
     * TIME ZONE Asia/Bangkok
     */
    MySQLtimeZone["ASIA_BANGKOK"] = "Asia/Bangkok";
    /**
     * TIME ZONE Australia/Darwin
     */
    MySQLtimeZone["AUSTRALIA_DARWIN"] = "Australia/Darwin";
    /**
     * TIME ZONE Africa/Casablanca
     */
    MySQLtimeZone["AFRICA_CASABLANCA"] = "Africa/Casablanca";
    /**
     * TIME ZONE Asia/Beirut
     */
    MySQLtimeZone["ASIA_BEIRUT"] = "Asia/Beirut";
    /**
     * TIME ZONE Australia/Hobart
     */
    MySQLtimeZone["AUSTRALIA_HOBART"] = "Australia/Hobart";
    /**
     * TIME ZONE Africa/Harare
     */
    MySQLtimeZone["AFRICA_HARARE"] = "Africa/Harare";
    /**
     * TIME ZONE Asia/Calcutta
     */
    MySQLtimeZone["ASIA_CALCUTTA"] = "Asia/Calcutta";
    /**
     * TIME ZONE Australia/Perth
     */
    MySQLtimeZone["AUSTRALIA_PERTH"] = "Australia/Perth";
    /**
     * TIME ZONE Africa/Monrovia
     */
    MySQLtimeZone["AFRICA_MONROVIA"] = "Africa/Monrovia";
    /**
     * TIME ZONE Asia/Damascus
     */
    MySQLtimeZone["ASIA_DAMASCUS"] = "Asia/Damascus";
    /**
     * TIME ZONE Australia/Sydney
     */
    MySQLtimeZone["AUSTRALIA_SYDNEY"] = "Australia/Sydney";
    /**
     * TIME ZONE Africa/Nairobi
     */
    MySQLtimeZone["AFRICA_NAIROBI"] = "Africa/Nairobi";
    /**
     * TIME ZONE Asia/Dhaka
     */
    MySQLtimeZone["ASIA_DHAKA"] = "Asia/Dhaka";
    /**
     * TIME ZONE Brazil/East
     */
    MySQLtimeZone["BRAZIL_EAST"] = "Brazil/East";
    /**
     * TIME ZONE Africa/Tripoli
     */
    MySQLtimeZone["AFRICA_TRIPOLI"] = "Africa/Tripoli";
    /**
     * TIME ZONE Asia/Irkutsk
     */
    MySQLtimeZone["ASIA_IRKUTSK"] = "Asia/Irkutsk";
    /**
     * TIME ZONE Canada/Newfoundland
     */
    MySQLtimeZone["CANADA_NEWFOUNDLAND"] = "Canada/Newfoundland";
    /**
     * TIME ZONE Africa/Windhoek
     */
    MySQLtimeZone["AFRICA_WINDHOEK"] = "Africa/Windhoek";
    /**
     * TIME ZONE Asia/Jerusalem
     */
    MySQLtimeZone["ASIA_JERUSALEM"] = "Asia/Jerusalem";
    /**
     * TIME ZONE Canada/Saskatchewan
     */
    MySQLtimeZone["CANADA_SASKATCHEWAN"] = "Canada/Saskatchewan";
    /**
     * TIME ZONE America/Araguaina
     */
    MySQLtimeZone["AMERICA_ARAGUAINA"] = "America/Araguaina";
    /**
     * TIME ZONE Asia/Kabul
     */
    MySQLtimeZone["ASIA_KABUL"] = "Asia/Kabul";
    /**
     * TIME ZONE Europe/Amsterdam
     */
    MySQLtimeZone["EUROPE_AMSTERDAM"] = "Europe/Amsterdam";
    /**
     * TIME ZONE America/Asuncion
     */
    MySQLtimeZone["AMERICA_ASUNCION"] = "America/Asuncion";
    /**
     * TIME ZONE Asia/Karachi
     */
    MySQLtimeZone["ASIA_KARACHI"] = "Asia/Karachi";
    /**
     * TIME ZONE Europe/Athens
     */
    MySQLtimeZone["EUROPE_ATHENS"] = "Europe/Athens";
    /**
     * TIME ZONE America/Bogota
     */
    MySQLtimeZone["AMERICA_BOGOTA"] = "America/Bogota";
    /**
     * TIME ZONE Asia/Kathmandu
     */
    MySQLtimeZone["ASIA_KATHMANDU"] = "Asia/Kathmandu";
    /**
     * TIME ZONE Europe/Dublin
     */
    MySQLtimeZone["EUROPE_DUBLIN"] = "Europe/Dublin";
    /**
     * TIME ZONE America/Caracas
     */
    MySQLtimeZone["AMERICA_CARACAS"] = "America/Caracas";
    /**
    * TIME ZONE Asia/Krasnoyarsk
    */
    MySQLtimeZone["ASIA_KRASNOYARSK"] = "Asia/Krasnoyarsk";
    /**
     * TIME ZONE Europe/Helsinki
     */
    MySQLtimeZone["EUROPE_HELSINKI"] = "Europe/Helsinki";
    /**
     * TIME ZONE America/Chihuahua
     */
    MySQLtimeZone["AMERICA_CHIHUAHUA"] = "America/Chihuahua";
    /**
     * TIME ZONE Asia/Magadan
     */
    MySQLtimeZone["ASIA_MAGADAN"] = "Asia/Magadan";
    /**
     * TIME ZONE Europe/Istanbul
     */
    MySQLtimeZone["EUROPE_ISTANBUL"] = "Europe/Istanbul";
    /**
     * TIME ZONE America/Cuiaba
     */
    MySQLtimeZone["AMERICA_CUIABA"] = "America/Cuiaba";
    /**
     * TIME ZONE Asia/Muscat
     */
    MySQLtimeZone["ASIA_MUSCAT"] = "Asia/Muscat";
    /**
     * TIME ZONE Europe/Kaliningrad
     */
    MySQLtimeZone["EUROPE_KALININGRAD"] = "Europe/Kaliningrad";
    /**
     * TIME ZONE America/Denver
     */
    MySQLtimeZone["AMERICA_DENVER"] = "America/Denver";
    /**
     * TIME ZONE Asia/Novosibirsk
     */
    MySQLtimeZone["ASIA_NOVOSIBIRSK"] = "Asia/Novosibirsk";
    /**
     * TIME ZONE Europe/Moscow'
     */
    MySQLtimeZone["EUROPE_MOSCOW"] = "Europe/Moscow";
    /**
     * TIME ZONE America/Fortaleza
     */
    MySQLtimeZone["AMERICA_FORTALEZA"] = "America/Fortaleza";
    /**
     * TIME ZONE Asia/Riyadh
     */
    MySQLtimeZone["ASIA_RIYADH"] = "Asia/Riyadh";
    /**
     * TIME ZONE Europe/Paris
     */
    MySQLtimeZone["EUROPE_PARIS"] = "Europe/Paris";
    /**
     * TIME ZONE America/Guatemala
     */
    MySQLtimeZone["AMERICA_GUATEMALA"] = "America/Guatemala";
    /**
     * TIME ZONE Asia/Seoul
     */
    MySQLtimeZone["ASIA_SEOUL"] = "Asia/Seoul";
    /**
     * TIME ZONE Europe/Prague
     */
    MySQLtimeZone["EUROPE_PRAGUE"] = "Europe/Prague";
    /**
     * TIME ZONE America/Halifax
     */
    MySQLtimeZone["AMERICA_HALIFAX"] = "America/Halifax";
    /**
     * TIME ZONE Asia/Shanghai
     */
    MySQLtimeZone["ASIA_SHANGHAI"] = "Asia/Shanghai";
    /**
     * TIME ZONE Europe/Sarajevo
     */
    MySQLtimeZone["EUROPE_SARAJEVO"] = "Europe/Sarajevo";
    /**
     * TIME ZONE America/Manaus
     */
    MySQLtimeZone["AMERICA_MANAUS"] = "America/Manaus";
    /**
     * TIME ZONE Asia/Singapore
     */
    MySQLtimeZone["ASIA_SINGAPORE"] = "Asia/Singapore";
    /**
     * TIME ZONE Pacific/Auckland
     */
    MySQLtimeZone["PACIFIC_AUCKLAND"] = "Pacific/Auckland";
    /**
     * TIME ZONE America/Matamoros
     */
    MySQLtimeZone["AMERICA_MATAMOROS"] = "America/Matamoros";
    /**
     * TIME ZONE Pacific/Fiji
     */
    MySQLtimeZone["PACIFIC_FIJI"] = "Pacific/Fiji";
    /**
     * TIME ZONE America/Monterrey
     */
    MySQLtimeZone["AMERICA_MONTERREY"] = "America/Monterrey";
    /**
     * TIME ZONE Asia/Tehran
     */
    MySQLtimeZone["ASIA_TEHRAN"] = "Asia/Tehran";
    /**
     * TIME ZONE Pacific/Guam
     */
    MySQLtimeZone["PACIFIC_GUAM"] = "Pacific/Guam";
    /**
     * TIME ZONE America/Montevideo
     */
    MySQLtimeZone["AMERICA_MONTEVIDEO"] = "America/Montevideo";
    /**
     * TIME ZONE Asia/Tokyo
     */
    MySQLtimeZone["ASIA_TOKYO"] = "Asia/Tokyo";
    /**
     * TIME ZONE Pacific/Honolulu
     */
    MySQLtimeZone["PACIFIC_HONOLULU"] = "Pacific/Honolulu";
    /**
     * TIME ZONE America/Phoenix
     */
    MySQLtimeZone["AMERICA_PHOENIX"] = "America/Phoenix";
    /**
     * TIME ZONE Asia/Ulaanbaatar
     */
    MySQLtimeZone["ASIA_ULAANBAATAR"] = "Asia/Ulaanbaatar";
    /**
     * TIME ZONE Pacific/Samoa
     */
    MySQLtimeZone["PACIFIC_SAMOA"] = "Pacific/Samoa";
    /**
     * TIME ZONE America/Santiago
     */
    MySQLtimeZone["AMERICA_SANTIAGO"] = "America/Santiago";
    /**
     * TIME ZONE Asia/Vladivostok
     */
    MySQLtimeZone["ASIA_VLADIVOSTOK"] = "Asia/Vladivostok";
    /**
     * TIME ZONE US/Alaska
     */
    MySQLtimeZone["US_ALASKA"] = "US/Alaska";
    /**
     * TIME ZONE America/Tijuana
     */
    MySQLtimeZone["AMERICA_TIJUANA"] = "America/Tijuana";
    /**
     * TIME ZONE Asia/Yakutsk
     */
    MySQLtimeZone["ASIA_YAKUTSK"] = "Asia/Yakutsk";
    /**
     * TIME ZONE US/Central
     */
    MySQLtimeZone["US_CENTRAL"] = "US/Central";
    /**
     * TIME ZONE Asia/Amman
     */
    MySQLtimeZone["ASIA_AMMAN"] = "Asia/Amman";
    /**
     * TIME ZONE Asia/Yerevan
     */
    MySQLtimeZone["ASIA_YEREVAN"] = "Asia/Yerevan";
    /**
    * TIME ZONE US/Eastern
    */
    MySQLtimeZone["US_EASTERN"] = "US/Eastern";
    /**
     * TIME ZONE Asia/Ashgabat
     */
    MySQLtimeZone["ASIA_ASHGABAT"] = "Asia/Ashgabat";
    /**
     * TIME ZONE Atlantic/Azores
     */
    MySQLtimeZone["ATLANTIC_AZORES"] = "Atlantic/Azores";
    /**
     * TIME ZONE US/East-Indiana
     */
    MySQLtimeZone["US_EAST_INDIANA"] = "US/East-Indiana";
    /**
     * TIME ZONE Asia/Baghdad
     */
    MySQLtimeZone["ASIA_BAGHDAD"] = "Asia/Baghdad";
    /**
     * TIME ZONE Australia/Adelaide
     */
    MySQLtimeZone["AUSTRALIA_ADELAIDE"] = "Australia/Adelaide";
    /**
     * TIME ZONE US/Pacific
     */
    MySQLtimeZone["US_PACIFIC"] = "US/Pacific";
    /**
     * TIME ZONE Asia/Baku
     */
    MySQLtimeZone["ASIA_BAKU"] = "Asia/Baku";
    /**
     * TIME ZONE Australia/Brisbane
     */
    MySQLtimeZone["AUSTRALIA_BRISBANE"] = "Australia/Brisbane";
})(MySQLtimeZone = exports.MySQLtimeZone || (exports.MySQLtimeZone = {}));
var InstanceTypeEnum;
(function (InstanceTypeEnum) {
    /**
     * db Instance Type r4.large
     */
    InstanceTypeEnum["R4_LARGE"] = "r4.large";
    /**
     * db Instance Type r4.xlarge
     */
    InstanceTypeEnum["R4_XLARGE"] = "r4.xlarge";
    /**
     * db Instance Type r4.2xlarge
     */
    InstanceTypeEnum["R4_2XLARGE"] = "r4.2xlarge";
    /**
     * db Instance Type r4.4xlarge
     */
    InstanceTypeEnum["R4_4XLARGE"] = "r4.4xlarge";
    /**
     * db Instance Type r4.8xlarge
     */
    InstanceTypeEnum["R4_8XLARGE"] = "r4.8xlarge";
    /**
     * db Instance Type r4.16xlarge
     */
    InstanceTypeEnum["R4_16XLARGE"] = "r4.16xlarge";
    /**
     * db Instance Type r5.large
     */
    InstanceTypeEnum["R5_LARGE"] = "r5.large";
    /**
     * db Instance Type r5.xlarge
     */
    InstanceTypeEnum["R5_XLARGE"] = "r5.xlarge";
    /**
     * db Instance Type r5.2xlarge
     */
    InstanceTypeEnum["R5_2XLARGE"] = "r5.2xlarge";
    /**
     * db Instance Type r5.4xlarge
     */
    InstanceTypeEnum["R5_4XLARGE"] = "r5.4xlarge";
    /**
     * db Instance Type r5.8xlarge
     */
    InstanceTypeEnum["R5_8XLARGE"] = "r5.8xlarge";
    /**
     * db Instance Type r5.12xlarge
     */
    InstanceTypeEnum["R5_12XLARGE"] = "r5.12xlarge";
    /**
     * db Instance Type r5.16xlarge
     */
    InstanceTypeEnum["R5_16XLARGE"] = "r5.16xlarge";
    /**
     * db Instance Type r5.24xlarge
     */
    InstanceTypeEnum["R5_24XLARGE"] = "r5.24xlarge";
    /**
     * db Instance Type r6g.large
     */
    InstanceTypeEnum["R6G_LARGE"] = "r6g.large";
    /**
     * db Instance Type r6g.xlarge
     */
    InstanceTypeEnum["R6G_XLARGE"] = "r6g.xlarge";
    /**
     * db Instance Type r6g.2xlarge
     */
    InstanceTypeEnum["R6G_2XLARGE"] = "r6g.2xlarge";
    /**
     * db Instance Type r6g.4xlarge
     */
    InstanceTypeEnum["R6G_4XLARGE"] = "r6g.4xlarge";
    /**
     * db Instance Type r6g.8xlarge
     */
    InstanceTypeEnum["R6G_8XLARGE"] = "r6g.8xlarge";
    /**
     * db Instance Type r6g.12xlarge
     */
    InstanceTypeEnum["R6G_12XLARGE"] = "r6g.12xlarge";
    /**
     * db Instance Type r6g.16xlarge
     */
    InstanceTypeEnum["R6G_16XLARGE"] = "r6g.16xlarge";
})(InstanceTypeEnum = exports.InstanceTypeEnum || (exports.InstanceTypeEnum = {}));
const GlobalAuroraRDSSupportRegion = ['us-east-1', 'us-east-2', 'us-west-1', 'us-west-2', 'eu-west-1', 'eu-west-2', 'eu-west-3', 'eu-central-1',
    'ap-south-1', 'ap-southeast-1', 'ap-southeast-2', 'ap-northeast-1', 'ap-northeast-2', 'ca-central-1'];
class GlobalAuroraRDSMaster extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        let rdsCredentials;
        if (props?.rdsPassword) {
            rdsCredentials = {
                username: props?.dbUserName ?? 'sysadmin',
                password: cdk.SecretValue.plainText(props?.rdsPassword),
            };
        }
        else {
            rdsCredentials = {
                username: props?.dbUserName ?? 'sysadmin',
            };
        }
        ;
        // Mysql need (MySQL 5.6 / version > 5.6.10a) , Postgres need (version 10.11 , 10.12 , 11.7 or later)
        this.engineVersion = props?.engineVersion ?? rds.DatabaseClusterEngine.auroraMysql({
            version: rds.AuroraMysqlEngineVersion.VER_2_07_1,
        });
        this.rdsInstanceType = props?.instanceType ?? InstanceTypeEnum.R5_LARGE;
        // Master region Vpc
        const rdsVpc = props?.vpc ?? new ec2.Vpc(this, 'RDSVpcRegionMaster', {
            cidr: '10.108.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        this.dbClusterpPG = props?.dbClusterpPG ?? new rds.ParameterGroup(this, 'dbClusterparametergroup', {
            engine: this.engineVersion,
            parameters: props?.parameters ?? {
                time_zone: props?.timeZone ?? MySQLtimeZone.UTC,
            },
        });
        let rdsVpcSubnetSelect = ec2.SubnetType.PRIVATE_WITH_NAT;
        if (this.azOfSubnets(rdsVpc.privateSubnets) === 0) {
            rdsVpcSubnetSelect = ec2.SubnetType.PUBLIC;
        }
        this.rdsCluster = new rds.DatabaseCluster(this, 'RDSCluster', {
            engine: this.engineVersion,
            parameterGroup: this.dbClusterpPG,
            clusterIdentifier: `${stack.stackName.toLowerCase()}-primary`,
            credentials: rdsCredentials,
            instances: 1,
            instanceProps: {
                // if want publicAccess , need to define vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC } ,
                vpc: rdsVpc,
                vpcSubnets: { subnetType: rdsVpcSubnetSelect },
                instanceType: new ec2.InstanceType(this.rdsInstanceType),
            },
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            defaultDatabaseName: props?.defaultDatabaseName ?? 'globaldatabase',
        });
        this.rdsPassword = `Please use this command get password back , aws secretsmanager get-secret-value --secret-id ${this.rdsCluster.secret?.secretName}` ?? props?.rdsPassword;
        ;
        this.rdsCluster.node.addDependency(rdsVpc);
        this.rdsCluster.connections.allowDefaultPortFrom(ec2.Peer.ipv4(rdsVpc.vpcCidrBlock));
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: ['rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster'],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(this, 'onEventHandler', {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'global_index.on_event',
            timeout: cdk.Duration.minutes(5),
        });
        const UpgradeglobaldbProvider = new cr.Provider(this, 'UpgradeglobaldbProvider', {
            onEventHandler: onEvent,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        this.crGlobalRDSProvider = new cdk.CustomResource(this, 'CRUpgradeglobaldbProvider', {
            resourceType: 'Custom::UpgradeGlobalClusterProvider',
            serviceToken: UpgradeglobaldbProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`,
                GlobalClusterIdentifier: `global-${stack.stackName.toLowerCase()}`,
            },
        });
        this.crGlobalRDSProvider.node.addDependency(this.rdsCluster);
        onEvent.role?.addToPrincipalPolicy(CustomResourcePolicy);
        this.rdsIsPublic = rdsVpcSubnetSelect;
        new cdk.CfnOutput(this, 'RDSisPublic', {
            value: this.rdsIsPublic,
        });
        this.rdsClusterarn = `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`;
        new cdk.CfnOutput(this, 'RDSClusterarn', {
            value: this.rdsClusterarn,
        });
        this.globalClusterIdentifier = `global-${stack.stackName.toLowerCase()}`;
        new cdk.CfnOutput(this, 'GlobalClusterIdentifier', {
            value: this.globalClusterIdentifier,
        });
        this.engine = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('Engine'));
        new cdk.CfnOutput(this, 'Engine', {
            value: this.engine,
        });
        this.clusterEngineVersion = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('EngineVersion'));
        new cdk.CfnOutput(this, 'clusterEngineVersion', {
            value: this.clusterEngineVersion,
        });
        this.globalClusterArn = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('GlobalClusterArn'));
        new cdk.CfnOutput(this, 'GlobalClusterArn', {
            value: this.globalClusterArn,
        });
        new cdk.CfnOutput(this, 'GlobalClusterPrimaryEndpoint', {
            value: this.rdsCluster.clusterEndpoint.hostname,
        });
    }
    azOfSubnets(subnets) {
        return new Set(subnets.map(subnet => subnet.availabilityZone)).size;
    }
    addRegionalCluster(scope, id, options) {
        const stack = cdk.Stack.of(scope);
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster',
                'rds:CreateDBCluster', 'rds:CreateDBInstance', 'rds:DeleteDBCluster', 'rds:DeleteDBInstance', 'rds:DescribeDBInstances',
                'rds:DescribeGlobalClusters',
            ],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(scope, `${id}-addRegionalonEvent`, {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.on_event',
            timeout: cdk.Duration.minutes(10),
        });
        const isComplete = new lambda.Function(scope, `${id}-IsComplete`, {
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.is_complete',
            runtime: lambda.Runtime.PYTHON_3_8,
            timeout: cdk.Duration.minutes(10),
            role: onEvent.role,
        });
        const addRegionalProvider = new cr.Provider(scope, `${id}-addRegionalProvider`, {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const secondRDSClusterArn = `arn:aws:rds:${options.region}:${stack.account}:cluster:${stack.stackName.toLowerCase()}-${options.region}`;
        const seconddbInstanceIdentifier = `${stack.stackName.toLowerCase()}-${options.region}-1`;
        const CRSecondRDSProvider = new cdk.CustomResource(scope, `${id}-addRegionalCustomResource`, {
            resourceType: 'Custom::addRegionalClusterProvider',
            serviceToken: addRegionalProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: this.rdsClusterarn,
                GlobalClusterIdentifier: this.globalClusterIdentifier,
                REGION: options.region,
                DBSubnetGroupName: options.dbSubnetGroupName,
                Engine: this.engine,
                EngineVersion: this.clusterEngineVersion,
                ClusterIdentifier: `${stack.stackName.toLowerCase()}-${options.region}`,
                InstanceType: this.rdsInstanceType,
                rdsIsPublic: this.rdsIsPublic,
                secondRDSClusterArn,
                seconddbInstanceIdentifier,
                securityGroup: options.securityGroupId,
                dbParameterGroup: options.dbParameterGroup,
            },
        });
        CRSecondRDSProvider.node.addDependency(this.crGlobalRDSProvider);
        onEvent.role?.addToPrincipalPolicy(CustomResourcePolicy);
        new cdk.CfnOutput(scope, 'secondRDSClusterArn', {
            value: secondRDSClusterArn,
        });
        new cdk.CfnOutput(scope, 'seconddbInstanceIdentifier', {
            value: seconddbInstanceIdentifier,
        });
    }
}
exports.GlobalAuroraRDSMaster = GlobalAuroraRDSMaster;
_a = JSII_RTTI_SYMBOL_1;
GlobalAuroraRDSMaster[_a] = { fqn: "cdk-aurora-globaldatabase.GlobalAuroraRDSMaster", version: "2.1.77" };
class GlobalAuroraRDSSlaveInfra extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        // Slave region Vpc
        const rdsVpcSecond = props?.vpc ?? new ec2.Vpc(this, 'RDSVpcRegionSlave', {
            cidr: '10.109.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        const DBsubnetType = props?.subnetType ?? ec2.SubnetType.PRIVATE_WITH_NAT;
        if (DBsubnetType === ec2.SubnetType.PUBLIC) {
            const PublicSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PUBLIC });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-publicsubnetgroup`,
                dbSubnetGroupDescription: 'Public Subnets for database',
                subnetIds: PublicSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PublicDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        else {
            const PrivateSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PRIVATE_WITH_NAT });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-privatesubnetgroup`,
                dbSubnetGroupDescription: 'Private Subnets for database',
                subnetIds: PrivateSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PrivateDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        new cdk.CfnOutput(this, 'newDBSubnetGroup', {
            value: `${this.dbSubnetGroup.dbSubnetGroupName}`,
        });
        new cdk.CfnOutput(this, 'stackRegion', {
            value: `${stack.region}`,
        });
    }
}
exports.GlobalAuroraRDSSlaveInfra = GlobalAuroraRDSSlaveInfra;
_b = JSII_RTTI_SYMBOL_1;
GlobalAuroraRDSSlaveInfra[_b] = { fqn: "cdk-aurora-globaldatabase.GlobalAuroraRDSSlaveInfra", version: "2.1.77" };
//# sourceMappingURL=data:application/json;base64,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