# MD025 - Keep your document organized with one main title

## What this rule does

Ensures your document has only one main title (heading level 1), maintaining a clear document hierarchy.

## Why this matters

- **Clear hierarchy**: One main title makes the document structure obvious to readers
- **Better navigation**: Tools and readers can easily identify the document's primary topic
- **SEO benefits**: Search engines expect one main title per page
- **Accessibility**: Screen readers rely on proper heading hierarchy for navigation

## Examples

### ✅ Correct

```markdown
# Document Title

## Section 1

Content here.

## Section 2

More content here.
```

### ❌ Incorrect

```markdown
# First Title

Content here.

# Second Title

More content here.
```

### 🔧 Fixed

```markdown
# Document Title

## First Section

Content here.

## Second Section

More content here.
```

## Configuration

```yaml
MD025:
  level: 1                    # The heading level that should be unique (default: 1)
  front_matter_title: "title" # Name of the front matter title field (default: "title")
```

## Automatic fixes

This rule will:
- Convert extra main titles to the next heading level (H1 → H2)
- Preserve the document's first main title
- Maintain the relative hierarchy of subsequent headings

## Learn more

- [CommonMark Spec: ATX headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [CommonMark Spec: Setext headings](https://spec.commonmark.org/0.31.2/#setext-headings)

## Related rules

- [MD001 - Keep heading levels organized](md001.md)
- [MD003 - Use consistent heading styles](md003.md)
- [MD024 - Avoid duplicate heading text](md024.md)
- [MD041 - Start files with a heading](md041.md)
