# MD028 - No blank lines inside quotes

## What this rule does

Prevents empty quote lines (lines with just >) that split a quote into multiple separate quotes.

## Why this matters

- **Intent**: Empty quote lines usually indicate an accidental break
- **Consistency**: Quotes should be continuous blocks
- **Rendering**: Some processors handle split quotes differently

## Examples

### ✅ Correct

```markdown
> This is a continuous quote
> with multiple lines
> that flow together nicely.

> This is a separate quote
> intentionally separated by a blank line.

> Quotes can have paragraphs too
> by using a > on the blank line:
> 
> Like this second paragraph.
```

### ❌ Incorrect

<!-- rumdl-disable MD028 -->

```markdown
> This quote has an empty line
> 
> that accidentally splits it into two quotes.

> Another broken quote
> 
> 
> with multiple empty lines.
```

<!-- rumdl-enable MD028 -->

### 🔧 Fixed

```markdown
> This quote has an empty line
> that accidentally splits it into two quotes.

> Another broken quote
> with multiple empty lines.
```

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule automatically removes lines that contain only the > symbol with no content.

## Philosophy note

Unlike some linters, rumdl only flags lines with lone > symbols. We don't flag completely blank lines between quotes because those clearly indicate the author wants separate quote blocks.

## Learn more

- [CommonMark block quotes](https://spec.commonmark.org/0.31.2/#block-quotes) - Technical specification
- [Quote paragraphs](https://www.markdownguide.org/basic-syntax/#blockquotes-with-multiple-paragraphs) - How to create multi-paragraph quotes

## Related rules

- [MD027](md027.md) - No multiple spaces after quote marker
- [MD009](md009.md) - No trailing spaces
- [MD012](md012.md) - No multiple consecutive blank lines
