# MD035 - Keep line breaks consistent

## What this rule does

Ensures all horizontal line breaks (dividers) use the same style throughout your document.

## Why this matters

- **Visual consistency**: Mixed styles (---, ***, ___) look unprofessional
- **Clear document structure**: Consistent dividers make sections easier to identify
- **Reduces confusion**: One style means less to remember when editing
- **Better readability**: Readers know what to expect for section breaks

## Examples

<!-- rumdl-disable MD035 -->

### ✅ Correct

All dividers use the same style:

```markdown
Chapter 1 content here.

---

Chapter 2 content here.

---

Chapter 3 content here.
```

### ❌ Incorrect

Different divider styles mixed together:

```markdown
Chapter 1 content here.

***

Chapter 2 content here.

___

Chapter 3 content here.
```

### 🔧 Fixed

All dividers now use the same style:

```markdown
Chapter 1 content here.

---

Chapter 2 content here.

---

Chapter 3 content here.
```

<!-- rumdl-enable MD035 -->

## Configuration

```yaml
MD035:
  style: "---"  # Choose your preferred style
```

### Style options

- `"---"` Three hyphens (default)
- `"***"` Three asterisks
- `"___"` Three underscores
- `"- - -"` Spaced hyphens
- `"* * *"` Spaced asterisks

## Automatic fixes

This rule will convert all horizontal dividers to match your configured style, preserving any spacing patterns.

## Learn more

- [CommonMark specification for thematic breaks](https://spec.commonmark.org/0.31.2/#thematic-breaks)

## Related rules

- [MD003 - Heading style](md003.md) - Keep heading formats consistent
- [MD012 - Multiple consecutive blank lines](md012.md) - Control spacing between sections
- [MD022 - Headings should be surrounded by blank lines](md022.md) - Ensure proper spacing around headings
