"""
    --- AUTO-GENERATED DOCSTRING ---
    Table of content is automatically generated by Agent Docstrings v1.3.0
    
    Classes/Functions:
        - main() (line 17)
    --- END AUTO-GENERATED DOCSTRING ---
"""
import argparse
import sys
from pathlib import Path

from . import core
from . import __version__


def main():
    """Parse CLI arguments and invoke the core processing routine.

    The function exists mainly to bridge the `console_scripts` entry point
    generated by *setuptools* and the internal API provided by
    :pymod:`agent_docstrings.core`.
    """
    parser = argparse.ArgumentParser(
        description="Generate file-level docstrings summarizing classes and functions.",
        formatter_class=argparse.RawTextHelpFormatter,
        epilog="Example:\n  agent-docstrings ./src ./libs"
    )
    parser.add_argument(
        "paths",
        metavar="PATH",
        nargs="+",
        help="One or more files or directories to scan for source files.",
    )
    parser.add_argument(
        "-v",
        "--verbose",
        action="store_true",
        help="Enable verbose output to see which files are being processed.",
    )
    parser.add_argument(
        "--version",
        action="version",
        version=f"%(prog)s {__version__}",
    )
    parser.add_argument(
        "--beta",
        action="store_true",
        help="Enable experimental beta features that may have breaking changes."
    )

    args = parser.parse_args()

    # Check if paths exist before starting
    for p_str in args.paths:
        p = Path(p_str)
        if not p.exists():
            print(f"Error: Path not found at '{p_str}'", file=sys.stderr)
            sys.exit(1)
        if not p.is_dir() and not p.is_file():
            print(f"Error: Path is not a file or directory at '{p_str}'", file=sys.stderr)
            sys.exit(1)

    core.discover_and_process_files(args.paths, args.verbose, args.beta)
    print("Done.")

if __name__ == "__main__":
    main()