"""
    --- AUTO-GENERATED DOCSTRING ---
    Table of content is automatically generated by Agent Docstrings v1.3.3
    
    Classes/Functions:
        - SignatureInfo (line 19):
        - ClassInfo (line 24):
        - CommentStyle (line 31):
        - remove_agent_docstring(text: str, language: str) -> str (line 52)
    --- END AUTO-GENERATED DOCSTRING ---
"""
from __future__ import annotations
import re
from typing import List, Tuple, Dict, NamedTuple

DOCSTRING_START_MARKER = "--- AUTO-GENERATED DOCSTRING ---"
DOCSTRING_END_MARKER = "--- END AUTO-GENERATED DOCSTRING ---"

class SignatureInfo(NamedTuple):
    """Stores information about a parsed function or method signature."""
    signature: str
    line: int

class ClassInfo(NamedTuple):
    """Stores information about a parsed class, including its methods."""
    name: str
    line: int
    methods: List[SignatureInfo]
    inner_classes: List["ClassInfo"]

class CommentStyle(NamedTuple):
    """Stores language-specific comment formatting information."""
    start: str
    end: str
    prefix: str
    indent: str

COMMENT_STYLES: Dict[str, CommentStyle] = {
    "python": CommentStyle('"""', '"""', "    ", "    "),
    "kotlin": CommentStyle('/**', ' */', ' * ', "    "),
    "javascript": CommentStyle('/**', ' */', ' * ', "  "),
    "typescript": CommentStyle('/**', ' */', ' * ', "  "),
    "csharp": CommentStyle('/*', ' */', ' * ', "    "),
    "cpp": CommentStyle('/*', ' */', ' * ', "  "),
    "c": CommentStyle('/*', ' */', ' * ', "  "),
    "java": CommentStyle('/**', ' */', ' * ', "  "),
    "go": CommentStyle('/*', ' */', ' * ', "\t"),
    "powershell": CommentStyle('<#', '#>', ' # ', "    "),
    "delphi": CommentStyle('(*', '*)', ' * ', "  "),
}

def remove_agent_docstring(text: str, language: str) -> str:
    """Remove a previously generated docstring from *text*."""
    style = COMMENT_STYLES[language]
    start_marker_escaped = re.escape(DOCSTRING_START_MARKER)
    end_marker_escaped = re.escape(DOCSTRING_END_MARKER)
    if language == "python":
        def replacer(match):
            docstring_content = match.group(0)

            # If the docstring doesn't contain the agent marker, it's a manual docstring.
            # Leave it untouched.
            if DOCSTRING_START_MARKER not in docstring_content:
                return docstring_content

            # * Match the auto-generated block inside the docstring, including any leading/
            # * trailing whitespace and the trailing newline (if present). Use single
            # * backslashes so that ``\s`` is interpreted by the *regex* engine as a
            # * whitespace token instead of a literal backslash followed by ``s``.
            auto_content_pattern = re.compile(
                rf"\s*{start_marker_escaped}[\s\S]*?{end_marker_escaped}\s*\n?",
                re.DOTALL,
            )
            cleaned_docstring = auto_content_pattern.sub('', docstring_content)
            
            # Check what's left after removing the agent part
            temp_cleaned = cleaned_docstring.replace('"""', '').replace("'''", '').strip()
            
            if not temp_cleaned:
                return ''  # Docstring was purely agent-generated, so remove it.

            # There was a manual part. Reformat it cleanly.
            return f'"""\\n{temp_cleaned}\\n"""'

        # * Match ANY triple-quoted block (single or double quotes) anywhere in the text.
        # * The former pattern anchored at ``^`` missed auto-generated blocks that were
        # * not located at the very start of the file, leading to duplication issues.
        docstring_pattern = re.compile(
            r'("""[\s\S]*?"""|\'\'\'[\s\S]*?\'\'\')',
            re.DOTALL,
        )
        # Iteratively clean the text
        cleaned_text = docstring_pattern.sub(replacer, text)
        # * Run a second pass to handle cases where two docstrings appear back-to-back,
        # * which can happen after removing an intermediary block.
        cleaned_text = docstring_pattern.sub(replacer, cleaned_text)
        # * Remove leading whitespace that may be left after docstring removal
        # * to ensure consistent line numbering between runs
        cleaned_text = cleaned_text.lstrip('\n')
        return cleaned_text
    else:
        # For C-style comments, be more flexible with the format
        # Handle both compact (/**---...---*/) and expanded formats
        start_escaped = re.escape(style.start.rstrip())  # Remove trailing spaces
        # Handle different possible endings (with or without space before *)
        end_patterns = [
            re.escape(style.end),  # Original format with space
            re.escape(style.end.strip()),  # Without space
        ]
        # Try each possible end pattern
        for end_pattern in end_patterns:
            pattern = re.compile(
                rf'^\s*{start_escaped}[\s\S]*?{start_marker_escaped}[\s\S]*?{end_marker_escaped}[\s\S]*?{end_pattern}\s*\n?',
                re.DOTALL
            )
            match = pattern.search(text)
            if match:
                return text[match.end():]
    
    return text