"""
    --- AUTO-GENERATED DOCSTRING ---
    Table of content is automatically generated by Agent Docstrings v1.3.0
    
    Classes/Functions:
        - _format_arg(arg: ast.arg) -> str (line 20)
        - _format_signature(node: Union[ast.FunctionDef, ast.AsyncFunctionDef]) -> str (line 28)
        - parse_python_file(lines: List[str]) -> Tuple[List[ClassInfo], List[SignatureInfo]] (line 95)
        - _parse_class_node(node: ast.ClassDef) -> ClassInfo (line 136)
    --- END AUTO-GENERATED DOCSTRING ---
"""
from __future__ import annotations

import ast
from typing import List, Tuple, Union

from .common import ClassInfo, SignatureInfo


def _format_arg(arg: ast.arg) -> str:
    """Formats a single argument from an AST node."""
    arg_str = arg.arg
    if arg.annotation:
        arg_str += f": {ast.unparse(arg.annotation)}"
    return arg_str


def _format_signature(node: Union[ast.FunctionDef, ast.AsyncFunctionDef]) -> str:
    """Formats a function signature from an AST node."""
    name = node.name
    args = node.args

    is_method = isinstance(getattr(node, "parent", None), ast.ClassDef)

    arg_parts = []

    # Positional-only arguments
    if args.posonlyargs:
        arg_parts.extend([_format_arg(arg) for arg in args.posonlyargs])
        arg_parts.append("/")

    # Regular arguments
    regular_args = args.args
    if is_method and regular_args and regular_args[0].arg == "self":
        regular_args = regular_args[1:]

    num_defaults = len(args.defaults)
    first_default_idx = len(regular_args) - num_defaults

    for i, arg in enumerate(regular_args):
        arg_str = _format_arg(arg)
        if i >= first_default_idx:
            default_val = ast.unparse(args.defaults[i - first_default_idx])
            # * Format default assignment: no spaces for unannotated args, spaces for annotated
            if arg.annotation:
                arg_str += f" = {default_val}"
            else:
                arg_str += f"={default_val}"
        arg_parts.append(arg_str)

    # Vararg (*args)
    if args.vararg:
        arg_parts.append(f"*{_format_arg(args.vararg)}")
    # Separator for keyword-only arguments
    elif args.kwonlyargs:
        arg_parts.append("*")

    # Keyword-only arguments
    for i, arg in enumerate(args.kwonlyargs):
        arg_str = _format_arg(arg)
        kw_default = args.kw_defaults[i]
        if kw_default is not None:
            default_val = ast.unparse(kw_default)
            if arg.annotation:
                arg_str += f" = {default_val}"
            else:
                arg_str += f"={default_val}"
        arg_parts.append(arg_str)

    # Kwarg (**kwargs)
    if args.kwarg:
        arg_parts.append(f"**{_format_arg(args.kwarg)}")

    # Cleanup empty entries from separators
    arg_parts = [part for part in arg_parts if part]

    signature = f"{name}({', '.join(arg_parts)})"

    if node.returns:
        signature += f" -> {ast.unparse(node.returns)}"

    return signature


def parse_python_file(
    lines: List[str],
) -> Tuple[List[ClassInfo], List[SignatureInfo]]:
    """
    Parses Python source code to extract class and function information using AST.
    """
    source = "\n".join(lines)
    try:
        tree = ast.parse(source)
    except SyntaxError:
        # * If initial parsing fails, try to add a 'pass' statement.
        # * This can fix incomplete blocks (e.g., a function with no body).
        # * If this also fails, the original SyntaxError is raised.
        try:
            tree = ast.parse(source + "\n    pass")
        except SyntaxError:
            raise  # * Re-raise the original SyntaxError

    # Add parent pointers to all nodes in the tree first
    for node in ast.walk(tree):
        for child in ast.iter_child_nodes(node):
            setattr(child, "parent", node)

    classes = []
    functions = []

    for node in ast.walk(tree):
        # Check if the node is a direct child of the Module
        parent = getattr(node, "parent", None)
        is_top_level = isinstance(parent, ast.Module)

        if isinstance(node, (ast.FunctionDef, ast.AsyncFunctionDef)) and is_top_level:
            functions.append(
                SignatureInfo(signature=_format_signature(node), line=node.lineno)
            )
        elif isinstance(node, ast.ClassDef) and is_top_level:
            classes.append(_parse_class_node(node))

    return classes, functions


def _parse_class_node(node: ast.ClassDef) -> ClassInfo:
    methods = []
    inner_classes = []
    for body_item in node.body:
        if isinstance(body_item, (ast.FunctionDef, ast.AsyncFunctionDef)):
            if body_item.name == "__init__":
                continue
            methods.append(
                SignatureInfo(
                    signature=_format_signature(body_item), line=body_item.lineno
                )
            )
        elif isinstance(body_item, ast.ClassDef):
            inner_classes.append(_parse_class_node(body_item))

    return ClassInfo(
        name=node.name,
        line=node.lineno,
        methods=methods,
        inner_classes=inner_classes,
    )