"""
    --- AUTO-GENERATED DOCSTRING ---
    Table of content is automatically generated by Agent Docstrings v1.3.0
    
    Classes/Functions:
        - TestPythonASTIntegration (line 24):
            - test_python_ast_integration_complex(source_processor) -> None (line 25)
            - test_python_ast_integration_async_functions(source_processor) -> None (line 66)
            - test_python_ast_integration_nested_classes(source_processor) -> None (line 89)
        - TestGoASTIntegration (line 125):
            - test_go_ast_integration_interfaces(source_processor) -> None (line 126)
            - test_go_ast_integration_methods(source_processor) -> None (line 172)
            - test_go_ast_fallback_integration(source_processor) -> None (line 217)
    --- END AUTO-GENERATED DOCSTRING ---
"""
from __future__ import annotations
import pytest
from pathlib import Path
from textwrap import dedent

from agent_docstrings.core import process_file


class TestPythonASTIntegration:
    def test_python_ast_integration_complex(self, source_processor) -> None:
        """Test full integration of Python AST parser with complex code."""
        source_code = dedent("""
            from typing import List, Dict, Optional
            import asyncio
            
            
            class DataProcessor:
                '''A class for processing data.'''
                
                def __init__(self, name: str):
                    self.name = name
                
                def process_data(self, data: List[Dict[str, str]], callback: Optional[callable] = None) -> Dict[str, int]:
                    '''Process the data and return statistics.'''
                    return {"count": len(data)}
                
                @property
                def status(self) -> str:
                    '''Get current status.'''
                    return "active"
            
            
            def global_function(x: int, y: float = 3.14, *args: str, **kwargs: dict) -> bool:
                '''A global function with various parameter types.'''
                return True
        """).strip()
        
        result_content, _, _ = source_processor("complex_test.py", source_code)
        
        # * Verify AST-generated docstring is present
        assert "--- AUTO-GENERATED DOCSTRING ---" in result_content
        assert "DataProcessor" in result_content
        assert "process_data(data: List[Dict[str, str]], callback: Optional[callable] = None) -> Dict[str, int]" in result_content
        assert "status() -> str" in result_content
        assert "global_function(x: int, y: float = 3.14, *args: str, **kwargs: dict) -> bool" in result_content
        
        # * Verify original code is preserved
        assert "from typing import List, Dict, Optional" in result_content
        assert "class DataProcessor:" in result_content

    def test_python_ast_integration_async_functions(self, source_processor) -> None:
        """Test integration with async functions."""
        source_code = dedent("""
            import asyncio
            
            
            class AsyncProcessor:
                async def process_async(self, data: bytes) -> str:
                    await asyncio.sleep(0.1)
                    return "processed"
            
            
            async def global_async_function() -> None:
                pass
        """).strip()
        
        result_content, _, _ = source_processor("async_test.py", source_code)
        
        # * Verify async functions are properly parsed
        assert "process_async(data: bytes) -> str" in result_content
        assert "global_async_function() -> None" in result_content
        assert "AsyncProcessor" in result_content

    def test_python_ast_integration_nested_classes(self, source_processor) -> None:
        """Test integration with nested classes."""
        source_code = dedent("""
            class OuterClass:
                def outer_method(self) -> None:
                    pass
                
                class InnerClass:
                    def inner_method(self, value: int = 42) -> int:
                        return value
                    
                    class DeeplyNestedClass:
                        def deep_method(self) -> str:
                            return "deep"
            
            
            def standalone_function() -> bool:
                return True
        """).strip()
        
        result_content, lines, _ = source_processor("nested_test.py", source_code)
        
        # * Verify nested class structure is properly represented
        assert "OuterClass" in result_content
        assert "outer_method() -> None" in result_content
        assert "InnerClass" in result_content
        assert "inner_method(value: int = 42) -> int" in result_content
        assert "standalone_function() -> bool" in result_content
        
        # * Verify proper indentation in docstring
        docstring_lines = [line for line in lines if '- ' in line and ('Class' in line or 'method' in line or 'function' in line)]
        
        # * Should have proper hierarchical structure
        assert len(docstring_lines) > 0


class TestGoASTIntegration:
    def test_go_ast_integration_interfaces(self, source_processor) -> None:
        """Test full integration of Go AST parser with interfaces."""
        source_code = dedent("""
            package main
            
            import "fmt"
            
            // Reader defines interface for reading data
            type Reader interface {
                Read(data []byte) (int, error)
                Close() error
            }
            
            // Writer defines interface for writing data  
            type Writer interface {
                Write(data []byte) (int, error)
                Flush() error
            }
            
            // GlobalFunction is a standalone function
            func GlobalFunction(param string) (string, error) {
                return fmt.Sprintf("result: %s", param), nil
            }
            
            func main() {
                fmt.Println("Test Go AST parsing")
            }
        """).strip()
        
        result_content, _, _ = source_processor("interfaces_test.go", source_code)
        
        # * Verify Go AST-generated docstring is present
        assert "--- AUTO-GENERATED DOCSTRING ---" in result_content
        assert "Reader" in result_content
        assert "Writer" in result_content
        assert "Read(data []byte) (int, error)" in result_content
        assert "Write(data []byte) (int, error)" in result_content
        assert "Close() error" in result_content
        assert "Flush() error" in result_content
        assert "func GlobalFunction" in result_content
        assert "func main()" in result_content
        
        # * Verify original code is preserved
        assert "package main" in result_content
        assert "type Reader interface" in result_content

    def test_go_ast_integration_methods(self, source_processor) -> None:
        """Test integration with Go methods on structs."""
        source_code = dedent("""
            package main
            
            import "context"
            
            // DataProcessor struct for processing data
            type DataProcessor struct {
                Name string
                ID   int
            }
            
            // ProcessData processes data synchronously
            func (dp *DataProcessor) ProcessData(data map[string]interface{}) (int, error) {
                return len(data), nil
            }
            
            // ProcessDataAsync processes data asynchronously
            func (dp *DataProcessor) ProcessDataAsync(ctx context.Context, data []string) <-chan string {
                result := make(chan string)
                return result
            }
            
            // ComplexFunction with complex signature
            func ComplexFunction(
                ctx context.Context,
                data map[string]interface{},
                callback func(string) error,
            ) (result map[string]int, err error) {
                return nil, nil
            }
        """).strip()
        
        result_content, _, _ = source_processor("methods_test.go", source_code)
        
        # * Verify methods are properly parsed
        assert "func (dp *DataProcessor) ProcessData" in result_content
        assert "func (dp *DataProcessor) ProcessDataAsync" in result_content
        assert "func ComplexFunction" in result_content
        
        # * Verify complex types are handled
        assert "context.Context" in result_content
        assert "map[string]interface{}" in result_content

    def test_go_ast_fallback_integration(self, source_processor) -> None:
        """Test Go AST parser fallback to regex when Go toolchain unavailable."""
        source_code = dedent("""
            package main
            
            func simpleFunction() {
                println("Hello")
            }
            
            func (s *MyStruct) simpleMethod(arg int) string {
                return "test"
            }
        """).strip()
        
        result_content, _, _ = source_processor("fallback_test.go", source_code)
        
        # * Process the file (will use AST if available, regex if not)
        # * Verify some form of processing occurred
        assert "--- AUTO-GENERATED DOCSTRING ---" in result_content
        assert "func" in result_content
        
        # * Should have at least basic function detection
        assert "simpleFunction" in result_content or "func simpleFunction" in result_content