"""
    --- AUTO-GENERATED DOCSTRING ---
    Table of content is automatically generated by Agent Docstrings v1.3.0
    
    Classes/Functions:
        - test_process_file_determinism(sample_files_by_language) (line 14)
    --- END AUTO-GENERATED DOCSTRING ---
"""
import pytest
from agent_docstrings.core import process_file
from pathlib import Path

# determinism test ensures that after inserting header once, subsequent runs do not modify the file

def test_process_file_determinism_with_manual_python_docstring(tmp_path):
    """
    Tests that a Python file with a pre-existing manual docstring is handled
    correctly and idempotently, by placing the agent docstring before the
    manual one without duplication on subsequent runs.
    """
    # Prepare the test file
    fixture_path = Path("tests/fixtures/python_with_manual_docstring.py")
    original_content = fixture_path.read_text(encoding="utf-8")
    test_file_path = tmp_path / "test.py"
    test_file_path.write_text(original_content, encoding="utf-8")

    # First run: should add the agent docstring
    process_file(test_file_path)
    content_after_first_run = test_file_path.read_text(encoding="utf-8")

    # Second run: should NOT change the file
    process_file(test_file_path)
    content_after_second_run = test_file_path.read_text(encoding="utf-8")
    
    # Assert that the first run actually added the docstring
    assert original_content != content_after_first_run
    # Assert that the second run made no changes
    assert content_after_first_run == content_after_second_run


def test_file_is_unchanged_if_no_docstring_added(tmp_path):
    """
    Tests that a Python file with only a manual docstring and no classes/functions
    is not modified by the agent.
    """
    original_content = '"""This is a manual docstring."""\\n'
    test_file_path = tmp_path / "test.py"
    test_file_path.write_text(original_content, encoding="utf-8")

    # Run processing
    process_file(test_file_path)
    content_after_run = test_file_path.read_text(encoding="utf-8")

    # Assert that the file content is identical
    assert original_content == content_after_run, \
        "File should not be modified if no agent docstring is added."


def test_process_file_determinism(sample_files_by_language):
    """
    Processes each sample file three times and asserts that after the first processing,
    subsequent runs do not change the file content.
    """
    for language, file_path in sample_files_by_language.items():
        # Read original content
        original = file_path.read_text(encoding='utf-8')
        # First run: may modify file (insert header)
        process_file(file_path)
        first = file_path.read_text(encoding='utf-8')
        # Second run: should not change content
        process_file(file_path)
        second = file_path.read_text(encoding='utf-8')
        # Third run: also should not change content
        process_file(file_path)
        third = file_path.read_text(encoding='utf-8')

        # After first processing, content should stabilize
        assert first == second == third