"""
    --- AUTO-GENERATED DOCSTRING ---
    Table of content is automatically generated by Agent Docstrings v1.3.2
    
    Classes/Functions:
        - test_no_docstring_duplication_on_repeated_runs(source_processor) -> None (line 15)
        - test_manual_docstring_preservation_with_auto_generation(source_processor) -> None (line 56)
        - test_existing_auto_docstring_replacement(source_processor) -> None (line 100)
        - test_multiple_auto_docstring_removal(source_processor) -> None (line 135)
    --- END AUTO-GENERATED DOCSTRING ---
"""
import pytest
import re
from textwrap import dedent
from agent_docstrings import __version__

def test_no_docstring_duplication_on_repeated_runs(source_processor) -> None:
    """
    Test that running the docstring generator multiple times on the same file
    does not create duplicate auto-generated docstrings.
    This test simulates the scenario where a file with manual docstring
    gets processed multiple times, ensuring no double docstrings are created.
    """
    # * Initial file with manual docstring
    initial_content = dedent('''
        """
        Human comments
        This is a manual docstring that should be preserved.
        """
        def test_function():
            """This is a function docstring."""
            return "test"
        class TestClass:
            def method(self):
                return "method"
    ''').strip()
    # * First run - should generate auto docstring and merge with manual
    result_content_1, lines_1, _ = source_processor("test_duplication.py", initial_content)
    # * Verify that auto-generated docstring was added
    assert "--- AUTO-GENERATED DOCSTRING ---" in result_content_1
    assert "Human comments" in result_content_1  # Manual content preserved
    assert "test_function()" in result_content_1  # Auto-generated content added
    # * Count auto-generated docstring markers
    auto_markers_1 = result_content_1.count("--- AUTO-GENERATED DOCSTRING ---")
    assert auto_markers_1 == 1, f"Expected 1 auto docstring marker, found {auto_markers_1}"
    # * Second run - should not create duplicate auto docstrings
    result_content_2, lines_2, _ = source_processor("test_duplication.py", result_content_1)
    # * Verify no duplication occurred
    auto_markers_2 = result_content_2.count("--- AUTO-GENERATED DOCSTRING ---")
    assert auto_markers_2 == 1, f"Expected 1 auto docstring marker after second run, found {auto_markers_2}"
    # * Verify manual content is still preserved
    assert "Human comments" in result_content_2
    assert "This is a manual docstring that should be preserved." in result_content_2
    # * Verify auto-generated content is still present
    assert "test_function()" in result_content_2
    assert "TestClass" in result_content_2
    assert "method()" in result_content_2

def test_manual_docstring_preservation_with_auto_generation(source_processor) -> None:
    """
    Test that manual docstrings are properly preserved when auto-generating
    docstrings, and that the structure is correct.
    """
    # * File with manual docstring only
    initial_content = dedent('''
        """
        This is a manual module docstring.
        It should be preserved and merged with auto-generated content.
        """
        def function_one():
            pass
        def function_two():
            pass
    ''').strip()
    result_content, lines, _ = source_processor("test_manual_preservation.py", initial_content)
    # * Verify structure: manual content should come after auto-generated content
    lines_list = result_content.split('\n')
    # * Find the docstring boundaries
    docstring_start = None
    docstring_end = None
    manual_content_found = False
    for i, line in enumerate(lines_list):
        if line.strip() == '"""' and docstring_start is None:
            docstring_start = i
        elif line.strip() == '"""' and docstring_start is not None:
            docstring_end = i
            break
    assert docstring_start is not None, "Docstring start not found"
    assert docstring_end is not None, "Docstring end not found"
    # * Extract docstring content
    docstring_content = lines_list[docstring_start:docstring_end + 1]
    docstring_text = '\n'.join(docstring_content)
    # * Verify auto-generated content is first
    assert "--- AUTO-GENERATED DOCSTRING ---" in docstring_text
    assert "function_one()" in docstring_text
    assert "function_two()" in docstring_text
    # * Verify manual content is preserved
    assert "This is a manual module docstring." in docstring_text
    assert "It should be preserved and merged with auto-generated content." in docstring_text
    # * Verify only one docstring block exists
    docstring_blocks = result_content.count('"""')
    assert docstring_blocks == 2, f"Expected 2 triple quotes (start and end), found {docstring_blocks}"

def test_existing_auto_docstring_replacement(source_processor) -> None:
    """
    Test that existing auto-generated docstrings are properly replaced
    when the file is processed again.
    """
    # * File with existing auto-generated docstring
    initial_content = dedent('''
        """
        --- AUTO-GENERATED DOCSTRING ---
        Table of content is automatically generated by Agent Docstrings v1.3.1
        Classes/Functions:
            - old_function() (line 8)
        --- END AUTO-GENERATED DOCSTRING ---
        """
        def old_function():
            pass
        def new_function():
            pass
    ''').strip()
    result_content, lines, _ = source_processor("test_replacement.py", initial_content)
    # * Find the docstring in the result
    docstring_match = re.search(r'"""[\s\S]*?"""', result_content)
    assert docstring_match, "Could not find docstring in processed file"
    docstring_text = docstring_match.group(0)
    # * Verify new content is in the docstring
    assert "old_function()" in docstring_text
    assert "new_function()" in docstring_text
    # * Verify only one auto-generated docstring exists in the whole file
    auto_markers = result_content.count("--- AUTO-GENERATED DOCSTRING ---")
    assert auto_markers == 1, f"Expected 1 auto docstring marker, found {auto_markers}"
    # * Verify the version is updated in the docstring
    assert f"Agent Docstrings v{__version__}" in docstring_text
    # * Verify that old_function is mentioned only once *within the docstring*
    assert docstring_text.count("old_function()") == 1, "Function should appear only once in docstring"
    assert docstring_text.count("new_function()") == 1, "Function should appear only once in docstring"

def test_multiple_auto_docstring_removal(source_processor) -> None:
    """
    Test that multiple auto-generated docstrings are properly removed
    and replaced with a single one.
    """
    # * File with multiple auto-generated docstrings (simulating a bug)
    initial_content = dedent('''
        """
        --- AUTO-GENERATED DOCSTRING ---
        Table of content is automatically generated by Agent Docstrings v1.3.1
        --- END AUTO-GENERATED DOCSTRING ---
        """
        """
        --- AUTO-GENERATED DOCSTRING ---
        Table of content is automatically generated by Agent Docstrings v1.3.2
        --- END AUTO-GENERATED DOCSTRING ---
        Human comments
        """
        def test_function():
            return "test"
    ''').strip()
    result_content, lines, _ = source_processor("test_multiple_removal.py", initial_content)
    # * Verify only one auto-generated docstring exists
    auto_markers = result_content.count("--- AUTO-GENERATED DOCSTRING ---")
    assert auto_markers == 1, f"Expected 1 auto docstring marker, found {auto_markers}"
    # * Verify manual content is preserved
    assert "Human comments" in result_content
    # * Verify function is documented
    assert "test_function()" in result_content
    # * Verify that there is only one docstring block in the final output
    docstring_blocks = re.findall(r'"""[\s\S]*?"""', result_content)
    assert len(docstring_blocks) == 1, f"Expected 1 docstring block, found {len(docstring_blocks)}" 