"""
    --- AUTO-GENERATED DOCSTRING ---
    Table of content is automatically generated by Agent Docstrings v1.3.0
    
    Classes/Functions:
        - test_header_preservation(source_processor, ext, header_lines, lang) (line 25)
        - test_future_import_preservation(source_processor) -> None (line 59)
        - test_kotlin_multiline_comment_preservation(source_processor) -> None (line 79)
    --- END AUTO-GENERATED DOCSTRING ---
"""
import pytest
from pathlib import Path
from agent_docstrings.core import process_file
from agent_docstrings.languages.common import COMMENT_STYLES

# Mapping of file extensions to sample header lines and language key
HEADER_CASES = [
    ('.py', ['#!/usr/bin/env python3', '# -*- coding: utf-8 -*-'], 'python'),
    ('.go', ['package main'], 'go'),
    ('.cs', ['using System;', 'using System.IO;'], 'csharp'),
    ('.js', ['// @jsx pragma'], 'javascript'),
    ('.ts', ['// @ts-check'], 'typescript'),
]

@pytest.mark.parametrize('ext,header_lines,lang', HEADER_CASES)
def test_header_preservation(source_processor, ext, header_lines, lang):
    """
    Verifies that language-specific headers remain unchanged and in place after processing.
    """
    # Minimal code snippet per language
    code_snippets = {
        'python': ['def foo():', '    pass'],
        'go': ['func Foo() {}'],
        'csharp': ['public class Test { }'],
        'javascript': ['function foo() { }'],
        'typescript': ['function foo(): void { }'],
    }
    content_lines = header_lines + [''] + code_snippets[lang]
    file_text = '\n'.join(content_lines)

    _, result_lines, _ = source_processor(f'test{ext}', file_text)

    # Header lines should remain identical at the top
    assert result_lines[:len(header_lines)] == header_lines

    # Find the docstring start - it might be after some empty lines
    docstring_start_idx = len(header_lines)
    style = COMMENT_STYLES[lang]
    
    # Skip any empty lines that were preserved
    while docstring_start_idx < len(result_lines) and result_lines[docstring_start_idx].strip() == "":
        docstring_start_idx += 1
    
    # Next non-empty line should be the docstring start delimiter for the language
    assert result_lines[docstring_start_idx] == style.start

    # The original code snippet should appear after the docstring block
    assert code_snippets[lang][0] in '\n'.join(result_lines)

def test_future_import_preservation(source_processor) -> None:
    """
    Verifies that `from __future__ import` statements are preserved at the very top
    of a Python file, before the agent-generated docstring.
    """
    content = [
        "from __future__ import annotations",
        "",
        "class MyClass:",
        "    pass",
    ]
    file_text = '\n'.join(content)

    _, result_lines, _ = source_processor('test_future.py', file_text)

    # The first line must be the __future__ import
    assert result_lines[0] == "from __future__ import annotations"
    # The second line should be empty (preserved)
    assert result_lines[1] == ""
    # The third line should be the start of our docstring
    assert result_lines[2] == '"""'

def test_kotlin_multiline_comment_preservation(source_processor) -> None:
    """
    Verifies that a multi-line block comment at the start of a Kotlin file is preserved.
    This is to address the bug reported in issue #9.
    """
    fixture_path = Path(__file__).parent / "fixtures" / "kotlin_with_multiline_comment.kt"
    original_content = fixture_path.read_text(encoding="utf-8")
    
    file_path, result_lines, _ = source_processor("test.kt", original_content)
    
    processed_content = '\n'.join(result_lines)
    
    # The original multiline comment should be at the start of the file
    assert processed_content.strip().startswith("/**")
    assert "This is a multi-line comment that should be preserved." in processed_content
    
    # The autogenerated docstring should come *after* the manual comment
    # and package declaration.
    assert "--- AUTO-GENERATED DOCSTRING ---" in processed_content
    assert processed_content.find("*/") < processed_content.find("--- AUTO-GENERATED DOCSTRING ---")