"""
    --- AUTO-GENERATED DOCSTRING ---
    Table of content is automatically generated by Agent Docstrings v1.3.0
    
    Classes/Functions:
        - TestLineNumberCorrection (line 22):
            - test_python_line_numbers_without_existing_docstring(source_processor) -> None (line 23)
            - test_python_line_numbers_with_existing_docstring(source_processor) -> None (line 64)
            - test_go_line_numbers_correction(source_processor) -> None (line 100)
            - test_line_numbers_with_shebang(source_processor) -> None (line 148)
            - test_line_numbers_after_multiple_updates(tmp_path: Path, source_processor) -> None (line 174)
    --- END AUTO-GENERATED DOCSTRING ---
"""
from __future__ import annotations
import pytest
from pathlib import Path
from textwrap import dedent

from agent_docstrings.core import process_file


class TestLineNumberCorrection:
    def test_python_line_numbers_without_existing_docstring(self, source_processor) -> None:
        """Test that line numbers are correct when adding docstring to file without one."""
        source_code = dedent("""
            def first_function():
                pass
            
            class MyClass:
                def method_one(self):
                    return 1
                
                def method_two(self):
                    return 2
            
            def second_function():
                return "hello"
        """).strip()
        
        _, lines, _ = source_processor("test_lines.py", source_code)
        
        # * Find the docstring content
        docstring_lines = [line for line in lines if "line" in line and ("function" in line or "method" in line)]
        
        # * Verify line numbers point to actual function/class definitions
        for docstring_line in docstring_lines:
            if "first_function()" in docstring_line:
                # * Extract line number from docstring
                line_num = int(docstring_line.split("line ")[1].split(")")[0])
                # * Check that line actually contains the function
                actual_line = lines[line_num - 1]  # Convert to 0-based index
                assert "def first_function():" in actual_line
            
            elif "MyClass" in docstring_line and "line" in docstring_line:
                line_num = int(docstring_line.split("line ")[1].split(")")[0])
                actual_line = lines[line_num - 1]
                assert "class MyClass:" in actual_line
            
            elif "method_one()" in docstring_line:
                line_num = int(docstring_line.split("line ")[1].split(")")[0])
                actual_line = lines[line_num - 1]
                assert "def method_one(self):" in actual_line

    def test_python_line_numbers_with_existing_docstring(self, source_processor) -> None:
        """Test line numbers when updating existing docstring."""
        source_code = dedent('''
            """
            Old docstring that will be replaced.
            Multiple lines here.
            """
            
            def first_function():
                pass
            
            class MyClass:
                def method_one(self):
                    return 1
        ''').strip()
        
        result_content, lines, _ = source_processor("test_existing.py", source_code)
        
        # * Find function definitions and verify line numbers in docstring
        first_func_line = None
        class_line = None
        method_line = None
        
        for i, line in enumerate(lines, 1):
            if "def first_function():" in line:
                first_func_line = i
            elif "class MyClass:" in line:
                class_line = i
            elif "def method_one(self):" in line:
                method_line = i
        
        # * Verify docstring has correct line numbers
        assert f"first_function() (line {first_func_line})" in result_content
        assert f"MyClass (line {class_line}):" in result_content
        assert f"method_one() (line {method_line})" in result_content

    def test_go_line_numbers_correction(self, source_processor) -> None:
        """Test line numbers for Go files (skipped if Go is unsupported)."""
        from agent_docstrings.core import EXT_TO_LANG  # type: ignore

        if ".go" not in EXT_TO_LANG:
            pytest.skip("Go support not available or configured")
        
        source_code = dedent("""
            package main
            
            import "fmt"
            
            type MyInterface interface {
                Method() string
            }
            
            func GlobalFunction() {
                fmt.Println("hello")
            }
            
            func (m *MyStruct) MethodOnStruct() int {
                return 42
            }
        """).strip()
        
        result_content, lines, _ = source_processor("test_lines.go", source_code)
        
        # * Find actual definitions
        interface_line = None
        global_func_line = None
        method_line = None
        
        for i, line in enumerate(lines, 1):
            if "type MyInterface interface" in line:
                interface_line = i
            elif "func GlobalFunction()" in line:
                global_func_line = i
            elif "func (m *MyStruct) MethodOnStruct()" in line:
                method_line = i
        
        # * Verify docstring line numbers match actual positions
        if interface_line:
            assert f"MyInterface (line {interface_line}):" in result_content
        if global_func_line:
            assert f"GlobalFunction" in result_content and f"line {global_func_line}" in result_content
        if method_line:
            assert f"MethodOnStruct" in result_content and f"line {method_line}" in result_content

    def test_line_numbers_with_shebang(self, source_processor) -> None:
        """Test line numbers when file has shebang and encoding."""
        source_code = dedent("""
            #!/usr/bin/env python3
            # -*- coding: utf-8 -*-
            
            def main():
                print("Hello, World!")
            
            class Application:
                def run(self):
                    main()
        """).strip()
        
        result_content, lines, _ = source_processor("test_shebang.py", source_code)
        
        # * Verify shebang and encoding are preserved
        assert lines[0] == "#!/usr/bin/env python3"
        assert lines[1] == "# -*- coding: utf-8 -*-"
        
        # * Verify that the docstring contains the correct entries
        assert '--- AUTO-GENERATED DOCSTRING ---' in result_content
        assert 'main()' in result_content
        assert 'Application' in result_content
        assert 'run()' in result_content

    def test_line_numbers_after_multiple_updates(self, tmp_path: Path, source_processor) -> None:
        """Test that line numbers remain correct after multiple updates."""
        source_code = dedent("""
            def original_function():
                return "original"
            
            class OriginalClass:
                def original_method(self):
                    pass
        """).strip()
        
        # * First processing
        first_result, _, python_file = source_processor("test_multiple.py", source_code)
        
        # * Second processing (should update existing docstring)
        process_file(python_file, verbose=False)
        second_result = python_file.read_text()
        
        # * Results should be identical (stable)
        assert first_result == second_result
        
        # * Verify line numbers are still correct
        lines = second_result.splitlines()
        
        func_line = None
        class_line = None
        method_line = None
        
        for i, line in enumerate(lines, 1):
            if "def original_function():" in line:
                func_line = i
            elif "class OriginalClass:" in line:
                class_line = i
            elif "def original_method(self):" in line:
                method_line = i
        
        # * Verify docstring still has correct line numbers
        assert f"original_function() (line {func_line})" in second_result
        assert f"OriginalClass (line {class_line}):" in second_result
        assert f"original_method() (line {method_line})" in second_result