"""
Signal Processing Algorithms (:mod:`sigima.tools.signal`)
---------------------------------------------------------------

This package contains signal processing algorithms.

Algorithms are organized into subpackages according to their purpose:

- :mod:`sigima.tools.signal.dynamic`: Dynamic parameter extraction
- :mod:`sigima.tools.signal.features`: Feature extraction algorithms
- :mod:`sigima.tools.signal.fitmodels`: Curve fitting models
- :mod:`sigima.tools.signal.fourier`: Fourier analysis algorithms
- :mod:`sigima.tools.signal.interpolation`: Interpolation algorithms
- :mod:`sigima.tools.signal.peakdetection`: Peak detection algorithms
- :mod:`sigima.tools.signal.pulse`: Pulse analysis algorithms
- :mod:`sigima.tools.signal.scaling`: Scaling algorithms
- :mod:`sigima.tools.signal.stability`: Stability analysis algorithms
- :mod:`sigima.tools.signal.windowing`: Windowing algorithms


Dynamic Parameter Extraction
^^^^^^^^^^^^^^^^^^^^^^^^^^^^

.. automodule:: sigima.tools.signal.dynamic
   :members:

Feature Extraction Algorithms
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

.. automodule:: sigima.tools.signal.features
   :members:

Curve Fitting Models
^^^^^^^^^^^^^^^^^^^^

.. automodule:: sigima.tools.signal.fitmodels
   :members:

Fourier Analysis Algorithms
^^^^^^^^^^^^^^^^^^^^^^^^^^^

.. automodule:: sigima.tools.signal.fourier
   :members:

Interpolation Algorithms
^^^^^^^^^^^^^^^^^^^^^^^^

.. automodule:: sigima.tools.signal.interpolation
   :members:

Peak Detection Algorithms
^^^^^^^^^^^^^^^^^^^^^^^^^

.. automodule:: sigima.tools.signal.peakdetection
   :members:

Pulse Analysis Algorithms
^^^^^^^^^^^^^^^^^^^^^^^^^

.. automodule:: sigima.tools.signal.pulse
   :members:

Scaling Algorithms
^^^^^^^^^^^^^^^^^^

.. automodule:: sigima.tools.signal.scaling
   :members:

Stability Analysis Algorithms
^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

.. automodule:: sigima.tools.signal.stability
   :members:

Windowing Algorithms
^^^^^^^^^^^^^^^^^^^^

.. automodule:: sigima.tools.signal.windowing
   :members:

"""
