from setuptools import setup, find_packages

setup(
    name='docuvert',
    version='1.3.5',
    packages=find_packages(where='src'),
    package_dir={'': 'src'},
    install_requires=[
        'pypandoc',
        'pandas',
        'openpyxl',
        'python-docx',
        'python-pptx',
        'PyMuPDF',
        'pdfplumber',
        'pdf2docx',
        'reportlab',
        'tabulate',
        'Jinja2',
        'playwright',
        'selenium',
        'webdriver-manager',
        'Pillow',
        'pillow-heif; platform_system!="Windows"',
        'pytesseract',
    ],
    author='Vanox Tech',
    author_email='dev@vanoxtech.com',
    description='Universal document converter supporting 250+ format combinations with OCR-enabled PDF text extraction and enhanced image support (PDF, DOCX, MD, TEX, CSV, XLSX, TXT, PNG, JPG, HEIC)',
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    url='https://github.com/avanomme/docuvert',
    keywords='document converter, pdf, docx, markdown, latex, csv, xlsx, file conversion, pandoc',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Intended Audience :: End Users/Desktop',
        'Topic :: Text Processing',
        'Topic :: Office/Business :: Office Suites',
        'Topic :: Utilities',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9', 
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
    ],
    python_requires='>=3.8',
    entry_points={
        'console_scripts': [
            'docuvert=docuvert.cli:main',
        ],
    },
)
