
import pytest
from converters.docx2md import Docx2MdConverter
import os
from docx import Document

# Helper function to create a dummy DOCX for testing
def create_dummy_docx(file_path):
    document = Document()
    document.add_paragraph("This is a dummy DOCX for testing.")
    document.save(file_path)

def test_docx2md_conversion(tmp_path):
    """
    Tests the DOCX to Markdown conversion.
    """
    input_docx = tmp_path / "dummy.docx"
    output_md = tmp_path / "output.md"
    
    create_dummy_docx(input_docx)

    converter = Docx2MdConverter()
    converter.convert(str(input_docx), str(output_md))

    assert os.path.exists(output_md)
    assert os.path.getsize(output_md) > 0

# TODO: Add tests for AST generation once implemented.
