DEFAULT_GENERAL_OPTIONS = {
    "generate_model_drawing": True,
    "show_model_drawing": True,
    "generate_fd_plot": True,
    "show_fd_plot": True,
    "generate_animation": True,
    "show_animation": True,
    "generate_parametric_fd_plots": True,
    "show_parametric_fd_plots": True,
    "generate_all_model_drawings": False,
    "show_all_model_drawings": False,
    "generate_all_fd_plots": False,
    "generate_all_animations": False,
}

DEFAULT_PLOT_OPTIONS = {
    "show_driven_path": False,
    "driven_path_only": False,
    "loading_sequence": 'cycle',
    "show_snapping_arrows": True,
    "drive_mode": 'none',
    "color_mode": "stability",
    "show_stability_legend": True,
    "show_driven_path_legend": True,
    "figure_width": 4,
    "figure_height": 4,
    "range_parameter_scan_colormap": 'viridis',
    "discrete_parameter_scan_colormap": 'tab10',
    "lowest_eigval_colormap": 'PuOr',
    "nb_negative_eigval_colormap": 'plasma',
    "max_nb_legend_entries_for_discrete_parameter": 4,
    "default_plot_name": 'fd_curve',
    "default_color": "#a0a0a0",
    "default_marker": 'o',
    "default_markersize": 2.5,
    "color_for_stable_points": "#86A7FC",
    "color_for_stabilizable_points": "#FFDD95",
    "color_for_unstable_points": "#FF9843",
    "driven_path_color": "#444444",
    "size_for_driven_path": 0.4,
    "snapping_arrow_color": "#aaaaaa",
    "snapping_arrow_opacity": 0.35,
    "size_for_stable_points": 1,
    "size_for_stabilizable_points": .66,
    "size_for_unstable_points": .33,
    "stylesheet": "default",
    "spine_offset": 10
}

DEFAULT_ANIMATION_OPTIONS = {
    "fps": 25,
    "nb_frames": 100,
    "dpi": 200,
    "drive_mode": 'none',
    "cycling": False,
    "default_animation_name": "animation",
    "save_as_mp4": False,
    "save_as_transparent_mov": False,
    "save_as_gif": True,
    "save_frames_as_png": False,
    "side_plot_mode": "force_displacement_curve",
    "stylesheet": "default",
    "spine_offset": 10,
    "animated_equilibrium_point_color": "#ff0000",
    "animated_equilibrium_point_size": 2,
}

DEFAULT_ASSEMBLY_APPEARANCE = {
    "coloring_mode": "generalized_force",
    "color_elements": True,
    "color_forces": False,
    "colormap": "coolwarm",
    "show_state_of_hysterons": True,
    "hysteron_state_label_size": 10,
    "hysteron_state_bg_color": "#E0E0E0",
    "hysteron_state_txt_color": "#101010",
    "show_forces": True,
    "force_vector_scaling": 1.0,
    "nb_spring_coils": 4,
    "spring_linewidth": 3,
    "spring_width_scaling": 1.0,
    "spring_default_opacity": 1.0,
    "spring_default_color": "#CECECE",
    "rotation_spring_linewidth": 3,
    "rotation_spring_radius_scaling": 1.0,
    "rotation_spring_default_opacity": 1.0,
    "rotation_spring_default_color": "#CECECE",
    "area_spring_default_opacity": 0.5,
    "area_spring_default_color": "#CECECE",
    "line_spring_linewidth": 3,
    "line_spring_default_opacity": 1.0,
    "line_spring_default_color": "#CECECE",
    "distance_spring_line_linewidth": 1.0,
    "distance_spring_line_default_color": "#CECECE",
    "distance_spring_line_default_opacity": 0.7,
    "node_size": 3,
    "node_color": "#101010",
    "show_node_numbers": False,
    "node_nb_color": "#CECECE",
    "force_inner_color": "#010101",
    "preload_force_inner_color": "#A0A0A0",
    "force_default_outer_color": "#CECECE",
    "force_vector_length_scaling": 1.0,
    "force_vector_connection": "tail"
}
