# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPrimaryContactResult',
    'AwaitableGetPrimaryContactResult',
    'get_primary_contact',
    'get_primary_contact_output',
]

@pulumi.output_type
class GetPrimaryContactResult:
    """
    A collection of values returned by getPrimaryContact.
    """
    def __init__(__self__, account_id=None, address_line1=None, address_line2=None, address_line3=None, city=None, company_name=None, country_code=None, district_or_county=None, full_name=None, id=None, phone_number=None, postal_code=None, state_or_region=None, website_url=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if address_line1 and not isinstance(address_line1, str):
            raise TypeError("Expected argument 'address_line1' to be a str")
        pulumi.set(__self__, "address_line1", address_line1)
        if address_line2 and not isinstance(address_line2, str):
            raise TypeError("Expected argument 'address_line2' to be a str")
        pulumi.set(__self__, "address_line2", address_line2)
        if address_line3 and not isinstance(address_line3, str):
            raise TypeError("Expected argument 'address_line3' to be a str")
        pulumi.set(__self__, "address_line3", address_line3)
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if company_name and not isinstance(company_name, str):
            raise TypeError("Expected argument 'company_name' to be a str")
        pulumi.set(__self__, "company_name", company_name)
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if district_or_county and not isinstance(district_or_county, str):
            raise TypeError("Expected argument 'district_or_county' to be a str")
        pulumi.set(__self__, "district_or_county", district_or_county)
        if full_name and not isinstance(full_name, str):
            raise TypeError("Expected argument 'full_name' to be a str")
        pulumi.set(__self__, "full_name", full_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if phone_number and not isinstance(phone_number, str):
            raise TypeError("Expected argument 'phone_number' to be a str")
        pulumi.set(__self__, "phone_number", phone_number)
        if postal_code and not isinstance(postal_code, str):
            raise TypeError("Expected argument 'postal_code' to be a str")
        pulumi.set(__self__, "postal_code", postal_code)
        if state_or_region and not isinstance(state_or_region, str):
            raise TypeError("Expected argument 'state_or_region' to be a str")
        pulumi.set(__self__, "state_or_region", state_or_region)
        if website_url and not isinstance(website_url, str):
            raise TypeError("Expected argument 'website_url' to be a str")
        pulumi.set(__self__, "website_url", website_url)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="addressLine1")
    def address_line1(self) -> builtins.str:
        """
        The first line of the primary contact address.
        """
        return pulumi.get(self, "address_line1")

    @property
    @pulumi.getter(name="addressLine2")
    def address_line2(self) -> builtins.str:
        """
        The second line of the primary contact address.
        """
        return pulumi.get(self, "address_line2")

    @property
    @pulumi.getter(name="addressLine3")
    def address_line3(self) -> builtins.str:
        """
        The third line of the primary contact address.
        """
        return pulumi.get(self, "address_line3")

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        The city of the primary contact address.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> builtins.str:
        """
        The name of the company associated with the primary contact information.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> builtins.str:
        """
        The ISO-3166 two-letter country code for the primary contact address.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="districtOrCounty")
    def district_or_county(self) -> builtins.str:
        """
        The district or county of the primary contact address.
        """
        return pulumi.get(self, "district_or_county")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> builtins.str:
        """
        The full name of the primary contact address.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> builtins.str:
        """
        The phone number of the primary contact information.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> builtins.str:
        """
        The postal code of the primary contact address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter(name="stateOrRegion")
    def state_or_region(self) -> builtins.str:
        """
        The state or region of the primary contact address.
        """
        return pulumi.get(self, "state_or_region")

    @property
    @pulumi.getter(name="websiteUrl")
    def website_url(self) -> builtins.str:
        """
        The URL of the website associated with the primary contact information.
        """
        return pulumi.get(self, "website_url")


class AwaitableGetPrimaryContactResult(GetPrimaryContactResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrimaryContactResult(
            account_id=self.account_id,
            address_line1=self.address_line1,
            address_line2=self.address_line2,
            address_line3=self.address_line3,
            city=self.city,
            company_name=self.company_name,
            country_code=self.country_code,
            district_or_county=self.district_or_county,
            full_name=self.full_name,
            id=self.id,
            phone_number=self.phone_number,
            postal_code=self.postal_code,
            state_or_region=self.state_or_region,
            website_url=self.website_url)


def get_primary_contact(account_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrimaryContactResult:
    """
    Data source for the primary contact information associated with an AWS Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.account.get_primary_contact()
    ```


    :param builtins.str account_id: The ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:account/getPrimaryContact:getPrimaryContact', __args__, opts=opts, typ=GetPrimaryContactResult).value

    return AwaitableGetPrimaryContactResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        address_line1=pulumi.get(__ret__, 'address_line1'),
        address_line2=pulumi.get(__ret__, 'address_line2'),
        address_line3=pulumi.get(__ret__, 'address_line3'),
        city=pulumi.get(__ret__, 'city'),
        company_name=pulumi.get(__ret__, 'company_name'),
        country_code=pulumi.get(__ret__, 'country_code'),
        district_or_county=pulumi.get(__ret__, 'district_or_county'),
        full_name=pulumi.get(__ret__, 'full_name'),
        id=pulumi.get(__ret__, 'id'),
        phone_number=pulumi.get(__ret__, 'phone_number'),
        postal_code=pulumi.get(__ret__, 'postal_code'),
        state_or_region=pulumi.get(__ret__, 'state_or_region'),
        website_url=pulumi.get(__ret__, 'website_url'))
def get_primary_contact_output(account_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPrimaryContactResult]:
    """
    Data source for the primary contact information associated with an AWS Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    test = aws.account.get_primary_contact()
    ```


    :param builtins.str account_id: The ID of the target account when managing member accounts. Will manage current user's account by default if omitted.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:account/getPrimaryContact:getPrimaryContact', __args__, opts=opts, typ=GetPrimaryContactResult)
    return __ret__.apply(lambda __response__: GetPrimaryContactResult(
        account_id=pulumi.get(__response__, 'account_id'),
        address_line1=pulumi.get(__response__, 'address_line1'),
        address_line2=pulumi.get(__response__, 'address_line2'),
        address_line3=pulumi.get(__response__, 'address_line3'),
        city=pulumi.get(__response__, 'city'),
        company_name=pulumi.get(__response__, 'company_name'),
        country_code=pulumi.get(__response__, 'country_code'),
        district_or_county=pulumi.get(__response__, 'district_or_county'),
        full_name=pulumi.get(__response__, 'full_name'),
        id=pulumi.get(__response__, 'id'),
        phone_number=pulumi.get(__response__, 'phone_number'),
        postal_code=pulumi.get(__response__, 'postal_code'),
        state_or_region=pulumi.get(__response__, 'state_or_region'),
        website_url=pulumi.get(__response__, 'website_url')))
