# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CertificateDomainValidationOptionArgs',
    'CertificateDomainValidationOptionArgsDict',
    'CertificateOptionsArgs',
    'CertificateOptionsArgsDict',
    'CertificateRenewalSummaryArgs',
    'CertificateRenewalSummaryArgsDict',
    'CertificateValidationOptionArgs',
    'CertificateValidationOptionArgsDict',
]

MYPY = False

if not MYPY:
    class CertificateDomainValidationOptionArgsDict(TypedDict):
        domain_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Fully qualified domain name (FQDN) in the certificate.
        """
        resource_record_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the DNS record to create to validate the certificate
        """
        resource_record_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of DNS record to create
        """
        resource_record_value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value the DNS record needs to have
        """
elif False:
    CertificateDomainValidationOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateDomainValidationOptionArgs:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_record_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_record_type: Optional[pulumi.Input[builtins.str]] = None,
                 resource_record_value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] domain_name: Fully qualified domain name (FQDN) in the certificate.
        :param pulumi.Input[builtins.str] resource_record_name: The name of the DNS record to create to validate the certificate
        :param pulumi.Input[builtins.str] resource_record_type: The type of DNS record to create
        :param pulumi.Input[builtins.str] resource_record_value: The value the DNS record needs to have
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if resource_record_name is not None:
            pulumi.set(__self__, "resource_record_name", resource_record_name)
        if resource_record_type is not None:
            pulumi.set(__self__, "resource_record_type", resource_record_type)
        if resource_record_value is not None:
            pulumi.set(__self__, "resource_record_value", resource_record_value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fully qualified domain name (FQDN) in the certificate.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="resourceRecordName")
    def resource_record_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the DNS record to create to validate the certificate
        """
        return pulumi.get(self, "resource_record_name")

    @resource_record_name.setter
    def resource_record_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_record_name", value)

    @property
    @pulumi.getter(name="resourceRecordType")
    def resource_record_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of DNS record to create
        """
        return pulumi.get(self, "resource_record_type")

    @resource_record_type.setter
    def resource_record_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_record_type", value)

    @property
    @pulumi.getter(name="resourceRecordValue")
    def resource_record_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value the DNS record needs to have
        """
        return pulumi.get(self, "resource_record_value")

    @resource_record_value.setter
    def resource_record_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_record_value", value)


if not MYPY:
    class CertificateOptionsArgsDict(TypedDict):
        certificate_transparency_logging_preference: NotRequired[pulumi.Input[builtins.str]]
        """
        Whether certificate details should be added to a certificate transparency log. Valid values are `ENABLED` or `DISABLED`. See https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency for more details.
        """
elif False:
    CertificateOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateOptionsArgs:
    def __init__(__self__, *,
                 certificate_transparency_logging_preference: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] certificate_transparency_logging_preference: Whether certificate details should be added to a certificate transparency log. Valid values are `ENABLED` or `DISABLED`. See https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency for more details.
        """
        if certificate_transparency_logging_preference is not None:
            pulumi.set(__self__, "certificate_transparency_logging_preference", certificate_transparency_logging_preference)

    @property
    @pulumi.getter(name="certificateTransparencyLoggingPreference")
    def certificate_transparency_logging_preference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether certificate details should be added to a certificate transparency log. Valid values are `ENABLED` or `DISABLED`. See https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency for more details.
        """
        return pulumi.get(self, "certificate_transparency_logging_preference")

    @certificate_transparency_logging_preference.setter
    def certificate_transparency_logging_preference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_transparency_logging_preference", value)


if not MYPY:
    class CertificateRenewalSummaryArgsDict(TypedDict):
        renewal_status: NotRequired[pulumi.Input[builtins.str]]
        """
        The status of ACM's managed renewal of the certificate
        """
        renewal_status_reason: NotRequired[pulumi.Input[builtins.str]]
        """
        The reason that a renewal request was unsuccessful or is pending
        """
        updated_at: NotRequired[pulumi.Input[builtins.str]]
elif False:
    CertificateRenewalSummaryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateRenewalSummaryArgs:
    def __init__(__self__, *,
                 renewal_status: Optional[pulumi.Input[builtins.str]] = None,
                 renewal_status_reason: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] renewal_status: The status of ACM's managed renewal of the certificate
        :param pulumi.Input[builtins.str] renewal_status_reason: The reason that a renewal request was unsuccessful or is pending
        """
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if renewal_status_reason is not None:
            pulumi.set(__self__, "renewal_status_reason", renewal_status_reason)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of ACM's managed renewal of the certificate
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "renewal_status", value)

    @property
    @pulumi.getter(name="renewalStatusReason")
    def renewal_status_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason that a renewal request was unsuccessful or is pending
        """
        return pulumi.get(self, "renewal_status_reason")

    @renewal_status_reason.setter
    def renewal_status_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "renewal_status_reason", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


if not MYPY:
    class CertificateValidationOptionArgsDict(TypedDict):
        domain_name: pulumi.Input[builtins.str]
        """
        Fully qualified domain name (FQDN) in the certificate.
        """
        validation_domain: pulumi.Input[builtins.str]
        """
        Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `"testing.example.com"`, you can specify `"example.com"` for this value.
        """
elif False:
    CertificateValidationOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CertificateValidationOptionArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[builtins.str],
                 validation_domain: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] domain_name: Fully qualified domain name (FQDN) in the certificate.
        :param pulumi.Input[builtins.str] validation_domain: Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `"testing.example.com"`, you can specify `"example.com"` for this value.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "validation_domain", validation_domain)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[builtins.str]:
        """
        Fully qualified domain name (FQDN) in the certificate.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="validationDomain")
    def validation_domain(self) -> pulumi.Input[builtins.str]:
        """
        Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `"testing.example.com"`, you can specify `"example.com"` for this value.
        """
        return pulumi.get(self, "validation_domain")

    @validation_domain.setter
    def validation_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "validation_domain", value)


