# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CertificateDomainValidationOption',
    'CertificateOptions',
    'CertificateRenewalSummary',
    'CertificateValidationOption',
]

@pulumi.output_type
class CertificateDomainValidationOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "resourceRecordName":
            suggest = "resource_record_name"
        elif key == "resourceRecordType":
            suggest = "resource_record_type"
        elif key == "resourceRecordValue":
            suggest = "resource_record_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateDomainValidationOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateDomainValidationOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateDomainValidationOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[builtins.str] = None,
                 resource_record_name: Optional[builtins.str] = None,
                 resource_record_type: Optional[builtins.str] = None,
                 resource_record_value: Optional[builtins.str] = None):
        """
        :param builtins.str domain_name: Fully qualified domain name (FQDN) in the certificate.
        :param builtins.str resource_record_name: The name of the DNS record to create to validate the certificate
        :param builtins.str resource_record_type: The type of DNS record to create
        :param builtins.str resource_record_value: The value the DNS record needs to have
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if resource_record_name is not None:
            pulumi.set(__self__, "resource_record_name", resource_record_name)
        if resource_record_type is not None:
            pulumi.set(__self__, "resource_record_type", resource_record_type)
        if resource_record_value is not None:
            pulumi.set(__self__, "resource_record_value", resource_record_value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[builtins.str]:
        """
        Fully qualified domain name (FQDN) in the certificate.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="resourceRecordName")
    def resource_record_name(self) -> Optional[builtins.str]:
        """
        The name of the DNS record to create to validate the certificate
        """
        return pulumi.get(self, "resource_record_name")

    @property
    @pulumi.getter(name="resourceRecordType")
    def resource_record_type(self) -> Optional[builtins.str]:
        """
        The type of DNS record to create
        """
        return pulumi.get(self, "resource_record_type")

    @property
    @pulumi.getter(name="resourceRecordValue")
    def resource_record_value(self) -> Optional[builtins.str]:
        """
        The value the DNS record needs to have
        """
        return pulumi.get(self, "resource_record_value")


@pulumi.output_type
class CertificateOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateTransparencyLoggingPreference":
            suggest = "certificate_transparency_logging_preference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_transparency_logging_preference: Optional[builtins.str] = None):
        """
        :param builtins.str certificate_transparency_logging_preference: Whether certificate details should be added to a certificate transparency log. Valid values are `ENABLED` or `DISABLED`. See https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency for more details.
        """
        if certificate_transparency_logging_preference is not None:
            pulumi.set(__self__, "certificate_transparency_logging_preference", certificate_transparency_logging_preference)

    @property
    @pulumi.getter(name="certificateTransparencyLoggingPreference")
    def certificate_transparency_logging_preference(self) -> Optional[builtins.str]:
        """
        Whether certificate details should be added to a certificate transparency log. Valid values are `ENABLED` or `DISABLED`. See https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency for more details.
        """
        return pulumi.get(self, "certificate_transparency_logging_preference")


@pulumi.output_type
class CertificateRenewalSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "renewalStatus":
            suggest = "renewal_status"
        elif key == "renewalStatusReason":
            suggest = "renewal_status_reason"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateRenewalSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateRenewalSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateRenewalSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 renewal_status: Optional[builtins.str] = None,
                 renewal_status_reason: Optional[builtins.str] = None,
                 updated_at: Optional[builtins.str] = None):
        """
        :param builtins.str renewal_status: The status of ACM's managed renewal of the certificate
        :param builtins.str renewal_status_reason: The reason that a renewal request was unsuccessful or is pending
        """
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if renewal_status_reason is not None:
            pulumi.set(__self__, "renewal_status_reason", renewal_status_reason)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[builtins.str]:
        """
        The status of ACM's managed renewal of the certificate
        """
        return pulumi.get(self, "renewal_status")

    @property
    @pulumi.getter(name="renewalStatusReason")
    def renewal_status_reason(self) -> Optional[builtins.str]:
        """
        The reason that a renewal request was unsuccessful or is pending
        """
        return pulumi.get(self, "renewal_status_reason")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class CertificateValidationOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "validationDomain":
            suggest = "validation_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateValidationOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateValidationOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateValidationOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: builtins.str,
                 validation_domain: builtins.str):
        """
        :param builtins.str domain_name: Fully qualified domain name (FQDN) in the certificate.
        :param builtins.str validation_domain: Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `"testing.example.com"`, you can specify `"example.com"` for this value.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "validation_domain", validation_domain)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> builtins.str:
        """
        Fully qualified domain name (FQDN) in the certificate.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="validationDomain")
    def validation_domain(self) -> builtins.str:
        """
        Domain name that you want ACM to use to send you validation emails. This domain name is the suffix of the email addresses that you want ACM to use. This must be the same as the `domain_name` value or a superdomain of the `domain_name` value. For example, if you request a certificate for `"testing.example.com"`, you can specify `"example.com"` for this value.
        """
        return pulumi.get(self, "validation_domain")


