# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ListenerDefaultActionArgs',
    'ListenerDefaultActionArgsDict',
    'ListenerDefaultActionAuthenticateCognitoArgs',
    'ListenerDefaultActionAuthenticateCognitoArgsDict',
    'ListenerDefaultActionAuthenticateOidcArgs',
    'ListenerDefaultActionAuthenticateOidcArgsDict',
    'ListenerDefaultActionFixedResponseArgs',
    'ListenerDefaultActionFixedResponseArgsDict',
    'ListenerDefaultActionForwardArgs',
    'ListenerDefaultActionForwardArgsDict',
    'ListenerDefaultActionForwardStickinessArgs',
    'ListenerDefaultActionForwardStickinessArgsDict',
    'ListenerDefaultActionForwardTargetGroupArgs',
    'ListenerDefaultActionForwardTargetGroupArgsDict',
    'ListenerDefaultActionRedirectArgs',
    'ListenerDefaultActionRedirectArgsDict',
    'ListenerMutualAuthenticationArgs',
    'ListenerMutualAuthenticationArgsDict',
    'ListenerRuleActionArgs',
    'ListenerRuleActionArgsDict',
    'ListenerRuleActionAuthenticateCognitoArgs',
    'ListenerRuleActionAuthenticateCognitoArgsDict',
    'ListenerRuleActionAuthenticateOidcArgs',
    'ListenerRuleActionAuthenticateOidcArgsDict',
    'ListenerRuleActionFixedResponseArgs',
    'ListenerRuleActionFixedResponseArgsDict',
    'ListenerRuleActionForwardArgs',
    'ListenerRuleActionForwardArgsDict',
    'ListenerRuleActionForwardStickinessArgs',
    'ListenerRuleActionForwardStickinessArgsDict',
    'ListenerRuleActionForwardTargetGroupArgs',
    'ListenerRuleActionForwardTargetGroupArgsDict',
    'ListenerRuleActionRedirectArgs',
    'ListenerRuleActionRedirectArgsDict',
    'ListenerRuleConditionArgs',
    'ListenerRuleConditionArgsDict',
    'ListenerRuleConditionHostHeaderArgs',
    'ListenerRuleConditionHostHeaderArgsDict',
    'ListenerRuleConditionHttpHeaderArgs',
    'ListenerRuleConditionHttpHeaderArgsDict',
    'ListenerRuleConditionHttpRequestMethodArgs',
    'ListenerRuleConditionHttpRequestMethodArgsDict',
    'ListenerRuleConditionPathPatternArgs',
    'ListenerRuleConditionPathPatternArgsDict',
    'ListenerRuleConditionQueryStringArgs',
    'ListenerRuleConditionQueryStringArgsDict',
    'ListenerRuleConditionSourceIpArgs',
    'ListenerRuleConditionSourceIpArgsDict',
    'LoadBalancerAccessLogsArgs',
    'LoadBalancerAccessLogsArgsDict',
    'LoadBalancerConnectionLogsArgs',
    'LoadBalancerConnectionLogsArgsDict',
    'LoadBalancerIpamPoolsArgs',
    'LoadBalancerIpamPoolsArgsDict',
    'LoadBalancerMinimumLoadBalancerCapacityArgs',
    'LoadBalancerMinimumLoadBalancerCapacityArgsDict',
    'LoadBalancerSubnetMappingArgs',
    'LoadBalancerSubnetMappingArgsDict',
    'TargetGroupHealthCheckArgs',
    'TargetGroupHealthCheckArgsDict',
    'TargetGroupStickinessArgs',
    'TargetGroupStickinessArgsDict',
    'TargetGroupTargetFailoverArgs',
    'TargetGroupTargetFailoverArgsDict',
    'TargetGroupTargetGroupHealthArgs',
    'TargetGroupTargetGroupHealthArgsDict',
    'TargetGroupTargetGroupHealthDnsFailoverArgs',
    'TargetGroupTargetGroupHealthDnsFailoverArgsDict',
    'TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs',
    'TargetGroupTargetGroupHealthUnhealthyStateRoutingArgsDict',
    'TargetGroupTargetHealthStateArgs',
    'TargetGroupTargetHealthStateArgsDict',
]

MYPY = False

if not MYPY:
    class ListenerDefaultActionArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.

        The following arguments are optional:
        """
        authenticate_cognito: NotRequired[pulumi.Input['ListenerDefaultActionAuthenticateCognitoArgsDict']]
        """
        Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. See below.
        """
        authenticate_oidc: NotRequired[pulumi.Input['ListenerDefaultActionAuthenticateOidcArgsDict']]
        """
        Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. See below.
        """
        fixed_response: NotRequired[pulumi.Input['ListenerDefaultActionFixedResponseArgsDict']]
        """
        Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        """
        forward: NotRequired[pulumi.Input['ListenerDefaultActionForwardArgsDict']]
        """
        Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. See below.
        """
        order: NotRequired[pulumi.Input[builtins.int]]
        """
        Order for the action. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`. Defaults to the position in the list of actions.
        """
        redirect: NotRequired[pulumi.Input['ListenerDefaultActionRedirectArgsDict']]
        """
        Configuration block for creating a redirect action. Required if `type` is `redirect`. See below.
        """
        target_group_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead. Can be specified with `forward` but ARNs must match.
        """
elif False:
    ListenerDefaultActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerDefaultActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 authenticate_cognito: Optional[pulumi.Input['ListenerDefaultActionAuthenticateCognitoArgs']] = None,
                 authenticate_oidc: Optional[pulumi.Input['ListenerDefaultActionAuthenticateOidcArgs']] = None,
                 fixed_response: Optional[pulumi.Input['ListenerDefaultActionFixedResponseArgs']] = None,
                 forward: Optional[pulumi.Input['ListenerDefaultActionForwardArgs']] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None,
                 redirect: Optional[pulumi.Input['ListenerDefaultActionRedirectArgs']] = None,
                 target_group_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
               
               The following arguments are optional:
        :param pulumi.Input['ListenerDefaultActionAuthenticateCognitoArgs'] authenticate_cognito: Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. See below.
        :param pulumi.Input['ListenerDefaultActionAuthenticateOidcArgs'] authenticate_oidc: Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. See below.
        :param pulumi.Input['ListenerDefaultActionFixedResponseArgs'] fixed_response: Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        :param pulumi.Input['ListenerDefaultActionForwardArgs'] forward: Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. See below.
        :param pulumi.Input[builtins.int] order: Order for the action. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`. Defaults to the position in the list of actions.
        :param pulumi.Input['ListenerDefaultActionRedirectArgs'] redirect: Configuration block for creating a redirect action. Required if `type` is `redirect`. See below.
        :param pulumi.Input[builtins.str] target_group_arn: ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead. Can be specified with `forward` but ARNs must match.
        """
        pulumi.set(__self__, "type", type)
        if authenticate_cognito is not None:
            pulumi.set(__self__, "authenticate_cognito", authenticate_cognito)
        if authenticate_oidc is not None:
            pulumi.set(__self__, "authenticate_oidc", authenticate_oidc)
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticateCognito")
    def authenticate_cognito(self) -> Optional[pulumi.Input['ListenerDefaultActionAuthenticateCognitoArgs']]:
        """
        Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. See below.
        """
        return pulumi.get(self, "authenticate_cognito")

    @authenticate_cognito.setter
    def authenticate_cognito(self, value: Optional[pulumi.Input['ListenerDefaultActionAuthenticateCognitoArgs']]):
        pulumi.set(self, "authenticate_cognito", value)

    @property
    @pulumi.getter(name="authenticateOidc")
    def authenticate_oidc(self) -> Optional[pulumi.Input['ListenerDefaultActionAuthenticateOidcArgs']]:
        """
        Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. See below.
        """
        return pulumi.get(self, "authenticate_oidc")

    @authenticate_oidc.setter
    def authenticate_oidc(self, value: Optional[pulumi.Input['ListenerDefaultActionAuthenticateOidcArgs']]):
        pulumi.set(self, "authenticate_oidc", value)

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional[pulumi.Input['ListenerDefaultActionFixedResponseArgs']]:
        """
        Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        """
        return pulumi.get(self, "fixed_response")

    @fixed_response.setter
    def fixed_response(self, value: Optional[pulumi.Input['ListenerDefaultActionFixedResponseArgs']]):
        pulumi.set(self, "fixed_response", value)

    @property
    @pulumi.getter
    def forward(self) -> Optional[pulumi.Input['ListenerDefaultActionForwardArgs']]:
        """
        Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. See below.
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: Optional[pulumi.Input['ListenerDefaultActionForwardArgs']]):
        pulumi.set(self, "forward", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Order for the action. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`. Defaults to the position in the list of actions.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def redirect(self) -> Optional[pulumi.Input['ListenerDefaultActionRedirectArgs']]:
        """
        Configuration block for creating a redirect action. Required if `type` is `redirect`. See below.
        """
        return pulumi.get(self, "redirect")

    @redirect.setter
    def redirect(self, value: Optional[pulumi.Input['ListenerDefaultActionRedirectArgs']]):
        pulumi.set(self, "redirect", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead. Can be specified with `forward` but ARNs must match.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_group_arn", value)


if not MYPY:
    class ListenerDefaultActionAuthenticateCognitoArgsDict(TypedDict):
        user_pool_arn: pulumi.Input[builtins.str]
        """
        ARN of the Cognito user pool.
        """
        user_pool_client_id: pulumi.Input[builtins.str]
        """
        ID of the Cognito user pool client.
        """
        user_pool_domain: pulumi.Input[builtins.str]
        """
        Domain prefix or fully-qualified domain name of the Cognito user pool.

        The following arguments are optional:
        """
        authentication_request_extra_params: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Query parameters to include in the redirect request to the authorization endpoint. Max: 10. See below.
        """
        on_unauthenticated_request: NotRequired[pulumi.Input[builtins.str]]
        """
        Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
        """
        scope: NotRequired[pulumi.Input[builtins.str]]
        """
        Set of user claims to be requested from the IdP.
        """
        session_cookie_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the cookie used to maintain session information.
        """
        session_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum duration of the authentication session, in seconds.
        """
elif False:
    ListenerDefaultActionAuthenticateCognitoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerDefaultActionAuthenticateCognitoArgs:
    def __init__(__self__, *,
                 user_pool_arn: pulumi.Input[builtins.str],
                 user_pool_client_id: pulumi.Input[builtins.str],
                 user_pool_domain: pulumi.Input[builtins.str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 session_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] user_pool_arn: ARN of the Cognito user pool.
        :param pulumi.Input[builtins.str] user_pool_client_id: ID of the Cognito user pool client.
        :param pulumi.Input[builtins.str] user_pool_domain: Domain prefix or fully-qualified domain name of the Cognito user pool.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] authentication_request_extra_params: Query parameters to include in the redirect request to the authorization endpoint. Max: 10. See below.
        :param pulumi.Input[builtins.str] on_unauthenticated_request: Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
        :param pulumi.Input[builtins.str] scope: Set of user claims to be requested from the IdP.
        :param pulumi.Input[builtins.str] session_cookie_name: Name of the cookie used to maintain session information.
        :param pulumi.Input[builtins.int] session_timeout: Maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @user_pool_arn.setter
    def user_pool_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_arn", value)

    @property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @user_pool_client_id.setter
    def user_pool_client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_client_id", value)

    @property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> pulumi.Input[builtins.str]:
        """
        Domain prefix or fully-qualified domain name of the Cognito user pool.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_pool_domain")

    @user_pool_domain.setter
    def user_pool_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_domain", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Query parameters to include in the redirect request to the authorization endpoint. Max: 10. See below.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_timeout", value)


if not MYPY:
    class ListenerDefaultActionAuthenticateOidcArgsDict(TypedDict):
        authorization_endpoint: pulumi.Input[builtins.str]
        """
        Authorization endpoint of the IdP.
        """
        client_id: pulumi.Input[builtins.str]
        """
        OAuth 2.0 client identifier.
        """
        client_secret: pulumi.Input[builtins.str]
        """
        OAuth 2.0 client secret.
        """
        issuer: pulumi.Input[builtins.str]
        """
        OIDC issuer identifier of the IdP.
        """
        token_endpoint: pulumi.Input[builtins.str]
        """
        Token endpoint of the IdP.
        """
        user_info_endpoint: pulumi.Input[builtins.str]
        """
        User info endpoint of the IdP.

        The following arguments are optional:
        """
        authentication_request_extra_params: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        on_unauthenticated_request: NotRequired[pulumi.Input[builtins.str]]
        """
        Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        scope: NotRequired[pulumi.Input[builtins.str]]
        """
        Set of user claims to be requested from the IdP.
        """
        session_cookie_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the cookie used to maintain session information.
        """
        session_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Maximum duration of the authentication session, in seconds.
        """
elif False:
    ListenerDefaultActionAuthenticateOidcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerDefaultActionAuthenticateOidcArgs:
    def __init__(__self__, *,
                 authorization_endpoint: pulumi.Input[builtins.str],
                 client_id: pulumi.Input[builtins.str],
                 client_secret: pulumi.Input[builtins.str],
                 issuer: pulumi.Input[builtins.str],
                 token_endpoint: pulumi.Input[builtins.str],
                 user_info_endpoint: pulumi.Input[builtins.str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 session_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] authorization_endpoint: Authorization endpoint of the IdP.
        :param pulumi.Input[builtins.str] client_id: OAuth 2.0 client identifier.
        :param pulumi.Input[builtins.str] client_secret: OAuth 2.0 client secret.
        :param pulumi.Input[builtins.str] issuer: OIDC issuer identifier of the IdP.
        :param pulumi.Input[builtins.str] token_endpoint: Token endpoint of the IdP.
        :param pulumi.Input[builtins.str] user_info_endpoint: User info endpoint of the IdP.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] authentication_request_extra_params: Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param pulumi.Input[builtins.str] on_unauthenticated_request: Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param pulumi.Input[builtins.str] scope: Set of user claims to be requested from the IdP.
        :param pulumi.Input[builtins.str] session_cookie_name: Name of the cookie used to maintain session information.
        :param pulumi.Input[builtins.int] session_timeout: Maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        Authorization endpoint of the IdP.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[builtins.str]:
        """
        OAuth 2.0 client secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[builtins.str]:
        """
        OIDC issuer identifier of the IdP.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        Token endpoint of the IdP.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token_endpoint", value)

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        User info endpoint of the IdP.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_info_endpoint")

    @user_info_endpoint.setter
    def user_info_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_info_endpoint", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_timeout", value)


if not MYPY:
    class ListenerDefaultActionFixedResponseArgsDict(TypedDict):
        content_type: pulumi.Input[builtins.str]
        """
        Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.

        The following arguments are optional:
        """
        message_body: NotRequired[pulumi.Input[builtins.str]]
        """
        Message body.
        """
        status_code: NotRequired[pulumi.Input[builtins.str]]
        """
        HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
elif False:
    ListenerDefaultActionFixedResponseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerDefaultActionFixedResponseArgs:
    def __init__(__self__, *,
                 content_type: pulumi.Input[builtins.str],
                 message_body: Optional[pulumi.Input[builtins.str]] = None,
                 status_code: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] content_type: Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] message_body: Message body.
        :param pulumi.Input[builtins.str] status_code: HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[builtins.str]:
        """
        Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.

        The following arguments are optional:
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Message body.
        """
        return pulumi.get(self, "message_body")

    @message_body.setter
    def message_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_body", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_code", value)


if not MYPY:
    class ListenerDefaultActionForwardArgsDict(TypedDict):
        target_groups: pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionForwardTargetGroupArgsDict']]]
        """
        Set of 1-5 target group blocks. See below.

        The following arguments are optional:
        """
        stickiness: NotRequired[pulumi.Input['ListenerDefaultActionForwardStickinessArgsDict']]
        """
        Configuration block for target group stickiness for the rule. See below.
        """
elif False:
    ListenerDefaultActionForwardArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerDefaultActionForwardArgs:
    def __init__(__self__, *,
                 target_groups: pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionForwardTargetGroupArgs']]],
                 stickiness: Optional[pulumi.Input['ListenerDefaultActionForwardStickinessArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionForwardTargetGroupArgs']]] target_groups: Set of 1-5 target group blocks. See below.
               
               The following arguments are optional:
        :param pulumi.Input['ListenerDefaultActionForwardStickinessArgs'] stickiness: Configuration block for target group stickiness for the rule. See below.
        """
        pulumi.set(__self__, "target_groups", target_groups)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionForwardTargetGroupArgs']]]:
        """
        Set of 1-5 target group blocks. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_groups")

    @target_groups.setter
    def target_groups(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerDefaultActionForwardTargetGroupArgs']]]):
        pulumi.set(self, "target_groups", value)

    @property
    @pulumi.getter
    def stickiness(self) -> Optional[pulumi.Input['ListenerDefaultActionForwardStickinessArgs']]:
        """
        Configuration block for target group stickiness for the rule. See below.
        """
        return pulumi.get(self, "stickiness")

    @stickiness.setter
    def stickiness(self, value: Optional[pulumi.Input['ListenerDefaultActionForwardStickinessArgs']]):
        pulumi.set(self, "stickiness", value)


if not MYPY:
    class ListenerDefaultActionForwardStickinessArgsDict(TypedDict):
        duration: pulumi.Input[builtins.int]
        """
        Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).

        The following arguments are optional:
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether target group stickiness is enabled. Default is `false`.
        """
elif False:
    ListenerDefaultActionForwardStickinessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerDefaultActionForwardStickinessArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[builtins.int],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] duration: Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] enabled: Whether target group stickiness is enabled. Default is `false`.
        """
        pulumi.set(__self__, "duration", duration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[builtins.int]:
        """
        Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).

        The following arguments are optional:
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether target group stickiness is enabled. Default is `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ListenerDefaultActionForwardTargetGroupArgsDict(TypedDict):
        arn: pulumi.Input[builtins.str]
        """
        ARN of the target group.

        The following arguments are optional:
        """
        weight: NotRequired[pulumi.Input[builtins.int]]
        """
        Weight. The range is 0 to 999.
        """
elif False:
    ListenerDefaultActionForwardTargetGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerDefaultActionForwardTargetGroupArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[builtins.str],
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] arn: ARN of the target group.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.int] weight: Weight. The range is 0 to 999.
        """
        pulumi.set(__self__, "arn", arn)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the target group.

        The following arguments are optional:
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Weight. The range is 0 to 999.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class ListenerDefaultActionRedirectArgsDict(TypedDict):
        status_code: pulumi.Input[builtins.str]
        """
        HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).

        The following arguments are optional:
        """
        host: NotRequired[pulumi.Input[builtins.str]]
        """
        Hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        Absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        """
        port: NotRequired[pulumi.Input[builtins.str]]
        """
        Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        protocol: NotRequired[pulumi.Input[builtins.str]]
        """
        Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        query: NotRequired[pulumi.Input[builtins.str]]
        """
        Query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
elif False:
    ListenerDefaultActionRedirectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerDefaultActionRedirectArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[builtins.str],
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] status_code: HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] host: Hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        :param pulumi.Input[builtins.str] path: Absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        :param pulumi.Input[builtins.str] port: Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        :param pulumi.Input[builtins.str] protocol: Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        :param pulumi.Input[builtins.str] query: Query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        pulumi.set(__self__, "status_code", status_code)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[builtins.str]:
        """
        HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).

        The following arguments are optional:
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query", value)


if not MYPY:
    class ListenerMutualAuthenticationArgsDict(TypedDict):
        mode: pulumi.Input[builtins.str]
        """
        Valid values are `off`, `passthrough`, and `verify`.
        """
        advertise_trust_store_ca_names: NotRequired[pulumi.Input[builtins.str]]
        """
        Valid values are `off` and `on`.
        """
        ignore_client_certificate_expiry: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether client certificate expiry is ignored.
        Default is `false`.
        """
        trust_store_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN of the elbv2 Trust Store.
        """
elif False:
    ListenerMutualAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerMutualAuthenticationArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[builtins.str],
                 advertise_trust_store_ca_names: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_client_certificate_expiry: Optional[pulumi.Input[builtins.bool]] = None,
                 trust_store_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] mode: Valid values are `off`, `passthrough`, and `verify`.
        :param pulumi.Input[builtins.str] advertise_trust_store_ca_names: Valid values are `off` and `on`.
        :param pulumi.Input[builtins.bool] ignore_client_certificate_expiry: Whether client certificate expiry is ignored.
               Default is `false`.
        :param pulumi.Input[builtins.str] trust_store_arn: ARN of the elbv2 Trust Store.
        """
        pulumi.set(__self__, "mode", mode)
        if advertise_trust_store_ca_names is not None:
            pulumi.set(__self__, "advertise_trust_store_ca_names", advertise_trust_store_ca_names)
        if ignore_client_certificate_expiry is not None:
            pulumi.set(__self__, "ignore_client_certificate_expiry", ignore_client_certificate_expiry)
        if trust_store_arn is not None:
            pulumi.set(__self__, "trust_store_arn", trust_store_arn)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[builtins.str]:
        """
        Valid values are `off`, `passthrough`, and `verify`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="advertiseTrustStoreCaNames")
    def advertise_trust_store_ca_names(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Valid values are `off` and `on`.
        """
        return pulumi.get(self, "advertise_trust_store_ca_names")

    @advertise_trust_store_ca_names.setter
    def advertise_trust_store_ca_names(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "advertise_trust_store_ca_names", value)

    @property
    @pulumi.getter(name="ignoreClientCertificateExpiry")
    def ignore_client_certificate_expiry(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether client certificate expiry is ignored.
        Default is `false`.
        """
        return pulumi.get(self, "ignore_client_certificate_expiry")

    @ignore_client_certificate_expiry.setter
    def ignore_client_certificate_expiry(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_client_certificate_expiry", value)

    @property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the elbv2 Trust Store.
        """
        return pulumi.get(self, "trust_store_arn")

    @trust_store_arn.setter
    def trust_store_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trust_store_arn", value)


if not MYPY:
    class ListenerRuleActionArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
        """
        authenticate_cognito: NotRequired[pulumi.Input['ListenerRuleActionAuthenticateCognitoArgsDict']]
        """
        Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
        """
        authenticate_oidc: NotRequired[pulumi.Input['ListenerRuleActionAuthenticateOidcArgsDict']]
        """
        Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
        """
        fixed_response: NotRequired[pulumi.Input['ListenerRuleActionFixedResponseArgsDict']]
        """
        Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        """
        forward: NotRequired[pulumi.Input['ListenerRuleActionForwardArgsDict']]
        """
        Configuration block for creating an action that distributes requests among one or more target groups.
        Specify only if `type` is `forward`.
        Cannot be specified with `target_group_arn`.
        """
        order: NotRequired[pulumi.Input[builtins.int]]
        """
        Order for the action.
        The action with the lowest value for order is performed first.
        Valid values are between `1` and `50000`.
        Defaults to the position in the list of actions.
        """
        redirect: NotRequired[pulumi.Input['ListenerRuleActionRedirectArgsDict']]
        """
        Information for creating a redirect action. Required if `type` is `redirect`.
        """
        target_group_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN of the Target Group to which to route traffic.
        Specify only if `type` is `forward` and you want to route to a single target group.
        To route to one or more target groups, use a `forward` block instead.
        Cannot be specified with `forward`.
        """
elif False:
    ListenerRuleActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 authenticate_cognito: Optional[pulumi.Input['ListenerRuleActionAuthenticateCognitoArgs']] = None,
                 authenticate_oidc: Optional[pulumi.Input['ListenerRuleActionAuthenticateOidcArgs']] = None,
                 fixed_response: Optional[pulumi.Input['ListenerRuleActionFixedResponseArgs']] = None,
                 forward: Optional[pulumi.Input['ListenerRuleActionForwardArgs']] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None,
                 redirect: Optional[pulumi.Input['ListenerRuleActionRedirectArgs']] = None,
                 target_group_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
        :param pulumi.Input['ListenerRuleActionAuthenticateCognitoArgs'] authenticate_cognito: Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
        :param pulumi.Input['ListenerRuleActionAuthenticateOidcArgs'] authenticate_oidc: Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
        :param pulumi.Input['ListenerRuleActionFixedResponseArgs'] fixed_response: Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        :param pulumi.Input['ListenerRuleActionForwardArgs'] forward: Configuration block for creating an action that distributes requests among one or more target groups.
               Specify only if `type` is `forward`.
               Cannot be specified with `target_group_arn`.
        :param pulumi.Input[builtins.int] order: Order for the action.
               The action with the lowest value for order is performed first.
               Valid values are between `1` and `50000`.
               Defaults to the position in the list of actions.
        :param pulumi.Input['ListenerRuleActionRedirectArgs'] redirect: Information for creating a redirect action. Required if `type` is `redirect`.
        :param pulumi.Input[builtins.str] target_group_arn: ARN of the Target Group to which to route traffic.
               Specify only if `type` is `forward` and you want to route to a single target group.
               To route to one or more target groups, use a `forward` block instead.
               Cannot be specified with `forward`.
        """
        pulumi.set(__self__, "type", type)
        if authenticate_cognito is not None:
            pulumi.set(__self__, "authenticate_cognito", authenticate_cognito)
        if authenticate_oidc is not None:
            pulumi.set(__self__, "authenticate_oidc", authenticate_oidc)
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticateCognito")
    def authenticate_cognito(self) -> Optional[pulumi.Input['ListenerRuleActionAuthenticateCognitoArgs']]:
        """
        Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
        """
        return pulumi.get(self, "authenticate_cognito")

    @authenticate_cognito.setter
    def authenticate_cognito(self, value: Optional[pulumi.Input['ListenerRuleActionAuthenticateCognitoArgs']]):
        pulumi.set(self, "authenticate_cognito", value)

    @property
    @pulumi.getter(name="authenticateOidc")
    def authenticate_oidc(self) -> Optional[pulumi.Input['ListenerRuleActionAuthenticateOidcArgs']]:
        """
        Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
        """
        return pulumi.get(self, "authenticate_oidc")

    @authenticate_oidc.setter
    def authenticate_oidc(self, value: Optional[pulumi.Input['ListenerRuleActionAuthenticateOidcArgs']]):
        pulumi.set(self, "authenticate_oidc", value)

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional[pulumi.Input['ListenerRuleActionFixedResponseArgs']]:
        """
        Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        """
        return pulumi.get(self, "fixed_response")

    @fixed_response.setter
    def fixed_response(self, value: Optional[pulumi.Input['ListenerRuleActionFixedResponseArgs']]):
        pulumi.set(self, "fixed_response", value)

    @property
    @pulumi.getter
    def forward(self) -> Optional[pulumi.Input['ListenerRuleActionForwardArgs']]:
        """
        Configuration block for creating an action that distributes requests among one or more target groups.
        Specify only if `type` is `forward`.
        Cannot be specified with `target_group_arn`.
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: Optional[pulumi.Input['ListenerRuleActionForwardArgs']]):
        pulumi.set(self, "forward", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Order for the action.
        The action with the lowest value for order is performed first.
        Valid values are between `1` and `50000`.
        Defaults to the position in the list of actions.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def redirect(self) -> Optional[pulumi.Input['ListenerRuleActionRedirectArgs']]:
        """
        Information for creating a redirect action. Required if `type` is `redirect`.
        """
        return pulumi.get(self, "redirect")

    @redirect.setter
    def redirect(self, value: Optional[pulumi.Input['ListenerRuleActionRedirectArgs']]):
        pulumi.set(self, "redirect", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Target Group to which to route traffic.
        Specify only if `type` is `forward` and you want to route to a single target group.
        To route to one or more target groups, use a `forward` block instead.
        Cannot be specified with `forward`.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_group_arn", value)


if not MYPY:
    class ListenerRuleActionAuthenticateCognitoArgsDict(TypedDict):
        user_pool_arn: pulumi.Input[builtins.str]
        """
        The ARN of the Cognito user pool.
        """
        user_pool_client_id: pulumi.Input[builtins.str]
        """
        The ID of the Cognito user pool client.
        """
        user_pool_domain: pulumi.Input[builtins.str]
        """
        The domain prefix or fully-qualified domain name of the Cognito user pool.
        """
        authentication_request_extra_params: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        on_unauthenticated_request: NotRequired[pulumi.Input[builtins.str]]
        """
        The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        scope: NotRequired[pulumi.Input[builtins.str]]
        """
        The set of user claims to be requested from the IdP.
        """
        session_cookie_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the cookie used to maintain session information.
        """
        session_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum duration of the authentication session, in seconds.
        """
elif False:
    ListenerRuleActionAuthenticateCognitoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleActionAuthenticateCognitoArgs:
    def __init__(__self__, *,
                 user_pool_arn: pulumi.Input[builtins.str],
                 user_pool_client_id: pulumi.Input[builtins.str],
                 user_pool_domain: pulumi.Input[builtins.str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 session_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] user_pool_arn: The ARN of the Cognito user pool.
        :param pulumi.Input[builtins.str] user_pool_client_id: The ID of the Cognito user pool client.
        :param pulumi.Input[builtins.str] user_pool_domain: The domain prefix or fully-qualified domain name of the Cognito user pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] authentication_request_extra_params: The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param pulumi.Input[builtins.str] on_unauthenticated_request: The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param pulumi.Input[builtins.str] scope: The set of user claims to be requested from the IdP.
        :param pulumi.Input[builtins.str] session_cookie_name: The name of the cookie used to maintain session information.
        :param pulumi.Input[builtins.int] session_timeout: The maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @user_pool_arn.setter
    def user_pool_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_arn", value)

    @property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @user_pool_client_id.setter
    def user_pool_client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_client_id", value)

    @property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> pulumi.Input[builtins.str]:
        """
        The domain prefix or fully-qualified domain name of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_domain")

    @user_pool_domain.setter
    def user_pool_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_domain", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_timeout", value)


if not MYPY:
    class ListenerRuleActionAuthenticateOidcArgsDict(TypedDict):
        authorization_endpoint: pulumi.Input[builtins.str]
        """
        The authorization endpoint of the IdP.
        """
        client_id: pulumi.Input[builtins.str]
        """
        The OAuth 2.0 client identifier.
        """
        client_secret: pulumi.Input[builtins.str]
        """
        The OAuth 2.0 client secret.
        """
        issuer: pulumi.Input[builtins.str]
        """
        The OIDC issuer identifier of the IdP.
        """
        token_endpoint: pulumi.Input[builtins.str]
        """
        The token endpoint of the IdP.
        """
        user_info_endpoint: pulumi.Input[builtins.str]
        """
        The user info endpoint of the IdP.
        """
        authentication_request_extra_params: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        on_unauthenticated_request: NotRequired[pulumi.Input[builtins.str]]
        """
        The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        scope: NotRequired[pulumi.Input[builtins.str]]
        """
        The set of user claims to be requested from the IdP.
        """
        session_cookie_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the cookie used to maintain session information.
        """
        session_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum duration of the authentication session, in seconds.
        """
elif False:
    ListenerRuleActionAuthenticateOidcArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleActionAuthenticateOidcArgs:
    def __init__(__self__, *,
                 authorization_endpoint: pulumi.Input[builtins.str],
                 client_id: pulumi.Input[builtins.str],
                 client_secret: pulumi.Input[builtins.str],
                 issuer: pulumi.Input[builtins.str],
                 token_endpoint: pulumi.Input[builtins.str],
                 user_info_endpoint: pulumi.Input[builtins.str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 session_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] authorization_endpoint: The authorization endpoint of the IdP.
        :param pulumi.Input[builtins.str] client_id: The OAuth 2.0 client identifier.
        :param pulumi.Input[builtins.str] client_secret: The OAuth 2.0 client secret.
        :param pulumi.Input[builtins.str] issuer: The OIDC issuer identifier of the IdP.
        :param pulumi.Input[builtins.str] token_endpoint: The token endpoint of the IdP.
        :param pulumi.Input[builtins.str] user_info_endpoint: The user info endpoint of the IdP.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] authentication_request_extra_params: The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param pulumi.Input[builtins.str] on_unauthenticated_request: The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param pulumi.Input[builtins.str] scope: The set of user claims to be requested from the IdP.
        :param pulumi.Input[builtins.str] session_cookie_name: The name of the cookie used to maintain session information.
        :param pulumi.Input[builtins.int] session_timeout: The maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The authorization endpoint of the IdP.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        The OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[builtins.str]:
        """
        The OAuth 2.0 client secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[builtins.str]:
        """
        The OIDC issuer identifier of the IdP.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The token endpoint of the IdP.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token_endpoint", value)

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The user info endpoint of the IdP.
        """
        return pulumi.get(self, "user_info_endpoint")

    @user_info_endpoint.setter
    def user_info_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_info_endpoint", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_timeout", value)


if not MYPY:
    class ListenerRuleActionFixedResponseArgsDict(TypedDict):
        content_type: pulumi.Input[builtins.str]
        """
        The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
        """
        message_body: NotRequired[pulumi.Input[builtins.str]]
        """
        The message body.
        """
        status_code: NotRequired[pulumi.Input[builtins.str]]
        """
        The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
elif False:
    ListenerRuleActionFixedResponseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleActionFixedResponseArgs:
    def __init__(__self__, *,
                 content_type: pulumi.Input[builtins.str],
                 message_body: Optional[pulumi.Input[builtins.str]] = None,
                 status_code: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] content_type: The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
        :param pulumi.Input[builtins.str] message_body: The message body.
        :param pulumi.Input[builtins.str] status_code: The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[builtins.str]:
        """
        The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The message body.
        """
        return pulumi.get(self, "message_body")

    @message_body.setter
    def message_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_body", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_code", value)


if not MYPY:
    class ListenerRuleActionForwardArgsDict(TypedDict):
        target_groups: pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionForwardTargetGroupArgsDict']]]
        """
        One or more target group blocks.
        """
        stickiness: NotRequired[pulumi.Input['ListenerRuleActionForwardStickinessArgsDict']]
        """
        The target group stickiness for the rule.
        """
elif False:
    ListenerRuleActionForwardArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleActionForwardArgs:
    def __init__(__self__, *,
                 target_groups: pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionForwardTargetGroupArgs']]],
                 stickiness: Optional[pulumi.Input['ListenerRuleActionForwardStickinessArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionForwardTargetGroupArgs']]] target_groups: One or more target group blocks.
        :param pulumi.Input['ListenerRuleActionForwardStickinessArgs'] stickiness: The target group stickiness for the rule.
        """
        pulumi.set(__self__, "target_groups", target_groups)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionForwardTargetGroupArgs']]]:
        """
        One or more target group blocks.
        """
        return pulumi.get(self, "target_groups")

    @target_groups.setter
    def target_groups(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerRuleActionForwardTargetGroupArgs']]]):
        pulumi.set(self, "target_groups", value)

    @property
    @pulumi.getter
    def stickiness(self) -> Optional[pulumi.Input['ListenerRuleActionForwardStickinessArgs']]:
        """
        The target group stickiness for the rule.
        """
        return pulumi.get(self, "stickiness")

    @stickiness.setter
    def stickiness(self, value: Optional[pulumi.Input['ListenerRuleActionForwardStickinessArgs']]):
        pulumi.set(self, "stickiness", value)


if not MYPY:
    class ListenerRuleActionForwardStickinessArgsDict(TypedDict):
        duration: pulumi.Input[builtins.int]
        """
        The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether target group stickiness is enabled.
        """
elif False:
    ListenerRuleActionForwardStickinessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleActionForwardStickinessArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[builtins.int],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] duration: The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        :param pulumi.Input[builtins.bool] enabled: Indicates whether target group stickiness is enabled.
        """
        pulumi.set(__self__, "duration", duration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[builtins.int]:
        """
        The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether target group stickiness is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ListenerRuleActionForwardTargetGroupArgsDict(TypedDict):
        arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the target group.
        """
        weight: NotRequired[pulumi.Input[builtins.int]]
        """
        The weight. The range is 0 to 999.
        """
elif False:
    ListenerRuleActionForwardTargetGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleActionForwardTargetGroupArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[builtins.str],
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] arn: The Amazon Resource Name (ARN) of the target group.
        :param pulumi.Input[builtins.int] weight: The weight. The range is 0 to 999.
        """
        pulumi.set(__self__, "arn", arn)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The weight. The range is 0 to 999.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class ListenerRuleActionRedirectArgsDict(TypedDict):
        status_code: pulumi.Input[builtins.str]
        """
        The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
        """
        host: NotRequired[pulumi.Input[builtins.str]]
        """
        The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        """
        port: NotRequired[pulumi.Input[builtins.str]]
        """
        The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        protocol: NotRequired[pulumi.Input[builtins.str]]
        """
        The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        query: NotRequired[pulumi.Input[builtins.str]]
        """
        The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
elif False:
    ListenerRuleActionRedirectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleActionRedirectArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[builtins.str],
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] status_code: The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
        :param pulumi.Input[builtins.str] host: The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        :param pulumi.Input[builtins.str] path: The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        :param pulumi.Input[builtins.str] port: The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        :param pulumi.Input[builtins.str] protocol: The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        :param pulumi.Input[builtins.str] query: The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        pulumi.set(__self__, "status_code", status_code)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[builtins.str]:
        """
        The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query", value)


if not MYPY:
    class ListenerRuleConditionArgsDict(TypedDict):
        host_header: NotRequired[pulumi.Input['ListenerRuleConditionHostHeaderArgsDict']]
        """
        Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
        """
        http_header: NotRequired[pulumi.Input['ListenerRuleConditionHttpHeaderArgsDict']]
        """
        HTTP headers to match. HTTP Header block fields documented below.
        """
        http_request_method: NotRequired[pulumi.Input['ListenerRuleConditionHttpRequestMethodArgsDict']]
        """
        Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
        """
        path_pattern: NotRequired[pulumi.Input['ListenerRuleConditionPathPatternArgsDict']]
        """
        Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
        """
        query_strings: NotRequired[pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionQueryStringArgsDict']]]]
        """
        Query strings to match. Query String block fields documented below.
        """
        source_ip: NotRequired[pulumi.Input['ListenerRuleConditionSourceIpArgsDict']]
        """
        Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.

        > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
        """
elif False:
    ListenerRuleConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleConditionArgs:
    def __init__(__self__, *,
                 host_header: Optional[pulumi.Input['ListenerRuleConditionHostHeaderArgs']] = None,
                 http_header: Optional[pulumi.Input['ListenerRuleConditionHttpHeaderArgs']] = None,
                 http_request_method: Optional[pulumi.Input['ListenerRuleConditionHttpRequestMethodArgs']] = None,
                 path_pattern: Optional[pulumi.Input['ListenerRuleConditionPathPatternArgs']] = None,
                 query_strings: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionQueryStringArgs']]]] = None,
                 source_ip: Optional[pulumi.Input['ListenerRuleConditionSourceIpArgs']] = None):
        """
        :param pulumi.Input['ListenerRuleConditionHostHeaderArgs'] host_header: Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
        :param pulumi.Input['ListenerRuleConditionHttpHeaderArgs'] http_header: HTTP headers to match. HTTP Header block fields documented below.
        :param pulumi.Input['ListenerRuleConditionHttpRequestMethodArgs'] http_request_method: Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
        :param pulumi.Input['ListenerRuleConditionPathPatternArgs'] path_pattern: Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionQueryStringArgs']]] query_strings: Query strings to match. Query String block fields documented below.
        :param pulumi.Input['ListenerRuleConditionSourceIpArgs'] source_ip: Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.
               
               > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
        """
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if http_header is not None:
            pulumi.set(__self__, "http_header", http_header)
        if http_request_method is not None:
            pulumi.set(__self__, "http_request_method", http_request_method)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)

    @property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[pulumi.Input['ListenerRuleConditionHostHeaderArgs']]:
        """
        Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
        """
        return pulumi.get(self, "host_header")

    @host_header.setter
    def host_header(self, value: Optional[pulumi.Input['ListenerRuleConditionHostHeaderArgs']]):
        pulumi.set(self, "host_header", value)

    @property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> Optional[pulumi.Input['ListenerRuleConditionHttpHeaderArgs']]:
        """
        HTTP headers to match. HTTP Header block fields documented below.
        """
        return pulumi.get(self, "http_header")

    @http_header.setter
    def http_header(self, value: Optional[pulumi.Input['ListenerRuleConditionHttpHeaderArgs']]):
        pulumi.set(self, "http_header", value)

    @property
    @pulumi.getter(name="httpRequestMethod")
    def http_request_method(self) -> Optional[pulumi.Input['ListenerRuleConditionHttpRequestMethodArgs']]:
        """
        Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
        """
        return pulumi.get(self, "http_request_method")

    @http_request_method.setter
    def http_request_method(self, value: Optional[pulumi.Input['ListenerRuleConditionHttpRequestMethodArgs']]):
        pulumi.set(self, "http_request_method", value)

    @property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional[pulumi.Input['ListenerRuleConditionPathPatternArgs']]:
        """
        Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
        """
        return pulumi.get(self, "path_pattern")

    @path_pattern.setter
    def path_pattern(self, value: Optional[pulumi.Input['ListenerRuleConditionPathPatternArgs']]):
        pulumi.set(self, "path_pattern", value)

    @property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionQueryStringArgs']]]]:
        """
        Query strings to match. Query String block fields documented below.
        """
        return pulumi.get(self, "query_strings")

    @query_strings.setter
    def query_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleConditionQueryStringArgs']]]]):
        pulumi.set(self, "query_strings", value)

    @property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional[pulumi.Input['ListenerRuleConditionSourceIpArgs']]:
        """
        Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.

        > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
        """
        return pulumi.get(self, "source_ip")

    @source_ip.setter
    def source_ip(self, value: Optional[pulumi.Input['ListenerRuleConditionSourceIpArgs']]):
        pulumi.set(self, "source_ip", value)


if not MYPY:
    class ListenerRuleConditionHostHeaderArgsDict(TypedDict):
        values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
elif False:
    ListenerRuleConditionHostHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleConditionHostHeaderArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRuleConditionHttpHeaderArgsDict(TypedDict):
        http_header_name: pulumi.Input[builtins.str]
        """
        Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
        """
        values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
        """
elif False:
    ListenerRuleConditionHttpHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleConditionHttpHeaderArgs:
    def __init__(__self__, *,
                 http_header_name: pulumi.Input[builtins.str],
                 values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[builtins.str] http_header_name: Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
        """
        pulumi.set(__self__, "http_header_name", http_header_name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="httpHeaderName")
    def http_header_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
        """
        return pulumi.get(self, "http_header_name")

    @http_header_name.setter
    def http_header_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "http_header_name", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRuleConditionHttpRequestMethodArgsDict(TypedDict):
        values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
elif False:
    ListenerRuleConditionHttpRequestMethodArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleConditionHttpRequestMethodArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRuleConditionPathPatternArgsDict(TypedDict):
        values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
elif False:
    ListenerRuleConditionPathPatternArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleConditionPathPatternArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRuleConditionQueryStringArgsDict(TypedDict):
        value: pulumi.Input[builtins.str]
        """
        Query string value pattern to match.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        Query string key pattern to match.
        """
elif False:
    ListenerRuleConditionQueryStringArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleConditionQueryStringArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[builtins.str],
                 key: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] value: Query string value pattern to match.
        :param pulumi.Input[builtins.str] key: Query string key pattern to match.
        """
        pulumi.set(__self__, "value", value)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Query string value pattern to match.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Query string key pattern to match.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)


if not MYPY:
    class ListenerRuleConditionSourceIpArgsDict(TypedDict):
        values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
elif False:
    ListenerRuleConditionSourceIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleConditionSourceIpArgs:
    def __init__(__self__, *,
                 values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class LoadBalancerAccessLogsArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        S3 bucket name to store the logs in.
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
        """
        prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        S3 bucket prefix. Logs are stored in the root if not configured.
        """
elif False:
    LoadBalancerAccessLogsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerAccessLogsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: S3 bucket name to store the logs in.
        :param pulumi.Input[builtins.bool] enabled: Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
        :param pulumi.Input[builtins.str] prefix: S3 bucket prefix. Logs are stored in the root if not configured.
        """
        pulumi.set(__self__, "bucket", bucket)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        S3 bucket name to store the logs in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 bucket prefix. Logs are stored in the root if not configured.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)


if not MYPY:
    class LoadBalancerConnectionLogsArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        S3 bucket name to store the logs in.
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Boolean to enable / disable `connection_logs`. Defaults to `false`, even when `bucket` is specified.
        """
        prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        S3 bucket prefix. Logs are stored in the root if not configured.
        """
elif False:
    LoadBalancerConnectionLogsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerConnectionLogsArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: S3 bucket name to store the logs in.
        :param pulumi.Input[builtins.bool] enabled: Boolean to enable / disable `connection_logs`. Defaults to `false`, even when `bucket` is specified.
        :param pulumi.Input[builtins.str] prefix: S3 bucket prefix. Logs are stored in the root if not configured.
        """
        pulumi.set(__self__, "bucket", bucket)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        S3 bucket name to store the logs in.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean to enable / disable `connection_logs`. Defaults to `false`, even when `bucket` is specified.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        S3 bucket prefix. Logs are stored in the root if not configured.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)


if not MYPY:
    class LoadBalancerIpamPoolsArgsDict(TypedDict):
        ipv4_ipam_pool_id: pulumi.Input[builtins.str]
        """
        The ID of the IPv4 IPAM pool.
        """
elif False:
    LoadBalancerIpamPoolsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerIpamPoolsArgs:
    def __init__(__self__, *,
                 ipv4_ipam_pool_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] ipv4_ipam_pool_id: The ID of the IPv4 IPAM pool.
        """
        pulumi.set(__self__, "ipv4_ipam_pool_id", ipv4_ipam_pool_id)

    @property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the IPv4 IPAM pool.
        """
        return pulumi.get(self, "ipv4_ipam_pool_id")

    @ipv4_ipam_pool_id.setter
    def ipv4_ipam_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ipv4_ipam_pool_id", value)


if not MYPY:
    class LoadBalancerMinimumLoadBalancerCapacityArgsDict(TypedDict):
        capacity_units: pulumi.Input[builtins.int]
        """
        The number of capacity units.
        """
elif False:
    LoadBalancerMinimumLoadBalancerCapacityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerMinimumLoadBalancerCapacityArgs:
    def __init__(__self__, *,
                 capacity_units: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] capacity_units: The number of capacity units.
        """
        pulumi.set(__self__, "capacity_units", capacity_units)

    @property
    @pulumi.getter(name="capacityUnits")
    def capacity_units(self) -> pulumi.Input[builtins.int]:
        """
        The number of capacity units.
        """
        return pulumi.get(self, "capacity_units")

    @capacity_units.setter
    def capacity_units(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "capacity_units", value)


if not MYPY:
    class LoadBalancerSubnetMappingArgsDict(TypedDict):
        subnet_id: pulumi.Input[builtins.str]
        """
        ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
        """
        allocation_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Allocation ID of the Elastic IP address for an internet-facing load balancer.
        """
        ipv6_address: NotRequired[pulumi.Input[builtins.str]]
        """
        IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
        """
        outpost_id: NotRequired[pulumi.Input[builtins.str]]
        private_ipv4_address: NotRequired[pulumi.Input[builtins.str]]
        """
        Private IPv4 address for an internal load balancer.
        """
elif False:
    LoadBalancerSubnetMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerSubnetMappingArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[builtins.str],
                 allocation_id: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 outpost_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_ipv4_address: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] subnet_id: ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
        :param pulumi.Input[builtins.str] allocation_id: Allocation ID of the Elastic IP address for an internet-facing load balancer.
        :param pulumi.Input[builtins.str] ipv6_address: IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
        :param pulumi.Input[builtins.str] private_ipv4_address: Private IPv4 address for an internal load balancer.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if outpost_id is not None:
            pulumi.set(__self__, "outpost_id", outpost_id)
        if private_ipv4_address is not None:
            pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allocation ID of the Elastic IP address for an internet-facing load balancer.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_id", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="outpostId")
    def outpost_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "outpost_id")

    @outpost_id.setter
    def outpost_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outpost_id", value)

    @property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private IPv4 address for an internal load balancer.
        """
        return pulumi.get(self, "private_ipv4_address")

    @private_ipv4_address.setter
    def private_ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ipv4_address", value)


if not MYPY:
    class TargetGroupHealthCheckArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether health checks are enabled. Defaults to `true`.
        """
        healthy_threshold: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
        """
        interval: NotRequired[pulumi.Input[builtins.int]]
        """
        Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
        """
        matcher: NotRequired[pulumi.Input[builtins.str]]
        """
        The HTTP or gRPC codes to use when checking for a successful response from a target.
        The `health_check.protocol` must be one of `HTTP` or `HTTPS` or the `target_type` must be `lambda`.
        Values can be comma-separated individual values (e.g., "200,202") or a range of values (e.g., "200-299").
        * For gRPC-based target groups (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is `GRPC`), values can be between `0` and `99`. The default is `12`.
        * When used with an Application Load Balancer (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is not `GRPC`), values can be between `200` and `499`. The default is `200`.
        * When used with a Network Load Balancer (i.e., the `protocol` is one of `TCP`, `TCP_UDP`, `UDP`, or `TLS`), values can be between `200` and `599`. The default is `200-399`.
        * When the `target_type` is `lambda`, values can be between `200` and `499`. The default is `200`.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
        * For HTTP and HTTPS health checks, the default is `/`.
        * For gRPC health checks, the default is `/AWS.ALB/healthcheck`.
        """
        port: NotRequired[pulumi.Input[builtins.str]]
        """
        The port the load balancer uses when performing health checks on targets.
        Valid values are either `traffic-port`, to use the same port as the target group, or a valid port number between `1` and `65536`.
        Default is `traffic-port`.
        """
        protocol: NotRequired[pulumi.Input[builtins.str]]
        """
        Protocol the load balancer uses when performing health checks on targets.
        Must be one of `TCP`, `HTTP`, or `HTTPS`.
        The `TCP` protocol is not supported for health checks if the protocol of the target group is `HTTP` or `HTTPS`.
        Default is `HTTP`.
        Cannot be specified when the `target_type` is `lambda`.
        """
        timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
        """
        unhealthy_threshold: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
        """
elif False:
    TargetGroupHealthCheckArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupHealthCheckArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 healthy_threshold: Optional[pulumi.Input[builtins.int]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 matcher: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Whether health checks are enabled. Defaults to `true`.
        :param pulumi.Input[builtins.int] healthy_threshold: Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
        :param pulumi.Input[builtins.int] interval: Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
        :param pulumi.Input[builtins.str] matcher: The HTTP or gRPC codes to use when checking for a successful response from a target.
               The `health_check.protocol` must be one of `HTTP` or `HTTPS` or the `target_type` must be `lambda`.
               Values can be comma-separated individual values (e.g., "200,202") or a range of values (e.g., "200-299").
               * For gRPC-based target groups (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is `GRPC`), values can be between `0` and `99`. The default is `12`.
               * When used with an Application Load Balancer (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is not `GRPC`), values can be between `200` and `499`. The default is `200`.
               * When used with a Network Load Balancer (i.e., the `protocol` is one of `TCP`, `TCP_UDP`, `UDP`, or `TLS`), values can be between `200` and `599`. The default is `200-399`.
               * When the `target_type` is `lambda`, values can be between `200` and `499`. The default is `200`.
        :param pulumi.Input[builtins.str] path: Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
               * For HTTP and HTTPS health checks, the default is `/`.
               * For gRPC health checks, the default is `/AWS.ALB/healthcheck`.
        :param pulumi.Input[builtins.str] port: The port the load balancer uses when performing health checks on targets.
               Valid values are either `traffic-port`, to use the same port as the target group, or a valid port number between `1` and `65536`.
               Default is `traffic-port`.
        :param pulumi.Input[builtins.str] protocol: Protocol the load balancer uses when performing health checks on targets.
               Must be one of `TCP`, `HTTP`, or `HTTPS`.
               The `TCP` protocol is not supported for health checks if the protocol of the target group is `HTTP` or `HTTPS`.
               Default is `HTTP`.
               Cannot be specified when the `target_type` is `lambda`.
        :param pulumi.Input[builtins.int] timeout: Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
        :param pulumi.Input[builtins.int] unhealthy_threshold: Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether health checks are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def matcher(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The HTTP or gRPC codes to use when checking for a successful response from a target.
        The `health_check.protocol` must be one of `HTTP` or `HTTPS` or the `target_type` must be `lambda`.
        Values can be comma-separated individual values (e.g., "200,202") or a range of values (e.g., "200-299").
        * For gRPC-based target groups (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is `GRPC`), values can be between `0` and `99`. The default is `12`.
        * When used with an Application Load Balancer (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is not `GRPC`), values can be between `200` and `499`. The default is `200`.
        * When used with a Network Load Balancer (i.e., the `protocol` is one of `TCP`, `TCP_UDP`, `UDP`, or `TLS`), values can be between `200` and `599`. The default is `200-399`.
        * When the `target_type` is `lambda`, values can be between `200` and `499`. The default is `200`.
        """
        return pulumi.get(self, "matcher")

    @matcher.setter
    def matcher(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "matcher", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
        * For HTTP and HTTPS health checks, the default is `/`.
        * For gRPC health checks, the default is `/AWS.ALB/healthcheck`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The port the load balancer uses when performing health checks on targets.
        Valid values are either `traffic-port`, to use the same port as the target group, or a valid port number between `1` and `65536`.
        Default is `traffic-port`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Protocol the load balancer uses when performing health checks on targets.
        Must be one of `TCP`, `HTTP`, or `HTTPS`.
        The `TCP` protocol is not supported for health checks if the protocol of the target group is `HTTP` or `HTTPS`.
        Default is `HTTP`.
        Cannot be specified when the `target_type` is `lambda`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "unhealthy_threshold", value)


if not MYPY:
    class TargetGroupStickinessArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
        """
        cookie_duration: NotRequired[pulumi.Input[builtins.int]]
        """
        Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
        """
        cookie_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Boolean to enable / disable `stickiness`. Default is `true`.
        """
elif False:
    TargetGroupStickinessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupStickinessArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 cookie_duration: Optional[pulumi.Input[builtins.int]] = None,
                 cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] type: The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
        :param pulumi.Input[builtins.int] cookie_duration: Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
        :param pulumi.Input[builtins.str] cookie_name: Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
        :param pulumi.Input[builtins.bool] enabled: Boolean to enable / disable `stickiness`. Default is `true`.
        """
        pulumi.set(__self__, "type", type)
        if cookie_duration is not None:
            pulumi.set(__self__, "cookie_duration", cookie_duration)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="cookieDuration")
    def cookie_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
        """
        return pulumi.get(self, "cookie_duration")

    @cookie_duration.setter
    def cookie_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cookie_duration", value)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
        """
        return pulumi.get(self, "cookie_name")

    @cookie_name.setter
    def cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cookie_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean to enable / disable `stickiness`. Default is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class TargetGroupTargetFailoverArgsDict(TypedDict):
        on_deregistration: pulumi.Input[builtins.str]
        """
        Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
        """
        on_unhealthy: pulumi.Input[builtins.str]
        """
        Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
        """
elif False:
    TargetGroupTargetFailoverArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupTargetFailoverArgs:
    def __init__(__self__, *,
                 on_deregistration: pulumi.Input[builtins.str],
                 on_unhealthy: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] on_deregistration: Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
        :param pulumi.Input[builtins.str] on_unhealthy: Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
        """
        pulumi.set(__self__, "on_deregistration", on_deregistration)
        pulumi.set(__self__, "on_unhealthy", on_unhealthy)

    @property
    @pulumi.getter(name="onDeregistration")
    def on_deregistration(self) -> pulumi.Input[builtins.str]:
        """
        Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
        """
        return pulumi.get(self, "on_deregistration")

    @on_deregistration.setter
    def on_deregistration(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "on_deregistration", value)

    @property
    @pulumi.getter(name="onUnhealthy")
    def on_unhealthy(self) -> pulumi.Input[builtins.str]:
        """
        Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
        """
        return pulumi.get(self, "on_unhealthy")

    @on_unhealthy.setter
    def on_unhealthy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "on_unhealthy", value)


if not MYPY:
    class TargetGroupTargetGroupHealthArgsDict(TypedDict):
        dns_failover: NotRequired[pulumi.Input['TargetGroupTargetGroupHealthDnsFailoverArgsDict']]
        """
        Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
        """
        unhealthy_state_routing: NotRequired[pulumi.Input['TargetGroupTargetGroupHealthUnhealthyStateRoutingArgsDict']]
        """
        Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
        """
elif False:
    TargetGroupTargetGroupHealthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupTargetGroupHealthArgs:
    def __init__(__self__, *,
                 dns_failover: Optional[pulumi.Input['TargetGroupTargetGroupHealthDnsFailoverArgs']] = None,
                 unhealthy_state_routing: Optional[pulumi.Input['TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs']] = None):
        """
        :param pulumi.Input['TargetGroupTargetGroupHealthDnsFailoverArgs'] dns_failover: Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
        :param pulumi.Input['TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs'] unhealthy_state_routing: Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
        """
        if dns_failover is not None:
            pulumi.set(__self__, "dns_failover", dns_failover)
        if unhealthy_state_routing is not None:
            pulumi.set(__self__, "unhealthy_state_routing", unhealthy_state_routing)

    @property
    @pulumi.getter(name="dnsFailover")
    def dns_failover(self) -> Optional[pulumi.Input['TargetGroupTargetGroupHealthDnsFailoverArgs']]:
        """
        Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
        """
        return pulumi.get(self, "dns_failover")

    @dns_failover.setter
    def dns_failover(self, value: Optional[pulumi.Input['TargetGroupTargetGroupHealthDnsFailoverArgs']]):
        pulumi.set(self, "dns_failover", value)

    @property
    @pulumi.getter(name="unhealthyStateRouting")
    def unhealthy_state_routing(self) -> Optional[pulumi.Input['TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs']]:
        """
        Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
        """
        return pulumi.get(self, "unhealthy_state_routing")

    @unhealthy_state_routing.setter
    def unhealthy_state_routing(self, value: Optional[pulumi.Input['TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs']]):
        pulumi.set(self, "unhealthy_state_routing", value)


if not MYPY:
    class TargetGroupTargetGroupHealthDnsFailoverArgsDict(TypedDict):
        minimum_healthy_targets_count: NotRequired[pulumi.Input[builtins.str]]
        """
        The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
        """
        minimum_healthy_targets_percentage: NotRequired[pulumi.Input[builtins.str]]
        """
        The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
elif False:
    TargetGroupTargetGroupHealthDnsFailoverArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupTargetGroupHealthDnsFailoverArgs:
    def __init__(__self__, *,
                 minimum_healthy_targets_count: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_healthy_targets_percentage: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] minimum_healthy_targets_count: The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
        :param pulumi.Input[builtins.str] minimum_healthy_targets_percentage: The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        if minimum_healthy_targets_count is not None:
            pulumi.set(__self__, "minimum_healthy_targets_count", minimum_healthy_targets_count)
        if minimum_healthy_targets_percentage is not None:
            pulumi.set(__self__, "minimum_healthy_targets_percentage", minimum_healthy_targets_percentage)

    @property
    @pulumi.getter(name="minimumHealthyTargetsCount")
    def minimum_healthy_targets_count(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
        """
        return pulumi.get(self, "minimum_healthy_targets_count")

    @minimum_healthy_targets_count.setter
    def minimum_healthy_targets_count(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimum_healthy_targets_count", value)

    @property
    @pulumi.getter(name="minimumHealthyTargetsPercentage")
    def minimum_healthy_targets_percentage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        return pulumi.get(self, "minimum_healthy_targets_percentage")

    @minimum_healthy_targets_percentage.setter
    def minimum_healthy_targets_percentage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimum_healthy_targets_percentage", value)


if not MYPY:
    class TargetGroupTargetGroupHealthUnhealthyStateRoutingArgsDict(TypedDict):
        minimum_healthy_targets_count: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
        """
        minimum_healthy_targets_percentage: NotRequired[pulumi.Input[builtins.str]]
        """
        The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
elif False:
    TargetGroupTargetGroupHealthUnhealthyStateRoutingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs:
    def __init__(__self__, *,
                 minimum_healthy_targets_count: Optional[pulumi.Input[builtins.int]] = None,
                 minimum_healthy_targets_percentage: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] minimum_healthy_targets_count: The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
        :param pulumi.Input[builtins.str] minimum_healthy_targets_percentage: The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        if minimum_healthy_targets_count is not None:
            pulumi.set(__self__, "minimum_healthy_targets_count", minimum_healthy_targets_count)
        if minimum_healthy_targets_percentage is not None:
            pulumi.set(__self__, "minimum_healthy_targets_percentage", minimum_healthy_targets_percentage)

    @property
    @pulumi.getter(name="minimumHealthyTargetsCount")
    def minimum_healthy_targets_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
        """
        return pulumi.get(self, "minimum_healthy_targets_count")

    @minimum_healthy_targets_count.setter
    def minimum_healthy_targets_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "minimum_healthy_targets_count", value)

    @property
    @pulumi.getter(name="minimumHealthyTargetsPercentage")
    def minimum_healthy_targets_percentage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        return pulumi.get(self, "minimum_healthy_targets_percentage")

    @minimum_healthy_targets_percentage.setter
    def minimum_healthy_targets_percentage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimum_healthy_targets_percentage", value)


if not MYPY:
    class TargetGroupTargetHealthStateArgsDict(TypedDict):
        enable_unhealthy_connection_termination: pulumi.Input[builtins.bool]
        """
        Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
        """
        unhealthy_draining_interval: NotRequired[pulumi.Input[builtins.int]]
        """
        Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
        """
elif False:
    TargetGroupTargetHealthStateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupTargetHealthStateArgs:
    def __init__(__self__, *,
                 enable_unhealthy_connection_termination: pulumi.Input[builtins.bool],
                 unhealthy_draining_interval: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.bool] enable_unhealthy_connection_termination: Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
        :param pulumi.Input[builtins.int] unhealthy_draining_interval: Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
        """
        pulumi.set(__self__, "enable_unhealthy_connection_termination", enable_unhealthy_connection_termination)
        if unhealthy_draining_interval is not None:
            pulumi.set(__self__, "unhealthy_draining_interval", unhealthy_draining_interval)

    @property
    @pulumi.getter(name="enableUnhealthyConnectionTermination")
    def enable_unhealthy_connection_termination(self) -> pulumi.Input[builtins.bool]:
        """
        Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
        """
        return pulumi.get(self, "enable_unhealthy_connection_termination")

    @enable_unhealthy_connection_termination.setter
    def enable_unhealthy_connection_termination(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable_unhealthy_connection_termination", value)

    @property
    @pulumi.getter(name="unhealthyDrainingInterval")
    def unhealthy_draining_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
        """
        return pulumi.get(self, "unhealthy_draining_interval")

    @unhealthy_draining_interval.setter
    def unhealthy_draining_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "unhealthy_draining_interval", value)


