# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceConfigurationArgs', 'WorkspaceConfiguration']

@pulumi.input_type
class WorkspaceConfigurationArgs:
    def __init__(__self__, *,
                 workspace_id: pulumi.Input[builtins.str],
                 limits_per_label_sets: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConfigurationLimitsPerLabelSetArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 timeouts: Optional[pulumi.Input['WorkspaceConfigurationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a WorkspaceConfiguration resource.
        :param pulumi.Input[builtins.str] workspace_id: ID of the workspace to configure.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceConfigurationLimitsPerLabelSetArgs']]] limits_per_label_sets: Configuration block for setting limits on metrics with specific label sets. Detailed below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] retention_period_in_days: Number of days to retain metric data in the workspace.
        """
        pulumi.set(__self__, "workspace_id", workspace_id)
        if limits_per_label_sets is not None:
            pulumi.set(__self__, "limits_per_label_sets", limits_per_label_sets)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_period_in_days is not None:
            pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        ID of the workspace to configure.

        The following arguments are optional:
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter(name="limitsPerLabelSets")
    def limits_per_label_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConfigurationLimitsPerLabelSetArgs']]]]:
        """
        Configuration block for setting limits on metrics with specific label sets. Detailed below.
        """
        return pulumi.get(self, "limits_per_label_sets")

    @limits_per_label_sets.setter
    def limits_per_label_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConfigurationLimitsPerLabelSetArgs']]]]):
        pulumi.set(self, "limits_per_label_sets", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of days to retain metric data in the workspace.
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_period_in_days", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['WorkspaceConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['WorkspaceConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _WorkspaceConfigurationState:
    def __init__(__self__, *,
                 limits_per_label_sets: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConfigurationLimitsPerLabelSetArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 timeouts: Optional[pulumi.Input['WorkspaceConfigurationTimeoutsArgs']] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceConfiguration resources.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceConfigurationLimitsPerLabelSetArgs']]] limits_per_label_sets: Configuration block for setting limits on metrics with specific label sets. Detailed below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] retention_period_in_days: Number of days to retain metric data in the workspace.
        :param pulumi.Input[builtins.str] workspace_id: ID of the workspace to configure.
               
               The following arguments are optional:
        """
        if limits_per_label_sets is not None:
            pulumi.set(__self__, "limits_per_label_sets", limits_per_label_sets)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_period_in_days is not None:
            pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="limitsPerLabelSets")
    def limits_per_label_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConfigurationLimitsPerLabelSetArgs']]]]:
        """
        Configuration block for setting limits on metrics with specific label sets. Detailed below.
        """
        return pulumi.get(self, "limits_per_label_sets")

    @limits_per_label_sets.setter
    def limits_per_label_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceConfigurationLimitsPerLabelSetArgs']]]]):
        pulumi.set(self, "limits_per_label_sets", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of days to retain metric data in the workspace.
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_period_in_days", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['WorkspaceConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['WorkspaceConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the workspace to configure.

        The following arguments are optional:
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("aws:amp/workspaceConfiguration:WorkspaceConfiguration")
class WorkspaceConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 limits_per_label_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceConfigurationLimitsPerLabelSetArgs', 'WorkspaceConfigurationLimitsPerLabelSetArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 timeouts: Optional[pulumi.Input[Union['WorkspaceConfigurationTimeoutsArgs', 'WorkspaceConfigurationTimeoutsArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS Managed Service for Prometheus Workspace Configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amp.Workspace("example")
        example_workspace_configuration = aws.amp.WorkspaceConfiguration("example",
            workspace_id=example.id,
            retention_period_in_days=60,
            limits_per_label_sets=[
                {
                    "label_set": {
                        "env": "dev",
                    },
                    "limits": {
                        "max_series": 100000,
                    },
                },
                {
                    "label_set": {
                        "env": "prod",
                    },
                    "limits": {
                        "max_series": 400000,
                    },
                },
            ])
        ```

        ### Setting up default bucket

        The default bucket limit is the maximum number of active time series that can be
        ingested in the workspace, counting only time series that don’t match a defined
        label set.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amp.Workspace("example")
        example_workspace_configuration = aws.amp.WorkspaceConfiguration("example",
            workspace_id=example.id,
            limits_per_label_sets=[{
                "label_set": {},
                "limits": {
                    "max_series": 50000,
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import AMP (Managed Prometheus) Workspace Configuration using the `workspace_id`. For example

        ```sh
        $ pulumi import aws:amp/workspaceConfiguration:WorkspaceConfiguration example ws-12345678-abcd-1234-abcd-123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceConfigurationLimitsPerLabelSetArgs', 'WorkspaceConfigurationLimitsPerLabelSetArgsDict']]]] limits_per_label_sets: Configuration block for setting limits on metrics with specific label sets. Detailed below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] retention_period_in_days: Number of days to retain metric data in the workspace.
        :param pulumi.Input[builtins.str] workspace_id: ID of the workspace to configure.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Managed Service for Prometheus Workspace Configuration.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amp.Workspace("example")
        example_workspace_configuration = aws.amp.WorkspaceConfiguration("example",
            workspace_id=example.id,
            retention_period_in_days=60,
            limits_per_label_sets=[
                {
                    "label_set": {
                        "env": "dev",
                    },
                    "limits": {
                        "max_series": 100000,
                    },
                },
                {
                    "label_set": {
                        "env": "prod",
                    },
                    "limits": {
                        "max_series": 400000,
                    },
                },
            ])
        ```

        ### Setting up default bucket

        The default bucket limit is the maximum number of active time series that can be
        ingested in the workspace, counting only time series that don’t match a defined
        label set.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amp.Workspace("example")
        example_workspace_configuration = aws.amp.WorkspaceConfiguration("example",
            workspace_id=example.id,
            limits_per_label_sets=[{
                "label_set": {},
                "limits": {
                    "max_series": 50000,
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import AMP (Managed Prometheus) Workspace Configuration using the `workspace_id`. For example

        ```sh
        $ pulumi import aws:amp/workspaceConfiguration:WorkspaceConfiguration example ws-12345678-abcd-1234-abcd-123456789012
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 limits_per_label_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceConfigurationLimitsPerLabelSetArgs', 'WorkspaceConfigurationLimitsPerLabelSetArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[builtins.int]] = None,
                 timeouts: Optional[pulumi.Input[Union['WorkspaceConfigurationTimeoutsArgs', 'WorkspaceConfigurationTimeoutsArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceConfigurationArgs.__new__(WorkspaceConfigurationArgs)

            __props__.__dict__["limits_per_label_sets"] = limits_per_label_sets
            __props__.__dict__["region"] = region
            __props__.__dict__["retention_period_in_days"] = retention_period_in_days
            __props__.__dict__["timeouts"] = timeouts
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(WorkspaceConfiguration, __self__).__init__(
            'aws:amp/workspaceConfiguration:WorkspaceConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            limits_per_label_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceConfigurationLimitsPerLabelSetArgs', 'WorkspaceConfigurationLimitsPerLabelSetArgsDict']]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            retention_period_in_days: Optional[pulumi.Input[builtins.int]] = None,
            timeouts: Optional[pulumi.Input[Union['WorkspaceConfigurationTimeoutsArgs', 'WorkspaceConfigurationTimeoutsArgsDict']]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkspaceConfiguration':
        """
        Get an existing WorkspaceConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceConfigurationLimitsPerLabelSetArgs', 'WorkspaceConfigurationLimitsPerLabelSetArgsDict']]]] limits_per_label_sets: Configuration block for setting limits on metrics with specific label sets. Detailed below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.int] retention_period_in_days: Number of days to retain metric data in the workspace.
        :param pulumi.Input[builtins.str] workspace_id: ID of the workspace to configure.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceConfigurationState.__new__(_WorkspaceConfigurationState)

        __props__.__dict__["limits_per_label_sets"] = limits_per_label_sets
        __props__.__dict__["region"] = region
        __props__.__dict__["retention_period_in_days"] = retention_period_in_days
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="limitsPerLabelSets")
    def limits_per_label_sets(self) -> pulumi.Output[Optional[Sequence['outputs.WorkspaceConfigurationLimitsPerLabelSet']]]:
        """
        Configuration block for setting limits on metrics with specific label sets. Detailed below.
        """
        return pulumi.get(self, "limits_per_label_sets")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> pulumi.Output[builtins.int]:
        """
        Number of days to retain metric data in the workspace.
        """
        return pulumi.get(self, "retention_period_in_days")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.WorkspaceConfigurationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the workspace to configure.

        The following arguments are optional:
        """
        return pulumi.get(self, "workspace_id")

