# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppArgs', 'App']

@pulumi.input_type
class AppArgs:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[builtins.str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']] = None,
                 auto_branch_creation_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[builtins.str]] = None,
                 build_spec: Optional[pulumi.Input[builtins.str]] = None,
                 cache_config: Optional[pulumi.Input['AppCacheConfigArgs']] = None,
                 compute_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_headers: Optional[pulumi.Input[builtins.str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_auto_branch_creation: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_branch_auto_build: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 iam_service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 job_config: Optional[pulumi.Input['AppJobConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oauth_token: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a App resource.
        :param pulumi.Input[builtins.str] access_token: Personal access token for a third-party source control system for an Amplify app. This token must have write access to the relevant repo to create a webhook and a read-only deploy key for the Amplify project. The token is not stored, so after applying this attribute can be removed and the setup token deleted.
        :param pulumi.Input['AppAutoBranchCreationConfigArgs'] auto_branch_creation_config: Automated branch creation configuration for an Amplify app. See `auto_branch_creation_config` Block for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] auto_branch_creation_patterns: Automated branch creation glob patterns for an Amplify app.
        :param pulumi.Input[builtins.str] basic_auth_credentials: Credentials for basic authorization for an Amplify app.
        :param pulumi.Input[builtins.str] build_spec: The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        :param pulumi.Input['AppCacheConfigArgs'] cache_config: Cache configuration for the Amplify app. See `cache_config` Block for details.
        :param pulumi.Input[builtins.str] compute_role_arn: AWS Identity and Access Management (IAM) SSR compute role for an Amplify app.
        :param pulumi.Input[builtins.str] custom_headers: The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]] custom_rules: Custom rewrite and redirect rules for an Amplify app. See `custom_rule` Block for details.
        :param pulumi.Input[builtins.str] description: Description for an Amplify app.
        :param pulumi.Input[builtins.bool] enable_auto_branch_creation: Enables automated branch creation for an Amplify app.
        :param pulumi.Input[builtins.bool] enable_basic_auth: Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        :param pulumi.Input[builtins.bool] enable_branch_auto_build: Enables auto-building of branches for the Amplify App.
        :param pulumi.Input[builtins.bool] enable_branch_auto_deletion: Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: Environment variables map for an Amplify app.
        :param pulumi.Input[builtins.str] iam_service_role_arn: AWS Identity and Access Management (IAM) service role for an Amplify app.
        :param pulumi.Input['AppJobConfigArgs'] job_config: Used to configure the [Amplify Application build settings](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html). See `job_config` Block for details.
        :param pulumi.Input[builtins.str] name: Name for an Amplify app.
        :param pulumi.Input[builtins.str] oauth_token: OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        :param pulumi.Input[builtins.str] platform: Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] repository: Repository for an Amplify app.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if auto_branch_creation_config is not None:
            pulumi.set(__self__, "auto_branch_creation_config", auto_branch_creation_config)
        if auto_branch_creation_patterns is not None:
            pulumi.set(__self__, "auto_branch_creation_patterns", auto_branch_creation_patterns)
        if basic_auth_credentials is not None:
            pulumi.set(__self__, "basic_auth_credentials", basic_auth_credentials)
        if build_spec is not None:
            pulumi.set(__self__, "build_spec", build_spec)
        if cache_config is not None:
            pulumi.set(__self__, "cache_config", cache_config)
        if compute_role_arn is not None:
            pulumi.set(__self__, "compute_role_arn", compute_role_arn)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if custom_rules is not None:
            pulumi.set(__self__, "custom_rules", custom_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_auto_branch_creation is not None:
            pulumi.set(__self__, "enable_auto_branch_creation", enable_auto_branch_creation)
        if enable_basic_auth is not None:
            pulumi.set(__self__, "enable_basic_auth", enable_basic_auth)
        if enable_branch_auto_build is not None:
            pulumi.set(__self__, "enable_branch_auto_build", enable_branch_auto_build)
        if enable_branch_auto_deletion is not None:
            pulumi.set(__self__, "enable_branch_auto_deletion", enable_branch_auto_deletion)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if iam_service_role_arn is not None:
            pulumi.set(__self__, "iam_service_role_arn", iam_service_role_arn)
        if job_config is not None:
            pulumi.set(__self__, "job_config", job_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_token is not None:
            pulumi.set(__self__, "oauth_token", oauth_token)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Personal access token for a third-party source control system for an Amplify app. This token must have write access to the relevant repo to create a webhook and a read-only deploy key for the Amplify project. The token is not stored, so after applying this attribute can be removed and the setup token deleted.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter(name="autoBranchCreationConfig")
    def auto_branch_creation_config(self) -> Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']]:
        """
        Automated branch creation configuration for an Amplify app. See `auto_branch_creation_config` Block for details.
        """
        return pulumi.get(self, "auto_branch_creation_config")

    @auto_branch_creation_config.setter
    def auto_branch_creation_config(self, value: Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']]):
        pulumi.set(self, "auto_branch_creation_config", value)

    @property
    @pulumi.getter(name="autoBranchCreationPatterns")
    def auto_branch_creation_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Automated branch creation glob patterns for an Amplify app.
        """
        return pulumi.get(self, "auto_branch_creation_patterns")

    @auto_branch_creation_patterns.setter
    def auto_branch_creation_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "auto_branch_creation_patterns", value)

    @property
    @pulumi.getter(name="basicAuthCredentials")
    def basic_auth_credentials(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Credentials for basic authorization for an Amplify app.
        """
        return pulumi.get(self, "basic_auth_credentials")

    @basic_auth_credentials.setter
    def basic_auth_credentials(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "basic_auth_credentials", value)

    @property
    @pulumi.getter(name="buildSpec")
    def build_spec(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        """
        return pulumi.get(self, "build_spec")

    @build_spec.setter
    def build_spec(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "build_spec", value)

    @property
    @pulumi.getter(name="cacheConfig")
    def cache_config(self) -> Optional[pulumi.Input['AppCacheConfigArgs']]:
        """
        Cache configuration for the Amplify app. See `cache_config` Block for details.
        """
        return pulumi.get(self, "cache_config")

    @cache_config.setter
    def cache_config(self, value: Optional[pulumi.Input['AppCacheConfigArgs']]):
        pulumi.set(self, "cache_config", value)

    @property
    @pulumi.getter(name="computeRoleArn")
    def compute_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS Identity and Access Management (IAM) SSR compute role for an Amplify app.
        """
        return pulumi.get(self, "compute_role_arn")

    @compute_role_arn.setter
    def compute_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_role_arn", value)

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_headers", value)

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]]:
        """
        Custom rewrite and redirect rules for an Amplify app. See `custom_rule` Block for details.
        """
        return pulumi.get(self, "custom_rules")

    @custom_rules.setter
    def custom_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]]):
        pulumi.set(self, "custom_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for an Amplify app.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableAutoBranchCreation")
    def enable_auto_branch_creation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables automated branch creation for an Amplify app.
        """
        return pulumi.get(self, "enable_auto_branch_creation")

    @enable_auto_branch_creation.setter
    def enable_auto_branch_creation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_auto_branch_creation", value)

    @property
    @pulumi.getter(name="enableBasicAuth")
    def enable_basic_auth(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        """
        return pulumi.get(self, "enable_basic_auth")

    @enable_basic_auth.setter
    def enable_basic_auth(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_basic_auth", value)

    @property
    @pulumi.getter(name="enableBranchAutoBuild")
    def enable_branch_auto_build(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables auto-building of branches for the Amplify App.
        """
        return pulumi.get(self, "enable_branch_auto_build")

    @enable_branch_auto_build.setter
    def enable_branch_auto_build(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_branch_auto_build", value)

    @property
    @pulumi.getter(name="enableBranchAutoDeletion")
    def enable_branch_auto_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        """
        return pulumi.get(self, "enable_branch_auto_deletion")

    @enable_branch_auto_deletion.setter
    def enable_branch_auto_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_branch_auto_deletion", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Environment variables map for an Amplify app.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="iamServiceRoleArn")
    def iam_service_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS Identity and Access Management (IAM) service role for an Amplify app.
        """
        return pulumi.get(self, "iam_service_role_arn")

    @iam_service_role_arn.setter
    def iam_service_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_service_role_arn", value)

    @property
    @pulumi.getter(name="jobConfig")
    def job_config(self) -> Optional[pulumi.Input['AppJobConfigArgs']]:
        """
        Used to configure the [Amplify Application build settings](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html). See `job_config` Block for details.
        """
        return pulumi.get(self, "job_config")

    @job_config.setter
    def job_config(self, value: Optional[pulumi.Input['AppJobConfigArgs']]):
        pulumi.set(self, "job_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for an Amplify app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        """
        return pulumi.get(self, "oauth_token")

    @oauth_token.setter
    def oauth_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oauth_token", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Repository for an Amplify app.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AppState:
    def __init__(__self__, *,
                 access_token: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']] = None,
                 auto_branch_creation_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[builtins.str]] = None,
                 build_spec: Optional[pulumi.Input[builtins.str]] = None,
                 cache_config: Optional[pulumi.Input['AppCacheConfigArgs']] = None,
                 compute_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_headers: Optional[pulumi.Input[builtins.str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]] = None,
                 default_domain: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_auto_branch_creation: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_branch_auto_build: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 iam_service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 job_config: Optional[pulumi.Input['AppJobConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oauth_token: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 production_branches: Optional[pulumi.Input[Sequence[pulumi.Input['AppProductionBranchArgs']]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering App resources.
        :param pulumi.Input[builtins.str] access_token: Personal access token for a third-party source control system for an Amplify app. This token must have write access to the relevant repo to create a webhook and a read-only deploy key for the Amplify project. The token is not stored, so after applying this attribute can be removed and the setup token deleted.
        :param pulumi.Input[builtins.str] arn: ARN of the Amplify app.
        :param pulumi.Input['AppAutoBranchCreationConfigArgs'] auto_branch_creation_config: Automated branch creation configuration for an Amplify app. See `auto_branch_creation_config` Block for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] auto_branch_creation_patterns: Automated branch creation glob patterns for an Amplify app.
        :param pulumi.Input[builtins.str] basic_auth_credentials: Credentials for basic authorization for an Amplify app.
        :param pulumi.Input[builtins.str] build_spec: The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        :param pulumi.Input['AppCacheConfigArgs'] cache_config: Cache configuration for the Amplify app. See `cache_config` Block for details.
        :param pulumi.Input[builtins.str] compute_role_arn: AWS Identity and Access Management (IAM) SSR compute role for an Amplify app.
        :param pulumi.Input[builtins.str] custom_headers: The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]] custom_rules: Custom rewrite and redirect rules for an Amplify app. See `custom_rule` Block for details.
        :param pulumi.Input[builtins.str] default_domain: Default domain for the Amplify app.
        :param pulumi.Input[builtins.str] description: Description for an Amplify app.
        :param pulumi.Input[builtins.bool] enable_auto_branch_creation: Enables automated branch creation for an Amplify app.
        :param pulumi.Input[builtins.bool] enable_basic_auth: Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        :param pulumi.Input[builtins.bool] enable_branch_auto_build: Enables auto-building of branches for the Amplify App.
        :param pulumi.Input[builtins.bool] enable_branch_auto_deletion: Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: Environment variables map for an Amplify app.
        :param pulumi.Input[builtins.str] iam_service_role_arn: AWS Identity and Access Management (IAM) service role for an Amplify app.
        :param pulumi.Input['AppJobConfigArgs'] job_config: Used to configure the [Amplify Application build settings](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html). See `job_config` Block for details.
        :param pulumi.Input[builtins.str] name: Name for an Amplify app.
        :param pulumi.Input[builtins.str] oauth_token: OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        :param pulumi.Input[builtins.str] platform: Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
        :param pulumi.Input[Sequence[pulumi.Input['AppProductionBranchArgs']]] production_branches: Describes the information about a production branch for an Amplify app. A `production_branch` block is documented below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] repository: Repository for an Amplify app.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auto_branch_creation_config is not None:
            pulumi.set(__self__, "auto_branch_creation_config", auto_branch_creation_config)
        if auto_branch_creation_patterns is not None:
            pulumi.set(__self__, "auto_branch_creation_patterns", auto_branch_creation_patterns)
        if basic_auth_credentials is not None:
            pulumi.set(__self__, "basic_auth_credentials", basic_auth_credentials)
        if build_spec is not None:
            pulumi.set(__self__, "build_spec", build_spec)
        if cache_config is not None:
            pulumi.set(__self__, "cache_config", cache_config)
        if compute_role_arn is not None:
            pulumi.set(__self__, "compute_role_arn", compute_role_arn)
        if custom_headers is not None:
            pulumi.set(__self__, "custom_headers", custom_headers)
        if custom_rules is not None:
            pulumi.set(__self__, "custom_rules", custom_rules)
        if default_domain is not None:
            pulumi.set(__self__, "default_domain", default_domain)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_auto_branch_creation is not None:
            pulumi.set(__self__, "enable_auto_branch_creation", enable_auto_branch_creation)
        if enable_basic_auth is not None:
            pulumi.set(__self__, "enable_basic_auth", enable_basic_auth)
        if enable_branch_auto_build is not None:
            pulumi.set(__self__, "enable_branch_auto_build", enable_branch_auto_build)
        if enable_branch_auto_deletion is not None:
            pulumi.set(__self__, "enable_branch_auto_deletion", enable_branch_auto_deletion)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if iam_service_role_arn is not None:
            pulumi.set(__self__, "iam_service_role_arn", iam_service_role_arn)
        if job_config is not None:
            pulumi.set(__self__, "job_config", job_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_token is not None:
            pulumi.set(__self__, "oauth_token", oauth_token)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if production_branches is not None:
            pulumi.set(__self__, "production_branches", production_branches)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Personal access token for a third-party source control system for an Amplify app. This token must have write access to the relevant repo to create a webhook and a read-only deploy key for the Amplify project. The token is not stored, so after applying this attribute can be removed and the setup token deleted.
        """
        return pulumi.get(self, "access_token")

    @access_token.setter
    def access_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_token", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Amplify app.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="autoBranchCreationConfig")
    def auto_branch_creation_config(self) -> Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']]:
        """
        Automated branch creation configuration for an Amplify app. See `auto_branch_creation_config` Block for details.
        """
        return pulumi.get(self, "auto_branch_creation_config")

    @auto_branch_creation_config.setter
    def auto_branch_creation_config(self, value: Optional[pulumi.Input['AppAutoBranchCreationConfigArgs']]):
        pulumi.set(self, "auto_branch_creation_config", value)

    @property
    @pulumi.getter(name="autoBranchCreationPatterns")
    def auto_branch_creation_patterns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Automated branch creation glob patterns for an Amplify app.
        """
        return pulumi.get(self, "auto_branch_creation_patterns")

    @auto_branch_creation_patterns.setter
    def auto_branch_creation_patterns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "auto_branch_creation_patterns", value)

    @property
    @pulumi.getter(name="basicAuthCredentials")
    def basic_auth_credentials(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Credentials for basic authorization for an Amplify app.
        """
        return pulumi.get(self, "basic_auth_credentials")

    @basic_auth_credentials.setter
    def basic_auth_credentials(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "basic_auth_credentials", value)

    @property
    @pulumi.getter(name="buildSpec")
    def build_spec(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        """
        return pulumi.get(self, "build_spec")

    @build_spec.setter
    def build_spec(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "build_spec", value)

    @property
    @pulumi.getter(name="cacheConfig")
    def cache_config(self) -> Optional[pulumi.Input['AppCacheConfigArgs']]:
        """
        Cache configuration for the Amplify app. See `cache_config` Block for details.
        """
        return pulumi.get(self, "cache_config")

    @cache_config.setter
    def cache_config(self, value: Optional[pulumi.Input['AppCacheConfigArgs']]):
        pulumi.set(self, "cache_config", value)

    @property
    @pulumi.getter(name="computeRoleArn")
    def compute_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS Identity and Access Management (IAM) SSR compute role for an Amplify app.
        """
        return pulumi.get(self, "compute_role_arn")

    @compute_role_arn.setter
    def compute_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_role_arn", value)

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
        """
        return pulumi.get(self, "custom_headers")

    @custom_headers.setter
    def custom_headers(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_headers", value)

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]]:
        """
        Custom rewrite and redirect rules for an Amplify app. See `custom_rule` Block for details.
        """
        return pulumi.get(self, "custom_rules")

    @custom_rules.setter
    def custom_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppCustomRuleArgs']]]]):
        pulumi.set(self, "custom_rules", value)

    @property
    @pulumi.getter(name="defaultDomain")
    def default_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Default domain for the Amplify app.
        """
        return pulumi.get(self, "default_domain")

    @default_domain.setter
    def default_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_domain", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for an Amplify app.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableAutoBranchCreation")
    def enable_auto_branch_creation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables automated branch creation for an Amplify app.
        """
        return pulumi.get(self, "enable_auto_branch_creation")

    @enable_auto_branch_creation.setter
    def enable_auto_branch_creation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_auto_branch_creation", value)

    @property
    @pulumi.getter(name="enableBasicAuth")
    def enable_basic_auth(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        """
        return pulumi.get(self, "enable_basic_auth")

    @enable_basic_auth.setter
    def enable_basic_auth(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_basic_auth", value)

    @property
    @pulumi.getter(name="enableBranchAutoBuild")
    def enable_branch_auto_build(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables auto-building of branches for the Amplify App.
        """
        return pulumi.get(self, "enable_branch_auto_build")

    @enable_branch_auto_build.setter
    def enable_branch_auto_build(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_branch_auto_build", value)

    @property
    @pulumi.getter(name="enableBranchAutoDeletion")
    def enable_branch_auto_deletion(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        """
        return pulumi.get(self, "enable_branch_auto_deletion")

    @enable_branch_auto_deletion.setter
    def enable_branch_auto_deletion(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_branch_auto_deletion", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Environment variables map for an Amplify app.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="iamServiceRoleArn")
    def iam_service_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS Identity and Access Management (IAM) service role for an Amplify app.
        """
        return pulumi.get(self, "iam_service_role_arn")

    @iam_service_role_arn.setter
    def iam_service_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_service_role_arn", value)

    @property
    @pulumi.getter(name="jobConfig")
    def job_config(self) -> Optional[pulumi.Input['AppJobConfigArgs']]:
        """
        Used to configure the [Amplify Application build settings](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html). See `job_config` Block for details.
        """
        return pulumi.get(self, "job_config")

    @job_config.setter
    def job_config(self, value: Optional[pulumi.Input['AppJobConfigArgs']]):
        pulumi.set(self, "job_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name for an Amplify app.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        """
        return pulumi.get(self, "oauth_token")

    @oauth_token.setter
    def oauth_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oauth_token", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="productionBranches")
    def production_branches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppProductionBranchArgs']]]]:
        """
        Describes the information about a production branch for an Amplify app. A `production_branch` block is documented below.
        """
        return pulumi.get(self, "production_branches")

    @production_branches.setter
    def production_branches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppProductionBranchArgs']]]]):
        pulumi.set(self, "production_branches", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Repository for an Amplify app.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:amplify/app:App")
class App(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[builtins.str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input[Union['AppAutoBranchCreationConfigArgs', 'AppAutoBranchCreationConfigArgsDict']]] = None,
                 auto_branch_creation_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[builtins.str]] = None,
                 build_spec: Optional[pulumi.Input[builtins.str]] = None,
                 cache_config: Optional[pulumi.Input[Union['AppCacheConfigArgs', 'AppCacheConfigArgsDict']]] = None,
                 compute_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_headers: Optional[pulumi.Input[builtins.str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppCustomRuleArgs', 'AppCustomRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_auto_branch_creation: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_branch_auto_build: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 iam_service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 job_config: Optional[pulumi.Input[Union['AppJobConfigArgs', 'AppJobConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oauth_token: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides an Amplify App resource, a fullstack serverless app hosted on the [AWS Amplify Console](https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html).

        > **Note:** When you create/update an Amplify App from the provider, you may end up with the error "BadRequestException: You should at least provide one valid token" because of authentication issues. See the section "Repository with Tokens" below.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            repository="https://github.com/example/app",
            build_spec=\"\"\"version: 0.1
        frontend:
          phases:
            preBuild:
              commands:
                - yarn install
            build:
              commands:
                - yarn run build
          artifacts:
            baseDirectory: build
            files:
              - '**/*'
          cache:
            paths:
              - node_modules/**/*
        \"\"\",
            custom_rules=[{
                "source": "/<*>",
                "status": "404",
                "target": "/index.html",
            }],
            environment_variables={
                "ENV": "test",
            })
        ```

        ### Repository with Tokens

        If you create a new Amplify App with the `repository` argument, you also need to set `oauth_token` or `access_token` for authentication. For GitHub, get a [personal access token](https://help.github.com/en/github/authenticating-to-github/creating-a-personal-access-token-for-the-command-line) and set `access_token` as follows:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            repository="https://github.com/example/app",
            access_token="...")
        ```

        You can omit `access_token` if you import an existing Amplify App created by the Amplify Console (using OAuth for authentication).

        ### Auto Branch Creation

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            enable_auto_branch_creation=True,
            auto_branch_creation_patterns=[
                "*",
                "*/**",
            ],
            auto_branch_creation_config={
                "enable_auto_build": True,
            })
        ```

        ### Basic Authorization

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.amplify.App("example",
            name="example",
            enable_basic_auth=True,
            basic_auth_credentials=std.base64encode(input="username1:password1").result)
        ```

        ### Rewrites and Redirects

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            custom_rules=[
                {
                    "source": "/api/<*>",
                    "status": "200",
                    "target": "https://api.example.com/api/<*>",
                },
                {
                    "source": "</^[^.]+$|\\\\.(?!(css|gif|ico|jpg|js|png|txt|svg|woff|ttf|map|json)$)([^.]+$)/>",
                    "status": "200",
                    "target": "/index.html",
                },
            ])
        ```

        ### Custom Image

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            environment_variables={
                "_CUSTOM_IMAGE": "node:16",
            })
        ```

        ### Custom Headers

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            custom_headers=\"\"\"customHeaders:
          - pattern: '**'
            headers:
              - key: 'Strict-Transport-Security'
                value: 'max-age=31536000; includeSubDomains'
              - key: 'X-Frame-Options'
                value: 'SAMEORIGIN'
              - key: 'X-XSS-Protection'
                value: '1; mode=block'
              - key: 'X-Content-Type-Options'
                value: 'nosniff'
              - key: 'Content-Security-Policy'
                value: "default-src 'self'"
        \"\"\")
        ```

        ### Job Config

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            job_config={
                "build_compute_type": "STANDARD_8GB",
            })
        ```

        ## Import

        Using `pulumi import`, import Amplify App using Amplify App ID (appId). For example:

        ```sh
        $ pulumi import aws:amplify/app:App example d2ypk4k47z8u6
        ```
        App ID can be obtained from App ARN (e.g., `arn:aws:amplify:us-east-1:12345678:apps/d2ypk4k47z8u6`).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_token: Personal access token for a third-party source control system for an Amplify app. This token must have write access to the relevant repo to create a webhook and a read-only deploy key for the Amplify project. The token is not stored, so after applying this attribute can be removed and the setup token deleted.
        :param pulumi.Input[Union['AppAutoBranchCreationConfigArgs', 'AppAutoBranchCreationConfigArgsDict']] auto_branch_creation_config: Automated branch creation configuration for an Amplify app. See `auto_branch_creation_config` Block for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] auto_branch_creation_patterns: Automated branch creation glob patterns for an Amplify app.
        :param pulumi.Input[builtins.str] basic_auth_credentials: Credentials for basic authorization for an Amplify app.
        :param pulumi.Input[builtins.str] build_spec: The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        :param pulumi.Input[Union['AppCacheConfigArgs', 'AppCacheConfigArgsDict']] cache_config: Cache configuration for the Amplify app. See `cache_config` Block for details.
        :param pulumi.Input[builtins.str] compute_role_arn: AWS Identity and Access Management (IAM) SSR compute role for an Amplify app.
        :param pulumi.Input[builtins.str] custom_headers: The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppCustomRuleArgs', 'AppCustomRuleArgsDict']]]] custom_rules: Custom rewrite and redirect rules for an Amplify app. See `custom_rule` Block for details.
        :param pulumi.Input[builtins.str] description: Description for an Amplify app.
        :param pulumi.Input[builtins.bool] enable_auto_branch_creation: Enables automated branch creation for an Amplify app.
        :param pulumi.Input[builtins.bool] enable_basic_auth: Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        :param pulumi.Input[builtins.bool] enable_branch_auto_build: Enables auto-building of branches for the Amplify App.
        :param pulumi.Input[builtins.bool] enable_branch_auto_deletion: Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: Environment variables map for an Amplify app.
        :param pulumi.Input[builtins.str] iam_service_role_arn: AWS Identity and Access Management (IAM) service role for an Amplify app.
        :param pulumi.Input[Union['AppJobConfigArgs', 'AppJobConfigArgsDict']] job_config: Used to configure the [Amplify Application build settings](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html). See `job_config` Block for details.
        :param pulumi.Input[builtins.str] name: Name for an Amplify app.
        :param pulumi.Input[builtins.str] oauth_token: OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        :param pulumi.Input[builtins.str] platform: Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] repository: Repository for an Amplify app.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AppArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amplify App resource, a fullstack serverless app hosted on the [AWS Amplify Console](https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html).

        > **Note:** When you create/update an Amplify App from the provider, you may end up with the error "BadRequestException: You should at least provide one valid token" because of authentication issues. See the section "Repository with Tokens" below.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            repository="https://github.com/example/app",
            build_spec=\"\"\"version: 0.1
        frontend:
          phases:
            preBuild:
              commands:
                - yarn install
            build:
              commands:
                - yarn run build
          artifacts:
            baseDirectory: build
            files:
              - '**/*'
          cache:
            paths:
              - node_modules/**/*
        \"\"\",
            custom_rules=[{
                "source": "/<*>",
                "status": "404",
                "target": "/index.html",
            }],
            environment_variables={
                "ENV": "test",
            })
        ```

        ### Repository with Tokens

        If you create a new Amplify App with the `repository` argument, you also need to set `oauth_token` or `access_token` for authentication. For GitHub, get a [personal access token](https://help.github.com/en/github/authenticating-to-github/creating-a-personal-access-token-for-the-command-line) and set `access_token` as follows:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            repository="https://github.com/example/app",
            access_token="...")
        ```

        You can omit `access_token` if you import an existing Amplify App created by the Amplify Console (using OAuth for authentication).

        ### Auto Branch Creation

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            enable_auto_branch_creation=True,
            auto_branch_creation_patterns=[
                "*",
                "*/**",
            ],
            auto_branch_creation_config={
                "enable_auto_build": True,
            })
        ```

        ### Basic Authorization

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.amplify.App("example",
            name="example",
            enable_basic_auth=True,
            basic_auth_credentials=std.base64encode(input="username1:password1").result)
        ```

        ### Rewrites and Redirects

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            custom_rules=[
                {
                    "source": "/api/<*>",
                    "status": "200",
                    "target": "https://api.example.com/api/<*>",
                },
                {
                    "source": "</^[^.]+$|\\\\.(?!(css|gif|ico|jpg|js|png|txt|svg|woff|ttf|map|json)$)([^.]+$)/>",
                    "status": "200",
                    "target": "/index.html",
                },
            ])
        ```

        ### Custom Image

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            environment_variables={
                "_CUSTOM_IMAGE": "node:16",
            })
        ```

        ### Custom Headers

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            custom_headers=\"\"\"customHeaders:
          - pattern: '**'
            headers:
              - key: 'Strict-Transport-Security'
                value: 'max-age=31536000; includeSubDomains'
              - key: 'X-Frame-Options'
                value: 'SAMEORIGIN'
              - key: 'X-XSS-Protection'
                value: '1; mode=block'
              - key: 'X-Content-Type-Options'
                value: 'nosniff'
              - key: 'Content-Security-Policy'
                value: "default-src 'self'"
        \"\"\")
        ```

        ### Job Config

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amplify.App("example",
            name="example",
            job_config={
                "build_compute_type": "STANDARD_8GB",
            })
        ```

        ## Import

        Using `pulumi import`, import Amplify App using Amplify App ID (appId). For example:

        ```sh
        $ pulumi import aws:amplify/app:App example d2ypk4k47z8u6
        ```
        App ID can be obtained from App ARN (e.g., `arn:aws:amplify:us-east-1:12345678:apps/d2ypk4k47z8u6`).

        :param str resource_name: The name of the resource.
        :param AppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token: Optional[pulumi.Input[builtins.str]] = None,
                 auto_branch_creation_config: Optional[pulumi.Input[Union['AppAutoBranchCreationConfigArgs', 'AppAutoBranchCreationConfigArgsDict']]] = None,
                 auto_branch_creation_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 basic_auth_credentials: Optional[pulumi.Input[builtins.str]] = None,
                 build_spec: Optional[pulumi.Input[builtins.str]] = None,
                 cache_config: Optional[pulumi.Input[Union['AppCacheConfigArgs', 'AppCacheConfigArgsDict']]] = None,
                 compute_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_headers: Optional[pulumi.Input[builtins.str]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppCustomRuleArgs', 'AppCustomRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_auto_branch_creation: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_basic_auth: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_branch_auto_build: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_branch_auto_deletion: Optional[pulumi.Input[builtins.bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 iam_service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 job_config: Optional[pulumi.Input[Union['AppJobConfigArgs', 'AppJobConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oauth_token: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppArgs.__new__(AppArgs)

            __props__.__dict__["access_token"] = None if access_token is None else pulumi.Output.secret(access_token)
            __props__.__dict__["auto_branch_creation_config"] = auto_branch_creation_config
            __props__.__dict__["auto_branch_creation_patterns"] = auto_branch_creation_patterns
            __props__.__dict__["basic_auth_credentials"] = None if basic_auth_credentials is None else pulumi.Output.secret(basic_auth_credentials)
            __props__.__dict__["build_spec"] = build_spec
            __props__.__dict__["cache_config"] = cache_config
            __props__.__dict__["compute_role_arn"] = compute_role_arn
            __props__.__dict__["custom_headers"] = custom_headers
            __props__.__dict__["custom_rules"] = custom_rules
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_auto_branch_creation"] = enable_auto_branch_creation
            __props__.__dict__["enable_basic_auth"] = enable_basic_auth
            __props__.__dict__["enable_branch_auto_build"] = enable_branch_auto_build
            __props__.__dict__["enable_branch_auto_deletion"] = enable_branch_auto_deletion
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["iam_service_role_arn"] = iam_service_role_arn
            __props__.__dict__["job_config"] = job_config
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth_token"] = None if oauth_token is None else pulumi.Output.secret(oauth_token)
            __props__.__dict__["platform"] = platform
            __props__.__dict__["region"] = region
            __props__.__dict__["repository"] = repository
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["default_domain"] = None
            __props__.__dict__["production_branches"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accessToken", "basicAuthCredentials", "oauthToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(App, __self__).__init__(
            'aws:amplify/app:App',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            auto_branch_creation_config: Optional[pulumi.Input[Union['AppAutoBranchCreationConfigArgs', 'AppAutoBranchCreationConfigArgsDict']]] = None,
            auto_branch_creation_patterns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            basic_auth_credentials: Optional[pulumi.Input[builtins.str]] = None,
            build_spec: Optional[pulumi.Input[builtins.str]] = None,
            cache_config: Optional[pulumi.Input[Union['AppCacheConfigArgs', 'AppCacheConfigArgsDict']]] = None,
            compute_role_arn: Optional[pulumi.Input[builtins.str]] = None,
            custom_headers: Optional[pulumi.Input[builtins.str]] = None,
            custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppCustomRuleArgs', 'AppCustomRuleArgsDict']]]]] = None,
            default_domain: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enable_auto_branch_creation: Optional[pulumi.Input[builtins.bool]] = None,
            enable_basic_auth: Optional[pulumi.Input[builtins.bool]] = None,
            enable_branch_auto_build: Optional[pulumi.Input[builtins.bool]] = None,
            enable_branch_auto_deletion: Optional[pulumi.Input[builtins.bool]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            iam_service_role_arn: Optional[pulumi.Input[builtins.str]] = None,
            job_config: Optional[pulumi.Input[Union['AppJobConfigArgs', 'AppJobConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            oauth_token: Optional[pulumi.Input[builtins.str]] = None,
            platform: Optional[pulumi.Input[builtins.str]] = None,
            production_branches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppProductionBranchArgs', 'AppProductionBranchArgsDict']]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            repository: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'App':
        """
        Get an existing App resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_token: Personal access token for a third-party source control system for an Amplify app. This token must have write access to the relevant repo to create a webhook and a read-only deploy key for the Amplify project. The token is not stored, so after applying this attribute can be removed and the setup token deleted.
        :param pulumi.Input[builtins.str] arn: ARN of the Amplify app.
        :param pulumi.Input[Union['AppAutoBranchCreationConfigArgs', 'AppAutoBranchCreationConfigArgsDict']] auto_branch_creation_config: Automated branch creation configuration for an Amplify app. See `auto_branch_creation_config` Block for details.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] auto_branch_creation_patterns: Automated branch creation glob patterns for an Amplify app.
        :param pulumi.Input[builtins.str] basic_auth_credentials: Credentials for basic authorization for an Amplify app.
        :param pulumi.Input[builtins.str] build_spec: The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        :param pulumi.Input[Union['AppCacheConfigArgs', 'AppCacheConfigArgsDict']] cache_config: Cache configuration for the Amplify app. See `cache_config` Block for details.
        :param pulumi.Input[builtins.str] compute_role_arn: AWS Identity and Access Management (IAM) SSR compute role for an Amplify app.
        :param pulumi.Input[builtins.str] custom_headers: The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppCustomRuleArgs', 'AppCustomRuleArgsDict']]]] custom_rules: Custom rewrite and redirect rules for an Amplify app. See `custom_rule` Block for details.
        :param pulumi.Input[builtins.str] default_domain: Default domain for the Amplify app.
        :param pulumi.Input[builtins.str] description: Description for an Amplify app.
        :param pulumi.Input[builtins.bool] enable_auto_branch_creation: Enables automated branch creation for an Amplify app.
        :param pulumi.Input[builtins.bool] enable_basic_auth: Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        :param pulumi.Input[builtins.bool] enable_branch_auto_build: Enables auto-building of branches for the Amplify App.
        :param pulumi.Input[builtins.bool] enable_branch_auto_deletion: Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: Environment variables map for an Amplify app.
        :param pulumi.Input[builtins.str] iam_service_role_arn: AWS Identity and Access Management (IAM) service role for an Amplify app.
        :param pulumi.Input[Union['AppJobConfigArgs', 'AppJobConfigArgsDict']] job_config: Used to configure the [Amplify Application build settings](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html). See `job_config` Block for details.
        :param pulumi.Input[builtins.str] name: Name for an Amplify app.
        :param pulumi.Input[builtins.str] oauth_token: OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        :param pulumi.Input[builtins.str] platform: Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppProductionBranchArgs', 'AppProductionBranchArgsDict']]]] production_branches: Describes the information about a production branch for an Amplify app. A `production_branch` block is documented below.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] repository: Repository for an Amplify app.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppState.__new__(_AppState)

        __props__.__dict__["access_token"] = access_token
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auto_branch_creation_config"] = auto_branch_creation_config
        __props__.__dict__["auto_branch_creation_patterns"] = auto_branch_creation_patterns
        __props__.__dict__["basic_auth_credentials"] = basic_auth_credentials
        __props__.__dict__["build_spec"] = build_spec
        __props__.__dict__["cache_config"] = cache_config
        __props__.__dict__["compute_role_arn"] = compute_role_arn
        __props__.__dict__["custom_headers"] = custom_headers
        __props__.__dict__["custom_rules"] = custom_rules
        __props__.__dict__["default_domain"] = default_domain
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_auto_branch_creation"] = enable_auto_branch_creation
        __props__.__dict__["enable_basic_auth"] = enable_basic_auth
        __props__.__dict__["enable_branch_auto_build"] = enable_branch_auto_build
        __props__.__dict__["enable_branch_auto_deletion"] = enable_branch_auto_deletion
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["iam_service_role_arn"] = iam_service_role_arn
        __props__.__dict__["job_config"] = job_config
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth_token"] = oauth_token
        __props__.__dict__["platform"] = platform
        __props__.__dict__["production_branches"] = production_branches
        __props__.__dict__["region"] = region
        __props__.__dict__["repository"] = repository
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return App(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Personal access token for a third-party source control system for an Amplify app. This token must have write access to the relevant repo to create a webhook and a read-only deploy key for the Amplify project. The token is not stored, so after applying this attribute can be removed and the setup token deleted.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Amplify app.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoBranchCreationConfig")
    def auto_branch_creation_config(self) -> pulumi.Output['outputs.AppAutoBranchCreationConfig']:
        """
        Automated branch creation configuration for an Amplify app. See `auto_branch_creation_config` Block for details.
        """
        return pulumi.get(self, "auto_branch_creation_config")

    @property
    @pulumi.getter(name="autoBranchCreationPatterns")
    def auto_branch_creation_patterns(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Automated branch creation glob patterns for an Amplify app.
        """
        return pulumi.get(self, "auto_branch_creation_patterns")

    @property
    @pulumi.getter(name="basicAuthCredentials")
    def basic_auth_credentials(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Credentials for basic authorization for an Amplify app.
        """
        return pulumi.get(self, "basic_auth_credentials")

    @property
    @pulumi.getter(name="buildSpec")
    def build_spec(self) -> pulumi.Output[builtins.str]:
        """
        The [build specification](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html) (build spec) for an Amplify app.
        """
        return pulumi.get(self, "build_spec")

    @property
    @pulumi.getter(name="cacheConfig")
    def cache_config(self) -> pulumi.Output['outputs.AppCacheConfig']:
        """
        Cache configuration for the Amplify app. See `cache_config` Block for details.
        """
        return pulumi.get(self, "cache_config")

    @property
    @pulumi.getter(name="computeRoleArn")
    def compute_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS Identity and Access Management (IAM) SSR compute role for an Amplify app.
        """
        return pulumi.get(self, "compute_role_arn")

    @property
    @pulumi.getter(name="customHeaders")
    def custom_headers(self) -> pulumi.Output[builtins.str]:
        """
        The [custom HTTP headers](https://docs.aws.amazon.com/amplify/latest/userguide/custom-headers.html) for an Amplify app.
        """
        return pulumi.get(self, "custom_headers")

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> pulumi.Output[Optional[Sequence['outputs.AppCustomRule']]]:
        """
        Custom rewrite and redirect rules for an Amplify app. See `custom_rule` Block for details.
        """
        return pulumi.get(self, "custom_rules")

    @property
    @pulumi.getter(name="defaultDomain")
    def default_domain(self) -> pulumi.Output[builtins.str]:
        """
        Default domain for the Amplify app.
        """
        return pulumi.get(self, "default_domain")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description for an Amplify app.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableAutoBranchCreation")
    def enable_auto_branch_creation(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables automated branch creation for an Amplify app.
        """
        return pulumi.get(self, "enable_auto_branch_creation")

    @property
    @pulumi.getter(name="enableBasicAuth")
    def enable_basic_auth(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
        """
        return pulumi.get(self, "enable_basic_auth")

    @property
    @pulumi.getter(name="enableBranchAutoBuild")
    def enable_branch_auto_build(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables auto-building of branches for the Amplify App.
        """
        return pulumi.get(self, "enable_branch_auto_build")

    @property
    @pulumi.getter(name="enableBranchAutoDeletion")
    def enable_branch_auto_deletion(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
        """
        return pulumi.get(self, "enable_branch_auto_deletion")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Environment variables map for an Amplify app.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="iamServiceRoleArn")
    def iam_service_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS Identity and Access Management (IAM) service role for an Amplify app.
        """
        return pulumi.get(self, "iam_service_role_arn")

    @property
    @pulumi.getter(name="jobConfig")
    def job_config(self) -> pulumi.Output['outputs.AppJobConfig']:
        """
        Used to configure the [Amplify Application build settings](https://docs.aws.amazon.com/amplify/latest/userguide/build-settings.html). See `job_config` Block for details.
        """
        return pulumi.get(self, "job_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name for an Amplify app.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key. The OAuth token is not stored.
        """
        return pulumi.get(self, "oauth_token")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Platform or framework for an Amplify app. Valid values: `WEB`, `WEB_COMPUTE`. Default value: `WEB`.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="productionBranches")
    def production_branches(self) -> pulumi.Output[Sequence['outputs.AppProductionBranch']]:
        """
        Describes the information about a production branch for an Amplify app. A `production_branch` block is documented below.
        """
        return pulumi.get(self, "production_branches")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Repository for an Amplify app.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

