# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApiKeysResult',
    'AwaitableGetApiKeysResult',
    'get_api_keys',
    'get_api_keys_output',
]

@pulumi.output_type
class GetApiKeysResult:
    """
    A collection of values returned by getApiKeys.
    """
    def __init__(__self__, customer_id=None, id=None, include_values=None, items=None, region=None):
        if customer_id and not isinstance(customer_id, str):
            raise TypeError("Expected argument 'customer_id' to be a str")
        pulumi.set(__self__, "customer_id", customer_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_values and not isinstance(include_values, bool):
            raise TypeError("Expected argument 'include_values' to be a bool")
        pulumi.set(__self__, "include_values", include_values)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> Optional[builtins.str]:
        """
        Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.
        """
        return pulumi.get(self, "customer_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the API Key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeValues")
    def include_values(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "include_values")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetApiKeysItemResult']:
        """
        List of objects containing API Key information. See below.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetApiKeysResult(GetApiKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiKeysResult(
            customer_id=self.customer_id,
            id=self.id,
            include_values=self.include_values,
            items=self.items,
            region=self.region)


def get_api_keys(customer_id: Optional[builtins.str] = None,
                 include_values: Optional[builtins.bool] = None,
                 region: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiKeysResult:
    """
    Data source for managing AWS API Gateway API Keys.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.apigateway.get_api_keys()
    ```


    :param builtins.str customer_id: Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.
    :param builtins.bool include_values: Set this value to `true` if you wish the result contains the key value. Defaults to `false`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['customerId'] = customer_id
    __args__['includeValues'] = include_values
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:apigateway/getApiKeys:getApiKeys', __args__, opts=opts, typ=GetApiKeysResult).value

    return AwaitableGetApiKeysResult(
        customer_id=pulumi.get(__ret__, 'customer_id'),
        id=pulumi.get(__ret__, 'id'),
        include_values=pulumi.get(__ret__, 'include_values'),
        items=pulumi.get(__ret__, 'items'),
        region=pulumi.get(__ret__, 'region'))
def get_api_keys_output(customer_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        include_values: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                        region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiKeysResult]:
    """
    Data source for managing AWS API Gateway API Keys.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.apigateway.get_api_keys()
    ```


    :param builtins.str customer_id: Amazon Web Services Marketplace customer identifier, when integrating with the Amazon Web Services SaaS Marketplace.
    :param builtins.bool include_values: Set this value to `true` if you wish the result contains the key value. Defaults to `false`.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['customerId'] = customer_id
    __args__['includeValues'] = include_values
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:apigateway/getApiKeys:getApiKeys', __args__, opts=opts, typ=GetApiKeysResult)
    return __ret__.apply(lambda __response__: GetApiKeysResult(
        customer_id=pulumi.get(__response__, 'customer_id'),
        id=pulumi.get(__response__, 'id'),
        include_values=pulumi.get(__response__, 'include_values'),
        items=pulumi.get(__response__, 'items'),
        region=pulumi.get(__response__, 'region')))
