# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RestApiPutArgs', 'RestApiPut']

@pulumi.input_type
class RestApiPutArgs:
    def __init__(__self__, *,
                 body: pulumi.Input[builtins.str],
                 rest_api_id: pulumi.Input[builtins.str],
                 fail_on_warnings: Optional[pulumi.Input[builtins.bool]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['RestApiPutTimeoutsArgs']] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a RestApiPut resource.
        :param pulumi.Input[builtins.str] body: PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
        :param pulumi.Input[builtins.str] rest_api_id: Identifier of the associated REST API.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] fail_on_warnings: Whether to rollback the API update when a warning is encountered. The default value is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Map of customizations for importing the specification in the `body` argument. For example, to exclude DocumentationParts from an imported API, use `ignore = "documentation"`. Additional documentation, including other parameters such as `basepath`, can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger a redeployment. To force a redeployment without changing these keys/values, use the `-replace` option with `pulumi preview` or `pulumi up`.
        """
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "rest_api_id", rest_api_id)
        if fail_on_warnings is not None:
            pulumi.set(__self__, "fail_on_warnings", fail_on_warnings)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Input[builtins.str]:
        """
        PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the associated REST API.

        The following arguments are optional:
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rest_api_id", value)

    @property
    @pulumi.getter(name="failOnWarnings")
    def fail_on_warnings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to rollback the API update when a warning is encountered. The default value is `false`.
        """
        return pulumi.get(self, "fail_on_warnings")

    @fail_on_warnings.setter
    def fail_on_warnings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fail_on_warnings", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of customizations for importing the specification in the `body` argument. For example, to exclude DocumentationParts from an imported API, use `ignore = "documentation"`. Additional documentation, including other parameters such as `basepath`, can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html).
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RestApiPutTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RestApiPutTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of arbitrary keys and values that, when changed, will trigger a redeployment. To force a redeployment without changing these keys/values, use the `-replace` option with `pulumi preview` or `pulumi up`.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "triggers", value)


@pulumi.input_type
class _RestApiPutState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 fail_on_warnings: Optional[pulumi.Input[builtins.bool]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rest_api_id: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['RestApiPutTimeoutsArgs']] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RestApiPut resources.
        :param pulumi.Input[builtins.str] body: PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
        :param pulumi.Input[builtins.bool] fail_on_warnings: Whether to rollback the API update when a warning is encountered. The default value is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Map of customizations for importing the specification in the `body` argument. For example, to exclude DocumentationParts from an imported API, use `ignore = "documentation"`. Additional documentation, including other parameters such as `basepath`, can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] rest_api_id: Identifier of the associated REST API.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger a redeployment. To force a redeployment without changing these keys/values, use the `-replace` option with `pulumi preview` or `pulumi up`.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if fail_on_warnings is not None:
            pulumi.set(__self__, "fail_on_warnings", fail_on_warnings)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest_api_id is not None:
            pulumi.set(__self__, "rest_api_id", rest_api_id)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="failOnWarnings")
    def fail_on_warnings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to rollback the API update when a warning is encountered. The default value is `false`.
        """
        return pulumi.get(self, "fail_on_warnings")

    @fail_on_warnings.setter
    def fail_on_warnings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fail_on_warnings", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of customizations for importing the specification in the `body` argument. For example, to exclude DocumentationParts from an imported API, use `ignore = "documentation"`. Additional documentation, including other parameters such as `basepath`, can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html).
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of the associated REST API.

        The following arguments are optional:
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rest_api_id", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['RestApiPutTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['RestApiPutTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of arbitrary keys and values that, when changed, will trigger a redeployment. To force a redeployment without changing these keys/values, use the `-replace` option with `pulumi preview` or `pulumi up`.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "triggers", value)


@pulumi.type_token("aws:apigateway/restApiPut:RestApiPut")
class RestApiPut(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 fail_on_warnings: Optional[pulumi.Input[builtins.bool]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rest_api_id: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['RestApiPutTimeoutsArgs', 'RestApiPutTimeoutsArgsDict']]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.apigateway.RestApiPut("example",
            body=json.dumps({
                "swagger": "2.0",
                "info": {
                    "title": "Example API",
                    "version": "v1",
                },
                "schemes": ["https"],
                "paths": {
                    "/example": {
                        "get": {
                            "responses": {
                                "200": {
                                    "description": "OK",
                                },
                            },
                            "x-amazon-apigateway-integration": {
                                "httpMethod": "GET",
                                "type": "HTTP",
                                "responses": {
                                    "default": {
                                        "statusCode": 200,
                                    },
                                },
                                "uri": "https://api.example.com/",
                            },
                        },
                    },
                },
            }),
            fail_on_warnings=True,
            rest_api_id=example_aws_api_gateway_rest_api["id"])
        ```

        ## Import

        Using `pulumi import`, import API Gateway REST API Put using the `rest_api_id`. For example:

        ```sh
        $ pulumi import aws:apigateway/restApiPut:RestApiPut example import-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] body: PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
        :param pulumi.Input[builtins.bool] fail_on_warnings: Whether to rollback the API update when a warning is encountered. The default value is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Map of customizations for importing the specification in the `body` argument. For example, to exclude DocumentationParts from an imported API, use `ignore = "documentation"`. Additional documentation, including other parameters such as `basepath`, can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] rest_api_id: Identifier of the associated REST API.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger a redeployment. To force a redeployment without changing these keys/values, use the `-replace` option with `pulumi preview` or `pulumi up`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RestApiPutArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.apigateway.RestApiPut("example",
            body=json.dumps({
                "swagger": "2.0",
                "info": {
                    "title": "Example API",
                    "version": "v1",
                },
                "schemes": ["https"],
                "paths": {
                    "/example": {
                        "get": {
                            "responses": {
                                "200": {
                                    "description": "OK",
                                },
                            },
                            "x-amazon-apigateway-integration": {
                                "httpMethod": "GET",
                                "type": "HTTP",
                                "responses": {
                                    "default": {
                                        "statusCode": 200,
                                    },
                                },
                                "uri": "https://api.example.com/",
                            },
                        },
                    },
                },
            }),
            fail_on_warnings=True,
            rest_api_id=example_aws_api_gateway_rest_api["id"])
        ```

        ## Import

        Using `pulumi import`, import API Gateway REST API Put using the `rest_api_id`. For example:

        ```sh
        $ pulumi import aws:apigateway/restApiPut:RestApiPut example import-id-12345678
        ```

        :param str resource_name: The name of the resource.
        :param RestApiPutArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestApiPutArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 fail_on_warnings: Optional[pulumi.Input[builtins.bool]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rest_api_id: Optional[pulumi.Input[builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['RestApiPutTimeoutsArgs', 'RestApiPutTimeoutsArgsDict']]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestApiPutArgs.__new__(RestApiPutArgs)

            if body is None and not opts.urn:
                raise TypeError("Missing required property 'body'")
            __props__.__dict__["body"] = body
            __props__.__dict__["fail_on_warnings"] = fail_on_warnings
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["region"] = region
            if rest_api_id is None and not opts.urn:
                raise TypeError("Missing required property 'rest_api_id'")
            __props__.__dict__["rest_api_id"] = rest_api_id
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["triggers"] = triggers
        super(RestApiPut, __self__).__init__(
            'aws:apigateway/restApiPut:RestApiPut',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[builtins.str]] = None,
            fail_on_warnings: Optional[pulumi.Input[builtins.bool]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            rest_api_id: Optional[pulumi.Input[builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['RestApiPutTimeoutsArgs', 'RestApiPutTimeoutsArgsDict']]] = None,
            triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'RestApiPut':
        """
        Get an existing RestApiPut resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] body: PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
        :param pulumi.Input[builtins.bool] fail_on_warnings: Whether to rollback the API update when a warning is encountered. The default value is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: Map of customizations for importing the specification in the `body` argument. For example, to exclude DocumentationParts from an imported API, use `ignore = "documentation"`. Additional documentation, including other parameters such as `basepath`, can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html).
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] rest_api_id: Identifier of the associated REST API.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] triggers: Map of arbitrary keys and values that, when changed, will trigger a redeployment. To force a redeployment without changing these keys/values, use the `-replace` option with `pulumi preview` or `pulumi up`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RestApiPutState.__new__(_RestApiPutState)

        __props__.__dict__["body"] = body
        __props__.__dict__["fail_on_warnings"] = fail_on_warnings
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["region"] = region
        __props__.__dict__["rest_api_id"] = rest_api_id
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["triggers"] = triggers
        return RestApiPut(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[builtins.str]:
        """
        PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="failOnWarnings")
    def fail_on_warnings(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to rollback the API update when a warning is encountered. The default value is `false`.
        """
        return pulumi.get(self, "fail_on_warnings")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of customizations for importing the specification in the `body` argument. For example, to exclude DocumentationParts from an imported API, use `ignore = "documentation"`. Additional documentation, including other parameters such as `basepath`, can be found in the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-import-api.html).
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Output[builtins.str]:
        """
        Identifier of the associated REST API.

        The following arguments are optional:
        """
        return pulumi.get(self, "rest_api_id")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.RestApiPutTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of arbitrary keys and values that, when changed, will trigger a redeployment. To force a redeployment without changing these keys/values, use the `-replace` option with `pulumi preview` or `pulumi up`.
        """
        return pulumi.get(self, "triggers")

