# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StageArgs', 'Stage']

@pulumi.input_type
class StageArgs:
    def __init__(__self__, *,
                 deployment: pulumi.Input[builtins.str],
                 rest_api: pulumi.Input[builtins.str],
                 stage_name: pulumi.Input[builtins.str],
                 access_log_settings: Optional[pulumi.Input['StageAccessLogSettingsArgs']] = None,
                 cache_cluster_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_cluster_size: Optional[pulumi.Input[builtins.str]] = None,
                 canary_settings: Optional[pulumi.Input['StageCanarySettingsArgs']] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 documentation_version: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 xray_tracing_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Stage resource.
        :param pulumi.Input[builtins.str] deployment: ID of the deployment that the stage points to
        :param pulumi.Input[builtins.str] rest_api: ID of the associated REST API
        :param pulumi.Input[builtins.str] stage_name: Name of the stage
        :param pulumi.Input['StageAccessLogSettingsArgs'] access_log_settings: Enables access logs for the API stage. See Access Log Settings below.
        :param pulumi.Input[builtins.bool] cache_cluster_enabled: Whether a cache cluster is enabled for the stage
        :param pulumi.Input[builtins.str] cache_cluster_size: Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
        :param pulumi.Input['StageCanarySettingsArgs'] canary_settings: Configuration settings of a canary deployment. See Canary Settings below.
        :param pulumi.Input[builtins.str] client_certificate_id: Identifier of a client certificate for the stage.
        :param pulumi.Input[builtins.str] description: Description of the stage.
        :param pulumi.Input[builtins.str] documentation_version: Version of the associated API documentation.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] variables: Map that defines the stage variables.
        :param pulumi.Input[builtins.bool] xray_tracing_enabled: Whether active tracing with X-ray is enabled. Defaults to `false`.
        """
        pulumi.set(__self__, "deployment", deployment)
        pulumi.set(__self__, "rest_api", rest_api)
        pulumi.set(__self__, "stage_name", stage_name)
        if access_log_settings is not None:
            pulumi.set(__self__, "access_log_settings", access_log_settings)
        if cache_cluster_enabled is not None:
            pulumi.set(__self__, "cache_cluster_enabled", cache_cluster_enabled)
        if cache_cluster_size is not None:
            pulumi.set(__self__, "cache_cluster_size", cache_cluster_size)
        if canary_settings is not None:
            pulumi.set(__self__, "canary_settings", canary_settings)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation_version is not None:
            pulumi.set(__self__, "documentation_version", documentation_version)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)
        if xray_tracing_enabled is not None:
            pulumi.set(__self__, "xray_tracing_enabled", xray_tracing_enabled)

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Input[builtins.str]:
        """
        ID of the deployment that the stage points to
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter(name="restApi")
    def rest_api(self) -> pulumi.Input[builtins.str]:
        """
        ID of the associated REST API
        """
        return pulumi.get(self, "rest_api")

    @rest_api.setter
    def rest_api(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rest_api", value)

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the stage
        """
        return pulumi.get(self, "stage_name")

    @stage_name.setter
    def stage_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "stage_name", value)

    @property
    @pulumi.getter(name="accessLogSettings")
    def access_log_settings(self) -> Optional[pulumi.Input['StageAccessLogSettingsArgs']]:
        """
        Enables access logs for the API stage. See Access Log Settings below.
        """
        return pulumi.get(self, "access_log_settings")

    @access_log_settings.setter
    def access_log_settings(self, value: Optional[pulumi.Input['StageAccessLogSettingsArgs']]):
        pulumi.set(self, "access_log_settings", value)

    @property
    @pulumi.getter(name="cacheClusterEnabled")
    def cache_cluster_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether a cache cluster is enabled for the stage
        """
        return pulumi.get(self, "cache_cluster_enabled")

    @cache_cluster_enabled.setter
    def cache_cluster_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cache_cluster_enabled", value)

    @property
    @pulumi.getter(name="cacheClusterSize")
    def cache_cluster_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
        """
        return pulumi.get(self, "cache_cluster_size")

    @cache_cluster_size.setter
    def cache_cluster_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_cluster_size", value)

    @property
    @pulumi.getter(name="canarySettings")
    def canary_settings(self) -> Optional[pulumi.Input['StageCanarySettingsArgs']]:
        """
        Configuration settings of a canary deployment. See Canary Settings below.
        """
        return pulumi.get(self, "canary_settings")

    @canary_settings.setter
    def canary_settings(self, value: Optional[pulumi.Input['StageCanarySettingsArgs']]):
        pulumi.set(self, "canary_settings", value)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a client certificate for the stage.
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the stage.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="documentationVersion")
    def documentation_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version of the associated API documentation.
        """
        return pulumi.get(self, "documentation_version")

    @documentation_version.setter
    def documentation_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "documentation_version", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map that defines the stage variables.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "variables", value)

    @property
    @pulumi.getter(name="xrayTracingEnabled")
    def xray_tracing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether active tracing with X-ray is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "xray_tracing_enabled")

    @xray_tracing_enabled.setter
    def xray_tracing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "xray_tracing_enabled", value)


@pulumi.input_type
class _StageState:
    def __init__(__self__, *,
                 access_log_settings: Optional[pulumi.Input['StageAccessLogSettingsArgs']] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 cache_cluster_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_cluster_size: Optional[pulumi.Input[builtins.str]] = None,
                 canary_settings: Optional[pulumi.Input['StageCanarySettingsArgs']] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 deployment: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 documentation_version: Optional[pulumi.Input[builtins.str]] = None,
                 execution_arn: Optional[pulumi.Input[builtins.str]] = None,
                 invoke_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rest_api: Optional[pulumi.Input[builtins.str]] = None,
                 stage_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 web_acl_arn: Optional[pulumi.Input[builtins.str]] = None,
                 xray_tracing_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Stage resources.
        :param pulumi.Input['StageAccessLogSettingsArgs'] access_log_settings: Enables access logs for the API stage. See Access Log Settings below.
        :param pulumi.Input[builtins.str] arn: ARN
        :param pulumi.Input[builtins.bool] cache_cluster_enabled: Whether a cache cluster is enabled for the stage
        :param pulumi.Input[builtins.str] cache_cluster_size: Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
        :param pulumi.Input['StageCanarySettingsArgs'] canary_settings: Configuration settings of a canary deployment. See Canary Settings below.
        :param pulumi.Input[builtins.str] client_certificate_id: Identifier of a client certificate for the stage.
        :param pulumi.Input[builtins.str] deployment: ID of the deployment that the stage points to
        :param pulumi.Input[builtins.str] description: Description of the stage.
        :param pulumi.Input[builtins.str] documentation_version: Version of the associated API documentation.
        :param pulumi.Input[builtins.str] execution_arn: Execution ARN to be used in `lambda_permission`'s `source_arn`
               when allowing API Gateway to invoke a Lambda function,
               e.g., `arn:aws:execute-api:eu-west-2:123456789012:z4675bid1j/prod`
        :param pulumi.Input[builtins.str] invoke_url: URL to invoke the API pointing to the stage,
               e.g., `https://z4675bid1j.execute-api.eu-west-2.amazonaws.com/prod`
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] rest_api: ID of the associated REST API
        :param pulumi.Input[builtins.str] stage_name: Name of the stage
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] variables: Map that defines the stage variables.
        :param pulumi.Input[builtins.str] web_acl_arn: ARN of the WebAcl associated with the Stage.
        :param pulumi.Input[builtins.bool] xray_tracing_enabled: Whether active tracing with X-ray is enabled. Defaults to `false`.
        """
        if access_log_settings is not None:
            pulumi.set(__self__, "access_log_settings", access_log_settings)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cache_cluster_enabled is not None:
            pulumi.set(__self__, "cache_cluster_enabled", cache_cluster_enabled)
        if cache_cluster_size is not None:
            pulumi.set(__self__, "cache_cluster_size", cache_cluster_size)
        if canary_settings is not None:
            pulumi.set(__self__, "canary_settings", canary_settings)
        if client_certificate_id is not None:
            pulumi.set(__self__, "client_certificate_id", client_certificate_id)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation_version is not None:
            pulumi.set(__self__, "documentation_version", documentation_version)
        if execution_arn is not None:
            pulumi.set(__self__, "execution_arn", execution_arn)
        if invoke_url is not None:
            pulumi.set(__self__, "invoke_url", invoke_url)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest_api is not None:
            pulumi.set(__self__, "rest_api", rest_api)
        if stage_name is not None:
            pulumi.set(__self__, "stage_name", stage_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)
        if web_acl_arn is not None:
            pulumi.set(__self__, "web_acl_arn", web_acl_arn)
        if xray_tracing_enabled is not None:
            pulumi.set(__self__, "xray_tracing_enabled", xray_tracing_enabled)

    @property
    @pulumi.getter(name="accessLogSettings")
    def access_log_settings(self) -> Optional[pulumi.Input['StageAccessLogSettingsArgs']]:
        """
        Enables access logs for the API stage. See Access Log Settings below.
        """
        return pulumi.get(self, "access_log_settings")

    @access_log_settings.setter
    def access_log_settings(self, value: Optional[pulumi.Input['StageAccessLogSettingsArgs']]):
        pulumi.set(self, "access_log_settings", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="cacheClusterEnabled")
    def cache_cluster_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether a cache cluster is enabled for the stage
        """
        return pulumi.get(self, "cache_cluster_enabled")

    @cache_cluster_enabled.setter
    def cache_cluster_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cache_cluster_enabled", value)

    @property
    @pulumi.getter(name="cacheClusterSize")
    def cache_cluster_size(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
        """
        return pulumi.get(self, "cache_cluster_size")

    @cache_cluster_size.setter
    def cache_cluster_size(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cache_cluster_size", value)

    @property
    @pulumi.getter(name="canarySettings")
    def canary_settings(self) -> Optional[pulumi.Input['StageCanarySettingsArgs']]:
        """
        Configuration settings of a canary deployment. See Canary Settings below.
        """
        return pulumi.get(self, "canary_settings")

    @canary_settings.setter
    def canary_settings(self, value: Optional[pulumi.Input['StageCanarySettingsArgs']]):
        pulumi.set(self, "canary_settings", value)

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier of a client certificate for the stage.
        """
        return pulumi.get(self, "client_certificate_id")

    @client_certificate_id.setter
    def client_certificate_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate_id", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the deployment that the stage points to
        """
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the stage.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="documentationVersion")
    def documentation_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version of the associated API documentation.
        """
        return pulumi.get(self, "documentation_version")

    @documentation_version.setter
    def documentation_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "documentation_version", value)

    @property
    @pulumi.getter(name="executionArn")
    def execution_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Execution ARN to be used in `lambda_permission`'s `source_arn`
        when allowing API Gateway to invoke a Lambda function,
        e.g., `arn:aws:execute-api:eu-west-2:123456789012:z4675bid1j/prod`
        """
        return pulumi.get(self, "execution_arn")

    @execution_arn.setter
    def execution_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_arn", value)

    @property
    @pulumi.getter(name="invokeUrl")
    def invoke_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL to invoke the API pointing to the stage,
        e.g., `https://z4675bid1j.execute-api.eu-west-2.amazonaws.com/prod`
        """
        return pulumi.get(self, "invoke_url")

    @invoke_url.setter
    def invoke_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "invoke_url", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restApi")
    def rest_api(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the associated REST API
        """
        return pulumi.get(self, "rest_api")

    @rest_api.setter
    def rest_api(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rest_api", value)

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the stage
        """
        return pulumi.get(self, "stage_name")

    @stage_name.setter
    def stage_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stage_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map that defines the stage variables.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "variables", value)

    @property
    @pulumi.getter(name="webAclArn")
    def web_acl_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the WebAcl associated with the Stage.
        """
        return pulumi.get(self, "web_acl_arn")

    @web_acl_arn.setter
    def web_acl_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_acl_arn", value)

    @property
    @pulumi.getter(name="xrayTracingEnabled")
    def xray_tracing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether active tracing with X-ray is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "xray_tracing_enabled")

    @xray_tracing_enabled.setter
    def xray_tracing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "xray_tracing_enabled", value)


@pulumi.type_token("aws:apigateway/stage:Stage")
class Stage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_settings: Optional[pulumi.Input[Union['StageAccessLogSettingsArgs', 'StageAccessLogSettingsArgsDict']]] = None,
                 cache_cluster_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_cluster_size: Optional[pulumi.Input[builtins.str]] = None,
                 canary_settings: Optional[pulumi.Input[Union['StageCanarySettingsArgs', 'StageCanarySettingsArgsDict']]] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 deployment: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 documentation_version: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rest_api: Optional[pulumi.Input[builtins.str]] = None,
                 stage_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 xray_tracing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Manages an API Gateway Stage. A stage is a named reference to a deployment, which can be done via the `apigateway.Deployment` resource. Stages can be optionally managed further with the `apigateway.BasePathMapping` resource, `apigateway.DomainName` resource, and `aws_api_method_settings` resource. For more information, see the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-stages.html).

        ### Managing the API Logging CloudWatch Log Group

        API Gateway provides the ability to [enable CloudWatch API logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html). To manage the CloudWatch Log Group when this feature is enabled, the `cloudwatch.LogGroup` resource can be used where the name matches the API Gateway naming convention. If the CloudWatch Log Group previously exists, import the `cloudwatch.LogGroup` resource into Pulumi as a one time operation. You can recreate the environment without import.

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        stage_name = config.get("stageName")
        if stage_name is None:
            stage_name = "example"
        example = aws.apigateway.RestApi("example")
        example_log_group = aws.cloudwatch.LogGroup("example",
            name=example.id.apply(lambda id: f"API-Gateway-Execution-Logs_{id}/{stage_name}"),
            retention_in_days=7)
        example_stage = aws.apigateway.Stage("example", stage_name=stage_name,
        opts = pulumi.ResourceOptions(depends_on=[example_log_group]))
        ```

        ## Import

        Using `pulumi import`, import `aws_api_gateway_stage` using `REST-API-ID/STAGE-NAME`. For example:

        ```sh
        $ pulumi import aws:apigateway/stage:Stage example 12345abcde/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StageAccessLogSettingsArgs', 'StageAccessLogSettingsArgsDict']] access_log_settings: Enables access logs for the API stage. See Access Log Settings below.
        :param pulumi.Input[builtins.bool] cache_cluster_enabled: Whether a cache cluster is enabled for the stage
        :param pulumi.Input[builtins.str] cache_cluster_size: Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
        :param pulumi.Input[Union['StageCanarySettingsArgs', 'StageCanarySettingsArgsDict']] canary_settings: Configuration settings of a canary deployment. See Canary Settings below.
        :param pulumi.Input[builtins.str] client_certificate_id: Identifier of a client certificate for the stage.
        :param pulumi.Input[builtins.str] deployment: ID of the deployment that the stage points to
        :param pulumi.Input[builtins.str] description: Description of the stage.
        :param pulumi.Input[builtins.str] documentation_version: Version of the associated API documentation.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] rest_api: ID of the associated REST API
        :param pulumi.Input[builtins.str] stage_name: Name of the stage
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] variables: Map that defines the stage variables.
        :param pulumi.Input[builtins.bool] xray_tracing_enabled: Whether active tracing with X-ray is enabled. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Gateway Stage. A stage is a named reference to a deployment, which can be done via the `apigateway.Deployment` resource. Stages can be optionally managed further with the `apigateway.BasePathMapping` resource, `apigateway.DomainName` resource, and `aws_api_method_settings` resource. For more information, see the [API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-stages.html).

        ### Managing the API Logging CloudWatch Log Group

        API Gateway provides the ability to [enable CloudWatch API logging](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html). To manage the CloudWatch Log Group when this feature is enabled, the `cloudwatch.LogGroup` resource can be used where the name matches the API Gateway naming convention. If the CloudWatch Log Group previously exists, import the `cloudwatch.LogGroup` resource into Pulumi as a one time operation. You can recreate the environment without import.

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        stage_name = config.get("stageName")
        if stage_name is None:
            stage_name = "example"
        example = aws.apigateway.RestApi("example")
        example_log_group = aws.cloudwatch.LogGroup("example",
            name=example.id.apply(lambda id: f"API-Gateway-Execution-Logs_{id}/{stage_name}"),
            retention_in_days=7)
        example_stage = aws.apigateway.Stage("example", stage_name=stage_name,
        opts = pulumi.ResourceOptions(depends_on=[example_log_group]))
        ```

        ## Import

        Using `pulumi import`, import `aws_api_gateway_stage` using `REST-API-ID/STAGE-NAME`. For example:

        ```sh
        $ pulumi import aws:apigateway/stage:Stage example 12345abcde/example
        ```

        :param str resource_name: The name of the resource.
        :param StageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_log_settings: Optional[pulumi.Input[Union['StageAccessLogSettingsArgs', 'StageAccessLogSettingsArgsDict']]] = None,
                 cache_cluster_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 cache_cluster_size: Optional[pulumi.Input[builtins.str]] = None,
                 canary_settings: Optional[pulumi.Input[Union['StageCanarySettingsArgs', 'StageCanarySettingsArgsDict']]] = None,
                 client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
                 deployment: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 documentation_version: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 rest_api: Optional[pulumi.Input[builtins.str]] = None,
                 stage_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 xray_tracing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StageArgs.__new__(StageArgs)

            __props__.__dict__["access_log_settings"] = access_log_settings
            __props__.__dict__["cache_cluster_enabled"] = cache_cluster_enabled
            __props__.__dict__["cache_cluster_size"] = cache_cluster_size
            __props__.__dict__["canary_settings"] = canary_settings
            __props__.__dict__["client_certificate_id"] = client_certificate_id
            if deployment is None and not opts.urn:
                raise TypeError("Missing required property 'deployment'")
            __props__.__dict__["deployment"] = deployment
            __props__.__dict__["description"] = description
            __props__.__dict__["documentation_version"] = documentation_version
            __props__.__dict__["region"] = region
            if rest_api is None and not opts.urn:
                raise TypeError("Missing required property 'rest_api'")
            __props__.__dict__["rest_api"] = rest_api
            if stage_name is None and not opts.urn:
                raise TypeError("Missing required property 'stage_name'")
            __props__.__dict__["stage_name"] = stage_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["variables"] = variables
            __props__.__dict__["xray_tracing_enabled"] = xray_tracing_enabled
            __props__.__dict__["arn"] = None
            __props__.__dict__["execution_arn"] = None
            __props__.__dict__["invoke_url"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["web_acl_arn"] = None
        super(Stage, __self__).__init__(
            'aws:apigateway/stage:Stage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_log_settings: Optional[pulumi.Input[Union['StageAccessLogSettingsArgs', 'StageAccessLogSettingsArgsDict']]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            cache_cluster_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            cache_cluster_size: Optional[pulumi.Input[builtins.str]] = None,
            canary_settings: Optional[pulumi.Input[Union['StageCanarySettingsArgs', 'StageCanarySettingsArgsDict']]] = None,
            client_certificate_id: Optional[pulumi.Input[builtins.str]] = None,
            deployment: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            documentation_version: Optional[pulumi.Input[builtins.str]] = None,
            execution_arn: Optional[pulumi.Input[builtins.str]] = None,
            invoke_url: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            rest_api: Optional[pulumi.Input[builtins.str]] = None,
            stage_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            web_acl_arn: Optional[pulumi.Input[builtins.str]] = None,
            xray_tracing_enabled: Optional[pulumi.Input[builtins.bool]] = None) -> 'Stage':
        """
        Get an existing Stage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StageAccessLogSettingsArgs', 'StageAccessLogSettingsArgsDict']] access_log_settings: Enables access logs for the API stage. See Access Log Settings below.
        :param pulumi.Input[builtins.str] arn: ARN
        :param pulumi.Input[builtins.bool] cache_cluster_enabled: Whether a cache cluster is enabled for the stage
        :param pulumi.Input[builtins.str] cache_cluster_size: Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
        :param pulumi.Input[Union['StageCanarySettingsArgs', 'StageCanarySettingsArgsDict']] canary_settings: Configuration settings of a canary deployment. See Canary Settings below.
        :param pulumi.Input[builtins.str] client_certificate_id: Identifier of a client certificate for the stage.
        :param pulumi.Input[builtins.str] deployment: ID of the deployment that the stage points to
        :param pulumi.Input[builtins.str] description: Description of the stage.
        :param pulumi.Input[builtins.str] documentation_version: Version of the associated API documentation.
        :param pulumi.Input[builtins.str] execution_arn: Execution ARN to be used in `lambda_permission`'s `source_arn`
               when allowing API Gateway to invoke a Lambda function,
               e.g., `arn:aws:execute-api:eu-west-2:123456789012:z4675bid1j/prod`
        :param pulumi.Input[builtins.str] invoke_url: URL to invoke the API pointing to the stage,
               e.g., `https://z4675bid1j.execute-api.eu-west-2.amazonaws.com/prod`
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] rest_api: ID of the associated REST API
        :param pulumi.Input[builtins.str] stage_name: Name of the stage
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] variables: Map that defines the stage variables.
        :param pulumi.Input[builtins.str] web_acl_arn: ARN of the WebAcl associated with the Stage.
        :param pulumi.Input[builtins.bool] xray_tracing_enabled: Whether active tracing with X-ray is enabled. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StageState.__new__(_StageState)

        __props__.__dict__["access_log_settings"] = access_log_settings
        __props__.__dict__["arn"] = arn
        __props__.__dict__["cache_cluster_enabled"] = cache_cluster_enabled
        __props__.__dict__["cache_cluster_size"] = cache_cluster_size
        __props__.__dict__["canary_settings"] = canary_settings
        __props__.__dict__["client_certificate_id"] = client_certificate_id
        __props__.__dict__["deployment"] = deployment
        __props__.__dict__["description"] = description
        __props__.__dict__["documentation_version"] = documentation_version
        __props__.__dict__["execution_arn"] = execution_arn
        __props__.__dict__["invoke_url"] = invoke_url
        __props__.__dict__["region"] = region
        __props__.__dict__["rest_api"] = rest_api
        __props__.__dict__["stage_name"] = stage_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["variables"] = variables
        __props__.__dict__["web_acl_arn"] = web_acl_arn
        __props__.__dict__["xray_tracing_enabled"] = xray_tracing_enabled
        return Stage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLogSettings")
    def access_log_settings(self) -> pulumi.Output[Optional['outputs.StageAccessLogSettings']]:
        """
        Enables access logs for the API stage. See Access Log Settings below.
        """
        return pulumi.get(self, "access_log_settings")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cacheClusterEnabled")
    def cache_cluster_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether a cache cluster is enabled for the stage
        """
        return pulumi.get(self, "cache_cluster_enabled")

    @property
    @pulumi.getter(name="cacheClusterSize")
    def cache_cluster_size(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Size of the cache cluster for the stage, if enabled. Allowed values include `0.5`, `1.6`, `6.1`, `13.5`, `28.4`, `58.2`, `118` and `237`.
        """
        return pulumi.get(self, "cache_cluster_size")

    @property
    @pulumi.getter(name="canarySettings")
    def canary_settings(self) -> pulumi.Output[Optional['outputs.StageCanarySettings']]:
        """
        Configuration settings of a canary deployment. See Canary Settings below.
        """
        return pulumi.get(self, "canary_settings")

    @property
    @pulumi.getter(name="clientCertificateId")
    def client_certificate_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Identifier of a client certificate for the stage.
        """
        return pulumi.get(self, "client_certificate_id")

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Output[builtins.str]:
        """
        ID of the deployment that the stage points to
        """
        return pulumi.get(self, "deployment")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the stage.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="documentationVersion")
    def documentation_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Version of the associated API documentation.
        """
        return pulumi.get(self, "documentation_version")

    @property
    @pulumi.getter(name="executionArn")
    def execution_arn(self) -> pulumi.Output[builtins.str]:
        """
        Execution ARN to be used in `lambda_permission`'s `source_arn`
        when allowing API Gateway to invoke a Lambda function,
        e.g., `arn:aws:execute-api:eu-west-2:123456789012:z4675bid1j/prod`
        """
        return pulumi.get(self, "execution_arn")

    @property
    @pulumi.getter(name="invokeUrl")
    def invoke_url(self) -> pulumi.Output[builtins.str]:
        """
        URL to invoke the API pointing to the stage,
        e.g., `https://z4675bid1j.execute-api.eu-west-2.amazonaws.com/prod`
        """
        return pulumi.get(self, "invoke_url")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="restApi")
    def rest_api(self) -> pulumi.Output[builtins.str]:
        """
        ID of the associated REST API
        """
        return pulumi.get(self, "rest_api")

    @property
    @pulumi.getter(name="stageName")
    def stage_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the stage
        """
        return pulumi.get(self, "stage_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map that defines the stage variables.
        """
        return pulumi.get(self, "variables")

    @property
    @pulumi.getter(name="webAclArn")
    def web_acl_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the WebAcl associated with the Stage.
        """
        return pulumi.get(self, "web_acl_arn")

    @property
    @pulumi.getter(name="xrayTracingEnabled")
    def xray_tracing_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether active tracing with X-ray is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "xray_tracing_enabled")

