# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiArgs', 'Api']

@pulumi.input_type
class ApiArgs:
    def __init__(__self__, *,
                 protocol_type: pulumi.Input[builtins.str],
                 api_key_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 cors_configuration: Optional[pulumi.Input['ApiCorsConfigurationArgs']] = None,
                 credentials_arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_execute_api_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
                 fail_on_warnings: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_key: Optional[pulumi.Input[builtins.str]] = None,
                 route_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Api resource.
        :param pulumi.Input[builtins.str] protocol_type: API protocol. Valid values: `HTTP`, `WEBSOCKET`.
        :param pulumi.Input[builtins.str] api_key_selection_expression: An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
               Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
               Applicable for WebSocket APIs.
        :param pulumi.Input[builtins.str] body: An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
        :param pulumi.Input['ApiCorsConfigurationArgs'] cors_configuration: Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] credentials_arn: Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] description: Description of the API. Must be less than or equal to 1024 characters in length.
        :param pulumi.Input[builtins.bool] disable_execute_api_endpoint: Whether clients can invoke the API by using the default `execute-api` endpoint.
               By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
               To require that clients use a custom domain name to invoke the API, disable the default endpoint.
        :param pulumi.Input[builtins.bool] fail_on_warnings: Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] ip_address_type: The IP address types that can invoke the API. Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke your API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your API. Defaults to `ipv4`.
        :param pulumi.Input[builtins.str] name: Name of the API. Must be less than or equal to 128 characters in length.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_key: Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] route_selection_expression: The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
               Defaults to `$request.method $request.path`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] target: Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
               For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
               The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] version: Version identifier for the API. Must be between 1 and 64 characters in length.
        """
        pulumi.set(__self__, "protocol_type", protocol_type)
        if api_key_selection_expression is not None:
            pulumi.set(__self__, "api_key_selection_expression", api_key_selection_expression)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if cors_configuration is not None:
            pulumi.set(__self__, "cors_configuration", cors_configuration)
        if credentials_arn is not None:
            pulumi.set(__self__, "credentials_arn", credentials_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_execute_api_endpoint is not None:
            pulumi.set(__self__, "disable_execute_api_endpoint", disable_execute_api_endpoint)
        if fail_on_warnings is not None:
            pulumi.set(__self__, "fail_on_warnings", fail_on_warnings)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_key is not None:
            pulumi.set(__self__, "route_key", route_key)
        if route_selection_expression is not None:
            pulumi.set(__self__, "route_selection_expression", route_selection_expression)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Input[builtins.str]:
        """
        API protocol. Valid values: `HTTP`, `WEBSOCKET`.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol_type", value)

    @property
    @pulumi.getter(name="apiKeySelectionExpression")
    def api_key_selection_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
        Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
        Applicable for WebSocket APIs.
        """
        return pulumi.get(self, "api_key_selection_expression")

    @api_key_selection_expression.setter
    def api_key_selection_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_key_selection_expression", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="corsConfiguration")
    def cors_configuration(self) -> Optional[pulumi.Input['ApiCorsConfigurationArgs']]:
        """
        Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
        """
        return pulumi.get(self, "cors_configuration")

    @cors_configuration.setter
    def cors_configuration(self, value: Optional[pulumi.Input['ApiCorsConfigurationArgs']]):
        pulumi.set(self, "cors_configuration", value)

    @property
    @pulumi.getter(name="credentialsArn")
    def credentials_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "credentials_arn")

    @credentials_arn.setter
    def credentials_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credentials_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the API. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableExecuteApiEndpoint")
    def disable_execute_api_endpoint(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether clients can invoke the API by using the default `execute-api` endpoint.
        By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
        To require that clients use a custom domain name to invoke the API, disable the default endpoint.
        """
        return pulumi.get(self, "disable_execute_api_endpoint")

    @disable_execute_api_endpoint.setter
    def disable_execute_api_endpoint(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_execute_api_endpoint", value)

    @property
    @pulumi.getter(name="failOnWarnings")
    def fail_on_warnings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "fail_on_warnings")

    @fail_on_warnings.setter
    def fail_on_warnings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fail_on_warnings", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address types that can invoke the API. Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke your API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your API. Defaults to `ipv4`.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the API. Must be less than or equal to 128 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routeKey")
    def route_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
        """
        return pulumi.get(self, "route_key")

    @route_key.setter
    def route_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_key", value)

    @property
    @pulumi.getter(name="routeSelectionExpression")
    def route_selection_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
        Defaults to `$request.method $request.path`.
        """
        return pulumi.get(self, "route_selection_expression")

    @route_selection_expression.setter
    def route_selection_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_selection_expression", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
        For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
        The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version identifier for the API. Must be between 1 and 64 characters in length.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ApiState:
    def __init__(__self__, *,
                 api_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 api_key_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 cors_configuration: Optional[pulumi.Input['ApiCorsConfigurationArgs']] = None,
                 credentials_arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_execute_api_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
                 execution_arn: Optional[pulumi.Input[builtins.str]] = None,
                 fail_on_warnings: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_key: Optional[pulumi.Input[builtins.str]] = None,
                 route_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Api resources.
        :param pulumi.Input[builtins.str] api_endpoint: URI of the API, of the form `https://{api-id}.execute-api.{region}.amazonaws.com` for HTTP APIs and `wss://{api-id}.execute-api.{region}.amazonaws.com` for WebSocket APIs.
        :param pulumi.Input[builtins.str] api_key_selection_expression: An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
               Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
               Applicable for WebSocket APIs.
        :param pulumi.Input[builtins.str] arn: ARN of the API.
        :param pulumi.Input[builtins.str] body: An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
        :param pulumi.Input['ApiCorsConfigurationArgs'] cors_configuration: Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] credentials_arn: Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] description: Description of the API. Must be less than or equal to 1024 characters in length.
        :param pulumi.Input[builtins.bool] disable_execute_api_endpoint: Whether clients can invoke the API by using the default `execute-api` endpoint.
               By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
               To require that clients use a custom domain name to invoke the API, disable the default endpoint.
        :param pulumi.Input[builtins.str] execution_arn: ARN prefix to be used in an `lambda.Permission`'s `source_arn` attribute
               or in an `iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
               See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
        :param pulumi.Input[builtins.bool] fail_on_warnings: Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] ip_address_type: The IP address types that can invoke the API. Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke your API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your API. Defaults to `ipv4`.
        :param pulumi.Input[builtins.str] name: Name of the API. Must be less than or equal to 128 characters in length.
        :param pulumi.Input[builtins.str] protocol_type: API protocol. Valid values: `HTTP`, `WEBSOCKET`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_key: Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] route_selection_expression: The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
               Defaults to `$request.method $request.path`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] target: Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
               For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
               The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] version: Version identifier for the API. Must be between 1 and 64 characters in length.
        """
        if api_endpoint is not None:
            pulumi.set(__self__, "api_endpoint", api_endpoint)
        if api_key_selection_expression is not None:
            pulumi.set(__self__, "api_key_selection_expression", api_key_selection_expression)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if cors_configuration is not None:
            pulumi.set(__self__, "cors_configuration", cors_configuration)
        if credentials_arn is not None:
            pulumi.set(__self__, "credentials_arn", credentials_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_execute_api_endpoint is not None:
            pulumi.set(__self__, "disable_execute_api_endpoint", disable_execute_api_endpoint)
        if execution_arn is not None:
            pulumi.set(__self__, "execution_arn", execution_arn)
        if fail_on_warnings is not None:
            pulumi.set(__self__, "fail_on_warnings", fail_on_warnings)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol_type is not None:
            pulumi.set(__self__, "protocol_type", protocol_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_key is not None:
            pulumi.set(__self__, "route_key", route_key)
        if route_selection_expression is not None:
            pulumi.set(__self__, "route_selection_expression", route_selection_expression)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URI of the API, of the form `https://{api-id}.execute-api.{region}.amazonaws.com` for HTTP APIs and `wss://{api-id}.execute-api.{region}.amazonaws.com` for WebSocket APIs.
        """
        return pulumi.get(self, "api_endpoint")

    @api_endpoint.setter
    def api_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_endpoint", value)

    @property
    @pulumi.getter(name="apiKeySelectionExpression")
    def api_key_selection_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
        Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
        Applicable for WebSocket APIs.
        """
        return pulumi.get(self, "api_key_selection_expression")

    @api_key_selection_expression.setter
    def api_key_selection_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_key_selection_expression", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the API.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter(name="corsConfiguration")
    def cors_configuration(self) -> Optional[pulumi.Input['ApiCorsConfigurationArgs']]:
        """
        Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
        """
        return pulumi.get(self, "cors_configuration")

    @cors_configuration.setter
    def cors_configuration(self, value: Optional[pulumi.Input['ApiCorsConfigurationArgs']]):
        pulumi.set(self, "cors_configuration", value)

    @property
    @pulumi.getter(name="credentialsArn")
    def credentials_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "credentials_arn")

    @credentials_arn.setter
    def credentials_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credentials_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the API. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableExecuteApiEndpoint")
    def disable_execute_api_endpoint(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether clients can invoke the API by using the default `execute-api` endpoint.
        By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
        To require that clients use a custom domain name to invoke the API, disable the default endpoint.
        """
        return pulumi.get(self, "disable_execute_api_endpoint")

    @disable_execute_api_endpoint.setter
    def disable_execute_api_endpoint(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_execute_api_endpoint", value)

    @property
    @pulumi.getter(name="executionArn")
    def execution_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN prefix to be used in an `lambda.Permission`'s `source_arn` attribute
        or in an `iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
        See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
        """
        return pulumi.get(self, "execution_arn")

    @execution_arn.setter
    def execution_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_arn", value)

    @property
    @pulumi.getter(name="failOnWarnings")
    def fail_on_warnings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "fail_on_warnings")

    @fail_on_warnings.setter
    def fail_on_warnings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fail_on_warnings", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address types that can invoke the API. Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke your API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your API. Defaults to `ipv4`.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the API. Must be less than or equal to 128 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API protocol. Valid values: `HTTP`, `WEBSOCKET`.
        """
        return pulumi.get(self, "protocol_type")

    @protocol_type.setter
    def protocol_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routeKey")
    def route_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
        """
        return pulumi.get(self, "route_key")

    @route_key.setter
    def route_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_key", value)

    @property
    @pulumi.getter(name="routeSelectionExpression")
    def route_selection_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
        Defaults to `$request.method $request.path`.
        """
        return pulumi.get(self, "route_selection_expression")

    @route_selection_expression.setter
    def route_selection_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_selection_expression", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
        For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
        The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version identifier for the API. Must be between 1 and 64 characters in length.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aws:apigatewayv2/api:Api")
class Api(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 cors_configuration: Optional[pulumi.Input[Union['ApiCorsConfigurationArgs', 'ApiCorsConfigurationArgsDict']]] = None,
                 credentials_arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_execute_api_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
                 fail_on_warnings: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_key: Optional[pulumi.Input[builtins.str]] = None,
                 route_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Amazon API Gateway Version 2 API.

        > **Note:** Amazon API Gateway Version 2 resources are used for creating and deploying WebSocket and HTTP APIs. To create and deploy REST APIs, use Amazon API Gateway Version 1 resources.

        ## Example Usage

        ### Basic WebSocket API

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Api("example",
            name="example-websocket-api",
            protocol_type="WEBSOCKET",
            route_selection_expression="$request.body.action")
        ```

        ### Basic HTTP API

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Api("example",
            name="example-http-api",
            protocol_type="HTTP")
        ```

        ## Import

        Using `pulumi import`, import `aws_apigatewayv2_api` using the API identifier. For example:

        ```sh
        $ pulumi import aws:apigatewayv2/api:Api example aabbccddee
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_key_selection_expression: An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
               Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
               Applicable for WebSocket APIs.
        :param pulumi.Input[builtins.str] body: An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
        :param pulumi.Input[Union['ApiCorsConfigurationArgs', 'ApiCorsConfigurationArgsDict']] cors_configuration: Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] credentials_arn: Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] description: Description of the API. Must be less than or equal to 1024 characters in length.
        :param pulumi.Input[builtins.bool] disable_execute_api_endpoint: Whether clients can invoke the API by using the default `execute-api` endpoint.
               By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
               To require that clients use a custom domain name to invoke the API, disable the default endpoint.
        :param pulumi.Input[builtins.bool] fail_on_warnings: Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] ip_address_type: The IP address types that can invoke the API. Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke your API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your API. Defaults to `ipv4`.
        :param pulumi.Input[builtins.str] name: Name of the API. Must be less than or equal to 128 characters in length.
        :param pulumi.Input[builtins.str] protocol_type: API protocol. Valid values: `HTTP`, `WEBSOCKET`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_key: Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] route_selection_expression: The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
               Defaults to `$request.method $request.path`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] target: Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
               For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
               The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] version: Version identifier for the API. Must be between 1 and 64 characters in length.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon API Gateway Version 2 API.

        > **Note:** Amazon API Gateway Version 2 resources are used for creating and deploying WebSocket and HTTP APIs. To create and deploy REST APIs, use Amazon API Gateway Version 1 resources.

        ## Example Usage

        ### Basic WebSocket API

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Api("example",
            name="example-websocket-api",
            protocol_type="WEBSOCKET",
            route_selection_expression="$request.body.action")
        ```

        ### Basic HTTP API

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Api("example",
            name="example-http-api",
            protocol_type="HTTP")
        ```

        ## Import

        Using `pulumi import`, import `aws_apigatewayv2_api` using the API identifier. For example:

        ```sh
        $ pulumi import aws:apigatewayv2/api:Api example aabbccddee
        ```

        :param str resource_name: The name of the resource.
        :param ApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 body: Optional[pulumi.Input[builtins.str]] = None,
                 cors_configuration: Optional[pulumi.Input[Union['ApiCorsConfigurationArgs', 'ApiCorsConfigurationArgsDict']]] = None,
                 credentials_arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disable_execute_api_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
                 fail_on_warnings: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protocol_type: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 route_key: Optional[pulumi.Input[builtins.str]] = None,
                 route_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiArgs.__new__(ApiArgs)

            __props__.__dict__["api_key_selection_expression"] = api_key_selection_expression
            __props__.__dict__["body"] = body
            __props__.__dict__["cors_configuration"] = cors_configuration
            __props__.__dict__["credentials_arn"] = credentials_arn
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_execute_api_endpoint"] = disable_execute_api_endpoint
            __props__.__dict__["fail_on_warnings"] = fail_on_warnings
            __props__.__dict__["ip_address_type"] = ip_address_type
            __props__.__dict__["name"] = name
            if protocol_type is None and not opts.urn:
                raise TypeError("Missing required property 'protocol_type'")
            __props__.__dict__["protocol_type"] = protocol_type
            __props__.__dict__["region"] = region
            __props__.__dict__["route_key"] = route_key
            __props__.__dict__["route_selection_expression"] = route_selection_expression
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target"] = target
            __props__.__dict__["version"] = version
            __props__.__dict__["api_endpoint"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["execution_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Api, __self__).__init__(
            'aws:apigatewayv2/api:Api',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            api_key_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            body: Optional[pulumi.Input[builtins.str]] = None,
            cors_configuration: Optional[pulumi.Input[Union['ApiCorsConfigurationArgs', 'ApiCorsConfigurationArgsDict']]] = None,
            credentials_arn: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disable_execute_api_endpoint: Optional[pulumi.Input[builtins.bool]] = None,
            execution_arn: Optional[pulumi.Input[builtins.str]] = None,
            fail_on_warnings: Optional[pulumi.Input[builtins.bool]] = None,
            ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            protocol_type: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            route_key: Optional[pulumi.Input[builtins.str]] = None,
            route_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'Api':
        """
        Get an existing Api resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_endpoint: URI of the API, of the form `https://{api-id}.execute-api.{region}.amazonaws.com` for HTTP APIs and `wss://{api-id}.execute-api.{region}.amazonaws.com` for WebSocket APIs.
        :param pulumi.Input[builtins.str] api_key_selection_expression: An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
               Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
               Applicable for WebSocket APIs.
        :param pulumi.Input[builtins.str] arn: ARN of the API.
        :param pulumi.Input[builtins.str] body: An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
        :param pulumi.Input[Union['ApiCorsConfigurationArgs', 'ApiCorsConfigurationArgsDict']] cors_configuration: Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] credentials_arn: Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] description: Description of the API. Must be less than or equal to 1024 characters in length.
        :param pulumi.Input[builtins.bool] disable_execute_api_endpoint: Whether clients can invoke the API by using the default `execute-api` endpoint.
               By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
               To require that clients use a custom domain name to invoke the API, disable the default endpoint.
        :param pulumi.Input[builtins.str] execution_arn: ARN prefix to be used in an `lambda.Permission`'s `source_arn` attribute
               or in an `iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
               See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
        :param pulumi.Input[builtins.bool] fail_on_warnings: Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] ip_address_type: The IP address types that can invoke the API. Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke your API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your API. Defaults to `ipv4`.
        :param pulumi.Input[builtins.str] name: Name of the API. Must be less than or equal to 128 characters in length.
        :param pulumi.Input[builtins.str] protocol_type: API protocol. Valid values: `HTTP`, `WEBSOCKET`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] route_key: Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] route_selection_expression: The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
               Defaults to `$request.method $request.path`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] target: Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
               For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
               The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
        :param pulumi.Input[builtins.str] version: Version identifier for the API. Must be between 1 and 64 characters in length.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiState.__new__(_ApiState)

        __props__.__dict__["api_endpoint"] = api_endpoint
        __props__.__dict__["api_key_selection_expression"] = api_key_selection_expression
        __props__.__dict__["arn"] = arn
        __props__.__dict__["body"] = body
        __props__.__dict__["cors_configuration"] = cors_configuration
        __props__.__dict__["credentials_arn"] = credentials_arn
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_execute_api_endpoint"] = disable_execute_api_endpoint
        __props__.__dict__["execution_arn"] = execution_arn
        __props__.__dict__["fail_on_warnings"] = fail_on_warnings
        __props__.__dict__["ip_address_type"] = ip_address_type
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol_type"] = protocol_type
        __props__.__dict__["region"] = region
        __props__.__dict__["route_key"] = route_key
        __props__.__dict__["route_selection_expression"] = route_selection_expression
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target"] = target
        __props__.__dict__["version"] = version
        return Api(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        URI of the API, of the form `https://{api-id}.execute-api.{region}.amazonaws.com` for HTTP APIs and `wss://{api-id}.execute-api.{region}.amazonaws.com` for WebSocket APIs.
        """
        return pulumi.get(self, "api_endpoint")

    @property
    @pulumi.getter(name="apiKeySelectionExpression")
    def api_key_selection_expression(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An [API key selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
        Valid values: `$context.authorizer.usageIdentifierKey`, `$request.header.x-api-key`. Defaults to `$request.header.x-api-key`.
        Applicable for WebSocket APIs.
        """
        return pulumi.get(self, "api_key_selection_expression")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the API.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An OpenAPI specification that defines the set of routes and integrations to create as part of the HTTP APIs. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="corsConfiguration")
    def cors_configuration(self) -> pulumi.Output[Optional['outputs.ApiCorsConfiguration']]:
        """
        Cross-origin resource sharing (CORS) [configuration](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html). Applicable for HTTP APIs.
        """
        return pulumi.get(self, "cors_configuration")

    @property
    @pulumi.getter(name="credentialsArn")
    def credentials_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Part of _quick create_. Specifies any credentials required for the integration. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "credentials_arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the API. Must be less than or equal to 1024 characters in length.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableExecuteApiEndpoint")
    def disable_execute_api_endpoint(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether clients can invoke the API by using the default `execute-api` endpoint.
        By default, clients can invoke the API with the default `{api_id}.execute-api.{region}.amazonaws.com endpoint`.
        To require that clients use a custom domain name to invoke the API, disable the default endpoint.
        """
        return pulumi.get(self, "disable_execute_api_endpoint")

    @property
    @pulumi.getter(name="executionArn")
    def execution_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN prefix to be used in an `lambda.Permission`'s `source_arn` attribute
        or in an `iam.Policy` to authorize access to the [`@connections` API](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html).
        See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-control-access-iam.html) for details.
        """
        return pulumi.get(self, "execution_arn")

    @property
    @pulumi.getter(name="failOnWarnings")
    def fail_on_warnings(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether warnings should return an error while API Gateway is creating or updating the resource using an OpenAPI specification. Defaults to `false`. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "fail_on_warnings")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Output[builtins.str]:
        """
        The IP address types that can invoke the API. Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke your API, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your API. Defaults to `ipv4`.
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the API. Must be less than or equal to 128 characters in length.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protocolType")
    def protocol_type(self) -> pulumi.Output[builtins.str]:
        """
        API protocol. Valid values: `HTTP`, `WEBSOCKET`.
        """
        return pulumi.get(self, "protocol_type")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routeKey")
    def route_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Part of _quick create_. Specifies any [route key](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-routes.html). Applicable for HTTP APIs.
        """
        return pulumi.get(self, "route_key")

    @property
    @pulumi.getter(name="routeSelectionExpression")
    def route_selection_expression(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The [route selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-route-selection-expressions) for the API.
        Defaults to `$request.method $request.path`.
        """
        return pulumi.get(self, "route_selection_expression")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of tags to assign to the API. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Part of _quick create_. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes.
        For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN.
        The type of the integration will be `HTTP_PROXY` or `AWS_PROXY`, respectively. Applicable for HTTP APIs.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Version identifier for the API. Must be between 1 and 64 characters in length.
        """
        return pulumi.get(self, "version")

