# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[builtins.str],
                 integration_type: pulumi.Input[builtins.str],
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[builtins.str]] = None,
                 content_handling_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 credentials_arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 integration_method: Optional[pulumi.Input[builtins.str]] = None,
                 integration_subtype: Optional[pulumi.Input[builtins.str]] = None,
                 integration_uri: Optional[pulumi.Input[builtins.str]] = None,
                 passthrough_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 payload_format_version: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 response_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]]] = None,
                 template_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_milliseconds: Optional[pulumi.Input[builtins.int]] = None,
                 tls_config: Optional[pulumi.Input['IntegrationTlsConfigArgs']] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input[builtins.str] api_id: API identifier.
        :param pulumi.Input[builtins.str] integration_type: Integration type of an integration.
               Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
        :param pulumi.Input[builtins.str] connection_id: ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
        :param pulumi.Input[builtins.str] connection_type: Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
        :param pulumi.Input[builtins.str] content_handling_strategy: How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
        :param pulumi.Input[builtins.str] credentials_arn: Credentials required for the integration, if any.
        :param pulumi.Input[builtins.str] description: Description of the integration.
        :param pulumi.Input[builtins.str] integration_method: Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
        :param pulumi.Input[builtins.str] integration_subtype: AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
        :param pulumi.Input[builtins.str] integration_uri: URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
               For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
        :param pulumi.Input[builtins.str] passthrough_behavior: Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
               Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
        :param pulumi.Input[builtins.str] payload_format_version: The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] request_parameters: For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
               For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
               For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
               See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] request_templates: Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]] response_parameters: Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
        :param pulumi.Input[builtins.str] template_selection_expression: The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
        :param pulumi.Input[builtins.int] timeout_milliseconds: Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
               The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
               this provider will only perform drift detection of its value when present in a configuration.
        :param pulumi.Input['IntegrationTlsConfigArgs'] tls_config: TLS configuration for a private integration. Supported only for HTTP APIs.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "integration_type", integration_type)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if content_handling_strategy is not None:
            pulumi.set(__self__, "content_handling_strategy", content_handling_strategy)
        if credentials_arn is not None:
            pulumi.set(__self__, "credentials_arn", credentials_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if integration_method is not None:
            pulumi.set(__self__, "integration_method", integration_method)
        if integration_subtype is not None:
            pulumi.set(__self__, "integration_subtype", integration_subtype)
        if integration_uri is not None:
            pulumi.set(__self__, "integration_uri", integration_uri)
        if passthrough_behavior is not None:
            pulumi.set(__self__, "passthrough_behavior", passthrough_behavior)
        if payload_format_version is not None:
            pulumi.set(__self__, "payload_format_version", payload_format_version)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if request_templates is not None:
            pulumi.set(__self__, "request_templates", request_templates)
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)
        if template_selection_expression is not None:
            pulumi.set(__self__, "template_selection_expression", template_selection_expression)
        if timeout_milliseconds is not None:
            pulumi.set(__self__, "timeout_milliseconds", timeout_milliseconds)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[builtins.str]:
        """
        API identifier.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Input[builtins.str]:
        """
        Integration type of an integration.
        Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
        """
        return pulumi.get(self, "integration_type")

    @integration_type.setter
    def integration_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "integration_type", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="contentHandlingStrategy")
    def content_handling_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "content_handling_strategy")

    @content_handling_strategy.setter
    def content_handling_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_handling_strategy", value)

    @property
    @pulumi.getter(name="credentialsArn")
    def credentials_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Credentials required for the integration, if any.
        """
        return pulumi.get(self, "credentials_arn")

    @credentials_arn.setter
    def credentials_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credentials_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the integration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="integrationMethod")
    def integration_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
        """
        return pulumi.get(self, "integration_method")

    @integration_method.setter
    def integration_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_method", value)

    @property
    @pulumi.getter(name="integrationSubtype")
    def integration_subtype(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
        """
        return pulumi.get(self, "integration_subtype")

    @integration_subtype.setter
    def integration_subtype(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_subtype", value)

    @property
    @pulumi.getter(name="integrationUri")
    def integration_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
        For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
        """
        return pulumi.get(self, "integration_uri")

    @integration_uri.setter
    def integration_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_uri", value)

    @property
    @pulumi.getter(name="passthroughBehavior")
    def passthrough_behavior(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
        Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "passthrough_behavior")

    @passthrough_behavior.setter
    def passthrough_behavior(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "passthrough_behavior", value)

    @property
    @pulumi.getter(name="payloadFormatVersion")
    def payload_format_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
        """
        return pulumi.get(self, "payload_format_version")

    @payload_format_version.setter
    def payload_format_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "payload_format_version", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
        For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
        For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
        See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
        """
        return pulumi.get(self, "request_parameters")

    @request_parameters.setter
    def request_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "request_parameters", value)

    @property
    @pulumi.getter(name="requestTemplates")
    def request_templates(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "request_templates")

    @request_templates.setter
    def request_templates(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "request_templates", value)

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]]]:
        """
        Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "response_parameters")

    @response_parameters.setter
    def response_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]]]):
        pulumi.set(self, "response_parameters", value)

    @property
    @pulumi.getter(name="templateSelectionExpression")
    def template_selection_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
        """
        return pulumi.get(self, "template_selection_expression")

    @template_selection_expression.setter
    def template_selection_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_selection_expression", value)

    @property
    @pulumi.getter(name="timeoutMilliseconds")
    def timeout_milliseconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
        The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
        this provider will only perform drift detection of its value when present in a configuration.
        """
        return pulumi.get(self, "timeout_milliseconds")

    @timeout_milliseconds.setter
    def timeout_milliseconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_milliseconds", value)

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['IntegrationTlsConfigArgs']]:
        """
        TLS configuration for a private integration. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['IntegrationTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[builtins.str]] = None,
                 content_handling_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 credentials_arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 integration_method: Optional[pulumi.Input[builtins.str]] = None,
                 integration_response_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 integration_subtype: Optional[pulumi.Input[builtins.str]] = None,
                 integration_type: Optional[pulumi.Input[builtins.str]] = None,
                 integration_uri: Optional[pulumi.Input[builtins.str]] = None,
                 passthrough_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 payload_format_version: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 response_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]]] = None,
                 template_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_milliseconds: Optional[pulumi.Input[builtins.int]] = None,
                 tls_config: Optional[pulumi.Input['IntegrationTlsConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input[builtins.str] api_id: API identifier.
        :param pulumi.Input[builtins.str] connection_id: ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
        :param pulumi.Input[builtins.str] connection_type: Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
        :param pulumi.Input[builtins.str] content_handling_strategy: How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
        :param pulumi.Input[builtins.str] credentials_arn: Credentials required for the integration, if any.
        :param pulumi.Input[builtins.str] description: Description of the integration.
        :param pulumi.Input[builtins.str] integration_method: Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
        :param pulumi.Input[builtins.str] integration_response_selection_expression: The [integration response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions) for the integration.
        :param pulumi.Input[builtins.str] integration_subtype: AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
        :param pulumi.Input[builtins.str] integration_type: Integration type of an integration.
               Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
        :param pulumi.Input[builtins.str] integration_uri: URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
               For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
        :param pulumi.Input[builtins.str] passthrough_behavior: Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
               Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
        :param pulumi.Input[builtins.str] payload_format_version: The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] request_parameters: For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
               For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
               For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
               See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] request_templates: Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]] response_parameters: Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
        :param pulumi.Input[builtins.str] template_selection_expression: The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
        :param pulumi.Input[builtins.int] timeout_milliseconds: Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
               The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
               this provider will only perform drift detection of its value when present in a configuration.
        :param pulumi.Input['IntegrationTlsConfigArgs'] tls_config: TLS configuration for a private integration. Supported only for HTTP APIs.
        """
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if content_handling_strategy is not None:
            pulumi.set(__self__, "content_handling_strategy", content_handling_strategy)
        if credentials_arn is not None:
            pulumi.set(__self__, "credentials_arn", credentials_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if integration_method is not None:
            pulumi.set(__self__, "integration_method", integration_method)
        if integration_response_selection_expression is not None:
            pulumi.set(__self__, "integration_response_selection_expression", integration_response_selection_expression)
        if integration_subtype is not None:
            pulumi.set(__self__, "integration_subtype", integration_subtype)
        if integration_type is not None:
            pulumi.set(__self__, "integration_type", integration_type)
        if integration_uri is not None:
            pulumi.set(__self__, "integration_uri", integration_uri)
        if passthrough_behavior is not None:
            pulumi.set(__self__, "passthrough_behavior", passthrough_behavior)
        if payload_format_version is not None:
            pulumi.set(__self__, "payload_format_version", payload_format_version)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if request_templates is not None:
            pulumi.set(__self__, "request_templates", request_templates)
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)
        if template_selection_expression is not None:
            pulumi.set(__self__, "template_selection_expression", template_selection_expression)
        if timeout_milliseconds is not None:
            pulumi.set(__self__, "timeout_milliseconds", timeout_milliseconds)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API identifier.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="contentHandlingStrategy")
    def content_handling_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "content_handling_strategy")

    @content_handling_strategy.setter
    def content_handling_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_handling_strategy", value)

    @property
    @pulumi.getter(name="credentialsArn")
    def credentials_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Credentials required for the integration, if any.
        """
        return pulumi.get(self, "credentials_arn")

    @credentials_arn.setter
    def credentials_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credentials_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the integration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="integrationMethod")
    def integration_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
        """
        return pulumi.get(self, "integration_method")

    @integration_method.setter
    def integration_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_method", value)

    @property
    @pulumi.getter(name="integrationResponseSelectionExpression")
    def integration_response_selection_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [integration response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions) for the integration.
        """
        return pulumi.get(self, "integration_response_selection_expression")

    @integration_response_selection_expression.setter
    def integration_response_selection_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_response_selection_expression", value)

    @property
    @pulumi.getter(name="integrationSubtype")
    def integration_subtype(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
        """
        return pulumi.get(self, "integration_subtype")

    @integration_subtype.setter
    def integration_subtype(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_subtype", value)

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Integration type of an integration.
        Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
        """
        return pulumi.get(self, "integration_type")

    @integration_type.setter
    def integration_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_type", value)

    @property
    @pulumi.getter(name="integrationUri")
    def integration_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
        For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
        """
        return pulumi.get(self, "integration_uri")

    @integration_uri.setter
    def integration_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_uri", value)

    @property
    @pulumi.getter(name="passthroughBehavior")
    def passthrough_behavior(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
        Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "passthrough_behavior")

    @passthrough_behavior.setter
    def passthrough_behavior(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "passthrough_behavior", value)

    @property
    @pulumi.getter(name="payloadFormatVersion")
    def payload_format_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
        """
        return pulumi.get(self, "payload_format_version")

    @payload_format_version.setter
    def payload_format_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "payload_format_version", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
        For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
        For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
        See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
        """
        return pulumi.get(self, "request_parameters")

    @request_parameters.setter
    def request_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "request_parameters", value)

    @property
    @pulumi.getter(name="requestTemplates")
    def request_templates(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "request_templates")

    @request_templates.setter
    def request_templates(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "request_templates", value)

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]]]:
        """
        Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "response_parameters")

    @response_parameters.setter
    def response_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationResponseParameterArgs']]]]):
        pulumi.set(self, "response_parameters", value)

    @property
    @pulumi.getter(name="templateSelectionExpression")
    def template_selection_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
        """
        return pulumi.get(self, "template_selection_expression")

    @template_selection_expression.setter
    def template_selection_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_selection_expression", value)

    @property
    @pulumi.getter(name="timeoutMilliseconds")
    def timeout_milliseconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
        The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
        this provider will only perform drift detection of its value when present in a configuration.
        """
        return pulumi.get(self, "timeout_milliseconds")

    @timeout_milliseconds.setter
    def timeout_milliseconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_milliseconds", value)

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['IntegrationTlsConfigArgs']]:
        """
        TLS configuration for a private integration. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['IntegrationTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)


@pulumi.type_token("aws:apigatewayv2/integration:Integration")
class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[builtins.str]] = None,
                 content_handling_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 credentials_arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 integration_method: Optional[pulumi.Input[builtins.str]] = None,
                 integration_subtype: Optional[pulumi.Input[builtins.str]] = None,
                 integration_type: Optional[pulumi.Input[builtins.str]] = None,
                 integration_uri: Optional[pulumi.Input[builtins.str]] = None,
                 passthrough_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 payload_format_version: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 response_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationResponseParameterArgs', 'IntegrationResponseParameterArgsDict']]]]] = None,
                 template_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_milliseconds: Optional[pulumi.Input[builtins.int]] = None,
                 tls_config: Optional[pulumi.Input[Union['IntegrationTlsConfigArgs', 'IntegrationTlsConfigArgsDict']]] = None,
                 __props__=None):
        """
        Manages an Amazon API Gateway Version 2 integration.
        More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Integration("example",
            api_id=example_aws_apigatewayv2_api["id"],
            integration_type="MOCK")
        ```

        ### Lambda Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.Function("example",
            code=pulumi.FileArchive("example.zip"),
            name="Example",
            role=example_aws_iam_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X)
        example_integration = aws.apigatewayv2.Integration("example",
            api_id=example_aws_apigatewayv2_api["id"],
            integration_type="AWS_PROXY",
            connection_type="INTERNET",
            content_handling_strategy="CONVERT_TO_TEXT",
            description="Lambda example",
            integration_method="POST",
            integration_uri=example.invoke_arn,
            passthrough_behavior="WHEN_NO_MATCH")
        ```

        ### AWS Service Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Integration("example",
            api_id=example_aws_apigatewayv2_api["id"],
            credentials_arn=example_aws_iam_role["arn"],
            description="SQS example",
            integration_type="AWS_PROXY",
            integration_subtype="SQS-SendMessage",
            request_parameters={
                "QueueUrl": "$request.header.queueUrl",
                "MessageBody": "$request.body.message",
            })
        ```

        ### Private Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Integration("example",
            api_id=example_aws_apigatewayv2_api["id"],
            credentials_arn=example_aws_iam_role["arn"],
            description="Example with a load balancer",
            integration_type="HTTP_PROXY",
            integration_uri=example_aws_lb_listener["arn"],
            integration_method="ANY",
            connection_type="VPC_LINK",
            connection_id=example_aws_apigatewayv2_vpc_link["id"],
            tls_config={
                "server_name_to_verify": "example.com",
            },
            request_parameters={
                "append:header.authforintegration": "$context.authorizer.authorizerResponse",
                "overwrite:path": "staticValueForIntegration",
            },
            response_parameters=[
                {
                    "status_code": "403",
                    "mappings": {
                        "append:header.auth": "$context.authorizer.authorizerResponse",
                    },
                },
                {
                    "status_code": "200",
                    "mappings": {
                        "overwrite:statuscode": "204",
                    },
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import `aws_apigatewayv2_integration` using the API identifier and integration identifier. For example:

        ```sh
        $ pulumi import aws:apigatewayv2/integration:Integration example aabbccddee/1122334
        ```
        -> __Note:__ The API Gateway managed integration created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_id: API identifier.
        :param pulumi.Input[builtins.str] connection_id: ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
        :param pulumi.Input[builtins.str] connection_type: Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
        :param pulumi.Input[builtins.str] content_handling_strategy: How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
        :param pulumi.Input[builtins.str] credentials_arn: Credentials required for the integration, if any.
        :param pulumi.Input[builtins.str] description: Description of the integration.
        :param pulumi.Input[builtins.str] integration_method: Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
        :param pulumi.Input[builtins.str] integration_subtype: AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
        :param pulumi.Input[builtins.str] integration_type: Integration type of an integration.
               Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
        :param pulumi.Input[builtins.str] integration_uri: URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
               For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
        :param pulumi.Input[builtins.str] passthrough_behavior: Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
               Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
        :param pulumi.Input[builtins.str] payload_format_version: The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] request_parameters: For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
               For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
               For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
               See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] request_templates: Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationResponseParameterArgs', 'IntegrationResponseParameterArgsDict']]]] response_parameters: Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
        :param pulumi.Input[builtins.str] template_selection_expression: The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
        :param pulumi.Input[builtins.int] timeout_milliseconds: Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
               The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
               this provider will only perform drift detection of its value when present in a configuration.
        :param pulumi.Input[Union['IntegrationTlsConfigArgs', 'IntegrationTlsConfigArgsDict']] tls_config: TLS configuration for a private integration. Supported only for HTTP APIs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon API Gateway Version 2 integration.
        More information can be found in the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api.html).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Integration("example",
            api_id=example_aws_apigatewayv2_api["id"],
            integration_type="MOCK")
        ```

        ### Lambda Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.Function("example",
            code=pulumi.FileArchive("example.zip"),
            name="Example",
            role=example_aws_iam_role["arn"],
            handler="index.handler",
            runtime=aws.lambda_.Runtime.NODE_JS20D_X)
        example_integration = aws.apigatewayv2.Integration("example",
            api_id=example_aws_apigatewayv2_api["id"],
            integration_type="AWS_PROXY",
            connection_type="INTERNET",
            content_handling_strategy="CONVERT_TO_TEXT",
            description="Lambda example",
            integration_method="POST",
            integration_uri=example.invoke_arn,
            passthrough_behavior="WHEN_NO_MATCH")
        ```

        ### AWS Service Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Integration("example",
            api_id=example_aws_apigatewayv2_api["id"],
            credentials_arn=example_aws_iam_role["arn"],
            description="SQS example",
            integration_type="AWS_PROXY",
            integration_subtype="SQS-SendMessage",
            request_parameters={
                "QueueUrl": "$request.header.queueUrl",
                "MessageBody": "$request.body.message",
            })
        ```

        ### Private Integration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.apigatewayv2.Integration("example",
            api_id=example_aws_apigatewayv2_api["id"],
            credentials_arn=example_aws_iam_role["arn"],
            description="Example with a load balancer",
            integration_type="HTTP_PROXY",
            integration_uri=example_aws_lb_listener["arn"],
            integration_method="ANY",
            connection_type="VPC_LINK",
            connection_id=example_aws_apigatewayv2_vpc_link["id"],
            tls_config={
                "server_name_to_verify": "example.com",
            },
            request_parameters={
                "append:header.authforintegration": "$context.authorizer.authorizerResponse",
                "overwrite:path": "staticValueForIntegration",
            },
            response_parameters=[
                {
                    "status_code": "403",
                    "mappings": {
                        "append:header.auth": "$context.authorizer.authorizerResponse",
                    },
                },
                {
                    "status_code": "200",
                    "mappings": {
                        "overwrite:statuscode": "204",
                    },
                },
            ])
        ```

        ## Import

        Using `pulumi import`, import `aws_apigatewayv2_integration` using the API identifier and integration identifier. For example:

        ```sh
        $ pulumi import aws:apigatewayv2/integration:Integration example aabbccddee/1122334
        ```
        -> __Note:__ The API Gateway managed integration created as part of [_quick_create_](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html#apigateway-definition-quick-create) cannot be imported.

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[builtins.str]] = None,
                 content_handling_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 credentials_arn: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 integration_method: Optional[pulumi.Input[builtins.str]] = None,
                 integration_subtype: Optional[pulumi.Input[builtins.str]] = None,
                 integration_type: Optional[pulumi.Input[builtins.str]] = None,
                 integration_uri: Optional[pulumi.Input[builtins.str]] = None,
                 passthrough_behavior: Optional[pulumi.Input[builtins.str]] = None,
                 payload_format_version: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 response_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationResponseParameterArgs', 'IntegrationResponseParameterArgsDict']]]]] = None,
                 template_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_milliseconds: Optional[pulumi.Input[builtins.int]] = None,
                 tls_config: Optional[pulumi.Input[Union['IntegrationTlsConfigArgs', 'IntegrationTlsConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["connection_id"] = connection_id
            __props__.__dict__["connection_type"] = connection_type
            __props__.__dict__["content_handling_strategy"] = content_handling_strategy
            __props__.__dict__["credentials_arn"] = credentials_arn
            __props__.__dict__["description"] = description
            __props__.__dict__["integration_method"] = integration_method
            __props__.__dict__["integration_subtype"] = integration_subtype
            if integration_type is None and not opts.urn:
                raise TypeError("Missing required property 'integration_type'")
            __props__.__dict__["integration_type"] = integration_type
            __props__.__dict__["integration_uri"] = integration_uri
            __props__.__dict__["passthrough_behavior"] = passthrough_behavior
            __props__.__dict__["payload_format_version"] = payload_format_version
            __props__.__dict__["region"] = region
            __props__.__dict__["request_parameters"] = request_parameters
            __props__.__dict__["request_templates"] = request_templates
            __props__.__dict__["response_parameters"] = response_parameters
            __props__.__dict__["template_selection_expression"] = template_selection_expression
            __props__.__dict__["timeout_milliseconds"] = timeout_milliseconds
            __props__.__dict__["tls_config"] = tls_config
            __props__.__dict__["integration_response_selection_expression"] = None
        super(Integration, __self__).__init__(
            'aws:apigatewayv2/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_id: Optional[pulumi.Input[builtins.str]] = None,
            connection_id: Optional[pulumi.Input[builtins.str]] = None,
            connection_type: Optional[pulumi.Input[builtins.str]] = None,
            content_handling_strategy: Optional[pulumi.Input[builtins.str]] = None,
            credentials_arn: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            integration_method: Optional[pulumi.Input[builtins.str]] = None,
            integration_response_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
            integration_subtype: Optional[pulumi.Input[builtins.str]] = None,
            integration_type: Optional[pulumi.Input[builtins.str]] = None,
            integration_uri: Optional[pulumi.Input[builtins.str]] = None,
            passthrough_behavior: Optional[pulumi.Input[builtins.str]] = None,
            payload_format_version: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            response_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationResponseParameterArgs', 'IntegrationResponseParameterArgsDict']]]]] = None,
            template_selection_expression: Optional[pulumi.Input[builtins.str]] = None,
            timeout_milliseconds: Optional[pulumi.Input[builtins.int]] = None,
            tls_config: Optional[pulumi.Input[Union['IntegrationTlsConfigArgs', 'IntegrationTlsConfigArgsDict']]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_id: API identifier.
        :param pulumi.Input[builtins.str] connection_id: ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
        :param pulumi.Input[builtins.str] connection_type: Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
        :param pulumi.Input[builtins.str] content_handling_strategy: How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
        :param pulumi.Input[builtins.str] credentials_arn: Credentials required for the integration, if any.
        :param pulumi.Input[builtins.str] description: Description of the integration.
        :param pulumi.Input[builtins.str] integration_method: Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
        :param pulumi.Input[builtins.str] integration_response_selection_expression: The [integration response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions) for the integration.
        :param pulumi.Input[builtins.str] integration_subtype: AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
        :param pulumi.Input[builtins.str] integration_type: Integration type of an integration.
               Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
        :param pulumi.Input[builtins.str] integration_uri: URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
               For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
        :param pulumi.Input[builtins.str] passthrough_behavior: Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
               Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
        :param pulumi.Input[builtins.str] payload_format_version: The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] request_parameters: For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
               For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
               For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
               See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] request_templates: Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationResponseParameterArgs', 'IntegrationResponseParameterArgsDict']]]] response_parameters: Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
        :param pulumi.Input[builtins.str] template_selection_expression: The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
        :param pulumi.Input[builtins.int] timeout_milliseconds: Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
               The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
               this provider will only perform drift detection of its value when present in a configuration.
        :param pulumi.Input[Union['IntegrationTlsConfigArgs', 'IntegrationTlsConfigArgsDict']] tls_config: TLS configuration for a private integration. Supported only for HTTP APIs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["connection_type"] = connection_type
        __props__.__dict__["content_handling_strategy"] = content_handling_strategy
        __props__.__dict__["credentials_arn"] = credentials_arn
        __props__.__dict__["description"] = description
        __props__.__dict__["integration_method"] = integration_method
        __props__.__dict__["integration_response_selection_expression"] = integration_response_selection_expression
        __props__.__dict__["integration_subtype"] = integration_subtype
        __props__.__dict__["integration_type"] = integration_type
        __props__.__dict__["integration_uri"] = integration_uri
        __props__.__dict__["passthrough_behavior"] = passthrough_behavior
        __props__.__dict__["payload_format_version"] = payload_format_version
        __props__.__dict__["region"] = region
        __props__.__dict__["request_parameters"] = request_parameters
        __props__.__dict__["request_templates"] = request_templates
        __props__.__dict__["response_parameters"] = response_parameters
        __props__.__dict__["template_selection_expression"] = template_selection_expression
        __props__.__dict__["timeout_milliseconds"] = timeout_milliseconds
        __props__.__dict__["tls_config"] = tls_config
        return Integration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[builtins.str]:
        """
        API identifier.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        ID of the VPC link for a private integration. Supported only for HTTP APIs. Must be between 1 and 1024 characters in length.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of the network connection to the integration endpoint. Valid values: `INTERNET`, `VPC_LINK`. Default is `INTERNET`.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="contentHandlingStrategy")
    def content_handling_strategy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        How to handle response payload content type conversions. Valid values: `CONVERT_TO_BINARY`, `CONVERT_TO_TEXT`. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "content_handling_strategy")

    @property
    @pulumi.getter(name="credentialsArn")
    def credentials_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Credentials required for the integration, if any.
        """
        return pulumi.get(self, "credentials_arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the integration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="integrationMethod")
    def integration_method(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Integration's HTTP method. Must be specified if `integration_type` is not `MOCK`.
        """
        return pulumi.get(self, "integration_method")

    @property
    @pulumi.getter(name="integrationResponseSelectionExpression")
    def integration_response_selection_expression(self) -> pulumi.Output[builtins.str]:
        """
        The [integration response selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions) for the integration.
        """
        return pulumi.get(self, "integration_response_selection_expression")

    @property
    @pulumi.getter(name="integrationSubtype")
    def integration_subtype(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        AWS service action to invoke. Supported only for HTTP APIs when `integration_type` is `AWS_PROXY`. See the [AWS service integration reference](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html) documentation for supported values. Must be between 1 and 128 characters in length.
        """
        return pulumi.get(self, "integration_subtype")

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Output[builtins.str]:
        """
        Integration type of an integration.
        Valid values: `AWS` (supported only for WebSocket APIs), `AWS_PROXY`, `HTTP` (supported only for WebSocket APIs), `HTTP_PROXY`, `MOCK` (supported only for WebSocket APIs). For an HTTP API private integration, use `HTTP_PROXY`.
        """
        return pulumi.get(self, "integration_type")

    @property
    @pulumi.getter(name="integrationUri")
    def integration_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URI of the Lambda function for a Lambda proxy integration, when `integration_type` is `AWS_PROXY`.
        For an `HTTP` integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
        """
        return pulumi.get(self, "integration_uri")

    @property
    @pulumi.getter(name="passthroughBehavior")
    def passthrough_behavior(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `request_templates` attribute.
        Valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`. Default is `WHEN_NO_MATCH`. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "passthrough_behavior")

    @property
    @pulumi.getter(name="payloadFormatVersion")
    def payload_format_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The [format of the payload](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html#http-api-develop-integrations-lambda.proxy-format) sent to an integration. Valid values: `1.0`, `2.0`. Default is `1.0`.
        """
        return pulumi.get(self, "payload_format_version")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
        For HTTP APIs with a specified `integration_subtype`, a key-value map specifying parameters that are passed to `AWS_PROXY` integrations.
        For HTTP APIs without a specified `integration_subtype`, a key-value map specifying how to transform HTTP requests before sending them to the backend.
        See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
        """
        return pulumi.get(self, "request_parameters")

    @property
    @pulumi.getter(name="requestTemplates")
    def request_templates(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of [Velocity](https://velocity.apache.org/) templates that are applied on the request payload based on the value of the Content-Type header sent by the client. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "request_templates")

    @property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationResponseParameter']]]:
        """
        Mappings to transform the HTTP response from a backend integration before returning the response to clients. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "response_parameters")

    @property
    @pulumi.getter(name="templateSelectionExpression")
    def template_selection_expression(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The [template selection expression](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-template-selection-expressions) for the integration.
        """
        return pulumi.get(self, "template_selection_expression")

    @property
    @pulumi.getter(name="timeoutMilliseconds")
    def timeout_milliseconds(self) -> pulumi.Output[builtins.int]:
        """
        Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
        The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
        this provider will only perform drift detection of its value when present in a configuration.
        """
        return pulumi.get(self, "timeout_milliseconds")

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> pulumi.Output[Optional['outputs.IntegrationTlsConfig']]:
        """
        TLS configuration for a private integration. Supported only for HTTP APIs.
        """
        return pulumi.get(self, "tls_config")

