# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ApiCorsConfiguration',
    'AuthorizerJwtConfiguration',
    'DomainNameDomainNameConfiguration',
    'DomainNameMutualTlsAuthentication',
    'IntegrationResponseParameter',
    'IntegrationTlsConfig',
    'RouteRequestParameter',
    'StageAccessLogSettings',
    'StageDefaultRouteSettings',
    'StageRouteSetting',
    'GetApiCorsConfigurationResult',
]

@pulumi.output_type
class ApiCorsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiCorsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiCorsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiCorsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[builtins.bool] = None,
                 allow_headers: Optional[Sequence[builtins.str]] = None,
                 allow_methods: Optional[Sequence[builtins.str]] = None,
                 allow_origins: Optional[Sequence[builtins.str]] = None,
                 expose_headers: Optional[Sequence[builtins.str]] = None,
                 max_age: Optional[builtins.int] = None):
        """
        :param builtins.bool allow_credentials: Whether credentials are included in the CORS request.
        :param Sequence[builtins.str] allow_headers: Set of allowed HTTP headers.
        :param Sequence[builtins.str] allow_methods: Set of allowed HTTP methods.
        :param Sequence[builtins.str] allow_origins: Set of allowed origins.
        :param Sequence[builtins.str] expose_headers: Set of exposed HTTP headers.
        :param builtins.int max_age: Number of seconds that the browser should cache preflight request results.
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[builtins.bool]:
        """
        Whether credentials are included in the CORS request.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of allowed HTTP headers.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of allowed HTTP methods.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of allowed origins.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Set of exposed HTTP headers.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[builtins.int]:
        """
        Number of seconds that the browser should cache preflight request results.
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class AuthorizerJwtConfiguration(dict):
    def __init__(__self__, *,
                 audiences: Optional[Sequence[builtins.str]] = None,
                 issuer: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] audiences: List of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list.
        :param builtins.str issuer: Base domain of the identity provider that issues JSON Web Tokens, such as the `endpoint` attribute of the `cognito.UserPool` resource.
        """
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)

    @property
    @pulumi.getter
    def audiences(self) -> Optional[Sequence[builtins.str]]:
        """
        List of the intended recipients of the JWT. A valid JWT must provide an aud that matches at least one entry in this list.
        """
        return pulumi.get(self, "audiences")

    @property
    @pulumi.getter
    def issuer(self) -> Optional[builtins.str]:
        """
        Base domain of the identity provider that issues JSON Web Tokens, such as the `endpoint` attribute of the `cognito.UserPool` resource.
        """
        return pulumi.get(self, "issuer")


@pulumi.output_type
class DomainNameDomainNameConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateArn":
            suggest = "certificate_arn"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "securityPolicy":
            suggest = "security_policy"
        elif key == "hostedZoneId":
            suggest = "hosted_zone_id"
        elif key == "ipAddressType":
            suggest = "ip_address_type"
        elif key == "ownershipVerificationCertificateArn":
            suggest = "ownership_verification_certificate_arn"
        elif key == "targetDomainName":
            suggest = "target_domain_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainNameDomainNameConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainNameDomainNameConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainNameDomainNameConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_arn: builtins.str,
                 endpoint_type: builtins.str,
                 security_policy: builtins.str,
                 hosted_zone_id: Optional[builtins.str] = None,
                 ip_address_type: Optional[builtins.str] = None,
                 ownership_verification_certificate_arn: Optional[builtins.str] = None,
                 target_domain_name: Optional[builtins.str] = None):
        """
        :param builtins.str certificate_arn: ARN of an AWS-managed certificate that will be used by the endpoint for the domain name. AWS Certificate Manager is the only supported source. Use the `acm.Certificate` resource to configure an ACM certificate.
        :param builtins.str endpoint_type: Endpoint type. Valid values: `REGIONAL`.
        :param builtins.str security_policy: Transport Layer Security (TLS) version of the [security policy](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-custom-domain-tls-version.html) for the domain name. Valid values: `TLS_1_2`.
        :param builtins.str hosted_zone_id: Amazon Route 53 Hosted Zone ID of the endpoint.
        :param builtins.str ip_address_type: The IP address types that can invoke the domain name. Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke your domain name, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your domain name. Defaults to `ipv4`.
        :param builtins.str ownership_verification_certificate_arn: ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
        :param builtins.str target_domain_name: Target domain name.
        """
        pulumi.set(__self__, "certificate_arn", certificate_arn)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "security_policy", security_policy)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ownership_verification_certificate_arn is not None:
            pulumi.set(__self__, "ownership_verification_certificate_arn", ownership_verification_certificate_arn)
        if target_domain_name is not None:
            pulumi.set(__self__, "target_domain_name", target_domain_name)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> builtins.str:
        """
        ARN of an AWS-managed certificate that will be used by the endpoint for the domain name. AWS Certificate Manager is the only supported source. Use the `acm.Certificate` resource to configure an ACM certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> builtins.str:
        """
        Endpoint type. Valid values: `REGIONAL`.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> builtins.str:
        """
        Transport Layer Security (TLS) version of the [security policy](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-custom-domain-tls-version.html) for the domain name. Valid values: `TLS_1_2`.
        """
        return pulumi.get(self, "security_policy")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[builtins.str]:
        """
        Amazon Route 53 Hosted Zone ID of the endpoint.
        """
        return pulumi.get(self, "hosted_zone_id")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[builtins.str]:
        """
        The IP address types that can invoke the domain name. Valid values: `ipv4`, `dualstack`. Use `ipv4` to allow only IPv4 addresses to invoke your domain name, or use `dualstack` to allow both IPv4 and IPv6 addresses to invoke your domain name. Defaults to `ipv4`.
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="ownershipVerificationCertificateArn")
    def ownership_verification_certificate_arn(self) -> Optional[builtins.str]:
        """
        ARN of the AWS-issued certificate used to validate custom domain ownership (when `certificate_arn` is issued via an ACM Private CA or `mutual_tls_authentication` is configured with an ACM-imported certificate.)
        """
        return pulumi.get(self, "ownership_verification_certificate_arn")

    @property
    @pulumi.getter(name="targetDomainName")
    def target_domain_name(self) -> Optional[builtins.str]:
        """
        Target domain name.
        """
        return pulumi.get(self, "target_domain_name")


@pulumi.output_type
class DomainNameMutualTlsAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "truststoreUri":
            suggest = "truststore_uri"
        elif key == "truststoreVersion":
            suggest = "truststore_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainNameMutualTlsAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainNameMutualTlsAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainNameMutualTlsAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 truststore_uri: builtins.str,
                 truststore_version: Optional[builtins.str] = None):
        """
        :param builtins.str truststore_uri: Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
        :param builtins.str truststore_version: Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        pulumi.set(__self__, "truststore_uri", truststore_uri)
        if truststore_version is not None:
            pulumi.set(__self__, "truststore_version", truststore_version)

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> builtins.str:
        """
        Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example, `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version.
        """
        return pulumi.get(self, "truststore_uri")

    @property
    @pulumi.getter(name="truststoreVersion")
    def truststore_version(self) -> Optional[builtins.str]:
        """
        Version of the S3 object that contains the truststore. To specify a version, you must have versioning enabled for the S3 bucket.
        """
        return pulumi.get(self, "truststore_version")


@pulumi.output_type
class IntegrationResponseParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationResponseParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationResponseParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationResponseParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mappings: Mapping[str, builtins.str],
                 status_code: builtins.str):
        """
        :param Mapping[str, builtins.str] mappings: Key-value map. The key of this map identifies the location of the request parameter to change, and how to change it. The corresponding value specifies the new data for the parameter.
               See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
        :param builtins.str status_code: HTTP status code in the range 200-599.
        """
        pulumi.set(__self__, "mappings", mappings)
        pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter
    def mappings(self) -> Mapping[str, builtins.str]:
        """
        Key-value map. The key of this map identifies the location of the request parameter to change, and how to change it. The corresponding value specifies the new data for the parameter.
        See the [Amazon API Gateway Developer Guide](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html) for details.
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> builtins.str:
        """
        HTTP status code in the range 200-599.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class IntegrationTlsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverNameToVerify":
            suggest = "server_name_to_verify"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTlsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTlsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTlsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_name_to_verify: Optional[builtins.str] = None):
        """
        :param builtins.str server_name_to_verify: If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
        """
        if server_name_to_verify is not None:
            pulumi.set(__self__, "server_name_to_verify", server_name_to_verify)

    @property
    @pulumi.getter(name="serverNameToVerify")
    def server_name_to_verify(self) -> Optional[builtins.str]:
        """
        If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate. The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
        """
        return pulumi.get(self, "server_name_to_verify")


@pulumi.output_type
class RouteRequestParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestParameterKey":
            suggest = "request_parameter_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RouteRequestParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RouteRequestParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RouteRequestParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_parameter_key: builtins.str,
                 required: builtins.bool):
        """
        :param builtins.str request_parameter_key: Request parameter key. This is a [request data mapping parameter](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-data-mapping.html#websocket-mapping-request-parameters).
        :param builtins.bool required: Boolean whether or not the parameter is required.
        """
        pulumi.set(__self__, "request_parameter_key", request_parameter_key)
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter(name="requestParameterKey")
    def request_parameter_key(self) -> builtins.str:
        """
        Request parameter key. This is a [request data mapping parameter](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-data-mapping.html#websocket-mapping-request-parameters).
        """
        return pulumi.get(self, "request_parameter_key")

    @property
    @pulumi.getter
    def required(self) -> builtins.bool:
        """
        Boolean whether or not the parameter is required.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class StageAccessLogSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StageAccessLogSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StageAccessLogSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StageAccessLogSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: builtins.str,
                 format: builtins.str):
        """
        :param builtins.str destination_arn: ARN of the CloudWatch Logs log group to receive access logs. Any trailing `:*` is trimmed from the ARN.
        :param builtins.str format: Single line [format](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#apigateway-cloudwatch-log-formats) of the access logs of data. Refer to log settings for [HTTP](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-logging-variables.html) or [Websocket](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-logging.html).
        """
        pulumi.set(__self__, "destination_arn", destination_arn)
        pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> builtins.str:
        """
        ARN of the CloudWatch Logs log group to receive access logs. Any trailing `:*` is trimmed from the ARN.
        """
        return pulumi.get(self, "destination_arn")

    @property
    @pulumi.getter
    def format(self) -> builtins.str:
        """
        Single line [format](https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-logging.html#apigateway-cloudwatch-log-formats) of the access logs of data. Refer to log settings for [HTTP](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-logging-variables.html) or [Websocket](https://docs.aws.amazon.com/apigateway/latest/developerguide/websocket-api-logging.html).
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class StageDefaultRouteSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataTraceEnabled":
            suggest = "data_trace_enabled"
        elif key == "detailedMetricsEnabled":
            suggest = "detailed_metrics_enabled"
        elif key == "loggingLevel":
            suggest = "logging_level"
        elif key == "throttlingBurstLimit":
            suggest = "throttling_burst_limit"
        elif key == "throttlingRateLimit":
            suggest = "throttling_rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StageDefaultRouteSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StageDefaultRouteSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StageDefaultRouteSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_trace_enabled: Optional[builtins.bool] = None,
                 detailed_metrics_enabled: Optional[builtins.bool] = None,
                 logging_level: Optional[builtins.str] = None,
                 throttling_burst_limit: Optional[builtins.int] = None,
                 throttling_rate_limit: Optional[builtins.float] = None):
        """
        :param builtins.bool data_trace_enabled: Whether data trace logging is enabled for the default route. Affects the log entries pushed to Amazon CloudWatch Logs.
               Defaults to `false`. Supported only for WebSocket APIs.
        :param builtins.bool detailed_metrics_enabled: Whether detailed metrics are enabled for the default route. Defaults to `false`.
        :param builtins.str logging_level: Logging level for the default route. Affects the log entries pushed to Amazon CloudWatch Logs.
               Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
        :param builtins.int throttling_burst_limit: Throttling burst limit for the default route.
        :param builtins.float throttling_rate_limit: Throttling rate limit for the default route.
        """
        if data_trace_enabled is not None:
            pulumi.set(__self__, "data_trace_enabled", data_trace_enabled)
        if detailed_metrics_enabled is not None:
            pulumi.set(__self__, "detailed_metrics_enabled", detailed_metrics_enabled)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if throttling_burst_limit is not None:
            pulumi.set(__self__, "throttling_burst_limit", throttling_burst_limit)
        if throttling_rate_limit is not None:
            pulumi.set(__self__, "throttling_rate_limit", throttling_rate_limit)

    @property
    @pulumi.getter(name="dataTraceEnabled")
    def data_trace_enabled(self) -> Optional[builtins.bool]:
        """
        Whether data trace logging is enabled for the default route. Affects the log entries pushed to Amazon CloudWatch Logs.
        Defaults to `false`. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "data_trace_enabled")

    @property
    @pulumi.getter(name="detailedMetricsEnabled")
    def detailed_metrics_enabled(self) -> Optional[builtins.bool]:
        """
        Whether detailed metrics are enabled for the default route. Defaults to `false`.
        """
        return pulumi.get(self, "detailed_metrics_enabled")

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[builtins.str]:
        """
        Logging level for the default route. Affects the log entries pushed to Amazon CloudWatch Logs.
        Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
        """
        return pulumi.get(self, "logging_level")

    @property
    @pulumi.getter(name="throttlingBurstLimit")
    def throttling_burst_limit(self) -> Optional[builtins.int]:
        """
        Throttling burst limit for the default route.
        """
        return pulumi.get(self, "throttling_burst_limit")

    @property
    @pulumi.getter(name="throttlingRateLimit")
    def throttling_rate_limit(self) -> Optional[builtins.float]:
        """
        Throttling rate limit for the default route.
        """
        return pulumi.get(self, "throttling_rate_limit")


@pulumi.output_type
class StageRouteSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routeKey":
            suggest = "route_key"
        elif key == "dataTraceEnabled":
            suggest = "data_trace_enabled"
        elif key == "detailedMetricsEnabled":
            suggest = "detailed_metrics_enabled"
        elif key == "loggingLevel":
            suggest = "logging_level"
        elif key == "throttlingBurstLimit":
            suggest = "throttling_burst_limit"
        elif key == "throttlingRateLimit":
            suggest = "throttling_rate_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StageRouteSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StageRouteSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StageRouteSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 route_key: builtins.str,
                 data_trace_enabled: Optional[builtins.bool] = None,
                 detailed_metrics_enabled: Optional[builtins.bool] = None,
                 logging_level: Optional[builtins.str] = None,
                 throttling_burst_limit: Optional[builtins.int] = None,
                 throttling_rate_limit: Optional[builtins.float] = None):
        """
        :param builtins.str route_key: Route key.
        :param builtins.bool data_trace_enabled: Whether data trace logging is enabled for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
               Defaults to `false`. Supported only for WebSocket APIs.
        :param builtins.bool detailed_metrics_enabled: Whether detailed metrics are enabled for the route. Defaults to `false`.
        :param builtins.str logging_level: Logging level for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
               Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
        :param builtins.int throttling_burst_limit: Throttling burst limit for the route.
        :param builtins.float throttling_rate_limit: Throttling rate limit for the route.
        """
        pulumi.set(__self__, "route_key", route_key)
        if data_trace_enabled is not None:
            pulumi.set(__self__, "data_trace_enabled", data_trace_enabled)
        if detailed_metrics_enabled is not None:
            pulumi.set(__self__, "detailed_metrics_enabled", detailed_metrics_enabled)
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if throttling_burst_limit is not None:
            pulumi.set(__self__, "throttling_burst_limit", throttling_burst_limit)
        if throttling_rate_limit is not None:
            pulumi.set(__self__, "throttling_rate_limit", throttling_rate_limit)

    @property
    @pulumi.getter(name="routeKey")
    def route_key(self) -> builtins.str:
        """
        Route key.
        """
        return pulumi.get(self, "route_key")

    @property
    @pulumi.getter(name="dataTraceEnabled")
    def data_trace_enabled(self) -> Optional[builtins.bool]:
        """
        Whether data trace logging is enabled for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
        Defaults to `false`. Supported only for WebSocket APIs.
        """
        return pulumi.get(self, "data_trace_enabled")

    @property
    @pulumi.getter(name="detailedMetricsEnabled")
    def detailed_metrics_enabled(self) -> Optional[builtins.bool]:
        """
        Whether detailed metrics are enabled for the route. Defaults to `false`.
        """
        return pulumi.get(self, "detailed_metrics_enabled")

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[builtins.str]:
        """
        Logging level for the route. Affects the log entries pushed to Amazon CloudWatch Logs.
        Valid values: `ERROR`, `INFO`, `OFF`. Defaults to `OFF`. Supported only for WebSocket APIs. This provider will only perform drift detection of its value when present in a configuration.
        """
        return pulumi.get(self, "logging_level")

    @property
    @pulumi.getter(name="throttlingBurstLimit")
    def throttling_burst_limit(self) -> Optional[builtins.int]:
        """
        Throttling burst limit for the route.
        """
        return pulumi.get(self, "throttling_burst_limit")

    @property
    @pulumi.getter(name="throttlingRateLimit")
    def throttling_rate_limit(self) -> Optional[builtins.float]:
        """
        Throttling rate limit for the route.
        """
        return pulumi.get(self, "throttling_rate_limit")


@pulumi.output_type
class GetApiCorsConfigurationResult(dict):
    def __init__(__self__, *,
                 allow_credentials: builtins.bool,
                 allow_headers: Sequence[builtins.str],
                 allow_methods: Sequence[builtins.str],
                 allow_origins: Sequence[builtins.str],
                 expose_headers: Sequence[builtins.str],
                 max_age: builtins.int):
        """
        :param builtins.bool allow_credentials: Whether credentials are included in the CORS request.
        :param Sequence[builtins.str] allow_headers: Set of allowed HTTP headers.
        :param Sequence[builtins.str] allow_methods: Set of allowed HTTP methods.
        :param Sequence[builtins.str] allow_origins: Set of allowed origins.
        :param Sequence[builtins.str] expose_headers: Set of exposed HTTP headers.
        :param builtins.int max_age: Number of seconds that the browser should cache preflight request results.
        """
        pulumi.set(__self__, "allow_credentials", allow_credentials)
        pulumi.set(__self__, "allow_headers", allow_headers)
        pulumi.set(__self__, "allow_methods", allow_methods)
        pulumi.set(__self__, "allow_origins", allow_origins)
        pulumi.set(__self__, "expose_headers", expose_headers)
        pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> builtins.bool:
        """
        Whether credentials are included in the CORS request.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Sequence[builtins.str]:
        """
        Set of allowed HTTP headers.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Sequence[builtins.str]:
        """
        Set of allowed HTTP methods.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Sequence[builtins.str]:
        """
        Set of allowed origins.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Sequence[builtins.str]:
        """
        Set of exposed HTTP headers.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> builtins.int:
        """
        Number of seconds that the browser should cache preflight request results.
        """
        return pulumi.get(self, "max_age")


