# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConfigurationProfileValidatorArgs',
    'ConfigurationProfileValidatorArgsDict',
    'EnvironmentMonitorArgs',
    'EnvironmentMonitorArgsDict',
    'EventIntegrationEventFilterArgs',
    'EventIntegrationEventFilterArgsDict',
    'ExtensionActionPointArgs',
    'ExtensionActionPointArgsDict',
    'ExtensionActionPointActionArgs',
    'ExtensionActionPointActionArgsDict',
    'ExtensionParameterArgs',
    'ExtensionParameterArgsDict',
]

MYPY = False

if not MYPY:
    class ConfigurationProfileValidatorArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
        """
        content: NotRequired[pulumi.Input[builtins.str]]
        """
        Either the JSON Schema content or the ARN of an AWS Lambda function.
        """
elif False:
    ConfigurationProfileValidatorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationProfileValidatorArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 content: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
        :param pulumi.Input[builtins.str] content: Either the JSON Schema content or the ARN of an AWS Lambda function.
        """
        pulumi.set(__self__, "type", type)
        if content is not None:
            pulumi.set(__self__, "content", content)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of validator. Valid values: `JSON_SCHEMA` and `LAMBDA`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Either the JSON Schema content or the ARN of an AWS Lambda function.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)


if not MYPY:
    class EnvironmentMonitorArgsDict(TypedDict):
        alarm_arn: pulumi.Input[builtins.str]
        """
        ARN of the Amazon CloudWatch alarm.
        """
        alarm_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
        """
elif False:
    EnvironmentMonitorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EnvironmentMonitorArgs:
    def __init__(__self__, *,
                 alarm_arn: pulumi.Input[builtins.str],
                 alarm_role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] alarm_arn: ARN of the Amazon CloudWatch alarm.
        :param pulumi.Input[builtins.str] alarm_role_arn: ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
        """
        pulumi.set(__self__, "alarm_arn", alarm_arn)
        if alarm_role_arn is not None:
            pulumi.set(__self__, "alarm_role_arn", alarm_role_arn)

    @property
    @pulumi.getter(name="alarmArn")
    def alarm_arn(self) -> pulumi.Input[builtins.str]:
        """
        ARN of the Amazon CloudWatch alarm.
        """
        return pulumi.get(self, "alarm_arn")

    @alarm_arn.setter
    def alarm_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "alarm_arn", value)

    @property
    @pulumi.getter(name="alarmRoleArn")
    def alarm_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of an IAM role for AWS AppConfig to monitor `alarm_arn`.
        """
        return pulumi.get(self, "alarm_role_arn")

    @alarm_role_arn.setter
    def alarm_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alarm_role_arn", value)


if not MYPY:
    class EventIntegrationEventFilterArgsDict(TypedDict):
        source: pulumi.Input[builtins.str]
        """
        Source of the events.
        """
elif False:
    EventIntegrationEventFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventIntegrationEventFilterArgs:
    def __init__(__self__, *,
                 source: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] source: Source of the events.
        """
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[builtins.str]:
        """
        Source of the events.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source", value)


if not MYPY:
    class ExtensionActionPointArgsDict(TypedDict):
        actions: pulumi.Input[Sequence[pulumi.Input['ExtensionActionPointActionArgsDict']]]
        """
        An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
        """
        point: pulumi.Input[builtins.str]
        """
        The point at which to perform the defined actions. Valid points are `PRE_CREATE_HOSTED_CONFIGURATION_VERSION`, `PRE_START_DEPLOYMENT`, `ON_DEPLOYMENT_START`, `ON_DEPLOYMENT_STEP`, `ON_DEPLOYMENT_BAKING`, `ON_DEPLOYMENT_COMPLETE`, `ON_DEPLOYMENT_ROLLED_BACK`.
        """
elif False:
    ExtensionActionPointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExtensionActionPointArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['ExtensionActionPointActionArgs']]],
                 point: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ExtensionActionPointActionArgs']]] actions: An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
        :param pulumi.Input[builtins.str] point: The point at which to perform the defined actions. Valid points are `PRE_CREATE_HOSTED_CONFIGURATION_VERSION`, `PRE_START_DEPLOYMENT`, `ON_DEPLOYMENT_START`, `ON_DEPLOYMENT_STEP`, `ON_DEPLOYMENT_BAKING`, `ON_DEPLOYMENT_COMPLETE`, `ON_DEPLOYMENT_ROLLED_BACK`.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "point", point)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['ExtensionActionPointActionArgs']]]:
        """
        An action defines the tasks the extension performs during the AppConfig workflow. Detailed below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['ExtensionActionPointActionArgs']]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def point(self) -> pulumi.Input[builtins.str]:
        """
        The point at which to perform the defined actions. Valid points are `PRE_CREATE_HOSTED_CONFIGURATION_VERSION`, `PRE_START_DEPLOYMENT`, `ON_DEPLOYMENT_START`, `ON_DEPLOYMENT_STEP`, `ON_DEPLOYMENT_BAKING`, `ON_DEPLOYMENT_COMPLETE`, `ON_DEPLOYMENT_ROLLED_BACK`.
        """
        return pulumi.get(self, "point")

    @point.setter
    def point(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "point", value)


if not MYPY:
    class ExtensionActionPointActionArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The action name.
        """
        uri: pulumi.Input[builtins.str]
        """
        The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        Information about the action.
        """
        role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
        """
elif False:
    ExtensionActionPointActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExtensionActionPointActionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 uri: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The action name.
        :param pulumi.Input[builtins.str] uri: The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
        :param pulumi.Input[builtins.str] description: Information about the action.
        :param pulumi.Input[builtins.str] role_arn: An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The action name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[builtins.str]:
        """
        The extension URI associated to the action point in the extension definition. The URI can be an Amazon Resource Name (ARN) for one of the following: an Lambda function, an Amazon Simple Queue Service queue, an Amazon Simple Notification Service topic, or the Amazon EventBridge default event bus.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Information about the action.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An Amazon Resource Name (ARN) for an Identity and Access Management assume role.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role_arn", value)


if not MYPY:
    class ExtensionParameterArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The parameter name.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        Information about the parameter.
        """
        required: NotRequired[pulumi.Input[builtins.bool]]
        """
        Determines if a parameter value must be specified in the extension association.
        """
elif False:
    ExtensionParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExtensionParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 required: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] name: The parameter name.
        :param pulumi.Input[builtins.str] description: Information about the parameter.
        :param pulumi.Input[builtins.bool] required: Determines if a parameter value must be specified in the extension association.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if required is not None:
            pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The parameter name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Information about the parameter.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if a parameter value must be specified in the extension association.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "required", value)


