# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExtensionAssociationArgs', 'ExtensionAssociation']

@pulumi.input_type
class ExtensionAssociationArgs:
    def __init__(__self__, *,
                 extension_arn: pulumi.Input[builtins.str],
                 resource_arn: pulumi.Input[builtins.str],
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ExtensionAssociation resource.
        :param pulumi.Input[builtins.str] extension_arn: The ARN of the extension defined in the association.
        :param pulumi.Input[builtins.str] resource_arn: The ARN of the application, configuration profile, or environment to associate with the extension.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: The parameter names and values defined for the association.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "extension_arn", extension_arn)
        pulumi.set(__self__, "resource_arn", resource_arn)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="extensionArn")
    def extension_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the extension defined in the association.
        """
        return pulumi.get(self, "extension_arn")

    @extension_arn.setter
    def extension_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "extension_arn", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the application, configuration profile, or environment to associate with the extension.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_arn", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The parameter names and values defined for the association.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ExtensionAssociationState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 extension_arn: Optional[pulumi.Input[builtins.str]] = None,
                 extension_version: Optional[pulumi.Input[builtins.int]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExtensionAssociation resources.
        :param pulumi.Input[builtins.str] arn: ARN of the AppConfig Extension Association.
        :param pulumi.Input[builtins.str] extension_arn: The ARN of the extension defined in the association.
        :param pulumi.Input[builtins.int] extension_version: The version number for the extension defined in the association.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: The parameter names and values defined for the association.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_arn: The ARN of the application, configuration profile, or environment to associate with the extension.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if extension_arn is not None:
            pulumi.set(__self__, "extension_arn", extension_arn)
        if extension_version is not None:
            pulumi.set(__self__, "extension_version", extension_version)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the AppConfig Extension Association.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="extensionArn")
    def extension_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the extension defined in the association.
        """
        return pulumi.get(self, "extension_arn")

    @extension_arn.setter
    def extension_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "extension_arn", value)

    @property
    @pulumi.getter(name="extensionVersion")
    def extension_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version number for the extension defined in the association.
        """
        return pulumi.get(self, "extension_version")

    @extension_version.setter
    def extension_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "extension_version", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The parameter names and values defined for the association.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the application, configuration profile, or environment to associate with the extension.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_arn", value)


@pulumi.type_token("aws:appconfig/extensionAssociation:ExtensionAssociation")
class ExtensionAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extension_arn: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Associates an AppConfig Extension with a Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_topic = aws.sns.Topic("test", name="test")
        test = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["appconfig.amazonaws.com"],
            }],
        }])
        test_role = aws.iam.Role("test",
            name="test",
            assume_role_policy=test.json)
        test_extension = aws.appconfig.Extension("test",
            name="test",
            description="test description",
            action_points=[{
                "point": "ON_DEPLOYMENT_COMPLETE",
                "actions": [{
                    "name": "test",
                    "role_arn": test_role.arn,
                    "uri": test_topic.arn,
                }],
            }],
            tags={
                "Type": "AppConfig Extension",
            })
        test_application = aws.appconfig.Application("test", name="test")
        test_extension_association = aws.appconfig.ExtensionAssociation("test",
            extension_arn=test_extension.arn,
            resource_arn=test_application.arn)
        ```

        ## Import

        Using `pulumi import`, import AppConfig Extension Associations using their extension association ID. For example:

        ```sh
        $ pulumi import aws:appconfig/extensionAssociation:ExtensionAssociation example 71rxuzt
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] extension_arn: The ARN of the extension defined in the association.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: The parameter names and values defined for the association.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_arn: The ARN of the application, configuration profile, or environment to associate with the extension.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExtensionAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates an AppConfig Extension with a Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_topic = aws.sns.Topic("test", name="test")
        test = aws.iam.get_policy_document(statements=[{
            "actions": ["sts:AssumeRole"],
            "principals": [{
                "type": "Service",
                "identifiers": ["appconfig.amazonaws.com"],
            }],
        }])
        test_role = aws.iam.Role("test",
            name="test",
            assume_role_policy=test.json)
        test_extension = aws.appconfig.Extension("test",
            name="test",
            description="test description",
            action_points=[{
                "point": "ON_DEPLOYMENT_COMPLETE",
                "actions": [{
                    "name": "test",
                    "role_arn": test_role.arn,
                    "uri": test_topic.arn,
                }],
            }],
            tags={
                "Type": "AppConfig Extension",
            })
        test_application = aws.appconfig.Application("test", name="test")
        test_extension_association = aws.appconfig.ExtensionAssociation("test",
            extension_arn=test_extension.arn,
            resource_arn=test_application.arn)
        ```

        ## Import

        Using `pulumi import`, import AppConfig Extension Associations using their extension association ID. For example:

        ```sh
        $ pulumi import aws:appconfig/extensionAssociation:ExtensionAssociation example 71rxuzt
        ```

        :param str resource_name: The name of the resource.
        :param ExtensionAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExtensionAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extension_arn: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExtensionAssociationArgs.__new__(ExtensionAssociationArgs)

            if extension_arn is None and not opts.urn:
                raise TypeError("Missing required property 'extension_arn'")
            __props__.__dict__["extension_arn"] = extension_arn
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["region"] = region
            if resource_arn is None and not opts.urn:
                raise TypeError("Missing required property 'resource_arn'")
            __props__.__dict__["resource_arn"] = resource_arn
            __props__.__dict__["arn"] = None
            __props__.__dict__["extension_version"] = None
        super(ExtensionAssociation, __self__).__init__(
            'aws:appconfig/extensionAssociation:ExtensionAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            extension_arn: Optional[pulumi.Input[builtins.str]] = None,
            extension_version: Optional[pulumi.Input[builtins.int]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            resource_arn: Optional[pulumi.Input[builtins.str]] = None) -> 'ExtensionAssociation':
        """
        Get an existing ExtensionAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the AppConfig Extension Association.
        :param pulumi.Input[builtins.str] extension_arn: The ARN of the extension defined in the association.
        :param pulumi.Input[builtins.int] extension_version: The version number for the extension defined in the association.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: The parameter names and values defined for the association.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] resource_arn: The ARN of the application, configuration profile, or environment to associate with the extension.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExtensionAssociationState.__new__(_ExtensionAssociationState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["extension_arn"] = extension_arn
        __props__.__dict__["extension_version"] = extension_version
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_arn"] = resource_arn
        return ExtensionAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the AppConfig Extension Association.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="extensionArn")
    def extension_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the extension defined in the association.
        """
        return pulumi.get(self, "extension_arn")

    @property
    @pulumi.getter(name="extensionVersion")
    def extension_version(self) -> pulumi.Output[builtins.int]:
        """
        The version number for the extension defined in the association.
        """
        return pulumi.get(self, "extension_version")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The parameter names and values defined for the association.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the application, configuration profile, or environment to associate with the extension.
        """
        return pulumi.get(self, "resource_arn")

