# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppAuthorizationArgs', 'AppAuthorization']

@pulumi.input_type
class AppAuthorizationArgs:
    def __init__(__self__, *,
                 app: pulumi.Input[builtins.str],
                 app_bundle_arn: pulumi.Input[builtins.str],
                 auth_type: pulumi.Input[builtins.str],
                 credential: Optional[pulumi.Input['AppAuthorizationCredentialArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenants: Optional[pulumi.Input[Sequence[pulumi.Input['AppAuthorizationTenantArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['AppAuthorizationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AppAuthorization resource.
        :param pulumi.Input[builtins.str] app: The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
        :param pulumi.Input[builtins.str] app_bundle_arn: The Amazon Resource Name (ARN) of the app bundle to use for the request.
        :param pulumi.Input[builtins.str] auth_type: The authorization type for the app authorization valid values are oauth2 and apiKey.
        :param pulumi.Input['AppAuthorizationCredentialArgs'] credential: Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
               Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AppAuthorizationTenantArgs']]] tenants: Contains information about an application tenant, such as the application display name and identifier.
        """
        pulumi.set(__self__, "app", app)
        pulumi.set(__self__, "app_bundle_arn", app_bundle_arn)
        pulumi.set(__self__, "auth_type", auth_type)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenants is not None:
            pulumi.set(__self__, "tenants", tenants)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter
    def app(self) -> pulumi.Input[builtins.str]:
        """
        The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "app", value)

    @property
    @pulumi.getter(name="appBundleArn")
    def app_bundle_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the app bundle to use for the request.
        """
        return pulumi.get(self, "app_bundle_arn")

    @app_bundle_arn.setter
    def app_bundle_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "app_bundle_arn", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[builtins.str]:
        """
        The authorization type for the app authorization valid values are oauth2 and apiKey.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input['AppAuthorizationCredentialArgs']]:
        """
        Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
        Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input['AppAuthorizationCredentialArgs']]):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tenants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppAuthorizationTenantArgs']]]]:
        """
        Contains information about an application tenant, such as the application display name and identifier.
        """
        return pulumi.get(self, "tenants")

    @tenants.setter
    def tenants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppAuthorizationTenantArgs']]]]):
        pulumi.set(self, "tenants", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AppAuthorizationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AppAuthorizationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AppAuthorizationState:
    def __init__(__self__, *,
                 app: Optional[pulumi.Input[builtins.str]] = None,
                 app_bundle_arn: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 auth_type: Optional[pulumi.Input[builtins.str]] = None,
                 auth_url: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 credential: Optional[pulumi.Input['AppAuthorizationCredentialArgs']] = None,
                 persona: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenants: Optional[pulumi.Input[Sequence[pulumi.Input['AppAuthorizationTenantArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['AppAuthorizationTimeoutsArgs']] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppAuthorization resources.
        :param pulumi.Input[builtins.str] app: The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
        :param pulumi.Input[builtins.str] app_bundle_arn: The Amazon Resource Name (ARN) of the app bundle to use for the request.
        :param pulumi.Input[builtins.str] arn: ARN of the App Authorization. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
        :param pulumi.Input[builtins.str] auth_type: The authorization type for the app authorization valid values are oauth2 and apiKey.
        :param pulumi.Input[builtins.str] auth_url: The application URL for the OAuth flow.
        :param pulumi.Input['AppAuthorizationCredentialArgs'] credential: Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
               Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
        :param pulumi.Input[builtins.str] persona: The user persona of the app authorization.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AppAuthorizationTenantArgs']]] tenants: Contains information about an application tenant, such as the application display name and identifier.
        """
        if app is not None:
            pulumi.set(__self__, "app", app)
        if app_bundle_arn is not None:
            pulumi.set(__self__, "app_bundle_arn", app_bundle_arn)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if auth_url is not None:
            pulumi.set(__self__, "auth_url", auth_url)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if credential is not None:
            pulumi.set(__self__, "credential", credential)
        if persona is not None:
            pulumi.set(__self__, "persona", persona)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tenants is not None:
            pulumi.set(__self__, "tenants", tenants)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def app(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
        """
        return pulumi.get(self, "app")

    @app.setter
    def app(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app", value)

    @property
    @pulumi.getter(name="appBundleArn")
    def app_bundle_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the app bundle to use for the request.
        """
        return pulumi.get(self, "app_bundle_arn")

    @app_bundle_arn.setter
    def app_bundle_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_bundle_arn", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the App Authorization. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The authorization type for the app authorization valid values are oauth2 and apiKey.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The application URL for the OAuth flow.
        """
        return pulumi.get(self, "auth_url")

    @auth_url.setter
    def auth_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auth_url", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def credential(self) -> Optional[pulumi.Input['AppAuthorizationCredentialArgs']]:
        """
        Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
        Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: Optional[pulumi.Input['AppAuthorizationCredentialArgs']]):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter
    def persona(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user persona of the app authorization.
        """
        return pulumi.get(self, "persona")

    @persona.setter
    def persona(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "persona", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def tenants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppAuthorizationTenantArgs']]]]:
        """
        Contains information about an application tenant, such as the application display name and identifier.
        """
        return pulumi.get(self, "tenants")

    @tenants.setter
    def tenants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppAuthorizationTenantArgs']]]]):
        pulumi.set(self, "tenants", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AppAuthorizationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AppAuthorizationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("aws:appfabric/appAuthorization:AppAuthorization")
class AppAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[builtins.str]] = None,
                 app_bundle_arn: Optional[pulumi.Input[builtins.str]] = None,
                 auth_type: Optional[pulumi.Input[builtins.str]] = None,
                 credential: Optional[pulumi.Input[Union['AppAuthorizationCredentialArgs', 'AppAuthorizationCredentialArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppAuthorizationTenantArgs', 'AppAuthorizationTenantArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AppAuthorizationTimeoutsArgs', 'AppAuthorizationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS AppFabric App Authorization.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appfabric.AppAuthorization("example",
            app="TERRAFORMCLOUD",
            app_bundle_arn=arn,
            auth_type="apiKey",
            credential={
                "api_key_credentials": [{
                    "api_key": "exampleapikeytoken",
                }],
            },
            tenants=[{
                "tenant_display_name": "example",
                "tenant_identifier": "example",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app: The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
        :param pulumi.Input[builtins.str] app_bundle_arn: The Amazon Resource Name (ARN) of the app bundle to use for the request.
        :param pulumi.Input[builtins.str] auth_type: The authorization type for the app authorization valid values are oauth2 and apiKey.
        :param pulumi.Input[Union['AppAuthorizationCredentialArgs', 'AppAuthorizationCredentialArgsDict']] credential: Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
               Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppAuthorizationTenantArgs', 'AppAuthorizationTenantArgsDict']]]] tenants: Contains information about an application tenant, such as the application display name and identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS AppFabric App Authorization.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appfabric.AppAuthorization("example",
            app="TERRAFORMCLOUD",
            app_bundle_arn=arn,
            auth_type="apiKey",
            credential={
                "api_key_credentials": [{
                    "api_key": "exampleapikeytoken",
                }],
            },
            tenants=[{
                "tenant_display_name": "example",
                "tenant_identifier": "example",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param AppAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app: Optional[pulumi.Input[builtins.str]] = None,
                 app_bundle_arn: Optional[pulumi.Input[builtins.str]] = None,
                 auth_type: Optional[pulumi.Input[builtins.str]] = None,
                 credential: Optional[pulumi.Input[Union['AppAuthorizationCredentialArgs', 'AppAuthorizationCredentialArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppAuthorizationTenantArgs', 'AppAuthorizationTenantArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AppAuthorizationTimeoutsArgs', 'AppAuthorizationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppAuthorizationArgs.__new__(AppAuthorizationArgs)

            if app is None and not opts.urn:
                raise TypeError("Missing required property 'app'")
            __props__.__dict__["app"] = app
            if app_bundle_arn is None and not opts.urn:
                raise TypeError("Missing required property 'app_bundle_arn'")
            __props__.__dict__["app_bundle_arn"] = app_bundle_arn
            if auth_type is None and not opts.urn:
                raise TypeError("Missing required property 'auth_type'")
            __props__.__dict__["auth_type"] = auth_type
            __props__.__dict__["credential"] = credential
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenants"] = tenants
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["auth_url"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["persona"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["updated_at"] = None
        super(AppAuthorization, __self__).__init__(
            'aws:appfabric/appAuthorization:AppAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app: Optional[pulumi.Input[builtins.str]] = None,
            app_bundle_arn: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            auth_type: Optional[pulumi.Input[builtins.str]] = None,
            auth_url: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            credential: Optional[pulumi.Input[Union['AppAuthorizationCredentialArgs', 'AppAuthorizationCredentialArgsDict']]] = None,
            persona: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tenants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppAuthorizationTenantArgs', 'AppAuthorizationTenantArgsDict']]]]] = None,
            timeouts: Optional[pulumi.Input[Union['AppAuthorizationTimeoutsArgs', 'AppAuthorizationTimeoutsArgsDict']]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'AppAuthorization':
        """
        Get an existing AppAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app: The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
        :param pulumi.Input[builtins.str] app_bundle_arn: The Amazon Resource Name (ARN) of the app bundle to use for the request.
        :param pulumi.Input[builtins.str] arn: ARN of the App Authorization. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
        :param pulumi.Input[builtins.str] auth_type: The authorization type for the app authorization valid values are oauth2 and apiKey.
        :param pulumi.Input[builtins.str] auth_url: The application URL for the OAuth flow.
        :param pulumi.Input[Union['AppAuthorizationCredentialArgs', 'AppAuthorizationCredentialArgsDict']] credential: Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
               Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
        :param pulumi.Input[builtins.str] persona: The user persona of the app authorization.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppAuthorizationTenantArgs', 'AppAuthorizationTenantArgsDict']]]] tenants: Contains information about an application tenant, such as the application display name and identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppAuthorizationState.__new__(_AppAuthorizationState)

        __props__.__dict__["app"] = app
        __props__.__dict__["app_bundle_arn"] = app_bundle_arn
        __props__.__dict__["arn"] = arn
        __props__.__dict__["auth_type"] = auth_type
        __props__.__dict__["auth_url"] = auth_url
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["credential"] = credential
        __props__.__dict__["persona"] = persona
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tenants"] = tenants
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["updated_at"] = updated_at
        return AppAuthorization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def app(self) -> pulumi.Output[builtins.str]:
        """
        The name of the application for valid values see https://docs.aws.amazon.com/appfabric/latest/api/API_CreateAppAuthorization.html.
        """
        return pulumi.get(self, "app")

    @property
    @pulumi.getter(name="appBundleArn")
    def app_bundle_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the app bundle to use for the request.
        """
        return pulumi.get(self, "app_bundle_arn")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the App Authorization. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output[builtins.str]:
        """
        The authorization type for the app authorization valid values are oauth2 and apiKey.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> pulumi.Output[builtins.str]:
        """
        The application URL for the OAuth flow.
        """
        return pulumi.get(self, "auth_url")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Output[Optional['outputs.AppAuthorizationCredential']]:
        """
        Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
        Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (oauth2), then you should provide only the OAuth2 credentials.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter
    def persona(self) -> pulumi.Output[builtins.str]:
        """
        The user persona of the app authorization.
        """
        return pulumi.get(self, "persona")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def tenants(self) -> pulumi.Output[Optional[Sequence['outputs.AppAuthorizationTenant']]]:
        """
        Contains information about an application tenant, such as the application display name and identifier.
        """
        return pulumi.get(self, "tenants")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AppAuthorizationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated_at")

