# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEventIntegrationResult',
    'AwaitableGetEventIntegrationResult',
    'get_event_integration',
    'get_event_integration_output',
]

@pulumi.output_type
class GetEventIntegrationResult:
    """
    A collection of values returned by getEventIntegration.
    """
    def __init__(__self__, arn=None, description=None, event_filters=None, eventbridge_bus=None, id=None, name=None, region=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if event_filters and not isinstance(event_filters, list):
            raise TypeError("Expected argument 'event_filters' to be a list")
        pulumi.set(__self__, "event_filters", event_filters)
        if eventbridge_bus and not isinstance(eventbridge_bus, str):
            raise TypeError("Expected argument 'eventbridge_bus' to be a str")
        pulumi.set(__self__, "eventbridge_bus", eventbridge_bus)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The ARN of the AppIntegrations Event Integration.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the Event Integration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventFilters")
    def event_filters(self) -> Sequence['outputs.GetEventIntegrationEventFilterResult']:
        """
        A block that defines the configuration information for the event filter. The Event Filter block is documented below.
        """
        return pulumi.get(self, "event_filters")

    @property
    @pulumi.getter(name="eventbridgeBus")
    def eventbridge_bus(self) -> builtins.str:
        """
        The EventBridge bus.
        """
        return pulumi.get(self, "eventbridge_bus")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Metadata that you can assign to help organize the report plans you create.
        """
        return pulumi.get(self, "tags")


class AwaitableGetEventIntegrationResult(GetEventIntegrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEventIntegrationResult(
            arn=self.arn,
            description=self.description,
            event_filters=self.event_filters,
            eventbridge_bus=self.eventbridge_bus,
            id=self.id,
            name=self.name,
            region=self.region,
            tags=self.tags)


def get_event_integration(name: Optional[builtins.str] = None,
                          region: Optional[builtins.str] = None,
                          tags: Optional[Mapping[str, builtins.str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEventIntegrationResult:
    """
    Use this data source to get information on an existing AppIntegrations Event Integration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.appintegrations.get_event_integration(name="example")
    ```


    :param builtins.str name: The AppIntegrations Event Integration name.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Metadata that you can assign to help organize the report plans you create.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:appintegrations/getEventIntegration:getEventIntegration', __args__, opts=opts, typ=GetEventIntegrationResult).value

    return AwaitableGetEventIntegrationResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        event_filters=pulumi.get(__ret__, 'event_filters'),
        eventbridge_bus=pulumi.get(__ret__, 'eventbridge_bus'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_event_integration_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                 region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                 tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEventIntegrationResult]:
    """
    Use this data source to get information on an existing AppIntegrations Event Integration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.appintegrations.get_event_integration(name="example")
    ```


    :param builtins.str name: The AppIntegrations Event Integration name.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Metadata that you can assign to help organize the report plans you create.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:appintegrations/getEventIntegration:getEventIntegration', __args__, opts=opts, typ=GetEventIntegrationResult)
    return __ret__.apply(lambda __response__: GetEventIntegrationResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        event_filters=pulumi.get(__response__, 'event_filters'),
        eventbridge_bus=pulumi.get(__response__, 'eventbridge_bus'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
