# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualGatewayResult',
    'AwaitableGetVirtualGatewayResult',
    'get_virtual_gateway',
    'get_virtual_gateway_output',
]

@pulumi.output_type
class GetVirtualGatewayResult:
    """
    A collection of values returned by getVirtualGateway.
    """
    def __init__(__self__, arn=None, created_date=None, id=None, last_updated_date=None, mesh_name=None, mesh_owner=None, name=None, region=None, resource_owner=None, specs=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_date and not isinstance(last_updated_date, str):
            raise TypeError("Expected argument 'last_updated_date' to be a str")
        pulumi.set(__self__, "last_updated_date", last_updated_date)
        if mesh_name and not isinstance(mesh_name, str):
            raise TypeError("Expected argument 'mesh_name' to be a str")
        pulumi.set(__self__, "mesh_name", mesh_name)
        if mesh_owner and not isinstance(mesh_owner, str):
            raise TypeError("Expected argument 'mesh_owner' to be a str")
        pulumi.set(__self__, "mesh_owner", mesh_owner)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_owner and not isinstance(resource_owner, str):
            raise TypeError("Expected argument 'resource_owner' to be a str")
        pulumi.set(__self__, "resource_owner", resource_owner)
        if specs and not isinstance(specs, list):
            raise TypeError("Expected argument 'specs' to be a list")
        pulumi.set(__self__, "specs", specs)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        ARN of the virtual gateway.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> builtins.str:
        """
        Creation date of the virtual gateway.
        """
        return pulumi.get(self, "created_date")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> builtins.str:
        """
        Last update date of the virtual gateway.
        """
        return pulumi.get(self, "last_updated_date")

    @property
    @pulumi.getter(name="meshName")
    def mesh_name(self) -> builtins.str:
        return pulumi.get(self, "mesh_name")

    @property
    @pulumi.getter(name="meshOwner")
    def mesh_owner(self) -> builtins.str:
        return pulumi.get(self, "mesh_owner")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceOwner")
    def resource_owner(self) -> builtins.str:
        """
        Resource owner's AWS account ID.
        """
        return pulumi.get(self, "resource_owner")

    @property
    @pulumi.getter
    def specs(self) -> Sequence['outputs.GetVirtualGatewaySpecResult']:
        """
        Virtual gateway specification. See the `appmesh.VirtualGateway` resource for details.
        """
        return pulumi.get(self, "specs")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Map of tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetVirtualGatewayResult(GetVirtualGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualGatewayResult(
            arn=self.arn,
            created_date=self.created_date,
            id=self.id,
            last_updated_date=self.last_updated_date,
            mesh_name=self.mesh_name,
            mesh_owner=self.mesh_owner,
            name=self.name,
            region=self.region,
            resource_owner=self.resource_owner,
            specs=self.specs,
            tags=self.tags)


def get_virtual_gateway(mesh_name: Optional[builtins.str] = None,
                        name: Optional[builtins.str] = None,
                        region: Optional[builtins.str] = None,
                        tags: Optional[Mapping[str, builtins.str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualGatewayResult:
    """
    Data source for managing an AWS App Mesh Virtual Gateway.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.appmesh.get_virtual_gateway(mesh_name="mesh-gateway",
        name="example-mesh")
    ```


    :param builtins.str mesh_name: Name of the service mesh in which the virtual gateway exists.
    :param builtins.str name: Name of the virtual gateway.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags.
    """
    __args__ = dict()
    __args__['meshName'] = mesh_name
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:appmesh/getVirtualGateway:getVirtualGateway', __args__, opts=opts, typ=GetVirtualGatewayResult).value

    return AwaitableGetVirtualGatewayResult(
        arn=pulumi.get(__ret__, 'arn'),
        created_date=pulumi.get(__ret__, 'created_date'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_date=pulumi.get(__ret__, 'last_updated_date'),
        mesh_name=pulumi.get(__ret__, 'mesh_name'),
        mesh_owner=pulumi.get(__ret__, 'mesh_owner'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        resource_owner=pulumi.get(__ret__, 'resource_owner'),
        specs=pulumi.get(__ret__, 'specs'),
        tags=pulumi.get(__ret__, 'tags'))
def get_virtual_gateway_output(mesh_name: Optional[pulumi.Input[builtins.str]] = None,
                               name: Optional[pulumi.Input[builtins.str]] = None,
                               region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               tags: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualGatewayResult]:
    """
    Data source for managing an AWS App Mesh Virtual Gateway.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.appmesh.get_virtual_gateway(mesh_name="mesh-gateway",
        name="example-mesh")
    ```


    :param builtins.str mesh_name: Name of the service mesh in which the virtual gateway exists.
    :param builtins.str name: Name of the virtual gateway.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, builtins.str] tags: Map of tags.
    """
    __args__ = dict()
    __args__['meshName'] = mesh_name
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:appmesh/getVirtualGateway:getVirtualGateway', __args__, opts=opts, typ=GetVirtualGatewayResult)
    return __ret__.apply(lambda __response__: GetVirtualGatewayResult(
        arn=pulumi.get(__response__, 'arn'),
        created_date=pulumi.get(__response__, 'created_date'),
        id=pulumi.get(__response__, 'id'),
        last_updated_date=pulumi.get(__response__, 'last_updated_date'),
        mesh_name=pulumi.get(__response__, 'mesh_name'),
        mesh_owner=pulumi.get(__response__, 'mesh_owner'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        resource_owner=pulumi.get(__response__, 'resource_owner'),
        specs=pulumi.get(__response__, 'specs'),
        tags=pulumi.get(__response__, 'tags')))
