# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DirectoryConfigServiceAccountCredentialsArgs',
    'DirectoryConfigServiceAccountCredentialsArgsDict',
    'FleetComputeCapacityArgs',
    'FleetComputeCapacityArgsDict',
    'FleetDomainJoinInfoArgs',
    'FleetDomainJoinInfoArgsDict',
    'FleetVpcConfigArgs',
    'FleetVpcConfigArgsDict',
    'ImageBuilderAccessEndpointArgs',
    'ImageBuilderAccessEndpointArgsDict',
    'ImageBuilderDomainJoinInfoArgs',
    'ImageBuilderDomainJoinInfoArgsDict',
    'ImageBuilderVpcConfigArgs',
    'ImageBuilderVpcConfigArgsDict',
    'StackAccessEndpointArgs',
    'StackAccessEndpointArgsDict',
    'StackApplicationSettingsArgs',
    'StackApplicationSettingsArgsDict',
    'StackStorageConnectorArgs',
    'StackStorageConnectorArgsDict',
    'StackStreamingExperienceSettingsArgs',
    'StackStreamingExperienceSettingsArgsDict',
    'StackUserSettingArgs',
    'StackUserSettingArgsDict',
]

MYPY = False

if not MYPY:
    class DirectoryConfigServiceAccountCredentialsArgsDict(TypedDict):
        account_name: pulumi.Input[builtins.str]
        """
        User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
        """
        account_password: pulumi.Input[builtins.str]
        """
        Password for the account.
        """
elif False:
    DirectoryConfigServiceAccountCredentialsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DirectoryConfigServiceAccountCredentialsArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[builtins.str],
                 account_password: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] account_name: User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
        :param pulumi.Input[builtins.str] account_password: Password for the account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_password", account_password)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[builtins.str]:
        """
        User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> pulumi.Input[builtins.str]:
        """
        Password for the account.
        """
        return pulumi.get(self, "account_password")

    @account_password.setter
    def account_password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_password", value)


if not MYPY:
    class FleetComputeCapacityArgsDict(TypedDict):
        available: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of currently available instances that can be used to stream sessions.
        """
        desired_instances: NotRequired[pulumi.Input[builtins.int]]
        """
        Desired number of streaming instances.
        """
        desired_sessions: NotRequired[pulumi.Input[builtins.int]]
        """
        Desired number of user sessions for a multi-session fleet. This is not allowed for single-session fleets.
        """
        in_use: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of instances in use for streaming.
        """
        running: NotRequired[pulumi.Input[builtins.int]]
        """
        Total number of simultaneous streaming instances that are running.
        """
elif False:
    FleetComputeCapacityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetComputeCapacityArgs:
    def __init__(__self__, *,
                 available: Optional[pulumi.Input[builtins.int]] = None,
                 desired_instances: Optional[pulumi.Input[builtins.int]] = None,
                 desired_sessions: Optional[pulumi.Input[builtins.int]] = None,
                 in_use: Optional[pulumi.Input[builtins.int]] = None,
                 running: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] available: Number of currently available instances that can be used to stream sessions.
        :param pulumi.Input[builtins.int] desired_instances: Desired number of streaming instances.
        :param pulumi.Input[builtins.int] desired_sessions: Desired number of user sessions for a multi-session fleet. This is not allowed for single-session fleets.
        :param pulumi.Input[builtins.int] in_use: Number of instances in use for streaming.
        :param pulumi.Input[builtins.int] running: Total number of simultaneous streaming instances that are running.
        """
        if available is not None:
            pulumi.set(__self__, "available", available)
        if desired_instances is not None:
            pulumi.set(__self__, "desired_instances", desired_instances)
        if desired_sessions is not None:
            pulumi.set(__self__, "desired_sessions", desired_sessions)
        if in_use is not None:
            pulumi.set(__self__, "in_use", in_use)
        if running is not None:
            pulumi.set(__self__, "running", running)

    @property
    @pulumi.getter
    def available(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of currently available instances that can be used to stream sessions.
        """
        return pulumi.get(self, "available")

    @available.setter
    def available(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "available", value)

    @property
    @pulumi.getter(name="desiredInstances")
    def desired_instances(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Desired number of streaming instances.
        """
        return pulumi.get(self, "desired_instances")

    @desired_instances.setter
    def desired_instances(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "desired_instances", value)

    @property
    @pulumi.getter(name="desiredSessions")
    def desired_sessions(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Desired number of user sessions for a multi-session fleet. This is not allowed for single-session fleets.
        """
        return pulumi.get(self, "desired_sessions")

    @desired_sessions.setter
    def desired_sessions(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "desired_sessions", value)

    @property
    @pulumi.getter(name="inUse")
    def in_use(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of instances in use for streaming.
        """
        return pulumi.get(self, "in_use")

    @in_use.setter
    def in_use(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "in_use", value)

    @property
    @pulumi.getter
    def running(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total number of simultaneous streaming instances that are running.
        """
        return pulumi.get(self, "running")

    @running.setter
    def running(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "running", value)


if not MYPY:
    class FleetDomainJoinInfoArgsDict(TypedDict):
        directory_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Fully qualified name of the directory (for example, corp.example.com).
        """
        organizational_unit_distinguished_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Distinguished name of the organizational unit for computer accounts.
        """
elif False:
    FleetDomainJoinInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetDomainJoinInfoArgs:
    def __init__(__self__, *,
                 directory_name: Optional[pulumi.Input[builtins.str]] = None,
                 organizational_unit_distinguished_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] directory_name: Fully qualified name of the directory (for example, corp.example.com).
        :param pulumi.Input[builtins.str] organizational_unit_distinguished_name: Distinguished name of the organizational unit for computer accounts.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fully qualified name of the directory (for example, corp.example.com).
        """
        return pulumi.get(self, "directory_name")

    @directory_name.setter
    def directory_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_name", value)

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Distinguished name of the organizational unit for computer accounts.
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @organizational_unit_distinguished_name.setter
    def organizational_unit_distinguished_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organizational_unit_distinguished_name", value)


if not MYPY:
    class FleetVpcConfigArgsDict(TypedDict):
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Identifiers of the security groups for the fleet or image builder.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
        """
elif False:
    FleetVpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FleetVpcConfigArgs:
    def __init__(__self__, *,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: Identifiers of the security groups for the fleet or image builder.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Identifiers of the security groups for the fleet or image builder.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)


if not MYPY:
    class ImageBuilderAccessEndpointArgsDict(TypedDict):
        endpoint_type: pulumi.Input[builtins.str]
        """
        Type of interface endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html).
        """
        vpce_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Identifier (ID) of the interface VPC endpoint.
        """
elif False:
    ImageBuilderAccessEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ImageBuilderAccessEndpointArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[builtins.str],
                 vpce_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] endpoint_type: Type of interface endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html).
        :param pulumi.Input[builtins.str] vpce_id: Identifier (ID) of the interface VPC endpoint.
        """
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if vpce_id is not None:
            pulumi.set(__self__, "vpce_id", vpce_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[builtins.str]:
        """
        Type of interface endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html).
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="vpceId")
    def vpce_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Identifier (ID) of the interface VPC endpoint.
        """
        return pulumi.get(self, "vpce_id")

    @vpce_id.setter
    def vpce_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpce_id", value)


if not MYPY:
    class ImageBuilderDomainJoinInfoArgsDict(TypedDict):
        directory_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Fully qualified name of the directory (for example, corp.example.com).
        """
        organizational_unit_distinguished_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Distinguished name of the organizational unit for computer accounts.
        """
elif False:
    ImageBuilderDomainJoinInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ImageBuilderDomainJoinInfoArgs:
    def __init__(__self__, *,
                 directory_name: Optional[pulumi.Input[builtins.str]] = None,
                 organizational_unit_distinguished_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] directory_name: Fully qualified name of the directory (for example, corp.example.com).
        :param pulumi.Input[builtins.str] organizational_unit_distinguished_name: Distinguished name of the organizational unit for computer accounts.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fully qualified name of the directory (for example, corp.example.com).
        """
        return pulumi.get(self, "directory_name")

    @directory_name.setter
    def directory_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_name", value)

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Distinguished name of the organizational unit for computer accounts.
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")

    @organizational_unit_distinguished_name.setter
    def organizational_unit_distinguished_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organizational_unit_distinguished_name", value)


if not MYPY:
    class ImageBuilderVpcConfigArgsDict(TypedDict):
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Identifiers of the security groups for the image builder or image builder.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Identifier of the subnet to which a network interface is attached from the image builder instance.
        """
elif False:
    ImageBuilderVpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ImageBuilderVpcConfigArgs:
    def __init__(__self__, *,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: Identifiers of the security groups for the image builder or image builder.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: Identifier of the subnet to which a network interface is attached from the image builder instance.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Identifiers of the security groups for the image builder or image builder.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Identifier of the subnet to which a network interface is attached from the image builder instance.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)


if not MYPY:
    class StackAccessEndpointArgsDict(TypedDict):
        endpoint_type: pulumi.Input[builtins.str]
        """
        Type of the interface endpoint.
        See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
        """
        vpce_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID of the VPC in which the interface endpoint is used.
        """
elif False:
    StackAccessEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackAccessEndpointArgs:
    def __init__(__self__, *,
                 endpoint_type: pulumi.Input[builtins.str],
                 vpce_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] endpoint_type: Type of the interface endpoint.
               See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
        :param pulumi.Input[builtins.str] vpce_id: ID of the VPC in which the interface endpoint is used.
        """
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if vpce_id is not None:
            pulumi.set(__self__, "vpce_id", vpce_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Input[builtins.str]:
        """
        Type of the interface endpoint.
        See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="vpceId")
    def vpce_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the VPC in which the interface endpoint is used.
        """
        return pulumi.get(self, "vpce_id")

    @vpce_id.setter
    def vpce_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpce_id", value)


if not MYPY:
    class StackApplicationSettingsArgsDict(TypedDict):
        enabled: pulumi.Input[builtins.bool]
        """
        Whether application settings should be persisted.
        """
        settings_group: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the settings group.
        Required when `enabled` is `true`.
        Can be up to 100 characters.
        """
elif False:
    StackApplicationSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackApplicationSettingsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[builtins.bool],
                 settings_group: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] enabled: Whether application settings should be persisted.
        :param pulumi.Input[builtins.str] settings_group: Name of the settings group.
               Required when `enabled` is `true`.
               Can be up to 100 characters.
        """
        pulumi.set(__self__, "enabled", enabled)
        if settings_group is not None:
            pulumi.set(__self__, "settings_group", settings_group)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Whether application settings should be persisted.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="settingsGroup")
    def settings_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the settings group.
        Required when `enabled` is `true`.
        Can be up to 100 characters.
        """
        return pulumi.get(self, "settings_group")

    @settings_group.setter
    def settings_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "settings_group", value)


if not MYPY:
    class StackStorageConnectorArgsDict(TypedDict):
        connector_type: pulumi.Input[builtins.str]
        """
        Type of storage connector.
        Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
        """
        domains: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Names of the domains for the account.
        """
        resource_identifier: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN of the storage connector.
        """
elif False:
    StackStorageConnectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackStorageConnectorArgs:
    def __init__(__self__, *,
                 connector_type: pulumi.Input[builtins.str],
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] connector_type: Type of storage connector.
               Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] domains: Names of the domains for the account.
        :param pulumi.Input[builtins.str] resource_identifier: ARN of the storage connector.
        """
        pulumi.set(__self__, "connector_type", connector_type)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if resource_identifier is not None:
            pulumi.set(__self__, "resource_identifier", resource_identifier)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> pulumi.Input[builtins.str]:
        """
        Type of storage connector.
        Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
        """
        return pulumi.get(self, "connector_type")

    @connector_type.setter
    def connector_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connector_type", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Names of the domains for the account.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the storage connector.
        """
        return pulumi.get(self, "resource_identifier")

    @resource_identifier.setter
    def resource_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_identifier", value)


if not MYPY:
    class StackStreamingExperienceSettingsArgsDict(TypedDict):
        preferred_protocol: NotRequired[pulumi.Input[builtins.str]]
        """
        The preferred protocol that you want to use while streaming your application.
        Valid values are `TCP` and `UDP`.
        """
elif False:
    StackStreamingExperienceSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackStreamingExperienceSettingsArgs:
    def __init__(__self__, *,
                 preferred_protocol: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] preferred_protocol: The preferred protocol that you want to use while streaming your application.
               Valid values are `TCP` and `UDP`.
        """
        if preferred_protocol is not None:
            pulumi.set(__self__, "preferred_protocol", preferred_protocol)

    @property
    @pulumi.getter(name="preferredProtocol")
    def preferred_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The preferred protocol that you want to use while streaming your application.
        Valid values are `TCP` and `UDP`.
        """
        return pulumi.get(self, "preferred_protocol")

    @preferred_protocol.setter
    def preferred_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "preferred_protocol", value)


if not MYPY:
    class StackUserSettingArgsDict(TypedDict):
        action: pulumi.Input[builtins.str]
        """
        Action that is enabled or disabled.
        Valid values are `AUTO_TIME_ZONE_REDIRECTION`, `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`, `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, `DOMAIN_SMART_CARD_SIGNIN`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, or `PRINTING_TO_LOCAL_DEVICE`.
        """
        permission: pulumi.Input[builtins.str]
        """
        Whether the action is enabled or disabled.
        Valid values are `ENABLED` or `DISABLED`.
        """
elif False:
    StackUserSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StackUserSettingArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 permission: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] action: Action that is enabled or disabled.
               Valid values are `AUTO_TIME_ZONE_REDIRECTION`, `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`, `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, `DOMAIN_SMART_CARD_SIGNIN`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, or `PRINTING_TO_LOCAL_DEVICE`.
        :param pulumi.Input[builtins.str] permission: Whether the action is enabled or disabled.
               Valid values are `ENABLED` or `DISABLED`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        Action that is enabled or disabled.
        Valid values are `AUTO_TIME_ZONE_REDIRECTION`, `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`, `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, `DOMAIN_SMART_CARD_SIGNIN`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, or `PRINTING_TO_LOCAL_DEVICE`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def permission(self) -> pulumi.Input[builtins.str]:
        """
        Whether the action is enabled or disabled.
        Valid values are `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "permission", value)


