# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DirectoryConfigServiceAccountCredentials',
    'FleetComputeCapacity',
    'FleetDomainJoinInfo',
    'FleetVpcConfig',
    'ImageBuilderAccessEndpoint',
    'ImageBuilderDomainJoinInfo',
    'ImageBuilderVpcConfig',
    'StackAccessEndpoint',
    'StackApplicationSettings',
    'StackStorageConnector',
    'StackStreamingExperienceSettings',
    'StackUserSetting',
    'GetImageApplicationResult',
    'GetImageApplicationIconS3LocationResult',
    'GetImageImagePermissionResult',
    'GetImageStateChangeReasonResult',
]

@pulumi.output_type
class DirectoryConfigServiceAccountCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountName":
            suggest = "account_name"
        elif key == "accountPassword":
            suggest = "account_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryConfigServiceAccountCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryConfigServiceAccountCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryConfigServiceAccountCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_name: builtins.str,
                 account_password: builtins.str):
        """
        :param builtins.str account_name: User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
        :param builtins.str account_password: Password for the account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_password", account_password)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> builtins.str:
        """
        User name of the account. This account must have the following privileges: create computer objects, join computers to the domain, and change/reset the password on descendant computer objects for the organizational units specified.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountPassword")
    def account_password(self) -> builtins.str:
        """
        Password for the account.
        """
        return pulumi.get(self, "account_password")


@pulumi.output_type
class FleetComputeCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredInstances":
            suggest = "desired_instances"
        elif key == "desiredSessions":
            suggest = "desired_sessions"
        elif key == "inUse":
            suggest = "in_use"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetComputeCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetComputeCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetComputeCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available: Optional[builtins.int] = None,
                 desired_instances: Optional[builtins.int] = None,
                 desired_sessions: Optional[builtins.int] = None,
                 in_use: Optional[builtins.int] = None,
                 running: Optional[builtins.int] = None):
        """
        :param builtins.int available: Number of currently available instances that can be used to stream sessions.
        :param builtins.int desired_instances: Desired number of streaming instances.
        :param builtins.int desired_sessions: Desired number of user sessions for a multi-session fleet. This is not allowed for single-session fleets.
        :param builtins.int in_use: Number of instances in use for streaming.
        :param builtins.int running: Total number of simultaneous streaming instances that are running.
        """
        if available is not None:
            pulumi.set(__self__, "available", available)
        if desired_instances is not None:
            pulumi.set(__self__, "desired_instances", desired_instances)
        if desired_sessions is not None:
            pulumi.set(__self__, "desired_sessions", desired_sessions)
        if in_use is not None:
            pulumi.set(__self__, "in_use", in_use)
        if running is not None:
            pulumi.set(__self__, "running", running)

    @property
    @pulumi.getter
    def available(self) -> Optional[builtins.int]:
        """
        Number of currently available instances that can be used to stream sessions.
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter(name="desiredInstances")
    def desired_instances(self) -> Optional[builtins.int]:
        """
        Desired number of streaming instances.
        """
        return pulumi.get(self, "desired_instances")

    @property
    @pulumi.getter(name="desiredSessions")
    def desired_sessions(self) -> Optional[builtins.int]:
        """
        Desired number of user sessions for a multi-session fleet. This is not allowed for single-session fleets.
        """
        return pulumi.get(self, "desired_sessions")

    @property
    @pulumi.getter(name="inUse")
    def in_use(self) -> Optional[builtins.int]:
        """
        Number of instances in use for streaming.
        """
        return pulumi.get(self, "in_use")

    @property
    @pulumi.getter
    def running(self) -> Optional[builtins.int]:
        """
        Total number of simultaneous streaming instances that are running.
        """
        return pulumi.get(self, "running")


@pulumi.output_type
class FleetDomainJoinInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryName":
            suggest = "directory_name"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetDomainJoinInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetDomainJoinInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetDomainJoinInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_name: Optional[builtins.str] = None,
                 organizational_unit_distinguished_name: Optional[builtins.str] = None):
        """
        :param builtins.str directory_name: Fully qualified name of the directory (for example, corp.example.com).
        :param builtins.str organizational_unit_distinguished_name: Distinguished name of the organizational unit for computer accounts.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[builtins.str]:
        """
        Fully qualified name of the directory (for example, corp.example.com).
        """
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[builtins.str]:
        """
        Distinguished name of the organizational unit for computer accounts.
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")


@pulumi.output_type
class FleetVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 subnet_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] security_group_ids: Identifiers of the security groups for the fleet or image builder.
        :param Sequence[builtins.str] subnet_ids: Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Identifiers of the security groups for the fleet or image builder.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class ImageBuilderAccessEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "vpceId":
            suggest = "vpce_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageBuilderAccessEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageBuilderAccessEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageBuilderAccessEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: builtins.str,
                 vpce_id: Optional[builtins.str] = None):
        """
        :param builtins.str endpoint_type: Type of interface endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html).
        :param builtins.str vpce_id: Identifier (ID) of the interface VPC endpoint.
        """
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if vpce_id is not None:
            pulumi.set(__self__, "vpce_id", vpce_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> builtins.str:
        """
        Type of interface endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html).
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="vpceId")
    def vpce_id(self) -> Optional[builtins.str]:
        """
        Identifier (ID) of the interface VPC endpoint.
        """
        return pulumi.get(self, "vpce_id")


@pulumi.output_type
class ImageBuilderDomainJoinInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryName":
            suggest = "directory_name"
        elif key == "organizationalUnitDistinguishedName":
            suggest = "organizational_unit_distinguished_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageBuilderDomainJoinInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageBuilderDomainJoinInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageBuilderDomainJoinInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_name: Optional[builtins.str] = None,
                 organizational_unit_distinguished_name: Optional[builtins.str] = None):
        """
        :param builtins.str directory_name: Fully qualified name of the directory (for example, corp.example.com).
        :param builtins.str organizational_unit_distinguished_name: Distinguished name of the organizational unit for computer accounts.
        """
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if organizational_unit_distinguished_name is not None:
            pulumi.set(__self__, "organizational_unit_distinguished_name", organizational_unit_distinguished_name)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[builtins.str]:
        """
        Fully qualified name of the directory (for example, corp.example.com).
        """
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="organizationalUnitDistinguishedName")
    def organizational_unit_distinguished_name(self) -> Optional[builtins.str]:
        """
        Distinguished name of the organizational unit for computer accounts.
        """
        return pulumi.get(self, "organizational_unit_distinguished_name")


@pulumi.output_type
class ImageBuilderVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageBuilderVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageBuilderVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageBuilderVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 subnet_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] security_group_ids: Identifiers of the security groups for the image builder or image builder.
        :param Sequence[builtins.str] subnet_ids: Identifier of the subnet to which a network interface is attached from the image builder instance.
        """
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Identifiers of the security groups for the image builder or image builder.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Identifier of the subnet to which a network interface is attached from the image builder instance.
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class StackAccessEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "vpceId":
            suggest = "vpce_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackAccessEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackAccessEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackAccessEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: builtins.str,
                 vpce_id: Optional[builtins.str] = None):
        """
        :param builtins.str endpoint_type: Type of the interface endpoint.
               See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
        :param builtins.str vpce_id: ID of the VPC in which the interface endpoint is used.
        """
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if vpce_id is not None:
            pulumi.set(__self__, "vpce_id", vpce_id)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> builtins.str:
        """
        Type of the interface endpoint.
        See the [`AccessEndpoint` AWS API documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_AccessEndpoint.html) for valid values.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="vpceId")
    def vpce_id(self) -> Optional[builtins.str]:
        """
        ID of the VPC in which the interface endpoint is used.
        """
        return pulumi.get(self, "vpce_id")


@pulumi.output_type
class StackApplicationSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "settingsGroup":
            suggest = "settings_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackApplicationSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackApplicationSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackApplicationSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 settings_group: Optional[builtins.str] = None):
        """
        :param builtins.bool enabled: Whether application settings should be persisted.
        :param builtins.str settings_group: Name of the settings group.
               Required when `enabled` is `true`.
               Can be up to 100 characters.
        """
        pulumi.set(__self__, "enabled", enabled)
        if settings_group is not None:
            pulumi.set(__self__, "settings_group", settings_group)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Whether application settings should be persisted.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="settingsGroup")
    def settings_group(self) -> Optional[builtins.str]:
        """
        Name of the settings group.
        Required when `enabled` is `true`.
        Can be up to 100 characters.
        """
        return pulumi.get(self, "settings_group")


@pulumi.output_type
class StackStorageConnector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectorType":
            suggest = "connector_type"
        elif key == "resourceIdentifier":
            suggest = "resource_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackStorageConnector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackStorageConnector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackStorageConnector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector_type: builtins.str,
                 domains: Optional[Sequence[builtins.str]] = None,
                 resource_identifier: Optional[builtins.str] = None):
        """
        :param builtins.str connector_type: Type of storage connector.
               Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
        :param Sequence[builtins.str] domains: Names of the domains for the account.
        :param builtins.str resource_identifier: ARN of the storage connector.
        """
        pulumi.set(__self__, "connector_type", connector_type)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if resource_identifier is not None:
            pulumi.set(__self__, "resource_identifier", resource_identifier)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> builtins.str:
        """
        Type of storage connector.
        Valid values are `HOMEFOLDERS`, `GOOGLE_DRIVE`, or `ONE_DRIVE`.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[builtins.str]]:
        """
        Names of the domains for the account.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[builtins.str]:
        """
        ARN of the storage connector.
        """
        return pulumi.get(self, "resource_identifier")


@pulumi.output_type
class StackStreamingExperienceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredProtocol":
            suggest = "preferred_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackStreamingExperienceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackStreamingExperienceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackStreamingExperienceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_protocol: Optional[builtins.str] = None):
        """
        :param builtins.str preferred_protocol: The preferred protocol that you want to use while streaming your application.
               Valid values are `TCP` and `UDP`.
        """
        if preferred_protocol is not None:
            pulumi.set(__self__, "preferred_protocol", preferred_protocol)

    @property
    @pulumi.getter(name="preferredProtocol")
    def preferred_protocol(self) -> Optional[builtins.str]:
        """
        The preferred protocol that you want to use while streaming your application.
        Valid values are `TCP` and `UDP`.
        """
        return pulumi.get(self, "preferred_protocol")


@pulumi.output_type
class StackUserSetting(dict):
    def __init__(__self__, *,
                 action: builtins.str,
                 permission: builtins.str):
        """
        :param builtins.str action: Action that is enabled or disabled.
               Valid values are `AUTO_TIME_ZONE_REDIRECTION`, `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`, `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, `DOMAIN_SMART_CARD_SIGNIN`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, or `PRINTING_TO_LOCAL_DEVICE`.
        :param builtins.str permission: Whether the action is enabled or disabled.
               Valid values are `ENABLED` or `DISABLED`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "permission", permission)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Action that is enabled or disabled.
        Valid values are `AUTO_TIME_ZONE_REDIRECTION`, `CLIPBOARD_COPY_FROM_LOCAL_DEVICE`, `CLIPBOARD_COPY_TO_LOCAL_DEVICE`, `DOMAIN_PASSWORD_SIGNIN`, `DOMAIN_SMART_CARD_SIGNIN`, `FILE_UPLOAD`, `FILE_DOWNLOAD`, or `PRINTING_TO_LOCAL_DEVICE`.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def permission(self) -> builtins.str:
        """
        Whether the action is enabled or disabled.
        Valid values are `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "permission")


@pulumi.output_type
class GetImageApplicationResult(dict):
    def __init__(__self__, *,
                 app_block_arn: builtins.str,
                 arn: builtins.str,
                 created_time: builtins.str,
                 description: builtins.str,
                 display_name: builtins.str,
                 enabled: builtins.bool,
                 icon_s3_locations: Sequence['outputs.GetImageApplicationIconS3LocationResult'],
                 icon_url: builtins.str,
                 instance_families: Sequence[builtins.str],
                 launch_parameters: builtins.str,
                 launch_path: builtins.str,
                 metadata: Mapping[str, builtins.str],
                 name: builtins.str,
                 platforms: Sequence[builtins.str],
                 working_directory: builtins.str):
        """
        :param builtins.str app_block_arn: The app block ARN of the application.
        :param builtins.str arn: Arn of the image being searched for. Cannot be used with name_regex or name.
        :param builtins.str created_time: Time at which this image was created.
        :param builtins.str description: Description of image.
        :param builtins.str display_name: Image name to display.
        :param builtins.bool enabled: Bool based on if the application is enabled.
        :param Sequence['GetImageApplicationIconS3LocationArgs'] icon_s3_locations: A list named icon_s3_location that contains the following:
        :param builtins.str icon_url: URL of the application icon. This URL may be time-limited.
        :param Sequence[builtins.str] instance_families: List of the instance families of the application.
        :param builtins.str launch_parameters: Arguments that are passed to the application at it's launch.
        :param builtins.str launch_path: Path to the application's excecutable in the instance.
        :param Mapping[str, builtins.str] metadata: String to string map that contains additional attributes used to describe the application.
               * `Name` - Name of the application.
        :param builtins.str name: Name of the image being searched for. Cannot be used with name_regex or arn.
        :param Sequence[builtins.str] platforms: Array of strings describing the platforms on which the application can run.
               Values will be from: WINDOWS | WINDOWS_SERVER_2016 | WINDOWS_SERVER_2019 | WINDOWS_SERVER_2022 | AMAZON_LINUX2
        :param builtins.str working_directory: Working directory for the application.
        """
        pulumi.set(__self__, "app_block_arn", app_block_arn)
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "icon_s3_locations", icon_s3_locations)
        pulumi.set(__self__, "icon_url", icon_url)
        pulumi.set(__self__, "instance_families", instance_families)
        pulumi.set(__self__, "launch_parameters", launch_parameters)
        pulumi.set(__self__, "launch_path", launch_path)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "platforms", platforms)
        pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter(name="appBlockArn")
    def app_block_arn(self) -> builtins.str:
        """
        The app block ARN of the application.
        """
        return pulumi.get(self, "app_block_arn")

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        Arn of the image being searched for. Cannot be used with name_regex or name.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> builtins.str:
        """
        Time at which this image was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of image.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Image name to display.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Bool based on if the application is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="iconS3Locations")
    def icon_s3_locations(self) -> Sequence['outputs.GetImageApplicationIconS3LocationResult']:
        """
        A list named icon_s3_location that contains the following:
        """
        return pulumi.get(self, "icon_s3_locations")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> builtins.str:
        """
        URL of the application icon. This URL may be time-limited.
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter(name="instanceFamilies")
    def instance_families(self) -> Sequence[builtins.str]:
        """
        List of the instance families of the application.
        """
        return pulumi.get(self, "instance_families")

    @property
    @pulumi.getter(name="launchParameters")
    def launch_parameters(self) -> builtins.str:
        """
        Arguments that are passed to the application at it's launch.
        """
        return pulumi.get(self, "launch_parameters")

    @property
    @pulumi.getter(name="launchPath")
    def launch_path(self) -> builtins.str:
        """
        Path to the application's excecutable in the instance.
        """
        return pulumi.get(self, "launch_path")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, builtins.str]:
        """
        String to string map that contains additional attributes used to describe the application.
        * `Name` - Name of the application.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the image being searched for. Cannot be used with name_regex or arn.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def platforms(self) -> Sequence[builtins.str]:
        """
        Array of strings describing the platforms on which the application can run.
        Values will be from: WINDOWS | WINDOWS_SERVER_2016 | WINDOWS_SERVER_2019 | WINDOWS_SERVER_2022 | AMAZON_LINUX2
        """
        return pulumi.get(self, "platforms")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> builtins.str:
        """
        Working directory for the application.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class GetImageApplicationIconS3LocationResult(dict):
    def __init__(__self__, *,
                 s3_bucket: builtins.str,
                 s3_key: builtins.str):
        """
        :param builtins.str s3_bucket: S3 bucket of the S3 object.
        :param builtins.str s3_key: S3 key of the S3 object.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_key", s3_key)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> builtins.str:
        """
        S3 bucket of the S3 object.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> builtins.str:
        """
        S3 key of the S3 object.
        """
        return pulumi.get(self, "s3_key")


@pulumi.output_type
class GetImageImagePermissionResult(dict):
    def __init__(__self__, *,
                 allow_fleet: builtins.bool,
                 allow_image_builder: builtins.bool):
        """
        :param builtins.bool allow_fleet: Boolean indicating if the image can be used for a fleet.
        :param builtins.bool allow_image_builder: indicated whether the image can be used for an image builder.
        """
        pulumi.set(__self__, "allow_fleet", allow_fleet)
        pulumi.set(__self__, "allow_image_builder", allow_image_builder)

    @property
    @pulumi.getter(name="allowFleet")
    def allow_fleet(self) -> builtins.bool:
        """
        Boolean indicating if the image can be used for a fleet.
        """
        return pulumi.get(self, "allow_fleet")

    @property
    @pulumi.getter(name="allowImageBuilder")
    def allow_image_builder(self) -> builtins.bool:
        """
        indicated whether the image can be used for an image builder.
        """
        return pulumi.get(self, "allow_image_builder")


@pulumi.output_type
class GetImageStateChangeReasonResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 message: builtins.str):
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        return pulumi.get(self, "message")


