# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[builtins.str],
                 user_name: pulumi.Input[builtins.str],
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 send_email_notification: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] authentication_type: Authentication type for the user. You must specify USERPOOL. Valid values: `API`, `SAML`, `USERPOOL`
        :param pulumi.Input[builtins.str] user_name: Email address of the user.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.bool] enabled: Whether the user in the user pool is enabled.
        :param pulumi.Input[builtins.str] first_name: First name, or given name, of the user.
        :param pulumi.Input[builtins.str] last_name: Last name, or surname, of the user.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] send_email_notification: Send an email notification.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        pulumi.set(__self__, "user_name", user_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if send_email_notification is not None:
            pulumi.set(__self__, "send_email_notification", send_email_notification)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[builtins.str]:
        """
        Authentication type for the user. You must specify USERPOOL. Valid values: `API`, `SAML`, `USERPOOL`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[builtins.str]:
        """
        Email address of the user.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the user in the user pool is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        First name, or given name, of the user.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last name, or surname, of the user.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sendEmailNotification")
    def send_email_notification(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Send an email notification.
        """
        return pulumi.get(self, "send_email_notification")

    @send_email_notification.setter
    def send_email_notification(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "send_email_notification", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 created_time: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 send_email_notification: Optional[pulumi.Input[builtins.bool]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[builtins.str] arn: ARN of the appstream user.
        :param pulumi.Input[builtins.str] authentication_type: Authentication type for the user. You must specify USERPOOL. Valid values: `API`, `SAML`, `USERPOOL`
        :param pulumi.Input[builtins.str] created_time: Date and time, in UTC and extended RFC 3339 format, when the user was created.
        :param pulumi.Input[builtins.bool] enabled: Whether the user in the user pool is enabled.
        :param pulumi.Input[builtins.str] first_name: First name, or given name, of the user.
        :param pulumi.Input[builtins.str] last_name: Last name, or surname, of the user.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] send_email_notification: Send an email notification.
        :param pulumi.Input[builtins.str] user_name: Email address of the user.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if send_email_notification is not None:
            pulumi.set(__self__, "send_email_notification", send_email_notification)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the appstream user.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Authentication type for the user. You must specify USERPOOL. Valid values: `API`, `SAML`, `USERPOOL`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the user was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the user in the user pool is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        First name, or given name, of the user.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Last name, or surname, of the user.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sendEmailNotification")
    def send_email_notification(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Send an email notification.
        """
        return pulumi.get(self, "send_email_notification")

    @send_email_notification.setter
    def send_email_notification(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "send_email_notification", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Email address of the user.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)


@pulumi.type_token("aws:appstream/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 send_email_notification: Optional[pulumi.Input[builtins.bool]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an AppStream user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appstream.User("example",
            authentication_type="USERPOOL",
            user_name="EMAIL",
            first_name="FIRST NAME",
            last_name="LAST NAME")
        ```

        ## Import

        Using `pulumi import`, import `aws_appstream_user` using the `user_name` and `authentication_type` separated by a slash (`/`). For example:

        ```sh
        $ pulumi import aws:appstream/user:User example UserName/AuthenticationType
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_type: Authentication type for the user. You must specify USERPOOL. Valid values: `API`, `SAML`, `USERPOOL`
        :param pulumi.Input[builtins.bool] enabled: Whether the user in the user pool is enabled.
        :param pulumi.Input[builtins.str] first_name: First name, or given name, of the user.
        :param pulumi.Input[builtins.str] last_name: Last name, or surname, of the user.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] send_email_notification: Send an email notification.
        :param pulumi.Input[builtins.str] user_name: Email address of the user.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppStream user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appstream.User("example",
            authentication_type="USERPOOL",
            user_name="EMAIL",
            first_name="FIRST NAME",
            last_name="LAST NAME")
        ```

        ## Import

        Using `pulumi import`, import `aws_appstream_user` using the `user_name` and `authentication_type` separated by a slash (`/`). For example:

        ```sh
        $ pulumi import aws:appstream/user:User example UserName/AuthenticationType
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_type: Optional[pulumi.Input[builtins.str]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 first_name: Optional[pulumi.Input[builtins.str]] = None,
                 last_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 send_email_notification: Optional[pulumi.Input[builtins.bool]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if authentication_type is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_type'")
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["region"] = region
            __props__.__dict__["send_email_notification"] = send_email_notification
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
        super(User, __self__).__init__(
            'aws:appstream/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            authentication_type: Optional[pulumi.Input[builtins.str]] = None,
            created_time: Optional[pulumi.Input[builtins.str]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            first_name: Optional[pulumi.Input[builtins.str]] = None,
            last_name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            send_email_notification: Optional[pulumi.Input[builtins.bool]] = None,
            user_name: Optional[pulumi.Input[builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: ARN of the appstream user.
        :param pulumi.Input[builtins.str] authentication_type: Authentication type for the user. You must specify USERPOOL. Valid values: `API`, `SAML`, `USERPOOL`
        :param pulumi.Input[builtins.str] created_time: Date and time, in UTC and extended RFC 3339 format, when the user was created.
        :param pulumi.Input[builtins.bool] enabled: Whether the user in the user pool is enabled.
        :param pulumi.Input[builtins.str] first_name: First name, or given name, of the user.
        :param pulumi.Input[builtins.str] last_name: Last name, or surname, of the user.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.bool] send_email_notification: Send an email notification.
        :param pulumi.Input[builtins.str] user_name: Email address of the user.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["region"] = region
        __props__.__dict__["send_email_notification"] = send_email_notification
        __props__.__dict__["user_name"] = user_name
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the appstream user.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[builtins.str]:
        """
        Authentication type for the user. You must specify USERPOOL. Valid values: `API`, `SAML`, `USERPOOL`
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[builtins.str]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the user was created.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the user in the user pool is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        First name, or given name, of the user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Last name, or surname, of the user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sendEmailNotification")
    def send_email_notification(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Send an email notification.
        """
        return pulumi.get(self, "send_email_notification")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[builtins.str]:
        """
        Email address of the user.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_name")

