# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DataSourceDynamodbConfig',
    'DataSourceDynamodbConfigDeltaSyncConfig',
    'DataSourceElasticsearchConfig',
    'DataSourceEventBridgeConfig',
    'DataSourceHttpConfig',
    'DataSourceHttpConfigAuthorizationConfig',
    'DataSourceHttpConfigAuthorizationConfigAwsIamConfig',
    'DataSourceLambdaConfig',
    'DataSourceOpensearchserviceConfig',
    'DataSourceRelationalDatabaseConfig',
    'DataSourceRelationalDatabaseConfigHttpEndpointConfig',
    'FunctionRuntime',
    'FunctionSyncConfig',
    'FunctionSyncConfigLambdaConflictHandlerConfig',
    'GraphQLApiAdditionalAuthenticationProvider',
    'GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig',
    'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig',
    'GraphQLApiAdditionalAuthenticationProviderUserPoolConfig',
    'GraphQLApiEnhancedMetricsConfig',
    'GraphQLApiLambdaAuthorizerConfig',
    'GraphQLApiLogConfig',
    'GraphQLApiOpenidConnectConfig',
    'GraphQLApiUserPoolConfig',
    'ResolverCachingConfig',
    'ResolverPipelineConfig',
    'ResolverRuntime',
    'ResolverSyncConfig',
    'ResolverSyncConfigLambdaConflictHandlerConfig',
    'SourceApiAssociationSourceApiAssociationConfig',
    'SourceApiAssociationTimeouts',
]

@pulumi.output_type
class DataSourceDynamodbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableName":
            suggest = "table_name"
        elif key == "deltaSyncConfig":
            suggest = "delta_sync_config"
        elif key == "useCallerCredentials":
            suggest = "use_caller_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDynamodbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDynamodbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDynamodbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_name: builtins.str,
                 delta_sync_config: Optional['outputs.DataSourceDynamodbConfigDeltaSyncConfig'] = None,
                 region: Optional[builtins.str] = None,
                 use_caller_credentials: Optional[builtins.bool] = None,
                 versioned: Optional[builtins.bool] = None):
        """
        :param builtins.str table_name: Name of the DynamoDB table.
        :param 'DataSourceDynamodbConfigDeltaSyncConfigArgs' delta_sync_config: The DeltaSyncConfig for a versioned data source. See `delta_sync_config` Block for details.
        :param builtins.str region: AWS region of the DynamoDB table. Defaults to current region.
        :param builtins.bool use_caller_credentials: Set to `true` to use Amazon Cognito credentials with this data source.
        :param builtins.bool versioned: Detects Conflict Detection and Resolution with this data source.
        """
        pulumi.set(__self__, "table_name", table_name)
        if delta_sync_config is not None:
            pulumi.set(__self__, "delta_sync_config", delta_sync_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if use_caller_credentials is not None:
            pulumi.set(__self__, "use_caller_credentials", use_caller_credentials)
        if versioned is not None:
            pulumi.set(__self__, "versioned", versioned)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="deltaSyncConfig")
    def delta_sync_config(self) -> Optional['outputs.DataSourceDynamodbConfigDeltaSyncConfig']:
        """
        The DeltaSyncConfig for a versioned data source. See `delta_sync_config` Block for details.
        """
        return pulumi.get(self, "delta_sync_config")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        AWS region of the DynamoDB table. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="useCallerCredentials")
    def use_caller_credentials(self) -> Optional[builtins.bool]:
        """
        Set to `true` to use Amazon Cognito credentials with this data source.
        """
        return pulumi.get(self, "use_caller_credentials")

    @property
    @pulumi.getter
    def versioned(self) -> Optional[builtins.bool]:
        """
        Detects Conflict Detection and Resolution with this data source.
        """
        return pulumi.get(self, "versioned")


@pulumi.output_type
class DataSourceDynamodbConfigDeltaSyncConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deltaSyncTableName":
            suggest = "delta_sync_table_name"
        elif key == "baseTableTtl":
            suggest = "base_table_ttl"
        elif key == "deltaSyncTableTtl":
            suggest = "delta_sync_table_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDynamodbConfigDeltaSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDynamodbConfigDeltaSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDynamodbConfigDeltaSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delta_sync_table_name: builtins.str,
                 base_table_ttl: Optional[builtins.int] = None,
                 delta_sync_table_ttl: Optional[builtins.int] = None):
        """
        :param builtins.str delta_sync_table_name: The table name.
        :param builtins.int base_table_ttl: The number of minutes that an Item is stored in the data source.
        :param builtins.int delta_sync_table_ttl: The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
        pulumi.set(__self__, "delta_sync_table_name", delta_sync_table_name)
        if base_table_ttl is not None:
            pulumi.set(__self__, "base_table_ttl", base_table_ttl)
        if delta_sync_table_ttl is not None:
            pulumi.set(__self__, "delta_sync_table_ttl", delta_sync_table_ttl)

    @property
    @pulumi.getter(name="deltaSyncTableName")
    def delta_sync_table_name(self) -> builtins.str:
        """
        The table name.
        """
        return pulumi.get(self, "delta_sync_table_name")

    @property
    @pulumi.getter(name="baseTableTtl")
    def base_table_ttl(self) -> Optional[builtins.int]:
        """
        The number of minutes that an Item is stored in the data source.
        """
        return pulumi.get(self, "base_table_ttl")

    @property
    @pulumi.getter(name="deltaSyncTableTtl")
    def delta_sync_table_ttl(self) -> Optional[builtins.int]:
        """
        The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
        return pulumi.get(self, "delta_sync_table_ttl")


@pulumi.output_type
class DataSourceElasticsearchConfig(dict):
    def __init__(__self__, *,
                 endpoint: builtins.str,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str endpoint: HTTP endpoint of the Elasticsearch domain.
        :param builtins.str region: AWS region of Elasticsearch domain. Defaults to current region.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        HTTP endpoint of the Elasticsearch domain.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        AWS region of Elasticsearch domain. Defaults to current region.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class DataSourceEventBridgeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBusArn":
            suggest = "event_bus_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceEventBridgeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceEventBridgeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceEventBridgeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_bus_arn: builtins.str):
        """
        :param builtins.str event_bus_arn: ARN for the EventBridge bus.
        """
        pulumi.set(__self__, "event_bus_arn", event_bus_arn)

    @property
    @pulumi.getter(name="eventBusArn")
    def event_bus_arn(self) -> builtins.str:
        """
        ARN for the EventBridge bus.
        """
        return pulumi.get(self, "event_bus_arn")


@pulumi.output_type
class DataSourceHttpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationConfig":
            suggest = "authorization_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHttpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHttpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHttpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: builtins.str,
                 authorization_config: Optional['outputs.DataSourceHttpConfigAuthorizationConfig'] = None):
        """
        :param builtins.str endpoint: HTTP URL.
        :param 'DataSourceHttpConfigAuthorizationConfigArgs' authorization_config: Authorization configuration in case the HTTP endpoint requires authorization. See `authorization_config` Block for details.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        HTTP URL.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional['outputs.DataSourceHttpConfigAuthorizationConfig']:
        """
        Authorization configuration in case the HTTP endpoint requires authorization. See `authorization_config` Block for details.
        """
        return pulumi.get(self, "authorization_config")


@pulumi.output_type
class DataSourceHttpConfigAuthorizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationType":
            suggest = "authorization_type"
        elif key == "awsIamConfig":
            suggest = "aws_iam_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHttpConfigAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHttpConfigAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHttpConfigAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_type: Optional[builtins.str] = None,
                 aws_iam_config: Optional['outputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfig'] = None):
        """
        :param builtins.str authorization_type: Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
        :param 'DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs' aws_iam_config: Identity and Access Management (IAM) settings. See `aws_iam_config` Block for details.
        """
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if aws_iam_config is not None:
            pulumi.set(__self__, "aws_iam_config", aws_iam_config)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[builtins.str]:
        """
        Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="awsIamConfig")
    def aws_iam_config(self) -> Optional['outputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfig']:
        """
        Identity and Access Management (IAM) settings. See `aws_iam_config` Block for details.
        """
        return pulumi.get(self, "aws_iam_config")


@pulumi.output_type
class DataSourceHttpConfigAuthorizationConfigAwsIamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signingRegion":
            suggest = "signing_region"
        elif key == "signingServiceName":
            suggest = "signing_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHttpConfigAuthorizationConfigAwsIamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHttpConfigAuthorizationConfigAwsIamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHttpConfigAuthorizationConfigAwsIamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signing_region: Optional[builtins.str] = None,
                 signing_service_name: Optional[builtins.str] = None):
        """
        :param builtins.str signing_region: Signing Amazon Web Services Region for IAM authorization.
        :param builtins.str signing_service_name: Signing service name for IAM authorization.
        """
        if signing_region is not None:
            pulumi.set(__self__, "signing_region", signing_region)
        if signing_service_name is not None:
            pulumi.set(__self__, "signing_service_name", signing_service_name)

    @property
    @pulumi.getter(name="signingRegion")
    def signing_region(self) -> Optional[builtins.str]:
        """
        Signing Amazon Web Services Region for IAM authorization.
        """
        return pulumi.get(self, "signing_region")

    @property
    @pulumi.getter(name="signingServiceName")
    def signing_service_name(self) -> Optional[builtins.str]:
        """
        Signing service name for IAM authorization.
        """
        return pulumi.get(self, "signing_service_name")


@pulumi.output_type
class DataSourceLambdaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceLambdaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceLambdaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceLambdaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: builtins.str):
        """
        :param builtins.str function_arn: ARN for the Lambda function.
        """
        pulumi.set(__self__, "function_arn", function_arn)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> builtins.str:
        """
        ARN for the Lambda function.
        """
        return pulumi.get(self, "function_arn")


@pulumi.output_type
class DataSourceOpensearchserviceConfig(dict):
    def __init__(__self__, *,
                 endpoint: builtins.str,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str endpoint: HTTP endpoint of the OpenSearch domain.
        :param builtins.str region: AWS region of the OpenSearch domain. Defaults to current region.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        HTTP endpoint of the OpenSearch domain.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        AWS region of the OpenSearch domain. Defaults to current region.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class DataSourceRelationalDatabaseConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpEndpointConfig":
            suggest = "http_endpoint_config"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRelationalDatabaseConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRelationalDatabaseConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRelationalDatabaseConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_endpoint_config: Optional['outputs.DataSourceRelationalDatabaseConfigHttpEndpointConfig'] = None,
                 source_type: Optional[builtins.str] = None):
        """
        :param 'DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs' http_endpoint_config: Amazon RDS HTTP endpoint configuration. See `http_endpoint_config` Block for details.
        :param builtins.str source_type: Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
        """
        if http_endpoint_config is not None:
            pulumi.set(__self__, "http_endpoint_config", http_endpoint_config)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="httpEndpointConfig")
    def http_endpoint_config(self) -> Optional['outputs.DataSourceRelationalDatabaseConfigHttpEndpointConfig']:
        """
        Amazon RDS HTTP endpoint configuration. See `http_endpoint_config` Block for details.
        """
        return pulumi.get(self, "http_endpoint_config")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[builtins.str]:
        """
        Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class DataSourceRelationalDatabaseConfigHttpEndpointConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsSecretStoreArn":
            suggest = "aws_secret_store_arn"
        elif key == "dbClusterIdentifier":
            suggest = "db_cluster_identifier"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRelationalDatabaseConfigHttpEndpointConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRelationalDatabaseConfigHttpEndpointConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRelationalDatabaseConfigHttpEndpointConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_secret_store_arn: builtins.str,
                 db_cluster_identifier: builtins.str,
                 database_name: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 schema: Optional[builtins.str] = None):
        """
        :param builtins.str aws_secret_store_arn: AWS secret store ARN for database credentials.
        :param builtins.str db_cluster_identifier: Amazon RDS cluster identifier.
        :param builtins.str database_name: Logical database name.
        :param builtins.str region: AWS Region for RDS HTTP endpoint. Defaults to current region.
        :param builtins.str schema: Logical schema name.
        """
        pulumi.set(__self__, "aws_secret_store_arn", aws_secret_store_arn)
        pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter(name="awsSecretStoreArn")
    def aws_secret_store_arn(self) -> builtins.str:
        """
        AWS secret store ARN for database credentials.
        """
        return pulumi.get(self, "aws_secret_store_arn")

    @property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> builtins.str:
        """
        Amazon RDS cluster identifier.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        """
        Logical database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        AWS Region for RDS HTTP endpoint. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def schema(self) -> Optional[builtins.str]:
        """
        Logical schema name.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class FunctionRuntime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionRuntime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionRuntime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionRuntime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 runtime_version: builtins.str):
        """
        :param builtins.str name: The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        :param builtins.str runtime_version: The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> builtins.str:
        """
        The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class FunctionSyncConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictDetection":
            suggest = "conflict_detection"
        elif key == "conflictHandler":
            suggest = "conflict_handler"
        elif key == "lambdaConflictHandlerConfig":
            suggest = "lambda_conflict_handler_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_detection: Optional[builtins.str] = None,
                 conflict_handler: Optional[builtins.str] = None,
                 lambda_conflict_handler_config: Optional['outputs.FunctionSyncConfigLambdaConflictHandlerConfig'] = None):
        """
        :param builtins.str conflict_detection: Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        :param builtins.str conflict_handler: Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        :param 'FunctionSyncConfigLambdaConflictHandlerConfigArgs' lambda_conflict_handler_config: Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See `lambda_conflict_handler_config` Block for details.
        """
        if conflict_detection is not None:
            pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> Optional[builtins.str]:
        """
        Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        """
        return pulumi.get(self, "conflict_detection")

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[builtins.str]:
        """
        Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        """
        return pulumi.get(self, "conflict_handler")

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional['outputs.FunctionSyncConfigLambdaConflictHandlerConfig']:
        """
        Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See `lambda_conflict_handler_config` Block for details.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")


@pulumi.output_type
class FunctionSyncConfigLambdaConflictHandlerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConflictHandlerArn":
            suggest = "lambda_conflict_handler_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSyncConfigLambdaConflictHandlerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[builtins.str] = None):
        """
        :param builtins.str lambda_conflict_handler_arn: ARN for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[builtins.str]:
        """
        ARN for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "lambdaAuthorizerConfig":
            suggest = "lambda_authorizer_config"
        elif key == "openidConnectConfig":
            suggest = "openid_connect_config"
        elif key == "userPoolConfig":
            suggest = "user_pool_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: builtins.str,
                 lambda_authorizer_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig'] = None,
                 openid_connect_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig'] = None,
                 user_pool_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfig'] = None):
        """
        :param builtins.str authentication_type: Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        :param 'GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs' lambda_authorizer_config: Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        :param 'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs' openid_connect_config: Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        :param 'GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs' user_pool_config: Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if openid_connect_config is not None:
            pulumi.set(__self__, "openid_connect_config", openid_connect_config)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> builtins.str:
        """
        Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig']:
        """
        Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @property
    @pulumi.getter(name="openidConnectConfig")
    def openid_connect_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig']:
        """
        Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        """
        return pulumi.get(self, "openid_connect_config")

    @property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfig']:
        """
        Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        """
        return pulumi.get(self, "user_pool_config")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerUri":
            suggest = "authorizer_uri"
        elif key == "authorizerResultTtlInSeconds":
            suggest = "authorizer_result_ttl_in_seconds"
        elif key == "identityValidationExpression":
            suggest = "identity_validation_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_uri: builtins.str,
                 authorizer_result_ttl_in_seconds: Optional[builtins.int] = None,
                 identity_validation_expression: Optional[builtins.str] = None):
        """
        :param builtins.str authorizer_uri: ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        :param builtins.int authorizer_result_ttl_in_seconds: Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        :param builtins.str identity_validation_expression: Regular expression for validation of tokens before the Lambda function is called.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> builtins.str:
        """
        ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        """
        return pulumi.get(self, "authorizer_uri")

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[builtins.int]:
        """
        Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[builtins.str]:
        """
        Regular expression for validation of tokens before the Lambda function is called.
        """
        return pulumi.get(self, "identity_validation_expression")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: builtins.str,
                 auth_ttl: Optional[builtins.int] = None,
                 client_id: Optional[builtins.str] = None,
                 iat_ttl: Optional[builtins.int] = None):
        """
        :param builtins.str issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param builtins.int auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param builtins.str client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param builtins.int iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[builtins.int]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[builtins.int]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderUserPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userPoolId":
            suggest = "user_pool_id"
        elif key == "appIdClientRegex":
            suggest = "app_id_client_regex"
        elif key == "awsRegion":
            suggest = "aws_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderUserPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderUserPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderUserPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_pool_id: builtins.str,
                 app_id_client_regex: Optional[builtins.str] = None,
                 aws_region: Optional[builtins.str] = None):
        """
        :param builtins.str user_pool_id: User pool ID.
        :param builtins.str app_id_client_regex: Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param builtins.str aws_region: AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> builtins.str:
        """
        User pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[builtins.str]:
        """
        Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[builtins.str]:
        """
        AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")


@pulumi.output_type
class GraphQLApiEnhancedMetricsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceLevelMetricsBehavior":
            suggest = "data_source_level_metrics_behavior"
        elif key == "operationLevelMetricsConfig":
            suggest = "operation_level_metrics_config"
        elif key == "resolverLevelMetricsBehavior":
            suggest = "resolver_level_metrics_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiEnhancedMetricsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiEnhancedMetricsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiEnhancedMetricsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_level_metrics_behavior: builtins.str,
                 operation_level_metrics_config: builtins.str,
                 resolver_level_metrics_behavior: builtins.str):
        """
        :param builtins.str data_source_level_metrics_behavior: How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
        :param builtins.str operation_level_metrics_config: How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
        :param builtins.str resolver_level_metrics_behavior: How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
        """
        pulumi.set(__self__, "data_source_level_metrics_behavior", data_source_level_metrics_behavior)
        pulumi.set(__self__, "operation_level_metrics_config", operation_level_metrics_config)
        pulumi.set(__self__, "resolver_level_metrics_behavior", resolver_level_metrics_behavior)

    @property
    @pulumi.getter(name="dataSourceLevelMetricsBehavior")
    def data_source_level_metrics_behavior(self) -> builtins.str:
        """
        How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
        """
        return pulumi.get(self, "data_source_level_metrics_behavior")

    @property
    @pulumi.getter(name="operationLevelMetricsConfig")
    def operation_level_metrics_config(self) -> builtins.str:
        """
        How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
        """
        return pulumi.get(self, "operation_level_metrics_config")

    @property
    @pulumi.getter(name="resolverLevelMetricsBehavior")
    def resolver_level_metrics_behavior(self) -> builtins.str:
        """
        How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
        """
        return pulumi.get(self, "resolver_level_metrics_behavior")


@pulumi.output_type
class GraphQLApiLambdaAuthorizerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerUri":
            suggest = "authorizer_uri"
        elif key == "authorizerResultTtlInSeconds":
            suggest = "authorizer_result_ttl_in_seconds"
        elif key == "identityValidationExpression":
            suggest = "identity_validation_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiLambdaAuthorizerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiLambdaAuthorizerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiLambdaAuthorizerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_uri: builtins.str,
                 authorizer_result_ttl_in_seconds: Optional[builtins.int] = None,
                 identity_validation_expression: Optional[builtins.str] = None):
        """
        :param builtins.str authorizer_uri: ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        :param builtins.int authorizer_result_ttl_in_seconds: Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        :param builtins.str identity_validation_expression: Regular expression for validation of tokens before the Lambda function is called.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> builtins.str:
        """
        ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        """
        return pulumi.get(self, "authorizer_uri")

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[builtins.int]:
        """
        Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[builtins.str]:
        """
        Regular expression for validation of tokens before the Lambda function is called.
        """
        return pulumi.get(self, "identity_validation_expression")


@pulumi.output_type
class GraphQLApiLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogsRoleArn":
            suggest = "cloudwatch_logs_role_arn"
        elif key == "fieldLogLevel":
            suggest = "field_log_level"
        elif key == "excludeVerboseContent":
            suggest = "exclude_verbose_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs_role_arn: builtins.str,
                 field_log_level: builtins.str,
                 exclude_verbose_content: Optional[builtins.bool] = None):
        """
        :param builtins.str cloudwatch_logs_role_arn: Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        :param builtins.str field_log_level: Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        :param builtins.bool exclude_verbose_content: Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        pulumi.set(__self__, "cloudwatch_logs_role_arn", cloudwatch_logs_role_arn)
        pulumi.set(__self__, "field_log_level", field_log_level)
        if exclude_verbose_content is not None:
            pulumi.set(__self__, "exclude_verbose_content", exclude_verbose_content)

    @property
    @pulumi.getter(name="cloudwatchLogsRoleArn")
    def cloudwatch_logs_role_arn(self) -> builtins.str:
        """
        Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        """
        return pulumi.get(self, "cloudwatch_logs_role_arn")

    @property
    @pulumi.getter(name="fieldLogLevel")
    def field_log_level(self) -> builtins.str:
        """
        Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        """
        return pulumi.get(self, "field_log_level")

    @property
    @pulumi.getter(name="excludeVerboseContent")
    def exclude_verbose_content(self) -> Optional[builtins.bool]:
        """
        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        return pulumi.get(self, "exclude_verbose_content")


@pulumi.output_type
class GraphQLApiOpenidConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiOpenidConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiOpenidConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiOpenidConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: builtins.str,
                 auth_ttl: Optional[builtins.int] = None,
                 client_id: Optional[builtins.str] = None,
                 iat_ttl: Optional[builtins.int] = None):
        """
        :param builtins.str issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param builtins.int auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param builtins.str client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param builtins.int iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @property
    @pulumi.getter
    def issuer(self) -> builtins.str:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[builtins.int]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[builtins.int]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")


@pulumi.output_type
class GraphQLApiUserPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "userPoolId":
            suggest = "user_pool_id"
        elif key == "appIdClientRegex":
            suggest = "app_id_client_regex"
        elif key == "awsRegion":
            suggest = "aws_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiUserPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiUserPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiUserPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: builtins.str,
                 user_pool_id: builtins.str,
                 app_id_client_regex: Optional[builtins.str] = None,
                 aws_region: Optional[builtins.str] = None):
        """
        :param builtins.str default_action: Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        :param builtins.str user_pool_id: User pool ID.
        :param builtins.str app_id_client_regex: Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param builtins.str aws_region: AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "default_action", default_action)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> builtins.str:
        """
        Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> builtins.str:
        """
        User pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[builtins.str]:
        """
        Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[builtins.str]:
        """
        AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")


@pulumi.output_type
class ResolverCachingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cachingKeys":
            suggest = "caching_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverCachingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching_keys: Optional[Sequence[builtins.str]] = None,
                 ttl: Optional[builtins.int] = None):
        """
        :param Sequence[builtins.str] caching_keys: The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
        :param builtins.int ttl: The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
        """
        if caching_keys is not None:
            pulumi.set(__self__, "caching_keys", caching_keys)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="cachingKeys")
    def caching_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
        """
        return pulumi.get(self, "caching_keys")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[builtins.int]:
        """
        The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class ResolverPipelineConfig(dict):
    def __init__(__self__, *,
                 functions: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] functions: A list of Function objects.
        """
        if functions is not None:
            pulumi.set(__self__, "functions", functions)

    @property
    @pulumi.getter
    def functions(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of Function objects.
        """
        return pulumi.get(self, "functions")


@pulumi.output_type
class ResolverRuntime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverRuntime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverRuntime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverRuntime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 runtime_version: builtins.str):
        """
        :param builtins.str name: The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        :param builtins.str runtime_version: The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> builtins.str:
        """
        The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class ResolverSyncConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictDetection":
            suggest = "conflict_detection"
        elif key == "conflictHandler":
            suggest = "conflict_handler"
        elif key == "lambdaConflictHandlerConfig":
            suggest = "lambda_conflict_handler_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_detection: Optional[builtins.str] = None,
                 conflict_handler: Optional[builtins.str] = None,
                 lambda_conflict_handler_config: Optional['outputs.ResolverSyncConfigLambdaConflictHandlerConfig'] = None):
        """
        :param builtins.str conflict_detection: Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        :param builtins.str conflict_handler: Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        :param 'ResolverSyncConfigLambdaConflictHandlerConfigArgs' lambda_conflict_handler_config: Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
        if conflict_detection is not None:
            pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> Optional[builtins.str]:
        """
        Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        """
        return pulumi.get(self, "conflict_detection")

    @property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[builtins.str]:
        """
        Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        """
        return pulumi.get(self, "conflict_handler")

    @property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional['outputs.ResolverSyncConfigLambdaConflictHandlerConfig']:
        """
        Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")


@pulumi.output_type
class ResolverSyncConfigLambdaConflictHandlerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConflictHandlerArn":
            suggest = "lambda_conflict_handler_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverSyncConfigLambdaConflictHandlerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[builtins.str] = None):
        """
        :param builtins.str lambda_conflict_handler_arn: ARN for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[builtins.str]:
        """
        ARN for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")


@pulumi.output_type
class SourceApiAssociationSourceApiAssociationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mergeType":
            suggest = "merge_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceApiAssociationSourceApiAssociationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceApiAssociationSourceApiAssociationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceApiAssociationSourceApiAssociationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 merge_type: builtins.str):
        """
        :param builtins.str merge_type: Merge type. Valid values: `MANUAL_MERGE`, `AUTO_MERGE`
        """
        pulumi.set(__self__, "merge_type", merge_type)

    @property
    @pulumi.getter(name="mergeType")
    def merge_type(self) -> builtins.str:
        """
        Merge type. Valid values: `MANUAL_MERGE`, `AUTO_MERGE`
        """
        return pulumi.get(self, "merge_type")


@pulumi.output_type
class SourceApiAssociationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[builtins.str] = None,
                 delete: Optional[builtins.str] = None,
                 update: Optional[builtins.str] = None):
        """
        :param builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter
    def delete(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @property
    @pulumi.getter
    def update(self) -> Optional[builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


