# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResolverArgs', 'Resolver']

@pulumi.input_type
class ResolverArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[builtins.str],
                 field: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 caching_config: Optional[pulumi.Input['ResolverCachingConfigArgs']] = None,
                 code: Optional[pulumi.Input[builtins.str]] = None,
                 data_source: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 max_batch_size: Optional[pulumi.Input[builtins.int]] = None,
                 pipeline_config: Optional[pulumi.Input['ResolverPipelineConfigArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 request_template: Optional[pulumi.Input[builtins.str]] = None,
                 response_template: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input['ResolverRuntimeArgs']] = None,
                 sync_config: Optional[pulumi.Input['ResolverSyncConfigArgs']] = None):
        """
        The set of arguments for constructing a Resolver resource.
        :param pulumi.Input[builtins.str] api_id: API ID for the GraphQL API.
        :param pulumi.Input[builtins.str] field: Field name from the schema defined in the GraphQL API.
        :param pulumi.Input[builtins.str] type: Type name from the schema defined in the GraphQL API.
        :param pulumi.Input['ResolverCachingConfigArgs'] caching_config: The Caching Config. See Caching Config.
        :param pulumi.Input[builtins.str] code: The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        :param pulumi.Input[builtins.str] data_source: Data source name.
        :param pulumi.Input[builtins.str] kind: Resolver type. Valid values are `UNIT` and `PIPELINE`.
        :param pulumi.Input[builtins.int] max_batch_size: Maximum batching size for a resolver. Valid values are between `0` and `2000`.
        :param pulumi.Input['ResolverPipelineConfigArgs'] pipeline_config: The caching configuration for the resolver. See Pipeline Config.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] request_template: Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        :param pulumi.Input[builtins.str] response_template: Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        :param pulumi.Input['ResolverRuntimeArgs'] runtime: Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
        :param pulumi.Input['ResolverSyncConfigArgs'] sync_config: Describes a Sync configuration for a resolver. See Sync Config.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "type", type)
        if caching_config is not None:
            pulumi.set(__self__, "caching_config", caching_config)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if max_batch_size is not None:
            pulumi.set(__self__, "max_batch_size", max_batch_size)
        if pipeline_config is not None:
            pulumi.set(__self__, "pipeline_config", pipeline_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_template is not None:
            pulumi.set(__self__, "request_template", request_template)
        if response_template is not None:
            pulumi.set(__self__, "response_template", response_template)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if sync_config is not None:
            pulumi.set(__self__, "sync_config", sync_config)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[builtins.str]:
        """
        API ID for the GraphQL API.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def field(self) -> pulumi.Input[builtins.str]:
        """
        Field name from the schema defined in the GraphQL API.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type name from the schema defined in the GraphQL API.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="cachingConfig")
    def caching_config(self) -> Optional[pulumi.Input['ResolverCachingConfigArgs']]:
        """
        The Caching Config. See Caching Config.
        """
        return pulumi.get(self, "caching_config")

    @caching_config.setter
    def caching_config(self, value: Optional[pulumi.Input['ResolverCachingConfigArgs']]):
        pulumi.set(self, "caching_config", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Data source name.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resolver type. Valid values are `UNIT` and `PIPELINE`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum batching size for a resolver. Valid values are between `0` and `2000`.
        """
        return pulumi.get(self, "max_batch_size")

    @max_batch_size.setter
    def max_batch_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_batch_size", value)

    @property
    @pulumi.getter(name="pipelineConfig")
    def pipeline_config(self) -> Optional[pulumi.Input['ResolverPipelineConfigArgs']]:
        """
        The caching configuration for the resolver. See Pipeline Config.
        """
        return pulumi.get(self, "pipeline_config")

    @pipeline_config.setter
    def pipeline_config(self, value: Optional[pulumi.Input['ResolverPipelineConfigArgs']]):
        pulumi.set(self, "pipeline_config", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="requestTemplate")
    def request_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        """
        return pulumi.get(self, "request_template")

    @request_template.setter
    def request_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_template", value)

    @property
    @pulumi.getter(name="responseTemplate")
    def response_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        """
        return pulumi.get(self, "response_template")

    @response_template.setter
    def response_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_template", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['ResolverRuntimeArgs']]:
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['ResolverRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> Optional[pulumi.Input['ResolverSyncConfigArgs']]:
        """
        Describes a Sync configuration for a resolver. See Sync Config.
        """
        return pulumi.get(self, "sync_config")

    @sync_config.setter
    def sync_config(self, value: Optional[pulumi.Input['ResolverSyncConfigArgs']]):
        pulumi.set(self, "sync_config", value)


@pulumi.input_type
class _ResolverState:
    def __init__(__self__, *,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 caching_config: Optional[pulumi.Input['ResolverCachingConfigArgs']] = None,
                 code: Optional[pulumi.Input[builtins.str]] = None,
                 data_source: Optional[pulumi.Input[builtins.str]] = None,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 max_batch_size: Optional[pulumi.Input[builtins.int]] = None,
                 pipeline_config: Optional[pulumi.Input['ResolverPipelineConfigArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 request_template: Optional[pulumi.Input[builtins.str]] = None,
                 response_template: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input['ResolverRuntimeArgs']] = None,
                 sync_config: Optional[pulumi.Input['ResolverSyncConfigArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Resolver resources.
        :param pulumi.Input[builtins.str] api_id: API ID for the GraphQL API.
        :param pulumi.Input[builtins.str] arn: ARN
        :param pulumi.Input['ResolverCachingConfigArgs'] caching_config: The Caching Config. See Caching Config.
        :param pulumi.Input[builtins.str] code: The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        :param pulumi.Input[builtins.str] data_source: Data source name.
        :param pulumi.Input[builtins.str] field: Field name from the schema defined in the GraphQL API.
        :param pulumi.Input[builtins.str] kind: Resolver type. Valid values are `UNIT` and `PIPELINE`.
        :param pulumi.Input[builtins.int] max_batch_size: Maximum batching size for a resolver. Valid values are between `0` and `2000`.
        :param pulumi.Input['ResolverPipelineConfigArgs'] pipeline_config: The caching configuration for the resolver. See Pipeline Config.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] request_template: Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        :param pulumi.Input[builtins.str] response_template: Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        :param pulumi.Input['ResolverRuntimeArgs'] runtime: Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
        :param pulumi.Input['ResolverSyncConfigArgs'] sync_config: Describes a Sync configuration for a resolver. See Sync Config.
        :param pulumi.Input[builtins.str] type: Type name from the schema defined in the GraphQL API.
        """
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if caching_config is not None:
            pulumi.set(__self__, "caching_config", caching_config)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if max_batch_size is not None:
            pulumi.set(__self__, "max_batch_size", max_batch_size)
        if pipeline_config is not None:
            pulumi.set(__self__, "pipeline_config", pipeline_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_template is not None:
            pulumi.set(__self__, "request_template", request_template)
        if response_template is not None:
            pulumi.set(__self__, "response_template", response_template)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if sync_config is not None:
            pulumi.set(__self__, "sync_config", sync_config)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        API ID for the GraphQL API.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="cachingConfig")
    def caching_config(self) -> Optional[pulumi.Input['ResolverCachingConfigArgs']]:
        """
        The Caching Config. See Caching Config.
        """
        return pulumi.get(self, "caching_config")

    @caching_config.setter
    def caching_config(self, value: Optional[pulumi.Input['ResolverCachingConfigArgs']]):
        pulumi.set(self, "caching_config", value)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Data source name.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Field name from the schema defined in the GraphQL API.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resolver type. Valid values are `UNIT` and `PIPELINE`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum batching size for a resolver. Valid values are between `0` and `2000`.
        """
        return pulumi.get(self, "max_batch_size")

    @max_batch_size.setter
    def max_batch_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_batch_size", value)

    @property
    @pulumi.getter(name="pipelineConfig")
    def pipeline_config(self) -> Optional[pulumi.Input['ResolverPipelineConfigArgs']]:
        """
        The caching configuration for the resolver. See Pipeline Config.
        """
        return pulumi.get(self, "pipeline_config")

    @pipeline_config.setter
    def pipeline_config(self, value: Optional[pulumi.Input['ResolverPipelineConfigArgs']]):
        pulumi.set(self, "pipeline_config", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="requestTemplate")
    def request_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        """
        return pulumi.get(self, "request_template")

    @request_template.setter
    def request_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "request_template", value)

    @property
    @pulumi.getter(name="responseTemplate")
    def response_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        """
        return pulumi.get(self, "response_template")

    @response_template.setter
    def response_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "response_template", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input['ResolverRuntimeArgs']]:
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input['ResolverRuntimeArgs']]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> Optional[pulumi.Input['ResolverSyncConfigArgs']]:
        """
        Describes a Sync configuration for a resolver. See Sync Config.
        """
        return pulumi.get(self, "sync_config")

    @sync_config.setter
    def sync_config(self, value: Optional[pulumi.Input['ResolverSyncConfigArgs']]):
        pulumi.set(self, "sync_config", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type name from the schema defined in the GraphQL API.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:appsync/resolver:Resolver")
class Resolver(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 caching_config: Optional[pulumi.Input[Union['ResolverCachingConfigArgs', 'ResolverCachingConfigArgsDict']]] = None,
                 code: Optional[pulumi.Input[builtins.str]] = None,
                 data_source: Optional[pulumi.Input[builtins.str]] = None,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 max_batch_size: Optional[pulumi.Input[builtins.int]] = None,
                 pipeline_config: Optional[pulumi.Input[Union['ResolverPipelineConfigArgs', 'ResolverPipelineConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 request_template: Optional[pulumi.Input[builtins.str]] = None,
                 response_template: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[Union['ResolverRuntimeArgs', 'ResolverRuntimeArgsDict']]] = None,
                 sync_config: Optional[pulumi.Input[Union['ResolverSyncConfigArgs', 'ResolverSyncConfigArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an AppSync Resolver.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.appsync.GraphQLApi("test",
            authentication_type="API_KEY",
            name="tf-example",
            schema=\"\"\"type Mutation {
        \\x09putPost(id: ID!, title: String!): Post
        }

        type Post {
        \\x09id: ID!
        \\x09title: String!
        }

        type Query {
        \\x09singlePost(id: ID!): Post
        }

        schema {
        \\x09query: Query
        \\x09mutation: Mutation
        }
        \"\"\")
        test_data_source = aws.appsync.DataSource("test",
            api_id=test.id,
            name="my_example",
            type="HTTP",
            http_config={
                "endpoint": "http://example.com",
            })
        # UNIT type resolver (default)
        test_resolver = aws.appsync.Resolver("test",
            api_id=test.id,
            field="singlePost",
            type="Query",
            data_source=test_data_source.name,
            request_template=\"\"\"{
            "version": "2018-05-29",
            "method": "GET",
            "resourcePath": "/",
            "params":{
                "headers": $utils.http.copyheaders($ctx.request.headers)
            }
        }
        \"\"\",
            response_template=\"\"\"#if($ctx.result.statusCode == 200)
            $ctx.result.body
        #else
            $utils.appendError($ctx.result.body, $ctx.result.statusCode)
        #end
        \"\"\",
            caching_config={
                "caching_keys": [
                    "$context.identity.sub",
                    "$context.arguments.id",
                ],
                "ttl": 60,
            })
        # PIPELINE type resolver
        mutation_pipeline_test = aws.appsync.Resolver("Mutation_pipelineTest",
            type="Mutation",
            api_id=test.id,
            field="pipelineTest",
            request_template="{}",
            response_template="$util.toJson($ctx.result)",
            kind="PIPELINE",
            pipeline_config={
                "functions": [
                    test1["functionId"],
                    test2["functionId"],
                    test3["functionId"],
                ],
            })
        ```

        ### JS

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.appsync.Resolver("example",
            type="Query",
            api_id=test_aws_appsync_graphql_api["id"],
            field="pipelineTest",
            kind="PIPELINE",
            code=std.file(input="some-code-dir").result,
            runtime={
                "name": "APPSYNC_JS",
                "runtime_version": "1.0.0",
            },
            pipeline_config={
                "functions": [test["functionId"]],
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_appsync_resolver` using the `api_id`, a hyphen, `type`, a hypen and `field`. For example:

        ```sh
        $ pulumi import aws:appsync/resolver:Resolver example abcdef123456-exampleType-exampleField
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_id: API ID for the GraphQL API.
        :param pulumi.Input[Union['ResolverCachingConfigArgs', 'ResolverCachingConfigArgsDict']] caching_config: The Caching Config. See Caching Config.
        :param pulumi.Input[builtins.str] code: The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        :param pulumi.Input[builtins.str] data_source: Data source name.
        :param pulumi.Input[builtins.str] field: Field name from the schema defined in the GraphQL API.
        :param pulumi.Input[builtins.str] kind: Resolver type. Valid values are `UNIT` and `PIPELINE`.
        :param pulumi.Input[builtins.int] max_batch_size: Maximum batching size for a resolver. Valid values are between `0` and `2000`.
        :param pulumi.Input[Union['ResolverPipelineConfigArgs', 'ResolverPipelineConfigArgsDict']] pipeline_config: The caching configuration for the resolver. See Pipeline Config.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] request_template: Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        :param pulumi.Input[builtins.str] response_template: Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        :param pulumi.Input[Union['ResolverRuntimeArgs', 'ResolverRuntimeArgsDict']] runtime: Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
        :param pulumi.Input[Union['ResolverSyncConfigArgs', 'ResolverSyncConfigArgsDict']] sync_config: Describes a Sync configuration for a resolver. See Sync Config.
        :param pulumi.Input[builtins.str] type: Type name from the schema defined in the GraphQL API.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResolverArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppSync Resolver.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.appsync.GraphQLApi("test",
            authentication_type="API_KEY",
            name="tf-example",
            schema=\"\"\"type Mutation {
        \\x09putPost(id: ID!, title: String!): Post
        }

        type Post {
        \\x09id: ID!
        \\x09title: String!
        }

        type Query {
        \\x09singlePost(id: ID!): Post
        }

        schema {
        \\x09query: Query
        \\x09mutation: Mutation
        }
        \"\"\")
        test_data_source = aws.appsync.DataSource("test",
            api_id=test.id,
            name="my_example",
            type="HTTP",
            http_config={
                "endpoint": "http://example.com",
            })
        # UNIT type resolver (default)
        test_resolver = aws.appsync.Resolver("test",
            api_id=test.id,
            field="singlePost",
            type="Query",
            data_source=test_data_source.name,
            request_template=\"\"\"{
            "version": "2018-05-29",
            "method": "GET",
            "resourcePath": "/",
            "params":{
                "headers": $utils.http.copyheaders($ctx.request.headers)
            }
        }
        \"\"\",
            response_template=\"\"\"#if($ctx.result.statusCode == 200)
            $ctx.result.body
        #else
            $utils.appendError($ctx.result.body, $ctx.result.statusCode)
        #end
        \"\"\",
            caching_config={
                "caching_keys": [
                    "$context.identity.sub",
                    "$context.arguments.id",
                ],
                "ttl": 60,
            })
        # PIPELINE type resolver
        mutation_pipeline_test = aws.appsync.Resolver("Mutation_pipelineTest",
            type="Mutation",
            api_id=test.id,
            field="pipelineTest",
            request_template="{}",
            response_template="$util.toJson($ctx.result)",
            kind="PIPELINE",
            pipeline_config={
                "functions": [
                    test1["functionId"],
                    test2["functionId"],
                    test3["functionId"],
                ],
            })
        ```

        ### JS

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.appsync.Resolver("example",
            type="Query",
            api_id=test_aws_appsync_graphql_api["id"],
            field="pipelineTest",
            kind="PIPELINE",
            code=std.file(input="some-code-dir").result,
            runtime={
                "name": "APPSYNC_JS",
                "runtime_version": "1.0.0",
            },
            pipeline_config={
                "functions": [test["functionId"]],
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_appsync_resolver` using the `api_id`, a hyphen, `type`, a hypen and `field`. For example:

        ```sh
        $ pulumi import aws:appsync/resolver:Resolver example abcdef123456-exampleType-exampleField
        ```

        :param str resource_name: The name of the resource.
        :param ResolverArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResolverArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 caching_config: Optional[pulumi.Input[Union['ResolverCachingConfigArgs', 'ResolverCachingConfigArgsDict']]] = None,
                 code: Optional[pulumi.Input[builtins.str]] = None,
                 data_source: Optional[pulumi.Input[builtins.str]] = None,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 max_batch_size: Optional[pulumi.Input[builtins.int]] = None,
                 pipeline_config: Optional[pulumi.Input[Union['ResolverPipelineConfigArgs', 'ResolverPipelineConfigArgsDict']]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 request_template: Optional[pulumi.Input[builtins.str]] = None,
                 response_template: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[Union['ResolverRuntimeArgs', 'ResolverRuntimeArgsDict']]] = None,
                 sync_config: Optional[pulumi.Input[Union['ResolverSyncConfigArgs', 'ResolverSyncConfigArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResolverArgs.__new__(ResolverArgs)

            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["caching_config"] = caching_config
            __props__.__dict__["code"] = code
            __props__.__dict__["data_source"] = data_source
            if field is None and not opts.urn:
                raise TypeError("Missing required property 'field'")
            __props__.__dict__["field"] = field
            __props__.__dict__["kind"] = kind
            __props__.__dict__["max_batch_size"] = max_batch_size
            __props__.__dict__["pipeline_config"] = pipeline_config
            __props__.__dict__["region"] = region
            __props__.__dict__["request_template"] = request_template
            __props__.__dict__["response_template"] = response_template
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["sync_config"] = sync_config
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
        super(Resolver, __self__).__init__(
            'aws:appsync/resolver:Resolver',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_id: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            caching_config: Optional[pulumi.Input[Union['ResolverCachingConfigArgs', 'ResolverCachingConfigArgsDict']]] = None,
            code: Optional[pulumi.Input[builtins.str]] = None,
            data_source: Optional[pulumi.Input[builtins.str]] = None,
            field: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            max_batch_size: Optional[pulumi.Input[builtins.int]] = None,
            pipeline_config: Optional[pulumi.Input[Union['ResolverPipelineConfigArgs', 'ResolverPipelineConfigArgsDict']]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            request_template: Optional[pulumi.Input[builtins.str]] = None,
            response_template: Optional[pulumi.Input[builtins.str]] = None,
            runtime: Optional[pulumi.Input[Union['ResolverRuntimeArgs', 'ResolverRuntimeArgsDict']]] = None,
            sync_config: Optional[pulumi.Input[Union['ResolverSyncConfigArgs', 'ResolverSyncConfigArgsDict']]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Resolver':
        """
        Get an existing Resolver resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_id: API ID for the GraphQL API.
        :param pulumi.Input[builtins.str] arn: ARN
        :param pulumi.Input[Union['ResolverCachingConfigArgs', 'ResolverCachingConfigArgsDict']] caching_config: The Caching Config. See Caching Config.
        :param pulumi.Input[builtins.str] code: The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        :param pulumi.Input[builtins.str] data_source: Data source name.
        :param pulumi.Input[builtins.str] field: Field name from the schema defined in the GraphQL API.
        :param pulumi.Input[builtins.str] kind: Resolver type. Valid values are `UNIT` and `PIPELINE`.
        :param pulumi.Input[builtins.int] max_batch_size: Maximum batching size for a resolver. Valid values are between `0` and `2000`.
        :param pulumi.Input[Union['ResolverPipelineConfigArgs', 'ResolverPipelineConfigArgsDict']] pipeline_config: The caching configuration for the resolver. See Pipeline Config.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] request_template: Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        :param pulumi.Input[builtins.str] response_template: Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        :param pulumi.Input[Union['ResolverRuntimeArgs', 'ResolverRuntimeArgsDict']] runtime: Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
        :param pulumi.Input[Union['ResolverSyncConfigArgs', 'ResolverSyncConfigArgsDict']] sync_config: Describes a Sync configuration for a resolver. See Sync Config.
        :param pulumi.Input[builtins.str] type: Type name from the schema defined in the GraphQL API.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResolverState.__new__(_ResolverState)

        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["caching_config"] = caching_config
        __props__.__dict__["code"] = code
        __props__.__dict__["data_source"] = data_source
        __props__.__dict__["field"] = field
        __props__.__dict__["kind"] = kind
        __props__.__dict__["max_batch_size"] = max_batch_size
        __props__.__dict__["pipeline_config"] = pipeline_config
        __props__.__dict__["region"] = region
        __props__.__dict__["request_template"] = request_template
        __props__.__dict__["response_template"] = response_template
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["sync_config"] = sync_config
        __props__.__dict__["type"] = type
        return Resolver(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[builtins.str]:
        """
        API ID for the GraphQL API.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="cachingConfig")
    def caching_config(self) -> pulumi.Output[Optional['outputs.ResolverCachingConfig']]:
        """
        The Caching Config. See Caching Config.
        """
        return pulumi.get(self, "caching_config")

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The function code that contains the request and response functions. When code is used, the runtime is required. The runtime value must be APPSYNC_JS.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Data source name.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter
    def field(self) -> pulumi.Output[builtins.str]:
        """
        Field name from the schema defined in the GraphQL API.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Resolver type. Valid values are `UNIT` and `PIPELINE`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Maximum batching size for a resolver. Valid values are between `0` and `2000`.
        """
        return pulumi.get(self, "max_batch_size")

    @property
    @pulumi.getter(name="pipelineConfig")
    def pipeline_config(self) -> pulumi.Output[Optional['outputs.ResolverPipelineConfig']]:
        """
        The caching configuration for the resolver. See Pipeline Config.
        """
        return pulumi.get(self, "pipeline_config")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="requestTemplate")
    def request_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Request mapping template for UNIT resolver or 'before mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        """
        return pulumi.get(self, "request_template")

    @property
    @pulumi.getter(name="responseTemplate")
    def response_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Response mapping template for UNIT resolver or 'after mapping template' for PIPELINE resolver. Required for non-Lambda resolvers.
        """
        return pulumi.get(self, "response_template")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[Optional['outputs.ResolverRuntime']]:
        """
        Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version of the runtime to use. Note that if a runtime is specified, code must also be specified. See Runtime.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="syncConfig")
    def sync_config(self) -> pulumi.Output[Optional['outputs.ResolverSyncConfig']]:
        """
        Describes a Sync configuration for a resolver. See Sync Config.
        """
        return pulumi.get(self, "sync_config")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type name from the schema defined in the GraphQL API.
        """
        return pulumi.get(self, "type")

