# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TypeArgs', 'Type']

@pulumi.input_type
class TypeArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[builtins.str],
                 definition: pulumi.Input[builtins.str],
                 format: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Type resource.
        :param pulumi.Input[builtins.str] api_id: GraphQL API ID.
        :param pulumi.Input[builtins.str] definition: The type definition.
        :param pulumi.Input[builtins.str] format: The type format: `SDL` or `JSON`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "definition", definition)
        pulumi.set(__self__, "format", format)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[builtins.str]:
        """
        GraphQL API ID.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Input[builtins.str]:
        """
        The type definition.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[builtins.str]:
        """
        The type format: `SDL` or `JSON`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _TypeState:
    def __init__(__self__, *,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 definition: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Type resources.
        :param pulumi.Input[builtins.str] api_id: GraphQL API ID.
        :param pulumi.Input[builtins.str] arn: The ARN of the type.
        :param pulumi.Input[builtins.str] definition: The type definition.
        :param pulumi.Input[builtins.str] description: The type description.
        :param pulumi.Input[builtins.str] format: The type format: `SDL` or `JSON`.
        :param pulumi.Input[builtins.str] name: The type name.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if definition is not None:
            pulumi.set(__self__, "definition", definition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GraphQL API ID.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_id", value)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the type.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def definition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type definition.
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type format: `SDL` or `JSON`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:appsync/type:Type")
class Type(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 definition: Optional[pulumi.Input[builtins.str]] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an AppSync Type.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="API_KEY",
            name="example")
        example_type = aws.appsync.Type("example",
            api_id=example.id,
            format="SDL",
            definition=\"\"\"type Mutation

        {
        putPost(id: ID!,title: String! ): Post

        }
        \"\"\")
        ```

        ## Import

        Using `pulumi import`, import Appsync Types using the `id`. For example:

        ```sh
        $ pulumi import aws:appsync/type:Type example api-id:format:name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_id: GraphQL API ID.
        :param pulumi.Input[builtins.str] definition: The type definition.
        :param pulumi.Input[builtins.str] format: The type format: `SDL` or `JSON`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppSync Type.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="API_KEY",
            name="example")
        example_type = aws.appsync.Type("example",
            api_id=example.id,
            format="SDL",
            definition=\"\"\"type Mutation

        {
        putPost(id: ID!,title: String! ): Post

        }
        \"\"\")
        ```

        ## Import

        Using `pulumi import`, import Appsync Types using the `id`. For example:

        ```sh
        $ pulumi import aws:appsync/type:Type example api-id:format:name
        ```

        :param str resource_name: The name of the resource.
        :param TypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[builtins.str]] = None,
                 definition: Optional[pulumi.Input[builtins.str]] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TypeArgs.__new__(TypeArgs)

            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            if definition is None and not opts.urn:
                raise TypeError("Missing required property 'definition'")
            __props__.__dict__["definition"] = definition
            if format is None and not opts.urn:
                raise TypeError("Missing required property 'format'")
            __props__.__dict__["format"] = format
            __props__.__dict__["region"] = region
            __props__.__dict__["arn"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["name"] = None
        super(Type, __self__).__init__(
            'aws:appsync/type:Type',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_id: Optional[pulumi.Input[builtins.str]] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            definition: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            format: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'Type':
        """
        Get an existing Type resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_id: GraphQL API ID.
        :param pulumi.Input[builtins.str] arn: The ARN of the type.
        :param pulumi.Input[builtins.str] definition: The type definition.
        :param pulumi.Input[builtins.str] description: The type description.
        :param pulumi.Input[builtins.str] format: The type format: `SDL` or `JSON`.
        :param pulumi.Input[builtins.str] name: The type name.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TypeState.__new__(_TypeState)

        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["definition"] = definition
        __props__.__dict__["description"] = description
        __props__.__dict__["format"] = format
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return Type(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[builtins.str]:
        """
        GraphQL API ID.
        """
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the type.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Output[builtins.str]:
        """
        The type definition.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The type description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[builtins.str]:
        """
        The type format: `SDL` or `JSON`.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The type name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

