# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NamedQueryArgs', 'NamedQuery']

@pulumi.input_type
class NamedQueryArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[builtins.str],
                 query: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 workgroup: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NamedQuery resource.
        :param pulumi.Input[builtins.str] database: Database to which the query belongs.
        :param pulumi.Input[builtins.str] query: Text of the query itself. In other words, all query statements. Maximum length of 262144.
        :param pulumi.Input[builtins.str] description: Brief explanation of the query. Maximum length of 1024.
        :param pulumi.Input[builtins.str] name: Plain language name for the query. Maximum length of 128.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] workgroup: Workgroup to which the query belongs. Defaults to `primary`
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "query", query)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if workgroup is not None:
            pulumi.set(__self__, "workgroup", workgroup)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[builtins.str]:
        """
        Database to which the query belongs.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[builtins.str]:
        """
        Text of the query itself. In other words, all query statements. Maximum length of 262144.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Brief explanation of the query. Maximum length of 1024.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Plain language name for the query. Maximum length of 128.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def workgroup(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Workgroup to which the query belongs. Defaults to `primary`
        """
        return pulumi.get(self, "workgroup")

    @workgroup.setter
    def workgroup(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workgroup", value)


@pulumi.input_type
class _NamedQueryState:
    def __init__(__self__, *,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 workgroup: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NamedQuery resources.
        :param pulumi.Input[builtins.str] database: Database to which the query belongs.
        :param pulumi.Input[builtins.str] description: Brief explanation of the query. Maximum length of 1024.
        :param pulumi.Input[builtins.str] name: Plain language name for the query. Maximum length of 128.
        :param pulumi.Input[builtins.str] query: Text of the query itself. In other words, all query statements. Maximum length of 262144.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] workgroup: Workgroup to which the query belongs. Defaults to `primary`
        """
        if database is not None:
            pulumi.set(__self__, "database", database)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if workgroup is not None:
            pulumi.set(__self__, "workgroup", workgroup)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Database to which the query belongs.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Brief explanation of the query. Maximum length of 1024.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Plain language name for the query. Maximum length of 128.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Text of the query itself. In other words, all query statements. Maximum length of 262144.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def workgroup(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Workgroup to which the query belongs. Defaults to `primary`
        """
        return pulumi.get(self, "workgroup")

    @workgroup.setter
    def workgroup(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workgroup", value)


@pulumi.type_token("aws:athena/namedQuery:NamedQuery")
class NamedQuery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 workgroup: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides an Athena Named Query resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        hoge = aws.s3.Bucket("hoge", bucket="tf-test")
        test = aws.kms.Key("test",
            deletion_window_in_days=7,
            description="Athena KMS Key")
        test_workgroup = aws.athena.Workgroup("test",
            name="example",
            configuration={
                "result_configuration": {
                    "encryption_configuration": {
                        "encryption_option": "SSE_KMS",
                        "kms_key_arn": test.arn,
                    },
                },
            })
        hoge_database = aws.athena.Database("hoge",
            name="users",
            bucket=hoge.id)
        foo = aws.athena.NamedQuery("foo",
            name="bar",
            workgroup=test_workgroup.id,
            database=hoge_database.name,
            query=hoge_database.name.apply(lambda name: f"SELECT * FROM {name} limit 10;"))
        ```

        ## Import

        Using `pulumi import`, import Athena Named Query using the query ID. For example:

        ```sh
        $ pulumi import aws:athena/namedQuery:NamedQuery example 0123456789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database: Database to which the query belongs.
        :param pulumi.Input[builtins.str] description: Brief explanation of the query. Maximum length of 1024.
        :param pulumi.Input[builtins.str] name: Plain language name for the query. Maximum length of 128.
        :param pulumi.Input[builtins.str] query: Text of the query itself. In other words, all query statements. Maximum length of 262144.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] workgroup: Workgroup to which the query belongs. Defaults to `primary`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamedQueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Athena Named Query resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        hoge = aws.s3.Bucket("hoge", bucket="tf-test")
        test = aws.kms.Key("test",
            deletion_window_in_days=7,
            description="Athena KMS Key")
        test_workgroup = aws.athena.Workgroup("test",
            name="example",
            configuration={
                "result_configuration": {
                    "encryption_configuration": {
                        "encryption_option": "SSE_KMS",
                        "kms_key_arn": test.arn,
                    },
                },
            })
        hoge_database = aws.athena.Database("hoge",
            name="users",
            bucket=hoge.id)
        foo = aws.athena.NamedQuery("foo",
            name="bar",
            workgroup=test_workgroup.id,
            database=hoge_database.name,
            query=hoge_database.name.apply(lambda name: f"SELECT * FROM {name} limit 10;"))
        ```

        ## Import

        Using `pulumi import`, import Athena Named Query using the query ID. For example:

        ```sh
        $ pulumi import aws:athena/namedQuery:NamedQuery example 0123456789
        ```

        :param str resource_name: The name of the resource.
        :param NamedQueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamedQueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 workgroup: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamedQueryArgs.__new__(NamedQueryArgs)

            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["region"] = region
            __props__.__dict__["workgroup"] = workgroup
        super(NamedQuery, __self__).__init__(
            'aws:athena/namedQuery:NamedQuery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            query: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            workgroup: Optional[pulumi.Input[builtins.str]] = None) -> 'NamedQuery':
        """
        Get an existing NamedQuery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] database: Database to which the query belongs.
        :param pulumi.Input[builtins.str] description: Brief explanation of the query. Maximum length of 1024.
        :param pulumi.Input[builtins.str] name: Plain language name for the query. Maximum length of 128.
        :param pulumi.Input[builtins.str] query: Text of the query itself. In other words, all query statements. Maximum length of 262144.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] workgroup: Workgroup to which the query belongs. Defaults to `primary`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamedQueryState.__new__(_NamedQueryState)

        __props__.__dict__["database"] = database
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        __props__.__dict__["region"] = region
        __props__.__dict__["workgroup"] = workgroup
        return NamedQuery(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[builtins.str]:
        """
        Database to which the query belongs.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Brief explanation of the query. Maximum length of 1024.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Plain language name for the query. Maximum length of 128.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> pulumi.Output[builtins.str]:
        """
        Text of the query itself. In other words, all query statements. Maximum length of 262144.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def workgroup(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Workgroup to which the query belongs. Defaults to `primary`
        """
        return pulumi.get(self, "workgroup")

