# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetControlResult',
    'AwaitableGetControlResult',
    'get_control',
    'get_control_output',
]

@pulumi.output_type
class GetControlResult:
    """
    A collection of values returned by getControl.
    """
    def __init__(__self__, action_plan_instructions=None, action_plan_title=None, arn=None, control_mapping_sources=None, description=None, id=None, name=None, region=None, tags=None, testing_information=None, type=None):
        if action_plan_instructions and not isinstance(action_plan_instructions, str):
            raise TypeError("Expected argument 'action_plan_instructions' to be a str")
        pulumi.set(__self__, "action_plan_instructions", action_plan_instructions)
        if action_plan_title and not isinstance(action_plan_title, str):
            raise TypeError("Expected argument 'action_plan_title' to be a str")
        pulumi.set(__self__, "action_plan_title", action_plan_title)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if control_mapping_sources and not isinstance(control_mapping_sources, list):
            raise TypeError("Expected argument 'control_mapping_sources' to be a list")
        pulumi.set(__self__, "control_mapping_sources", control_mapping_sources)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if testing_information and not isinstance(testing_information, str):
            raise TypeError("Expected argument 'testing_information' to be a str")
        pulumi.set(__self__, "testing_information", testing_information)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="actionPlanInstructions")
    def action_plan_instructions(self) -> builtins.str:
        return pulumi.get(self, "action_plan_instructions")

    @property
    @pulumi.getter(name="actionPlanTitle")
    def action_plan_title(self) -> builtins.str:
        return pulumi.get(self, "action_plan_title")

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="controlMappingSources")
    def control_mapping_sources(self) -> Sequence['outputs.GetControlControlMappingSourceResult']:
        return pulumi.get(self, "control_mapping_sources")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="testingInformation")
    def testing_information(self) -> builtins.str:
        return pulumi.get(self, "testing_information")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


class AwaitableGetControlResult(GetControlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetControlResult(
            action_plan_instructions=self.action_plan_instructions,
            action_plan_title=self.action_plan_title,
            arn=self.arn,
            control_mapping_sources=self.control_mapping_sources,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region,
            tags=self.tags,
            testing_information=self.testing_information,
            type=self.type)


def get_control(name: Optional[builtins.str] = None,
                region: Optional[builtins.str] = None,
                type: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetControlResult:
    """
    Data source for managing an AWS Audit Manager Control.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.auditmanager.get_control(name="1. Risk Management",
        type="Standard")
    ```

    ### With Framework Resource

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.auditmanager.get_control(name="1. Risk Management",
        type="Standard")
    example2 = aws.auditmanager.get_control(name="2. Personnel",
        type="Standard")
    example_framework = aws.auditmanager.Framework("example",
        name="example",
        control_sets=[
            {
                "name": "example",
                "controls": [{
                    "id": example.id,
                }],
            },
            {
                "name": "example2",
                "controls": [{
                    "id": example2.id,
                }],
            },
        ])
    ```


    :param builtins.str name: Name of the control.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str type: Type of control. Valid values are `Custom` and `Standard`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:auditmanager/getControl:getControl', __args__, opts=opts, typ=GetControlResult).value

    return AwaitableGetControlResult(
        action_plan_instructions=pulumi.get(__ret__, 'action_plan_instructions'),
        action_plan_title=pulumi.get(__ret__, 'action_plan_title'),
        arn=pulumi.get(__ret__, 'arn'),
        control_mapping_sources=pulumi.get(__ret__, 'control_mapping_sources'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        testing_information=pulumi.get(__ret__, 'testing_information'),
        type=pulumi.get(__ret__, 'type'))
def get_control_output(name: Optional[pulumi.Input[builtins.str]] = None,
                       region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       type: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetControlResult]:
    """
    Data source for managing an AWS Audit Manager Control.

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.auditmanager.get_control(name="1. Risk Management",
        type="Standard")
    ```

    ### With Framework Resource

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.auditmanager.get_control(name="1. Risk Management",
        type="Standard")
    example2 = aws.auditmanager.get_control(name="2. Personnel",
        type="Standard")
    example_framework = aws.auditmanager.Framework("example",
        name="example",
        control_sets=[
            {
                "name": "example",
                "controls": [{
                    "id": example.id,
                }],
            },
            {
                "name": "example2",
                "controls": [{
                    "id": example2.id,
                }],
            },
        ])
    ```


    :param builtins.str name: Name of the control.
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.str type: Type of control. Valid values are `Custom` and `Standard`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:auditmanager/getControl:getControl', __args__, opts=opts, typ=GetControlResult)
    return __ret__.apply(lambda __response__: GetControlResult(
        action_plan_instructions=pulumi.get(__response__, 'action_plan_instructions'),
        action_plan_title=pulumi.get(__response__, 'action_plan_title'),
        arn=pulumi.get(__response__, 'arn'),
        control_mapping_sources=pulumi.get(__response__, 'control_mapping_sources'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        testing_information=pulumi.get(__response__, 'testing_information'),
        type=pulumi.get(__response__, 'type')))
