# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TrafficSourceAttachmentArgs', 'TrafficSourceAttachment']

@pulumi.input_type
class TrafficSourceAttachmentArgs:
    def __init__(__self__, *,
                 autoscaling_group_name: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_source: Optional[pulumi.Input['TrafficSourceAttachmentTrafficSourceArgs']] = None):
        """
        The set of arguments for constructing a TrafficSourceAttachment resource.
        :param pulumi.Input[builtins.str] autoscaling_group_name: The name of the Auto Scaling group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['TrafficSourceAttachmentTrafficSourceArgs'] traffic_source: The unique identifiers of a traffic sources.
        """
        pulumi.set(__self__, "autoscaling_group_name", autoscaling_group_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if traffic_source is not None:
            pulumi.set(__self__, "traffic_source", traffic_source)

    @property
    @pulumi.getter(name="autoscalingGroupName")
    def autoscaling_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Auto Scaling group.
        """
        return pulumi.get(self, "autoscaling_group_name")

    @autoscaling_group_name.setter
    def autoscaling_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "autoscaling_group_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="trafficSource")
    def traffic_source(self) -> Optional[pulumi.Input['TrafficSourceAttachmentTrafficSourceArgs']]:
        """
        The unique identifiers of a traffic sources.
        """
        return pulumi.get(self, "traffic_source")

    @traffic_source.setter
    def traffic_source(self, value: Optional[pulumi.Input['TrafficSourceAttachmentTrafficSourceArgs']]):
        pulumi.set(self, "traffic_source", value)


@pulumi.input_type
class _TrafficSourceAttachmentState:
    def __init__(__self__, *,
                 autoscaling_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_source: Optional[pulumi.Input['TrafficSourceAttachmentTrafficSourceArgs']] = None):
        """
        Input properties used for looking up and filtering TrafficSourceAttachment resources.
        :param pulumi.Input[builtins.str] autoscaling_group_name: The name of the Auto Scaling group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['TrafficSourceAttachmentTrafficSourceArgs'] traffic_source: The unique identifiers of a traffic sources.
        """
        if autoscaling_group_name is not None:
            pulumi.set(__self__, "autoscaling_group_name", autoscaling_group_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if traffic_source is not None:
            pulumi.set(__self__, "traffic_source", traffic_source)

    @property
    @pulumi.getter(name="autoscalingGroupName")
    def autoscaling_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Auto Scaling group.
        """
        return pulumi.get(self, "autoscaling_group_name")

    @autoscaling_group_name.setter
    def autoscaling_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "autoscaling_group_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="trafficSource")
    def traffic_source(self) -> Optional[pulumi.Input['TrafficSourceAttachmentTrafficSourceArgs']]:
        """
        The unique identifiers of a traffic sources.
        """
        return pulumi.get(self, "traffic_source")

    @traffic_source.setter
    def traffic_source(self, value: Optional[pulumi.Input['TrafficSourceAttachmentTrafficSourceArgs']]):
        pulumi.set(self, "traffic_source", value)


@pulumi.type_token("aws:autoscaling/trafficSourceAttachment:TrafficSourceAttachment")
class TrafficSourceAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_source: Optional[pulumi.Input[Union['TrafficSourceAttachmentTrafficSourceArgs', 'TrafficSourceAttachmentTrafficSourceArgsDict']]] = None,
                 __props__=None):
        """
        Attaches a traffic source to an Auto Scaling group.

        > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.autoscaling.TrafficSourceAttachment("example",
            autoscaling_group_name=example_aws_autoscaling_group["id"],
            traffic_source={
                "identifier": example_aws_lb_target_group["arn"],
                "type": "elbv2",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] autoscaling_group_name: The name of the Auto Scaling group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['TrafficSourceAttachmentTrafficSourceArgs', 'TrafficSourceAttachmentTrafficSourceArgsDict']] traffic_source: The unique identifiers of a traffic sources.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrafficSourceAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attaches a traffic source to an Auto Scaling group.

        > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.autoscaling.TrafficSourceAttachment("example",
            autoscaling_group_name=example_aws_autoscaling_group["id"],
            traffic_source={
                "identifier": example_aws_lb_target_group["arn"],
                "type": "elbv2",
            })
        ```

        :param str resource_name: The name of the resource.
        :param TrafficSourceAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrafficSourceAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 traffic_source: Optional[pulumi.Input[Union['TrafficSourceAttachmentTrafficSourceArgs', 'TrafficSourceAttachmentTrafficSourceArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrafficSourceAttachmentArgs.__new__(TrafficSourceAttachmentArgs)

            if autoscaling_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'autoscaling_group_name'")
            __props__.__dict__["autoscaling_group_name"] = autoscaling_group_name
            __props__.__dict__["region"] = region
            __props__.__dict__["traffic_source"] = traffic_source
        super(TrafficSourceAttachment, __self__).__init__(
            'aws:autoscaling/trafficSourceAttachment:TrafficSourceAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoscaling_group_name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            traffic_source: Optional[pulumi.Input[Union['TrafficSourceAttachmentTrafficSourceArgs', 'TrafficSourceAttachmentTrafficSourceArgsDict']]] = None) -> 'TrafficSourceAttachment':
        """
        Get an existing TrafficSourceAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] autoscaling_group_name: The name of the Auto Scaling group.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['TrafficSourceAttachmentTrafficSourceArgs', 'TrafficSourceAttachmentTrafficSourceArgsDict']] traffic_source: The unique identifiers of a traffic sources.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrafficSourceAttachmentState.__new__(_TrafficSourceAttachmentState)

        __props__.__dict__["autoscaling_group_name"] = autoscaling_group_name
        __props__.__dict__["region"] = region
        __props__.__dict__["traffic_source"] = traffic_source
        return TrafficSourceAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoscalingGroupName")
    def autoscaling_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Auto Scaling group.
        """
        return pulumi.get(self, "autoscaling_group_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="trafficSource")
    def traffic_source(self) -> pulumi.Output[Optional['outputs.TrafficSourceAttachmentTrafficSource']]:
        """
        The unique identifiers of a traffic sources.
        """
        return pulumi.get(self, "traffic_source")

