# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ScalingPlanApplicationSource',
    'ScalingPlanApplicationSourceTagFilter',
    'ScalingPlanScalingInstruction',
    'ScalingPlanScalingInstructionCustomizedLoadMetricSpecification',
    'ScalingPlanScalingInstructionPredefinedLoadMetricSpecification',
    'ScalingPlanScalingInstructionTargetTrackingConfiguration',
    'ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification',
    'ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification',
]

@pulumi.output_type
class ScalingPlanApplicationSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudformationStackArn":
            suggest = "cloudformation_stack_arn"
        elif key == "tagFilters":
            suggest = "tag_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPlanApplicationSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPlanApplicationSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPlanApplicationSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudformation_stack_arn: Optional[builtins.str] = None,
                 tag_filters: Optional[Sequence['outputs.ScalingPlanApplicationSourceTagFilter']] = None):
        """
        :param builtins.str cloudformation_stack_arn: ARN of a AWS CloudFormation stack.
        :param Sequence['ScalingPlanApplicationSourceTagFilterArgs'] tag_filters: Set of tags.
        """
        if cloudformation_stack_arn is not None:
            pulumi.set(__self__, "cloudformation_stack_arn", cloudformation_stack_arn)
        if tag_filters is not None:
            pulumi.set(__self__, "tag_filters", tag_filters)

    @property
    @pulumi.getter(name="cloudformationStackArn")
    def cloudformation_stack_arn(self) -> Optional[builtins.str]:
        """
        ARN of a AWS CloudFormation stack.
        """
        return pulumi.get(self, "cloudformation_stack_arn")

    @property
    @pulumi.getter(name="tagFilters")
    def tag_filters(self) -> Optional[Sequence['outputs.ScalingPlanApplicationSourceTagFilter']]:
        """
        Set of tags.
        """
        return pulumi.get(self, "tag_filters")


@pulumi.output_type
class ScalingPlanApplicationSourceTagFilter(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str key: Tag key.
        :param Sequence[builtins.str] values: Tag values.
        """
        pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Tag key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        Tag values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ScalingPlanScalingInstruction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "scalableDimension":
            suggest = "scalable_dimension"
        elif key == "serviceNamespace":
            suggest = "service_namespace"
        elif key == "targetTrackingConfigurations":
            suggest = "target_tracking_configurations"
        elif key == "customizedLoadMetricSpecification":
            suggest = "customized_load_metric_specification"
        elif key == "disableDynamicScaling":
            suggest = "disable_dynamic_scaling"
        elif key == "predefinedLoadMetricSpecification":
            suggest = "predefined_load_metric_specification"
        elif key == "predictiveScalingMaxCapacityBehavior":
            suggest = "predictive_scaling_max_capacity_behavior"
        elif key == "predictiveScalingMaxCapacityBuffer":
            suggest = "predictive_scaling_max_capacity_buffer"
        elif key == "predictiveScalingMode":
            suggest = "predictive_scaling_mode"
        elif key == "scalingPolicyUpdateBehavior":
            suggest = "scaling_policy_update_behavior"
        elif key == "scheduledActionBufferTime":
            suggest = "scheduled_action_buffer_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPlanScalingInstruction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPlanScalingInstruction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPlanScalingInstruction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: builtins.int,
                 min_capacity: builtins.int,
                 resource_id: builtins.str,
                 scalable_dimension: builtins.str,
                 service_namespace: builtins.str,
                 target_tracking_configurations: Sequence['outputs.ScalingPlanScalingInstructionTargetTrackingConfiguration'],
                 customized_load_metric_specification: Optional['outputs.ScalingPlanScalingInstructionCustomizedLoadMetricSpecification'] = None,
                 disable_dynamic_scaling: Optional[builtins.bool] = None,
                 predefined_load_metric_specification: Optional['outputs.ScalingPlanScalingInstructionPredefinedLoadMetricSpecification'] = None,
                 predictive_scaling_max_capacity_behavior: Optional[builtins.str] = None,
                 predictive_scaling_max_capacity_buffer: Optional[builtins.int] = None,
                 predictive_scaling_mode: Optional[builtins.str] = None,
                 scaling_policy_update_behavior: Optional[builtins.str] = None,
                 scheduled_action_buffer_time: Optional[builtins.int] = None):
        """
        :param builtins.int max_capacity: Maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for `predictive_scaling_max_capacity_behavior`.
        :param builtins.int min_capacity: Minimum capacity of the resource.
        :param builtins.str resource_id: ID of the resource. This string consists of the resource type and unique identifier.
        :param builtins.str scalable_dimension: Scalable dimension associated with the resource. Valid values: `autoscaling:autoScalingGroup:DesiredCapacity`, `dynamodb:index:ReadCapacityUnits`, `dynamodb:index:WriteCapacityUnits`, `dynamodb:table:ReadCapacityUnits`, `dynamodb:table:WriteCapacityUnits`, `ecs:service:DesiredCount`, `ec2:spot-fleet-request:TargetCapacity`, `rds:cluster:ReadReplicaCount`.
        :param builtins.str service_namespace: Namespace of the AWS service. Valid values: `autoscaling`, `dynamodb`, `ecs`, `ec2`, `rds`.
        :param Sequence['ScalingPlanScalingInstructionTargetTrackingConfigurationArgs'] target_tracking_configurations: Structure that defines new target tracking configurations. Each of these structures includes a specific scaling metric and a target value for the metric, along with various parameters to use with dynamic scaling.
               More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_TargetTrackingConfiguration.html).
        :param 'ScalingPlanScalingInstructionCustomizedLoadMetricSpecificationArgs' customized_load_metric_specification: Customized load metric to use for predictive scaling. You must specify either `customized_load_metric_specification` or `predefined_load_metric_specification` when configuring predictive scaling.
               More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedLoadMetricSpecification.html).
        :param builtins.bool disable_dynamic_scaling: Boolean controlling whether dynamic scaling by AWS Auto Scaling is disabled. Defaults to `false`.
        :param 'ScalingPlanScalingInstructionPredefinedLoadMetricSpecificationArgs' predefined_load_metric_specification: Predefined load metric to use for predictive scaling. You must specify either `predefined_load_metric_specification` or `customized_load_metric_specification` when configuring predictive scaling.
               More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedLoadMetricSpecification.html).
        :param builtins.str predictive_scaling_max_capacity_behavior: Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource.
               Valid values: `SetForecastCapacityToMaxCapacity`, `SetMaxCapacityAboveForecastCapacity`, `SetMaxCapacityToForecastCapacity`.
        :param builtins.int predictive_scaling_max_capacity_buffer: Size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
        :param builtins.str predictive_scaling_mode: Predictive scaling mode. Valid values: `ForecastAndScale`, `ForecastOnly`.
        :param builtins.str scaling_policy_update_behavior: Controls whether a resource's externally created scaling policies are kept or replaced. Valid values: `KeepExternalPolicies`, `ReplaceExternalPolicies`. Defaults to `KeepExternalPolicies`.
        :param builtins.int scheduled_action_buffer_time: Amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "scalable_dimension", scalable_dimension)
        pulumi.set(__self__, "service_namespace", service_namespace)
        pulumi.set(__self__, "target_tracking_configurations", target_tracking_configurations)
        if customized_load_metric_specification is not None:
            pulumi.set(__self__, "customized_load_metric_specification", customized_load_metric_specification)
        if disable_dynamic_scaling is not None:
            pulumi.set(__self__, "disable_dynamic_scaling", disable_dynamic_scaling)
        if predefined_load_metric_specification is not None:
            pulumi.set(__self__, "predefined_load_metric_specification", predefined_load_metric_specification)
        if predictive_scaling_max_capacity_behavior is not None:
            pulumi.set(__self__, "predictive_scaling_max_capacity_behavior", predictive_scaling_max_capacity_behavior)
        if predictive_scaling_max_capacity_buffer is not None:
            pulumi.set(__self__, "predictive_scaling_max_capacity_buffer", predictive_scaling_max_capacity_buffer)
        if predictive_scaling_mode is not None:
            pulumi.set(__self__, "predictive_scaling_mode", predictive_scaling_mode)
        if scaling_policy_update_behavior is not None:
            pulumi.set(__self__, "scaling_policy_update_behavior", scaling_policy_update_behavior)
        if scheduled_action_buffer_time is not None:
            pulumi.set(__self__, "scheduled_action_buffer_time", scheduled_action_buffer_time)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> builtins.int:
        """
        Maximum capacity of the resource. The exception to this upper limit is if you specify a non-default setting for `predictive_scaling_max_capacity_behavior`.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> builtins.int:
        """
        Minimum capacity of the resource.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        ID of the resource. This string consists of the resource type and unique identifier.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="scalableDimension")
    def scalable_dimension(self) -> builtins.str:
        """
        Scalable dimension associated with the resource. Valid values: `autoscaling:autoScalingGroup:DesiredCapacity`, `dynamodb:index:ReadCapacityUnits`, `dynamodb:index:WriteCapacityUnits`, `dynamodb:table:ReadCapacityUnits`, `dynamodb:table:WriteCapacityUnits`, `ecs:service:DesiredCount`, `ec2:spot-fleet-request:TargetCapacity`, `rds:cluster:ReadReplicaCount`.
        """
        return pulumi.get(self, "scalable_dimension")

    @property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> builtins.str:
        """
        Namespace of the AWS service. Valid values: `autoscaling`, `dynamodb`, `ecs`, `ec2`, `rds`.
        """
        return pulumi.get(self, "service_namespace")

    @property
    @pulumi.getter(name="targetTrackingConfigurations")
    def target_tracking_configurations(self) -> Sequence['outputs.ScalingPlanScalingInstructionTargetTrackingConfiguration']:
        """
        Structure that defines new target tracking configurations. Each of these structures includes a specific scaling metric and a target value for the metric, along with various parameters to use with dynamic scaling.
        More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_TargetTrackingConfiguration.html).
        """
        return pulumi.get(self, "target_tracking_configurations")

    @property
    @pulumi.getter(name="customizedLoadMetricSpecification")
    def customized_load_metric_specification(self) -> Optional['outputs.ScalingPlanScalingInstructionCustomizedLoadMetricSpecification']:
        """
        Customized load metric to use for predictive scaling. You must specify either `customized_load_metric_specification` or `predefined_load_metric_specification` when configuring predictive scaling.
        More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedLoadMetricSpecification.html).
        """
        return pulumi.get(self, "customized_load_metric_specification")

    @property
    @pulumi.getter(name="disableDynamicScaling")
    def disable_dynamic_scaling(self) -> Optional[builtins.bool]:
        """
        Boolean controlling whether dynamic scaling by AWS Auto Scaling is disabled. Defaults to `false`.
        """
        return pulumi.get(self, "disable_dynamic_scaling")

    @property
    @pulumi.getter(name="predefinedLoadMetricSpecification")
    def predefined_load_metric_specification(self) -> Optional['outputs.ScalingPlanScalingInstructionPredefinedLoadMetricSpecification']:
        """
        Predefined load metric to use for predictive scaling. You must specify either `predefined_load_metric_specification` or `customized_load_metric_specification` when configuring predictive scaling.
        More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedLoadMetricSpecification.html).
        """
        return pulumi.get(self, "predefined_load_metric_specification")

    @property
    @pulumi.getter(name="predictiveScalingMaxCapacityBehavior")
    def predictive_scaling_max_capacity_behavior(self) -> Optional[builtins.str]:
        """
        Defines the behavior that should be applied if the forecast capacity approaches or exceeds the maximum capacity specified for the resource.
        Valid values: `SetForecastCapacityToMaxCapacity`, `SetMaxCapacityAboveForecastCapacity`, `SetMaxCapacityToForecastCapacity`.
        """
        return pulumi.get(self, "predictive_scaling_max_capacity_behavior")

    @property
    @pulumi.getter(name="predictiveScalingMaxCapacityBuffer")
    def predictive_scaling_max_capacity_buffer(self) -> Optional[builtins.int]:
        """
        Size of the capacity buffer to use when the forecast capacity is close to or exceeds the maximum capacity.
        """
        return pulumi.get(self, "predictive_scaling_max_capacity_buffer")

    @property
    @pulumi.getter(name="predictiveScalingMode")
    def predictive_scaling_mode(self) -> Optional[builtins.str]:
        """
        Predictive scaling mode. Valid values: `ForecastAndScale`, `ForecastOnly`.
        """
        return pulumi.get(self, "predictive_scaling_mode")

    @property
    @pulumi.getter(name="scalingPolicyUpdateBehavior")
    def scaling_policy_update_behavior(self) -> Optional[builtins.str]:
        """
        Controls whether a resource's externally created scaling policies are kept or replaced. Valid values: `KeepExternalPolicies`, `ReplaceExternalPolicies`. Defaults to `KeepExternalPolicies`.
        """
        return pulumi.get(self, "scaling_policy_update_behavior")

    @property
    @pulumi.getter(name="scheduledActionBufferTime")
    def scheduled_action_buffer_time(self) -> Optional[builtins.int]:
        """
        Amount of time, in seconds, to buffer the run time of scheduled scaling actions when scaling out.
        """
        return pulumi.get(self, "scheduled_action_buffer_time")


@pulumi.output_type
class ScalingPlanScalingInstructionCustomizedLoadMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPlanScalingInstructionCustomizedLoadMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPlanScalingInstructionCustomizedLoadMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPlanScalingInstructionCustomizedLoadMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: builtins.str,
                 namespace: builtins.str,
                 statistic: builtins.str,
                 dimensions: Optional[Mapping[str, builtins.str]] = None,
                 unit: Optional[builtins.str] = None):
        """
        :param builtins.str metric_name: Name of the metric.
        :param builtins.str namespace: Namespace of the metric.
        :param builtins.str statistic: Statistic of the metric. Currently, the value must always be `Sum`.
        :param Mapping[str, builtins.str] dimensions: Dimensions of the metric.
        :param builtins.str unit: Unit of the metric.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "statistic", statistic)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> builtins.str:
        """
        Name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def statistic(self) -> builtins.str:
        """
        Statistic of the metric. Currently, the value must always be `Sum`.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Dimensions of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def unit(self) -> Optional[builtins.str]:
        """
        Unit of the metric.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ScalingPlanScalingInstructionPredefinedLoadMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedLoadMetricType":
            suggest = "predefined_load_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPlanScalingInstructionPredefinedLoadMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPlanScalingInstructionPredefinedLoadMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPlanScalingInstructionPredefinedLoadMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_load_metric_type: builtins.str,
                 resource_label: Optional[builtins.str] = None):
        """
        :param builtins.str predefined_load_metric_type: Metric type. Valid values: `ALBTargetGroupRequestCount`, `ASGTotalCPUUtilization`, `ASGTotalNetworkIn`, `ASGTotalNetworkOut`.
        :param builtins.str resource_label: Identifies the resource associated with the metric type.
        """
        pulumi.set(__self__, "predefined_load_metric_type", predefined_load_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedLoadMetricType")
    def predefined_load_metric_type(self) -> builtins.str:
        """
        Metric type. Valid values: `ALBTargetGroupRequestCount`, `ASGTotalCPUUtilization`, `ASGTotalNetworkIn`, `ASGTotalNetworkOut`.
        """
        return pulumi.get(self, "predefined_load_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[builtins.str]:
        """
        Identifies the resource associated with the metric type.
        """
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class ScalingPlanScalingInstructionTargetTrackingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"
        elif key == "customizedScalingMetricSpecification":
            suggest = "customized_scaling_metric_specification"
        elif key == "disableScaleIn":
            suggest = "disable_scale_in"
        elif key == "estimatedInstanceWarmup":
            suggest = "estimated_instance_warmup"
        elif key == "predefinedScalingMetricSpecification":
            suggest = "predefined_scaling_metric_specification"
        elif key == "scaleInCooldown":
            suggest = "scale_in_cooldown"
        elif key == "scaleOutCooldown":
            suggest = "scale_out_cooldown"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPlanScalingInstructionTargetTrackingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPlanScalingInstructionTargetTrackingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPlanScalingInstructionTargetTrackingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: builtins.float,
                 customized_scaling_metric_specification: Optional['outputs.ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification'] = None,
                 disable_scale_in: Optional[builtins.bool] = None,
                 estimated_instance_warmup: Optional[builtins.int] = None,
                 predefined_scaling_metric_specification: Optional['outputs.ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification'] = None,
                 scale_in_cooldown: Optional[builtins.int] = None,
                 scale_out_cooldown: Optional[builtins.int] = None):
        """
        :param builtins.float target_value: Target value for the metric.
        :param 'ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecificationArgs' customized_scaling_metric_specification: Customized metric. You can specify either `customized_scaling_metric_specification` or `predefined_scaling_metric_specification`.
               More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedScalingMetricSpecification.html).
        :param builtins.bool disable_scale_in: Boolean indicating whether scale in by the target tracking scaling policy is disabled. Defaults to `false`.
        :param builtins.int estimated_instance_warmup: Estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
               This value is used only if the resource is an Auto Scaling group.
        :param 'ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecificationArgs' predefined_scaling_metric_specification: Predefined metric. You can specify either `predefined_scaling_metric_specification` or `customized_scaling_metric_specification`.
               More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html).
        :param builtins.int scale_in_cooldown: Amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
               This value is not used if the scalable resource is an Auto Scaling group.
        :param builtins.int scale_out_cooldown: Amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
               This value is not used if the scalable resource is an Auto Scaling group.
        """
        pulumi.set(__self__, "target_value", target_value)
        if customized_scaling_metric_specification is not None:
            pulumi.set(__self__, "customized_scaling_metric_specification", customized_scaling_metric_specification)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if estimated_instance_warmup is not None:
            pulumi.set(__self__, "estimated_instance_warmup", estimated_instance_warmup)
        if predefined_scaling_metric_specification is not None:
            pulumi.set(__self__, "predefined_scaling_metric_specification", predefined_scaling_metric_specification)
        if scale_in_cooldown is not None:
            pulumi.set(__self__, "scale_in_cooldown", scale_in_cooldown)
        if scale_out_cooldown is not None:
            pulumi.set(__self__, "scale_out_cooldown", scale_out_cooldown)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> builtins.float:
        """
        Target value for the metric.
        """
        return pulumi.get(self, "target_value")

    @property
    @pulumi.getter(name="customizedScalingMetricSpecification")
    def customized_scaling_metric_specification(self) -> Optional['outputs.ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification']:
        """
        Customized metric. You can specify either `customized_scaling_metric_specification` or `predefined_scaling_metric_specification`.
        More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_CustomizedScalingMetricSpecification.html).
        """
        return pulumi.get(self, "customized_scaling_metric_specification")

    @property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[builtins.bool]:
        """
        Boolean indicating whether scale in by the target tracking scaling policy is disabled. Defaults to `false`.
        """
        return pulumi.get(self, "disable_scale_in")

    @property
    @pulumi.getter(name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> Optional[builtins.int]:
        """
        Estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
        This value is used only if the resource is an Auto Scaling group.
        """
        return pulumi.get(self, "estimated_instance_warmup")

    @property
    @pulumi.getter(name="predefinedScalingMetricSpecification")
    def predefined_scaling_metric_specification(self) -> Optional['outputs.ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification']:
        """
        Predefined metric. You can specify either `predefined_scaling_metric_specification` or `customized_scaling_metric_specification`.
        More details can be found in the [AWS Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/plans/APIReference/API_PredefinedScalingMetricSpecification.html).
        """
        return pulumi.get(self, "predefined_scaling_metric_specification")

    @property
    @pulumi.getter(name="scaleInCooldown")
    def scale_in_cooldown(self) -> Optional[builtins.int]:
        """
        Amount of time, in seconds, after a scale in activity completes before another scale in activity can start.
        This value is not used if the scalable resource is an Auto Scaling group.
        """
        return pulumi.get(self, "scale_in_cooldown")

    @property
    @pulumi.getter(name="scaleOutCooldown")
    def scale_out_cooldown(self) -> Optional[builtins.int]:
        """
        Amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
        This value is not used if the scalable resource is an Auto Scaling group.
        """
        return pulumi.get(self, "scale_out_cooldown")


@pulumi.output_type
class ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPlanScalingInstructionTargetTrackingConfigurationCustomizedScalingMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: builtins.str,
                 namespace: builtins.str,
                 statistic: builtins.str,
                 dimensions: Optional[Mapping[str, builtins.str]] = None,
                 unit: Optional[builtins.str] = None):
        """
        :param builtins.str metric_name: Name of the metric.
        :param builtins.str namespace: Namespace of the metric.
        :param builtins.str statistic: Statistic of the metric. Valid values: `Average`, `Maximum`, `Minimum`, `SampleCount`, `Sum`.
        :param Mapping[str, builtins.str] dimensions: Dimensions of the metric.
        :param builtins.str unit: Unit of the metric.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "statistic", statistic)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> builtins.str:
        """
        Name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Namespace of the metric.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def statistic(self) -> builtins.str:
        """
        Statistic of the metric. Valid values: `Average`, `Maximum`, `Minimum`, `SampleCount`, `Sum`.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Dimensions of the metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def unit(self) -> Optional[builtins.str]:
        """
        Unit of the metric.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedScalingMetricType":
            suggest = "predefined_scaling_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPlanScalingInstructionTargetTrackingConfigurationPredefinedScalingMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_scaling_metric_type: builtins.str,
                 resource_label: Optional[builtins.str] = None):
        """
        :param builtins.str predefined_scaling_metric_type: Metric type. Valid values: `ALBRequestCountPerTarget`, `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, `DynamoDBReadCapacityUtilization`, `DynamoDBWriteCapacityUtilization`, `ECSServiceAverageCPUUtilization`, `ECSServiceAverageMemoryUtilization`, `EC2SpotFleetRequestAverageCPUUtilization`, `EC2SpotFleetRequestAverageNetworkIn`, `EC2SpotFleetRequestAverageNetworkOut`, `RDSReaderAverageCPUUtilization`, `RDSReaderAverageDatabaseConnections`.
        :param builtins.str resource_label: Identifies the resource associated with the metric type.
        """
        pulumi.set(__self__, "predefined_scaling_metric_type", predefined_scaling_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedScalingMetricType")
    def predefined_scaling_metric_type(self) -> builtins.str:
        """
        Metric type. Valid values: `ALBRequestCountPerTarget`, `ASGAverageCPUUtilization`, `ASGAverageNetworkIn`, `ASGAverageNetworkOut`, `DynamoDBReadCapacityUtilization`, `DynamoDBWriteCapacityUtilization`, `ECSServiceAverageCPUUtilization`, `ECSServiceAverageMemoryUtilization`, `EC2SpotFleetRequestAverageCPUUtilization`, `EC2SpotFleetRequestAverageNetworkIn`, `EC2SpotFleetRequestAverageNetworkOut`, `RDSReaderAverageCPUUtilization`, `RDSReaderAverageDatabaseConnections`.
        """
        return pulumi.get(self, "predefined_scaling_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[builtins.str]:
        """
        Identifies the resource associated with the metric type.
        """
        return pulumi.get(self, "resource_label")


