# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ComputeEnvironmentComputeResourcesArgs',
    'ComputeEnvironmentComputeResourcesArgsDict',
    'ComputeEnvironmentComputeResourcesEc2ConfigurationArgs',
    'ComputeEnvironmentComputeResourcesEc2ConfigurationArgsDict',
    'ComputeEnvironmentComputeResourcesLaunchTemplateArgs',
    'ComputeEnvironmentComputeResourcesLaunchTemplateArgsDict',
    'ComputeEnvironmentEksConfigurationArgs',
    'ComputeEnvironmentEksConfigurationArgsDict',
    'ComputeEnvironmentUpdatePolicyArgs',
    'ComputeEnvironmentUpdatePolicyArgsDict',
    'JobDefinitionEksPropertiesArgs',
    'JobDefinitionEksPropertiesArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesArgs',
    'JobDefinitionEksPropertiesPodPropertiesArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesContainerArgs',
    'JobDefinitionEksPropertiesPodPropertiesContainerArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesContainerEnvArgs',
    'JobDefinitionEksPropertiesPodPropertiesContainerEnvArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesContainerResourcesArgs',
    'JobDefinitionEksPropertiesPodPropertiesContainerResourcesArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesContainerSecurityContextArgs',
    'JobDefinitionEksPropertiesPodPropertiesContainerSecurityContextArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesContainerVolumeMountArgs',
    'JobDefinitionEksPropertiesPodPropertiesContainerVolumeMountArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs',
    'JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerArgs',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgs',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgs',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgs',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgs',
    'JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesMetadataArgs',
    'JobDefinitionEksPropertiesPodPropertiesMetadataArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesVolumeArgs',
    'JobDefinitionEksPropertiesPodPropertiesVolumeArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs',
    'JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs',
    'JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgsDict',
    'JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs',
    'JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgsDict',
    'JobDefinitionRetryStrategyArgs',
    'JobDefinitionRetryStrategyArgsDict',
    'JobDefinitionRetryStrategyEvaluateOnExitArgs',
    'JobDefinitionRetryStrategyEvaluateOnExitArgsDict',
    'JobDefinitionTimeoutArgs',
    'JobDefinitionTimeoutArgsDict',
    'JobQueueComputeEnvironmentOrderArgs',
    'JobQueueComputeEnvironmentOrderArgsDict',
    'JobQueueJobStateTimeLimitActionArgs',
    'JobQueueJobStateTimeLimitActionArgsDict',
    'JobQueueTimeoutsArgs',
    'JobQueueTimeoutsArgsDict',
    'SchedulingPolicyFairSharePolicyArgs',
    'SchedulingPolicyFairSharePolicyArgsDict',
    'SchedulingPolicyFairSharePolicyShareDistributionArgs',
    'SchedulingPolicyFairSharePolicyShareDistributionArgsDict',
]

MYPY = False

if not MYPY:
    class ComputeEnvironmentComputeResourcesArgsDict(TypedDict):
        max_vcpus: pulumi.Input[builtins.int]
        """
        The maximum number of EC2 vCPUs that an environment can reach.
        """
        subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of VPC subnets into which the compute resources are launched.
        """
        type: pulumi.Input[builtins.str]
        """
        The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
        """
        allocation_strategy: NotRequired[pulumi.Input[builtins.str]]
        """
        The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-allocationStrategy). Defaults to `BEST_FIT`. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        bid_percentage: NotRequired[pulumi.Input[builtins.int]]
        """
        Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        desired_vcpus: NotRequired[pulumi.Input[builtins.int]]
        """
        The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        ec2_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentComputeResourcesEc2ConfigurationArgsDict']]]]
        """
        Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
        """
        ec2_key_pair: NotRequired[pulumi.Input[builtins.str]]
        """
        The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        image_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
        """
        instance_role: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        instance_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        launch_template: NotRequired[pulumi.Input['ComputeEnvironmentComputeResourcesLaunchTemplateArgsDict']]
        """
        The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        min_vcpus: NotRequired[pulumi.Input[builtins.int]]
        """
        The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        placement_group: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon EC2 placement group to associate with your compute resources.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
        """
        spot_iam_fleet_role: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
elif False:
    ComputeEnvironmentComputeResourcesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentComputeResourcesArgs:
    def __init__(__self__, *,
                 max_vcpus: pulumi.Input[builtins.int],
                 subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 type: pulumi.Input[builtins.str],
                 allocation_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 bid_percentage: Optional[pulumi.Input[builtins.int]] = None,
                 desired_vcpus: Optional[pulumi.Input[builtins.int]] = None,
                 ec2_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentComputeResourcesEc2ConfigurationArgs']]]] = None,
                 ec2_key_pair: Optional[pulumi.Input[builtins.str]] = None,
                 image_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_role: Optional[pulumi.Input[builtins.str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 launch_template: Optional[pulumi.Input['ComputeEnvironmentComputeResourcesLaunchTemplateArgs']] = None,
                 min_vcpus: Optional[pulumi.Input[builtins.int]] = None,
                 placement_group: Optional[pulumi.Input[builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 spot_iam_fleet_role: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.int] max_vcpus: The maximum number of EC2 vCPUs that an environment can reach.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnets: A list of VPC subnets into which the compute resources are launched.
        :param pulumi.Input[builtins.str] type: The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
        :param pulumi.Input[builtins.str] allocation_strategy: The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-allocationStrategy). Defaults to `BEST_FIT`. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[builtins.int] bid_percentage: Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[builtins.int] desired_vcpus: The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentComputeResourcesEc2ConfigurationArgs']]] ec2_configurations: Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[builtins.str] ec2_key_pair: The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[builtins.str] image_id: The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
        :param pulumi.Input[builtins.str] instance_role: The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input['ComputeEnvironmentComputeResourcesLaunchTemplateArgs'] launch_template: The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[builtins.int] min_vcpus: The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[builtins.str] placement_group: The Amazon EC2 placement group to associate with your compute resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
        :param pulumi.Input[builtins.str] spot_iam_fleet_role: The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        pulumi.set(__self__, "max_vcpus", max_vcpus)
        pulumi.set(__self__, "subnets", subnets)
        pulumi.set(__self__, "type", type)
        if allocation_strategy is not None:
            pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        if bid_percentage is not None:
            pulumi.set(__self__, "bid_percentage", bid_percentage)
        if desired_vcpus is not None:
            pulumi.set(__self__, "desired_vcpus", desired_vcpus)
        if ec2_configurations is not None:
            pulumi.set(__self__, "ec2_configurations", ec2_configurations)
        if ec2_key_pair is not None:
            pulumi.set(__self__, "ec2_key_pair", ec2_key_pair)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_role is not None:
            pulumi.set(__self__, "instance_role", instance_role)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if min_vcpus is not None:
            pulumi.set(__self__, "min_vcpus", min_vcpus)
        if placement_group is not None:
            pulumi.set(__self__, "placement_group", placement_group)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_iam_fleet_role is not None:
            pulumi.set(__self__, "spot_iam_fleet_role", spot_iam_fleet_role)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="maxVcpus")
    def max_vcpus(self) -> pulumi.Input[builtins.int]:
        """
        The maximum number of EC2 vCPUs that an environment can reach.
        """
        return pulumi.get(self, "max_vcpus")

    @max_vcpus.setter
    def max_vcpus(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_vcpus", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of VPC subnets into which the compute resources are launched.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of compute environment. Valid items are `EC2`, `SPOT`, `FARGATE` or `FARGATE_SPOT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The allocation strategy to use for the compute resource in case not enough instances of the best fitting instance type can be allocated. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/batch/latest/APIReference/API_ComputeResource.html#Batch-Type-ComputeResource-allocationStrategy). Defaults to `BEST_FIT`. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "allocation_strategy")

    @allocation_strategy.setter
    def allocation_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_strategy", value)

    @property
    @pulumi.getter(name="bidPercentage")
    def bid_percentage(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Integer of maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your bid percentage is 20% (`20`), then the Spot price must be below 20% of the current On-Demand price for that EC2 instance. If you leave this field empty, the default value is 100% of the On-Demand price. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "bid_percentage")

    @bid_percentage.setter
    def bid_percentage(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "bid_percentage", value)

    @property
    @pulumi.getter(name="desiredVcpus")
    def desired_vcpus(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The desired number of EC2 vCPUS in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "desired_vcpus")

    @desired_vcpus.setter
    def desired_vcpus(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "desired_vcpus", value)

    @property
    @pulumi.getter(name="ec2Configurations")
    def ec2_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentComputeResourcesEc2ConfigurationArgs']]]]:
        """
        Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If Ec2Configuration isn't specified, the default is ECS_AL2. This parameter isn't applicable to jobs that are running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "ec2_configurations")

    @ec2_configurations.setter
    def ec2_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeEnvironmentComputeResourcesEc2ConfigurationArgs']]]]):
        pulumi.set(self, "ec2_configurations", value)

    @property
    @pulumi.getter(name="ec2KeyPair")
    def ec2_key_pair(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The EC2 key pair that is used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "ec2_key_pair")

    @ec2_key_pair.setter
    def ec2_key_pair(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ec2_key_pair", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified. (Deprecated, use `ec2_configuration` `image_id_override` instead)
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceRole")
    def instance_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon ECS instance role applied to Amazon EC2 instances in a compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "instance_role")

    @instance_role.setter
    def instance_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_role", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance types that may be launched. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['ComputeEnvironmentComputeResourcesLaunchTemplateArgs']]:
        """
        The launch template to use for your compute resources. See details below. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['ComputeEnvironmentComputeResourcesLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="minVcpus")
    def min_vcpus(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of EC2 vCPUs that an environment should maintain. For `EC2` or `SPOT` compute environments, if the parameter is not explicitly defined, a `0` default value will be set. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "min_vcpus")

    @min_vcpus.setter
    def min_vcpus(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_vcpus", value)

    @property
    @pulumi.getter(name="placementGroup")
    def placement_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon EC2 placement group to associate with your compute resources.
        """
        return pulumi.get(self, "placement_group")

    @placement_group.setter
    def placement_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "placement_group", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of EC2 security group that are associated with instances launched in the compute environment. This parameter is required for Fargate compute environments.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="spotIamFleetRole")
    def spot_iam_fleet_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a SPOT compute environment. This parameter is required for SPOT compute environments. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "spot_iam_fleet_role")

    @spot_iam_fleet_role.setter
    def spot_iam_fleet_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "spot_iam_fleet_role", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value pair tags to be applied to resources that are launched in the compute environment. This parameter isn't applicable to jobs running on Fargate resources, and shouldn't be specified.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class ComputeEnvironmentComputeResourcesEc2ConfigurationArgsDict(TypedDict):
        image_id_override: NotRequired[pulumi.Input[builtins.str]]
        """
        The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
        """
        image_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
        """
elif False:
    ComputeEnvironmentComputeResourcesEc2ConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentComputeResourcesEc2ConfigurationArgs:
    def __init__(__self__, *,
                 image_id_override: Optional[pulumi.Input[builtins.str]] = None,
                 image_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] image_id_override: The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
        :param pulumi.Input[builtins.str] image_type: The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
        """
        if image_id_override is not None:
            pulumi.set(__self__, "image_id_override", image_id_override)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)

    @property
    @pulumi.getter(name="imageIdOverride")
    def image_id_override(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the `image_id` argument in the `compute_resources` block.
        """
        return pulumi.get(self, "image_id_override")

    @image_id_override.setter
    def image_id_override(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_id_override", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The image type to match with the instance type to select an AMI. If the `image_id_override` parameter isn't specified, then a recent [Amazon ECS-optimized Amazon Linux 2 AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami) (`ECS_AL2`) is used.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_type", value)


if not MYPY:
    class ComputeEnvironmentComputeResourcesLaunchTemplateArgsDict(TypedDict):
        launch_template_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
        """
        launch_template_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the launch template.
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version number of the launch template. Default: The default version of the launch template.
        """
elif False:
    ComputeEnvironmentComputeResourcesLaunchTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentComputeResourcesLaunchTemplateArgs:
    def __init__(__self__, *,
                 launch_template_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_template_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] launch_template_id: ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
        :param pulumi.Input[builtins.str] launch_template_name: Name of the launch template.
        :param pulumi.Input[builtins.str] version: The version number of the launch template. Default: The default version of the launch template.
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the launch template. You must specify either the launch template ID or launch template name in the request, but not both.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version number of the launch template. Default: The default version of the launch template.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class ComputeEnvironmentEksConfigurationArgsDict(TypedDict):
        eks_cluster_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the Amazon EKS cluster.
        """
        kubernetes_namespace: pulumi.Input[builtins.str]
        """
        The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
        """
elif False:
    ComputeEnvironmentEksConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentEksConfigurationArgs:
    def __init__(__self__, *,
                 eks_cluster_arn: pulumi.Input[builtins.str],
                 kubernetes_namespace: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] eks_cluster_arn: The Amazon Resource Name (ARN) of the Amazon EKS cluster.
        :param pulumi.Input[builtins.str] kubernetes_namespace: The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
        """
        pulumi.set(__self__, "eks_cluster_arn", eks_cluster_arn)
        pulumi.set(__self__, "kubernetes_namespace", kubernetes_namespace)

    @property
    @pulumi.getter(name="eksClusterArn")
    def eks_cluster_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon EKS cluster.
        """
        return pulumi.get(self, "eks_cluster_arn")

    @eks_cluster_arn.setter
    def eks_cluster_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "eks_cluster_arn", value)

    @property
    @pulumi.getter(name="kubernetesNamespace")
    def kubernetes_namespace(self) -> pulumi.Input[builtins.str]:
        """
        The namespace of the Amazon EKS cluster. AWS Batch manages pods in this namespace.
        """
        return pulumi.get(self, "kubernetes_namespace")

    @kubernetes_namespace.setter
    def kubernetes_namespace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kubernetes_namespace", value)


if not MYPY:
    class ComputeEnvironmentUpdatePolicyArgsDict(TypedDict):
        job_execution_timeout_minutes: pulumi.Input[builtins.int]
        """
        Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
        """
        terminate_jobs_on_update: pulumi.Input[builtins.bool]
        """
        Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
        """
elif False:
    ComputeEnvironmentUpdatePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ComputeEnvironmentUpdatePolicyArgs:
    def __init__(__self__, *,
                 job_execution_timeout_minutes: pulumi.Input[builtins.int],
                 terminate_jobs_on_update: pulumi.Input[builtins.bool]):
        """
        :param pulumi.Input[builtins.int] job_execution_timeout_minutes: Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
        :param pulumi.Input[builtins.bool] terminate_jobs_on_update: Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
        """
        pulumi.set(__self__, "job_execution_timeout_minutes", job_execution_timeout_minutes)
        pulumi.set(__self__, "terminate_jobs_on_update", terminate_jobs_on_update)

    @property
    @pulumi.getter(name="jobExecutionTimeoutMinutes")
    def job_execution_timeout_minutes(self) -> pulumi.Input[builtins.int]:
        """
        Specifies the job timeout (in minutes) when the compute environment infrastructure is updated.
        """
        return pulumi.get(self, "job_execution_timeout_minutes")

    @job_execution_timeout_minutes.setter
    def job_execution_timeout_minutes(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "job_execution_timeout_minutes", value)

    @property
    @pulumi.getter(name="terminateJobsOnUpdate")
    def terminate_jobs_on_update(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated.
        """
        return pulumi.get(self, "terminate_jobs_on_update")

    @terminate_jobs_on_update.setter
    def terminate_jobs_on_update(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "terminate_jobs_on_update", value)


if not MYPY:
    class JobDefinitionEksPropertiesArgsDict(TypedDict):
        pod_properties: pulumi.Input['JobDefinitionEksPropertiesPodPropertiesArgsDict']
        """
        Properties for the Kubernetes pod resources of a job. See `pod_properties` below.
        """
elif False:
    JobDefinitionEksPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesArgs:
    def __init__(__self__, *,
                 pod_properties: pulumi.Input['JobDefinitionEksPropertiesPodPropertiesArgs']):
        """
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesArgs'] pod_properties: Properties for the Kubernetes pod resources of a job. See `pod_properties` below.
        """
        pulumi.set(__self__, "pod_properties", pod_properties)

    @property
    @pulumi.getter(name="podProperties")
    def pod_properties(self) -> pulumi.Input['JobDefinitionEksPropertiesPodPropertiesArgs']:
        """
        Properties for the Kubernetes pod resources of a job. See `pod_properties` below.
        """
        return pulumi.get(self, "pod_properties")

    @pod_properties.setter
    def pod_properties(self, value: pulumi.Input['JobDefinitionEksPropertiesPodPropertiesArgs']):
        pulumi.set(self, "pod_properties", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesArgsDict(TypedDict):
        containers: pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerArgsDict']]]
        """
        Properties of the container that's used on the Amazon EKS pod. See containers below.
        """
        dns_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
        """
        host_network: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
        """
        image_pull_secrets: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgsDict']]]]
        """
        List of Kubernetes secret resources. See `image_pull_secret` below.
        """
        init_containers: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerArgsDict']]]]
        """
        Containers which run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. See containers below.
        """
        metadata: NotRequired[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesMetadataArgsDict']]
        """
        Metadata about the Kubernetes pod.
        """
        service_account_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the service account that's used to run the pod.
        """
        share_process_namespace: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates if the processes in a container are shared, or visible, to other containers in the same pod.
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeArgsDict']]]]
        """
        Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
        """
elif False:
    JobDefinitionEksPropertiesPodPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesArgs:
    def __init__(__self__, *,
                 containers: pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerArgs']]],
                 dns_policy: Optional[pulumi.Input[builtins.str]] = None,
                 host_network: Optional[pulumi.Input[builtins.bool]] = None,
                 image_pull_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs']]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerArgs']]]] = None,
                 metadata: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesMetadataArgs']] = None,
                 service_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 share_process_namespace: Optional[pulumi.Input[builtins.bool]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerArgs']]] containers: Properties of the container that's used on the Amazon EKS pod. See containers below.
        :param pulumi.Input[builtins.str] dns_policy: DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
        :param pulumi.Input[builtins.bool] host_network: Whether the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs']]] image_pull_secrets: List of Kubernetes secret resources. See `image_pull_secret` below.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerArgs']]] init_containers: Containers which run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. See containers below.
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesMetadataArgs'] metadata: Metadata about the Kubernetes pod.
        :param pulumi.Input[builtins.str] service_account_name: Name of the service account that's used to run the pod.
        :param pulumi.Input[builtins.bool] share_process_namespace: Indicates if the processes in a container are shared, or visible, to other containers in the same pod.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeArgs']]] volumes: Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
        """
        pulumi.set(__self__, "containers", containers)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if host_network is not None:
            pulumi.set(__self__, "host_network", host_network)
        if image_pull_secrets is not None:
            pulumi.set(__self__, "image_pull_secrets", image_pull_secrets)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if service_account_name is not None:
            pulumi.set(__self__, "service_account_name", service_account_name)
        if share_process_namespace is not None:
            pulumi.set(__self__, "share_process_namespace", share_process_namespace)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerArgs']]]:
        """
        Properties of the container that's used on the Amazon EKS pod. See containers below.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerArgs']]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        DNS policy for the pod. The default value is `ClusterFirst`. If the `host_network` argument is not specified, the default is `ClusterFirstWithHostNet`. `ClusterFirst` indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. For more information, see Pod's DNS policy in the Kubernetes documentation.
        """
        return pulumi.get(self, "dns_policy")

    @dns_policy.setter
    def dns_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_policy", value)

    @property
    @pulumi.getter(name="hostNetwork")
    def host_network(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the pod uses the hosts' network IP address. The default value is `true`. Setting this to `false` enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
        """
        return pulumi.get(self, "host_network")

    @host_network.setter
    def host_network(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "host_network", value)

    @property
    @pulumi.getter(name="imagePullSecrets")
    def image_pull_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs']]]]:
        """
        List of Kubernetes secret resources. See `image_pull_secret` below.
        """
        return pulumi.get(self, "image_pull_secrets")

    @image_pull_secrets.setter
    def image_pull_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs']]]]):
        pulumi.set(self, "image_pull_secrets", value)

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerArgs']]]]:
        """
        Containers which run before application containers, always runs to completion, and must complete successfully before the next container starts. These containers are registered with the Amazon EKS Connector agent and persists the registration information in the Kubernetes backend data store. See containers below.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesMetadataArgs']]:
        """
        Metadata about the Kubernetes pod.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the service account that's used to run the pod.
        """
        return pulumi.get(self, "service_account_name")

    @service_account_name.setter
    def service_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account_name", value)

    @property
    @pulumi.getter(name="shareProcessNamespace")
    def share_process_namespace(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if the processes in a container are shared, or visible, to other containers in the same pod.
        """
        return pulumi.get(self, "share_process_namespace")

    @share_process_namespace.setter
    def share_process_namespace(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "share_process_namespace", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeArgs']]]]:
        """
        Volumes for a job definition that uses Amazon EKS resources. AWS Batch supports emptyDir, hostPath, and secret volume types.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesContainerArgsDict(TypedDict):
        image: pulumi.Input[builtins.str]
        """
        Docker image used to start the container.
        """
        args: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        """
        commands: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        """
        envs: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerEnvArgsDict']]]]
        """
        Environment variables to pass to a container. See EKS Environment below.
        """
        image_pull_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
        """
        resources: NotRequired[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerResourcesArgsDict']]
        """
        Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        """
        security_context: NotRequired[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerSecurityContextArgsDict']]
        """
        Security context for a job.
        """
        volume_mounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerVolumeMountArgsDict']]]]
        """
        Volume mounts for the container.
        """
elif False:
    JobDefinitionEksPropertiesPodPropertiesContainerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerEnvArgs']]]] = None,
                 image_pull_policy: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resources: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerResourcesArgs']] = None,
                 security_context: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerSecurityContextArgs']] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerVolumeMountArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] image: Docker image used to start the container.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] args: Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] commands: Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerEnvArgs']]] envs: Environment variables to pass to a container. See EKS Environment below.
        :param pulumi.Input[builtins.str] image_pull_policy: Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        :param pulumi.Input[builtins.str] name: Name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerResourcesArgs'] resources: Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerSecurityContextArgs'] security_context: Security context for a job.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerVolumeMountArgs']]] volume_mounts: Volume mounts for the container.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[builtins.str]:
        """
        Docker image used to start the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerEnvArgs']]]]:
        """
        Environment variables to pass to a container. See EKS Environment below.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the container. If the name isn't specified, the default name "Default" is used. Each container in a pod must have a unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerResourcesArgs']]:
        """
        Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerSecurityContextArgs']]:
        """
        Security context for a job.
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerSecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerVolumeMountArgs']]]]:
        """
        Volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesContainerEnvArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Name of the job definition.
        """
        value: pulumi.Input[builtins.str]
        """
        Value of the environment variable.
        """
elif False:
    JobDefinitionEksPropertiesPodPropertiesContainerEnvArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesContainerEnvArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Name of the job definition.
        :param pulumi.Input[builtins.str] value: Value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesContainerResourcesArgsDict(TypedDict):
        limits: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        requests: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
elif False:
    JobDefinitionEksPropertiesPodPropertiesContainerResourcesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesContainerResourcesArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 requests: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesContainerSecurityContextArgsDict(TypedDict):
        privileged: NotRequired[pulumi.Input[builtins.bool]]
        read_only_root_file_system: NotRequired[pulumi.Input[builtins.bool]]
        run_as_group: NotRequired[pulumi.Input[builtins.int]]
        run_as_non_root: NotRequired[pulumi.Input[builtins.bool]]
        run_as_user: NotRequired[pulumi.Input[builtins.int]]
elif False:
    JobDefinitionEksPropertiesPodPropertiesContainerSecurityContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesContainerSecurityContextArgs:
    def __init__(__self__, *,
                 privileged: Optional[pulumi.Input[builtins.bool]] = None,
                 read_only_root_file_system: Optional[pulumi.Input[builtins.bool]] = None,
                 run_as_group: Optional[pulumi.Input[builtins.int]] = None,
                 run_as_non_root: Optional[pulumi.Input[builtins.bool]] = None,
                 run_as_user: Optional[pulumi.Input[builtins.int]] = None):
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if read_only_root_file_system is not None:
            pulumi.set(__self__, "read_only_root_file_system", read_only_root_file_system)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_non_root is not None:
            pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="readOnlyRootFileSystem")
    def read_only_root_file_system(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "read_only_root_file_system")

    @read_only_root_file_system.setter
    def read_only_root_file_system(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only_root_file_system", value)

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "run_as_group")

    @run_as_group.setter
    def run_as_group(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "run_as_group", value)

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "run_as_non_root")

    @run_as_non_root.setter
    def run_as_non_root(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "run_as_non_root", value)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "run_as_user", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesContainerVolumeMountArgsDict(TypedDict):
        mount_path: pulumi.Input[builtins.str]
        name: pulumi.Input[builtins.str]
        """
        Name of the job definition.
        """
        read_only: NotRequired[pulumi.Input[builtins.bool]]
elif False:
    JobDefinitionEksPropertiesPodPropertiesContainerVolumeMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 read_only: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] name: Name of the job definition.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Unique identifier.
        """
elif False:
    JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesImagePullSecretArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Unique identifier.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Unique identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesInitContainerArgsDict(TypedDict):
        image: pulumi.Input[builtins.str]
        """
        Docker image used to start the container.
        """
        args: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        """
        commands: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        """
        envs: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgsDict']]]]
        """
        Environment variables to pass to a container. See EKS Environment below.
        """
        image_pull_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the job definition.
        """
        resources: NotRequired[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgsDict']]
        """
        Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        """
        security_context: NotRequired[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgsDict']]
        """
        Security context for a job.
        """
        volume_mounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgsDict']]]]
        """
        Volume mounts for the container.
        """
elif False:
    JobDefinitionEksPropertiesPodPropertiesInitContainerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesInitContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgs']]]] = None,
                 image_pull_policy: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resources: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgs']] = None,
                 security_context: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgs']] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] image: Docker image used to start the container.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] args: Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] commands: Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgs']]] envs: Environment variables to pass to a container. See EKS Environment below.
        :param pulumi.Input[builtins.str] image_pull_policy: Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        :param pulumi.Input[builtins.str] name: Name of the job definition.
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgs'] resources: Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        :param pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgs'] security_context: Security context for a job.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgs']]] volume_mounts: Volume mounts for the container.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[builtins.str]:
        """
        Docker image used to start the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Array of arguments to the entrypoint. If this isn't specified, the CMD of the container image is used. This corresponds to the args member in the Entrypoint portion of the Pod in Kubernetes. Environment variable references are expanded using the container's environment.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Entrypoint for the container. This isn't run within a shell. If this isn't specified, the ENTRYPOINT of the container image is used. Environment variable references are expanded using the container's environment.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgs']]]]:
        """
        Environment variables to pass to a container. See EKS Environment below.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Image pull policy for the container. Supported values are `Always`, `IfNotPresent`, and `Never`.
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgs']]:
        """
        Type and amount of resources to assign to a container. The supported resources include `memory`, `cpu`, and `nvidia.com/gpu`.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgs']]:
        """
        Security context for a job.
        """
        return pulumi.get(self, "security_context")

    @security_context.setter
    def security_context(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgs']]):
        pulumi.set(self, "security_context", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgs']]]]:
        """
        Volume mounts for the container.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Name of the job definition.
        """
        value: pulumi.Input[builtins.str]
        """
        Value of the environment variable.
        """
elif False:
    JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesInitContainerEnvArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Name of the job definition.
        :param pulumi.Input[builtins.str] value: Value of the environment variable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Value of the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgsDict(TypedDict):
        limits: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        requests: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
elif False:
    JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesInitContainerResourcesArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 requests: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requests", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgsDict(TypedDict):
        privileged: NotRequired[pulumi.Input[builtins.bool]]
        read_only_root_file_system: NotRequired[pulumi.Input[builtins.bool]]
        run_as_group: NotRequired[pulumi.Input[builtins.int]]
        run_as_non_root: NotRequired[pulumi.Input[builtins.bool]]
        run_as_user: NotRequired[pulumi.Input[builtins.int]]
elif False:
    JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesInitContainerSecurityContextArgs:
    def __init__(__self__, *,
                 privileged: Optional[pulumi.Input[builtins.bool]] = None,
                 read_only_root_file_system: Optional[pulumi.Input[builtins.bool]] = None,
                 run_as_group: Optional[pulumi.Input[builtins.int]] = None,
                 run_as_non_root: Optional[pulumi.Input[builtins.bool]] = None,
                 run_as_user: Optional[pulumi.Input[builtins.int]] = None):
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if read_only_root_file_system is not None:
            pulumi.set(__self__, "read_only_root_file_system", read_only_root_file_system)
        if run_as_group is not None:
            pulumi.set(__self__, "run_as_group", run_as_group)
        if run_as_non_root is not None:
            pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "privileged", value)

    @property
    @pulumi.getter(name="readOnlyRootFileSystem")
    def read_only_root_file_system(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "read_only_root_file_system")

    @read_only_root_file_system.setter
    def read_only_root_file_system(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only_root_file_system", value)

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "run_as_group")

    @run_as_group.setter
    def run_as_group(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "run_as_group", value)

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "run_as_non_root")

    @run_as_non_root.setter
    def run_as_non_root(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "run_as_non_root", value)

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "run_as_user")

    @run_as_user.setter
    def run_as_user(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "run_as_user", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgsDict(TypedDict):
        mount_path: pulumi.Input[builtins.str]
        name: pulumi.Input[builtins.str]
        """
        Name of the job definition.
        """
        read_only: NotRequired[pulumi.Input[builtins.bool]]
elif False:
    JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesInitContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 read_only: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] name: Name of the job definition.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesMetadataArgsDict(TypedDict):
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Key-value pairs used to identify, sort, and organize cube resources.
        """
elif False:
    JobDefinitionEksPropertiesPodPropertiesMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesMetadataArgs:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Key-value pairs used to identify, sort, and organize cube resources.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value pairs used to identify, sort, and organize cube resources.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesVolumeArgsDict(TypedDict):
        empty_dir: NotRequired[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgsDict']]
        host_path: NotRequired[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgsDict']]
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the job definition.
        """
        secret: NotRequired[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgsDict']]
elif False:
    JobDefinitionEksPropertiesPodPropertiesVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesVolumeArgs:
    def __init__(__self__, *,
                 empty_dir: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs']] = None,
                 host_path: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs']] = None):
        """
        :param pulumi.Input[builtins.str] name: Name of the job definition.
        """
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs']]:
        return pulumi.get(self, "empty_dir")

    @empty_dir.setter
    def empty_dir(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs']]):
        pulumi.set(self, "empty_dir", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs']]:
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs']]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the job definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs']]:
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input['JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs']]):
        pulumi.set(self, "secret", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgsDict(TypedDict):
        size_limit: pulumi.Input[builtins.str]
        """
        Maximum size of the volume. By default, there's no maximum size defined.
        """
        medium: NotRequired[pulumi.Input[builtins.str]]
        """
        Medium to store the volume. The default value is an empty string, which uses the storage of the node.
        """
elif False:
    JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesVolumeEmptyDirArgs:
    def __init__(__self__, *,
                 size_limit: pulumi.Input[builtins.str],
                 medium: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] size_limit: Maximum size of the volume. By default, there's no maximum size defined.
        :param pulumi.Input[builtins.str] medium: Medium to store the volume. The default value is an empty string, which uses the storage of the node.
        """
        pulumi.set(__self__, "size_limit", size_limit)
        if medium is not None:
            pulumi.set(__self__, "medium", medium)

    @property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> pulumi.Input[builtins.str]:
        """
        Maximum size of the volume. By default, there's no maximum size defined.
        """
        return pulumi.get(self, "size_limit")

    @size_limit.setter
    def size_limit(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "size_limit", value)

    @property
    @pulumi.getter
    def medium(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Medium to store the volume. The default value is an empty string, which uses the storage of the node.
        """
        return pulumi.get(self, "medium")

    @medium.setter
    def medium(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "medium", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgsDict(TypedDict):
        path: pulumi.Input[builtins.str]
        """
        Path of the file or directory on the host to mount into containers on the pod.
        """
elif False:
    JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesVolumeHostPathArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] path: Path of the file or directory on the host to mount into containers on the pod.
        """
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        Path of the file or directory on the host to mount into containers on the pod.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)


if not MYPY:
    class JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgsDict(TypedDict):
        secret_name: pulumi.Input[builtins.str]
        """
        Name of the secret. The name must be allowed as a DNS subdomain name.
        """
        optional: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the secret or the secret's keys must be defined.
        """
elif False:
    JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionEksPropertiesPodPropertiesVolumeSecretArgs:
    def __init__(__self__, *,
                 secret_name: pulumi.Input[builtins.str],
                 optional: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] secret_name: Name of the secret. The name must be allowed as a DNS subdomain name.
        :param pulumi.Input[builtins.bool] optional: Whether the secret or the secret's keys must be defined.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the secret. The name must be allowed as a DNS subdomain name.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret_name", value)

    @property
    @pulumi.getter
    def optional(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the secret or the secret's keys must be defined.
        """
        return pulumi.get(self, "optional")

    @optional.setter
    def optional(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "optional", value)


if not MYPY:
    class JobDefinitionRetryStrategyArgsDict(TypedDict):
        attempts: NotRequired[pulumi.Input[builtins.int]]
        """
        Number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
        """
        evaluate_on_exits: NotRequired[pulumi.Input[Sequence[pulumi.Input['JobDefinitionRetryStrategyEvaluateOnExitArgsDict']]]]
        """
        Evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
        """
elif False:
    JobDefinitionRetryStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionRetryStrategyArgs:
    def __init__(__self__, *,
                 attempts: Optional[pulumi.Input[builtins.int]] = None,
                 evaluate_on_exits: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionRetryStrategyEvaluateOnExitArgs']]]] = None):
        """
        :param pulumi.Input[builtins.int] attempts: Number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
        :param pulumi.Input[Sequence[pulumi.Input['JobDefinitionRetryStrategyEvaluateOnExitArgs']]] evaluate_on_exits: Evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
        """
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)
        if evaluate_on_exits is not None:
            pulumi.set(__self__, "evaluate_on_exits", evaluate_on_exits)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of times to move a job to the `RUNNABLE` status. You may specify between `1` and `10` attempts.
        """
        return pulumi.get(self, "attempts")

    @attempts.setter
    def attempts(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "attempts", value)

    @property
    @pulumi.getter(name="evaluateOnExits")
    def evaluate_on_exits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionRetryStrategyEvaluateOnExitArgs']]]]:
        """
        Evaluate on exit conditions under which the job should be retried or failed. If this parameter is specified, then the `attempts` parameter must also be specified. You may specify up to 5 configuration blocks.
        """
        return pulumi.get(self, "evaluate_on_exits")

    @evaluate_on_exits.setter
    def evaluate_on_exits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobDefinitionRetryStrategyEvaluateOnExitArgs']]]]):
        pulumi.set(self, "evaluate_on_exits", value)


if not MYPY:
    class JobDefinitionRetryStrategyEvaluateOnExitArgsDict(TypedDict):
        action: pulumi.Input[builtins.str]
        """
        Action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `retry`, `exit`.
        """
        on_exit_code: NotRequired[pulumi.Input[builtins.str]]
        """
        Glob pattern to match against the decimal representation of the exit code returned for a job.
        """
        on_reason: NotRequired[pulumi.Input[builtins.str]]
        """
        Glob pattern to match against the reason returned for a job.
        """
        on_status_reason: NotRequired[pulumi.Input[builtins.str]]
        """
        Glob pattern to match against the status reason returned for a job.
        """
elif False:
    JobDefinitionRetryStrategyEvaluateOnExitArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionRetryStrategyEvaluateOnExitArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 on_exit_code: Optional[pulumi.Input[builtins.str]] = None,
                 on_reason: Optional[pulumi.Input[builtins.str]] = None,
                 on_status_reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] action: Action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `retry`, `exit`.
        :param pulumi.Input[builtins.str] on_exit_code: Glob pattern to match against the decimal representation of the exit code returned for a job.
        :param pulumi.Input[builtins.str] on_reason: Glob pattern to match against the reason returned for a job.
        :param pulumi.Input[builtins.str] on_status_reason: Glob pattern to match against the status reason returned for a job.
        """
        pulumi.set(__self__, "action", action)
        if on_exit_code is not None:
            pulumi.set(__self__, "on_exit_code", on_exit_code)
        if on_reason is not None:
            pulumi.set(__self__, "on_reason", on_reason)
        if on_status_reason is not None:
            pulumi.set(__self__, "on_status_reason", on_status_reason)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        Action to take if all of the specified conditions are met. The values are not case sensitive. Valid values: `retry`, `exit`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="onExitCode")
    def on_exit_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Glob pattern to match against the decimal representation of the exit code returned for a job.
        """
        return pulumi.get(self, "on_exit_code")

    @on_exit_code.setter
    def on_exit_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_exit_code", value)

    @property
    @pulumi.getter(name="onReason")
    def on_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Glob pattern to match against the reason returned for a job.
        """
        return pulumi.get(self, "on_reason")

    @on_reason.setter
    def on_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_reason", value)

    @property
    @pulumi.getter(name="onStatusReason")
    def on_status_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Glob pattern to match against the status reason returned for a job.
        """
        return pulumi.get(self, "on_status_reason")

    @on_status_reason.setter
    def on_status_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_status_reason", value)


if not MYPY:
    class JobDefinitionTimeoutArgsDict(TypedDict):
        attempt_duration_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
        """
elif False:
    JobDefinitionTimeoutArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDefinitionTimeoutArgs:
    def __init__(__self__, *,
                 attempt_duration_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] attempt_duration_seconds: Time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
        """
        if attempt_duration_seconds is not None:
            pulumi.set(__self__, "attempt_duration_seconds", attempt_duration_seconds)

    @property
    @pulumi.getter(name="attemptDurationSeconds")
    def attempt_duration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Time duration in seconds after which AWS Batch terminates your jobs if they have not finished. The minimum value for the timeout is `60` seconds.
        """
        return pulumi.get(self, "attempt_duration_seconds")

    @attempt_duration_seconds.setter
    def attempt_duration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "attempt_duration_seconds", value)


if not MYPY:
    class JobQueueComputeEnvironmentOrderArgsDict(TypedDict):
        compute_environment: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the compute environment.
        """
        order: pulumi.Input[builtins.int]
        """
        The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
        """
elif False:
    JobQueueComputeEnvironmentOrderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobQueueComputeEnvironmentOrderArgs:
    def __init__(__self__, *,
                 compute_environment: pulumi.Input[builtins.str],
                 order: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] compute_environment: The Amazon Resource Name (ARN) of the compute environment.
        :param pulumi.Input[builtins.int] order: The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
        """
        pulumi.set(__self__, "compute_environment", compute_environment)
        pulumi.set(__self__, "order", order)

    @property
    @pulumi.getter(name="computeEnvironment")
    def compute_environment(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the compute environment.
        """
        return pulumi.get(self, "compute_environment")

    @compute_environment.setter
    def compute_environment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compute_environment", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[builtins.int]:
        """
        The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "order", value)


if not MYPY:
    class JobQueueJobStateTimeLimitActionArgsDict(TypedDict):
        action: pulumi.Input[builtins.str]
        """
        The action to take when a job is at the head of the job queue in the specified state for the specified period of time. Valid values include `"CANCEL"`
        """
        max_time_seconds: pulumi.Input[builtins.int]
        """
        The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken. Valid values include integers between `600` & `86400`
        """
        reason: pulumi.Input[builtins.str]
        """
        The reason to log for the action being taken.
        """
        state: pulumi.Input[builtins.str]
        """
        The state of the job needed to trigger the action. Valid values include `"RUNNABLE"`.
        """
elif False:
    JobQueueJobStateTimeLimitActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobQueueJobStateTimeLimitActionArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 max_time_seconds: pulumi.Input[builtins.int],
                 reason: pulumi.Input[builtins.str],
                 state: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] action: The action to take when a job is at the head of the job queue in the specified state for the specified period of time. Valid values include `"CANCEL"`
        :param pulumi.Input[builtins.int] max_time_seconds: The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken. Valid values include integers between `600` & `86400`
        :param pulumi.Input[builtins.str] reason: The reason to log for the action being taken.
        :param pulumi.Input[builtins.str] state: The state of the job needed to trigger the action. Valid values include `"RUNNABLE"`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "max_time_seconds", max_time_seconds)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        The action to take when a job is at the head of the job queue in the specified state for the specified period of time. Valid values include `"CANCEL"`
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="maxTimeSeconds")
    def max_time_seconds(self) -> pulumi.Input[builtins.int]:
        """
        The approximate amount of time, in seconds, that must pass with the job in the specified state before the action is taken. Valid values include integers between `600` & `86400`
        """
        return pulumi.get(self, "max_time_seconds")

    @max_time_seconds.setter
    def max_time_seconds(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "max_time_seconds", value)

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Input[builtins.str]:
        """
        The reason to log for the action being taken.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input[builtins.str]:
        """
        The state of the job needed to trigger the action. Valid values include `"RUNNABLE"`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "state", value)


if not MYPY:
    class JobQueueTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        update: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    JobQueueTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobQueueTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None,
                 delete: Optional[pulumi.Input[builtins.str]] = None,
                 update: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[builtins.str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[builtins.str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update", value)


if not MYPY:
    class SchedulingPolicyFairSharePolicyArgsDict(TypedDict):
        compute_reservation: NotRequired[pulumi.Input[builtins.int]]
        """
        A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
        """
        share_decay_seconds: NotRequired[pulumi.Input[builtins.int]]
        share_distributions: NotRequired[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyFairSharePolicyShareDistributionArgsDict']]]]
        """
        One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
        """
elif False:
    SchedulingPolicyFairSharePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulingPolicyFairSharePolicyArgs:
    def __init__(__self__, *,
                 compute_reservation: Optional[pulumi.Input[builtins.int]] = None,
                 share_decay_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 share_distributions: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyFairSharePolicyShareDistributionArgs']]]] = None):
        """
        :param pulumi.Input[builtins.int] compute_reservation: A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
        :param pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyFairSharePolicyShareDistributionArgs']]] share_distributions: One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
        """
        if compute_reservation is not None:
            pulumi.set(__self__, "compute_reservation", compute_reservation)
        if share_decay_seconds is not None:
            pulumi.set(__self__, "share_decay_seconds", share_decay_seconds)
        if share_distributions is not None:
            pulumi.set(__self__, "share_distributions", share_distributions)

    @property
    @pulumi.getter(name="computeReservation")
    def compute_reservation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html).
        """
        return pulumi.get(self, "compute_reservation")

    @compute_reservation.setter
    def compute_reservation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "compute_reservation", value)

    @property
    @pulumi.getter(name="shareDecaySeconds")
    def share_decay_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "share_decay_seconds")

    @share_decay_seconds.setter
    def share_decay_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "share_decay_seconds", value)

    @property
    @pulumi.getter(name="shareDistributions")
    def share_distributions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyFairSharePolicyShareDistributionArgs']]]]:
        """
        One or more share distribution blocks which define the weights for the fair share identifiers for the fair share policy. For more information, see [FairsharePolicy](https://docs.aws.amazon.com/batch/latest/APIReference/API_FairsharePolicy.html). The `share_distribution` block is documented below.
        """
        return pulumi.get(self, "share_distributions")

    @share_distributions.setter
    def share_distributions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulingPolicyFairSharePolicyShareDistributionArgs']]]]):
        pulumi.set(self, "share_distributions", value)


if not MYPY:
    class SchedulingPolicyFairSharePolicyShareDistributionArgsDict(TypedDict):
        share_identifier: pulumi.Input[builtins.str]
        """
        A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        weight_factor: NotRequired[pulumi.Input[builtins.float]]
        """
        The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
elif False:
    SchedulingPolicyFairSharePolicyShareDistributionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulingPolicyFairSharePolicyShareDistributionArgs:
    def __init__(__self__, *,
                 share_identifier: pulumi.Input[builtins.str],
                 weight_factor: Optional[pulumi.Input[builtins.float]] = None):
        """
        :param pulumi.Input[builtins.str] share_identifier: A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        :param pulumi.Input[builtins.float] weight_factor: The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        pulumi.set(__self__, "share_identifier", share_identifier)
        if weight_factor is not None:
            pulumi.set(__self__, "weight_factor", weight_factor)

    @property
    @pulumi.getter(name="shareIdentifier")
    def share_identifier(self) -> pulumi.Input[builtins.str]:
        """
        A fair share identifier or fair share identifier prefix. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        return pulumi.get(self, "share_identifier")

    @share_identifier.setter
    def share_identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "share_identifier", value)

    @property
    @pulumi.getter(name="weightFactor")
    def weight_factor(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The weight factor for the fair share identifier. For more information, see [ShareAttributes](https://docs.aws.amazon.com/batch/latest/APIReference/API_ShareAttributes.html).
        """
        return pulumi.get(self, "weight_factor")

    @weight_factor.setter
    def weight_factor(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "weight_factor", value)


