# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetJobDefinitionResult',
    'AwaitableGetJobDefinitionResult',
    'get_job_definition',
    'get_job_definition_output',
]

@pulumi.output_type
class GetJobDefinitionResult:
    """
    A collection of values returned by getJobDefinition.
    """
    def __init__(__self__, arn=None, arn_prefix=None, container_orchestration_type=None, eks_properties=None, id=None, name=None, node_properties=None, region=None, retry_strategies=None, revision=None, scheduling_priority=None, status=None, tags=None, timeouts=None, type=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if arn_prefix and not isinstance(arn_prefix, str):
            raise TypeError("Expected argument 'arn_prefix' to be a str")
        pulumi.set(__self__, "arn_prefix", arn_prefix)
        if container_orchestration_type and not isinstance(container_orchestration_type, str):
            raise TypeError("Expected argument 'container_orchestration_type' to be a str")
        pulumi.set(__self__, "container_orchestration_type", container_orchestration_type)
        if eks_properties and not isinstance(eks_properties, list):
            raise TypeError("Expected argument 'eks_properties' to be a list")
        pulumi.set(__self__, "eks_properties", eks_properties)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_properties and not isinstance(node_properties, list):
            raise TypeError("Expected argument 'node_properties' to be a list")
        pulumi.set(__self__, "node_properties", node_properties)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if retry_strategies and not isinstance(retry_strategies, list):
            raise TypeError("Expected argument 'retry_strategies' to be a list")
        pulumi.set(__self__, "retry_strategies", retry_strategies)
        if revision and not isinstance(revision, int):
            raise TypeError("Expected argument 'revision' to be a int")
        pulumi.set(__self__, "revision", revision)
        if scheduling_priority and not isinstance(scheduling_priority, int):
            raise TypeError("Expected argument 'scheduling_priority' to be a int")
        pulumi.set(__self__, "scheduling_priority", scheduling_priority)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if timeouts and not isinstance(timeouts, list):
            raise TypeError("Expected argument 'timeouts' to be a list")
        pulumi.set(__self__, "timeouts", timeouts)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="arnPrefix")
    def arn_prefix(self) -> builtins.str:
        return pulumi.get(self, "arn_prefix")

    @property
    @pulumi.getter(name="containerOrchestrationType")
    def container_orchestration_type(self) -> builtins.str:
        """
        The orchestration type of the compute environment.
        """
        return pulumi.get(self, "container_orchestration_type")

    @property
    @pulumi.getter(name="eksProperties")
    def eks_properties(self) -> Sequence['outputs.GetJobDefinitionEksPropertyResult']:
        """
        An object with various properties that are specific to Amazon EKS based jobs. This must not be specified for Amazon ECS based job definitions.
        """
        return pulumi.get(self, "eks_properties")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ARN
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeProperties")
    def node_properties(self) -> Sequence['outputs.GetJobDefinitionNodePropertyResult']:
        """
        An object with various properties specific to multi-node parallel jobs. If you specify node properties for a job, it becomes a multi-node parallel job. For more information, see Multi-node Parallel Jobs in the AWS Batch User Guide. If the job definition's type parameter is container, then you must specify either containerProperties or nodeProperties.
        """
        return pulumi.get(self, "node_properties")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="retryStrategies")
    def retry_strategies(self) -> Sequence['outputs.GetJobDefinitionRetryStrategyResult']:
        """
        The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy that's specified during a SubmitJob operation overrides the retry strategy defined here. If a job is terminated due to a timeout, it isn't retried.
        """
        return pulumi.get(self, "retry_strategies")

    @property
    @pulumi.getter
    def revision(self) -> Optional[builtins.int]:
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="schedulingPriority")
    def scheduling_priority(self) -> builtins.int:
        """
        The scheduling priority for jobs that are submitted with this job definition. This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
        """
        return pulumi.get(self, "scheduling_priority")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeouts(self) -> Sequence['outputs.GetJobDefinitionTimeoutResult']:
        """
        The timeout configuration for jobs that are submitted with this job definition, after which AWS Batch terminates your jobs if they have not finished. If a job is terminated due to a timeout, it isn't retried. The minimum value for the timeout is 60 seconds.
        """
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of resource to assign to a container. The supported resources include `GPU`, `MEMORY`, and `VCPU`.
        """
        return pulumi.get(self, "type")


class AwaitableGetJobDefinitionResult(GetJobDefinitionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobDefinitionResult(
            arn=self.arn,
            arn_prefix=self.arn_prefix,
            container_orchestration_type=self.container_orchestration_type,
            eks_properties=self.eks_properties,
            id=self.id,
            name=self.name,
            node_properties=self.node_properties,
            region=self.region,
            retry_strategies=self.retry_strategies,
            revision=self.revision,
            scheduling_priority=self.scheduling_priority,
            status=self.status,
            tags=self.tags,
            timeouts=self.timeouts,
            type=self.type)


def get_job_definition(arn: Optional[builtins.str] = None,
                       name: Optional[builtins.str] = None,
                       region: Optional[builtins.str] = None,
                       revision: Optional[builtins.int] = None,
                       status: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobDefinitionResult:
    """
    Data source for managing an AWS Batch Job Definition.

    ## Example Usage

    ### Lookup via Arn

    ```python
    import pulumi
    import pulumi_aws as aws

    arn = aws.batch.get_job_definition(arn="arn:aws:batch:us-east-1:012345678910:job-definition/example")
    ```

    ### Lookup via Name

    ```python
    import pulumi
    import pulumi_aws as aws

    name = aws.batch.get_job_definition(name="example",
        revision=2)
    ```


    :param builtins.str arn: ARN of the Job Definition. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
    :param builtins.str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.int revision: The revision of the job definition.
    :param builtins.str status: The status of the job definition.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['name'] = name
    __args__['region'] = region
    __args__['revision'] = revision
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:batch/getJobDefinition:getJobDefinition', __args__, opts=opts, typ=GetJobDefinitionResult).value

    return AwaitableGetJobDefinitionResult(
        arn=pulumi.get(__ret__, 'arn'),
        arn_prefix=pulumi.get(__ret__, 'arn_prefix'),
        container_orchestration_type=pulumi.get(__ret__, 'container_orchestration_type'),
        eks_properties=pulumi.get(__ret__, 'eks_properties'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        node_properties=pulumi.get(__ret__, 'node_properties'),
        region=pulumi.get(__ret__, 'region'),
        retry_strategies=pulumi.get(__ret__, 'retry_strategies'),
        revision=pulumi.get(__ret__, 'revision'),
        scheduling_priority=pulumi.get(__ret__, 'scheduling_priority'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        timeouts=pulumi.get(__ret__, 'timeouts'),
        type=pulumi.get(__ret__, 'type'))
def get_job_definition_output(arn: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              revision: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                              status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJobDefinitionResult]:
    """
    Data source for managing an AWS Batch Job Definition.

    ## Example Usage

    ### Lookup via Arn

    ```python
    import pulumi
    import pulumi_aws as aws

    arn = aws.batch.get_job_definition(arn="arn:aws:batch:us-east-1:012345678910:job-definition/example")
    ```

    ### Lookup via Name

    ```python
    import pulumi
    import pulumi_aws as aws

    name = aws.batch.get_job_definition(name="example",
        revision=2)
    ```


    :param builtins.str arn: ARN of the Job Definition. Do not begin the description with "An", "The", "Defines", "Indicates", or "Specifies," as these are verbose. In other words, "Indicates the amount of storage," can be rewritten as "Amount of storage," without losing any information.
    :param builtins.str name: The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
    :param builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param builtins.int revision: The revision of the job definition.
    :param builtins.str status: The status of the job definition.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['name'] = name
    __args__['region'] = region
    __args__['revision'] = revision
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:batch/getJobDefinition:getJobDefinition', __args__, opts=opts, typ=GetJobDefinitionResult)
    return __ret__.apply(lambda __response__: GetJobDefinitionResult(
        arn=pulumi.get(__response__, 'arn'),
        arn_prefix=pulumi.get(__response__, 'arn_prefix'),
        container_orchestration_type=pulumi.get(__response__, 'container_orchestration_type'),
        eks_properties=pulumi.get(__response__, 'eks_properties'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        node_properties=pulumi.get(__response__, 'node_properties'),
        region=pulumi.get(__response__, 'region'),
        retry_strategies=pulumi.get(__response__, 'retry_strategies'),
        revision=pulumi.get(__response__, 'revision'),
        scheduling_priority=pulumi.get(__response__, 'scheduling_priority'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        timeouts=pulumi.get(__response__, 'timeouts'),
        type=pulumi.get(__response__, 'type')))
