# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ExportExportArgs',
    'ExportExportArgsDict',
    'ExportExportDataQueryArgs',
    'ExportExportDataQueryArgsDict',
    'ExportExportDestinationConfigurationArgs',
    'ExportExportDestinationConfigurationArgsDict',
    'ExportExportDestinationConfigurationS3DestinationArgs',
    'ExportExportDestinationConfigurationS3DestinationArgsDict',
    'ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs',
    'ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsDict',
    'ExportExportRefreshCadenceArgs',
    'ExportExportRefreshCadenceArgsDict',
    'ExportTimeoutsArgs',
    'ExportTimeoutsArgsDict',
]

MYPY = False

if not MYPY:
    class ExportExportArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Name of this specific data export.
        """
        data_queries: NotRequired[pulumi.Input[Sequence[pulumi.Input['ExportExportDataQueryArgsDict']]]]
        """
        Data query for this specific data export. See the `data_query` argument reference below.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        Description for this specific data export.
        """
        destination_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationArgsDict']]]]
        """
        Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
        """
        export_arn: NotRequired[pulumi.Input[builtins.str]]
        refresh_cadences: NotRequired[pulumi.Input[Sequence[pulumi.Input['ExportExportRefreshCadenceArgsDict']]]]
        """
        Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
        """
elif False:
    ExportExportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExportExportArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 data_queries: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDataQueryArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationArgs']]]] = None,
                 export_arn: Optional[pulumi.Input[builtins.str]] = None,
                 refresh_cadences: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportRefreshCadenceArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] name: Name of this specific data export.
        :param pulumi.Input[Sequence[pulumi.Input['ExportExportDataQueryArgs']]] data_queries: Data query for this specific data export. See the `data_query` argument reference below.
        :param pulumi.Input[builtins.str] description: Description for this specific data export.
        :param pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationArgs']]] destination_configurations: Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
        :param pulumi.Input[Sequence[pulumi.Input['ExportExportRefreshCadenceArgs']]] refresh_cadences: Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
        """
        pulumi.set(__self__, "name", name)
        if data_queries is not None:
            pulumi.set(__self__, "data_queries", data_queries)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_configurations is not None:
            pulumi.set(__self__, "destination_configurations", destination_configurations)
        if export_arn is not None:
            pulumi.set(__self__, "export_arn", export_arn)
        if refresh_cadences is not None:
            pulumi.set(__self__, "refresh_cadences", refresh_cadences)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of this specific data export.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="dataQueries")
    def data_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDataQueryArgs']]]]:
        """
        Data query for this specific data export. See the `data_query` argument reference below.
        """
        return pulumi.get(self, "data_queries")

    @data_queries.setter
    def data_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDataQueryArgs']]]]):
        pulumi.set(self, "data_queries", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for this specific data export.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationConfigurations")
    def destination_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationArgs']]]]:
        """
        Destination configuration for this specific data export. See the `destination_configurations` argument reference below.
        """
        return pulumi.get(self, "destination_configurations")

    @destination_configurations.setter
    def destination_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationArgs']]]]):
        pulumi.set(self, "destination_configurations", value)

    @property
    @pulumi.getter(name="exportArn")
    def export_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "export_arn")

    @export_arn.setter
    def export_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "export_arn", value)

    @property
    @pulumi.getter(name="refreshCadences")
    def refresh_cadences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportRefreshCadenceArgs']]]]:
        """
        Cadence for Amazon Web Services to update the export in your S3 bucket. See the `refresh_cadence` argument reference below.
        """
        return pulumi.get(self, "refresh_cadences")

    @refresh_cadences.setter
    def refresh_cadences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportRefreshCadenceArgs']]]]):
        pulumi.set(self, "refresh_cadences", value)


if not MYPY:
    class ExportExportDataQueryArgsDict(TypedDict):
        query_statement: pulumi.Input[builtins.str]
        """
        Query statement.
        """
        table_configurations: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]
        """
        Table configuration.
        """
elif False:
    ExportExportDataQueryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExportExportDataQueryArgs:
    def __init__(__self__, *,
                 query_statement: pulumi.Input[builtins.str],
                 table_configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None):
        """
        :param pulumi.Input[builtins.str] query_statement: Query statement.
        :param pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] table_configurations: Table configuration.
        """
        pulumi.set(__self__, "query_statement", query_statement)
        if table_configurations is not None:
            pulumi.set(__self__, "table_configurations", table_configurations)

    @property
    @pulumi.getter(name="queryStatement")
    def query_statement(self) -> pulumi.Input[builtins.str]:
        """
        Query statement.
        """
        return pulumi.get(self, "query_statement")

    @query_statement.setter
    def query_statement(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query_statement", value)

    @property
    @pulumi.getter(name="tableConfigurations")
    def table_configurations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]:
        """
        Table configuration.
        """
        return pulumi.get(self, "table_configurations")

    @table_configurations.setter
    def table_configurations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "table_configurations", value)


if not MYPY:
    class ExportExportDestinationConfigurationArgsDict(TypedDict):
        s3_destinations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationS3DestinationArgsDict']]]]
        """
        Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
        """
elif False:
    ExportExportDestinationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExportExportDestinationConfigurationArgs:
    def __init__(__self__, *,
                 s3_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationS3DestinationArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationS3DestinationArgs']]] s3_destinations: Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
        """
        if s3_destinations is not None:
            pulumi.set(__self__, "s3_destinations", s3_destinations)

    @property
    @pulumi.getter(name="s3Destinations")
    def s3_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationS3DestinationArgs']]]]:
        """
        Object that describes the destination of the data exports file. See the `s3_destination` argument reference below.
        """
        return pulumi.get(self, "s3_destinations")

    @s3_destinations.setter
    def s3_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationS3DestinationArgs']]]]):
        pulumi.set(self, "s3_destinations", value)


if not MYPY:
    class ExportExportDestinationConfigurationS3DestinationArgsDict(TypedDict):
        s3_bucket: pulumi.Input[builtins.str]
        """
        Name of the Amazon S3 bucket used as the destination of a data export file.
        """
        s3_prefix: pulumi.Input[builtins.str]
        """
        S3 path prefix you want prepended to the name of your data export.
        """
        s3_region: pulumi.Input[builtins.str]
        """
        S3 bucket region.
        """
        s3_output_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsDict']]]]
        """
        Output configuration for the data export. See the `s3_output_configurations` argument reference below.
        """
elif False:
    ExportExportDestinationConfigurationS3DestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExportExportDestinationConfigurationS3DestinationArgs:
    def __init__(__self__, *,
                 s3_bucket: pulumi.Input[builtins.str],
                 s3_prefix: pulumi.Input[builtins.str],
                 s3_region: pulumi.Input[builtins.str],
                 s3_output_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] s3_bucket: Name of the Amazon S3 bucket used as the destination of a data export file.
        :param pulumi.Input[builtins.str] s3_prefix: S3 path prefix you want prepended to the name of your data export.
        :param pulumi.Input[builtins.str] s3_region: S3 bucket region.
        :param pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs']]] s3_output_configurations: Output configuration for the data export. See the `s3_output_configurations` argument reference below.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        pulumi.set(__self__, "s3_prefix", s3_prefix)
        pulumi.set(__self__, "s3_region", s3_region)
        if s3_output_configurations is not None:
            pulumi.set(__self__, "s3_output_configurations", s3_output_configurations)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Amazon S3 bucket used as the destination of a data export file.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Prefix")
    def s3_prefix(self) -> pulumi.Input[builtins.str]:
        """
        S3 path prefix you want prepended to the name of your data export.
        """
        return pulumi.get(self, "s3_prefix")

    @s3_prefix.setter
    def s3_prefix(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "s3_prefix", value)

    @property
    @pulumi.getter(name="s3Region")
    def s3_region(self) -> pulumi.Input[builtins.str]:
        """
        S3 bucket region.
        """
        return pulumi.get(self, "s3_region")

    @s3_region.setter
    def s3_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "s3_region", value)

    @property
    @pulumi.getter(name="s3OutputConfigurations")
    def s3_output_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs']]]]:
        """
        Output configuration for the data export. See the `s3_output_configurations` argument reference below.
        """
        return pulumi.get(self, "s3_output_configurations")

    @s3_output_configurations.setter
    def s3_output_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs']]]]):
        pulumi.set(self, "s3_output_configurations", value)


if not MYPY:
    class ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsDict(TypedDict):
        compression: pulumi.Input[builtins.str]
        """
        Compression type for the data export. Valid values `GZIP`, `PARQUET`.
        """
        format: pulumi.Input[builtins.str]
        """
        File format for the data export. Valid values `TEXT_OR_CSV` or `PARQUET`.
        """
        output_type: pulumi.Input[builtins.str]
        """
        Output type for the data export. Valid value `CUSTOM`.
        """
        overwrite: pulumi.Input[builtins.str]
        """
        The rule to follow when generating a version of the data export file. You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time. Valid values `CREATE_NEW_REPORT` or `OVERWRITE_REPORT`.
        """
elif False:
    ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExportExportDestinationConfigurationS3DestinationS3OutputConfigurationArgs:
    def __init__(__self__, *,
                 compression: pulumi.Input[builtins.str],
                 format: pulumi.Input[builtins.str],
                 output_type: pulumi.Input[builtins.str],
                 overwrite: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] compression: Compression type for the data export. Valid values `GZIP`, `PARQUET`.
        :param pulumi.Input[builtins.str] format: File format for the data export. Valid values `TEXT_OR_CSV` or `PARQUET`.
        :param pulumi.Input[builtins.str] output_type: Output type for the data export. Valid value `CUSTOM`.
        :param pulumi.Input[builtins.str] overwrite: The rule to follow when generating a version of the data export file. You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time. Valid values `CREATE_NEW_REPORT` or `OVERWRITE_REPORT`.
        """
        pulumi.set(__self__, "compression", compression)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "output_type", output_type)
        pulumi.set(__self__, "overwrite", overwrite)

    @property
    @pulumi.getter
    def compression(self) -> pulumi.Input[builtins.str]:
        """
        Compression type for the data export. Valid values `GZIP`, `PARQUET`.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[builtins.str]:
        """
        File format for the data export. Valid values `TEXT_OR_CSV` or `PARQUET`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> pulumi.Input[builtins.str]:
        """
        Output type for the data export. Valid value `CUSTOM`.
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "output_type", value)

    @property
    @pulumi.getter
    def overwrite(self) -> pulumi.Input[builtins.str]:
        """
        The rule to follow when generating a version of the data export file. You have the choice to overwrite the previous version or to be delivered in addition to the previous versions. Overwriting exports can save on Amazon S3 storage costs. Creating new export versions allows you to track the changes in cost and usage data over time. Valid values `CREATE_NEW_REPORT` or `OVERWRITE_REPORT`.
        """
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "overwrite", value)


if not MYPY:
    class ExportExportRefreshCadenceArgsDict(TypedDict):
        frequency: pulumi.Input[builtins.str]
        """
        Frequency that data exports are updated. The export refreshes each time the source data updates, up to three times daily. Valid values `SYNCHRONOUS`.
        """
elif False:
    ExportExportRefreshCadenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExportExportRefreshCadenceArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] frequency: Frequency that data exports are updated. The export refreshes each time the source data updates, up to three times daily. Valid values `SYNCHRONOUS`.
        """
        pulumi.set(__self__, "frequency", frequency)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[builtins.str]:
        """
        Frequency that data exports are updated. The export refreshes each time the source data updates, up to three times daily. Valid values `SYNCHRONOUS`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frequency", value)


if not MYPY:
    class ExportTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        update: NotRequired[pulumi.Input[builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    ExportTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExportTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[builtins.str]] = None,
                 update: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[builtins.str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update", value)


