# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GuardrailArgs', 'Guardrail']

@pulumi.input_type
class GuardrailArgs:
    def __init__(__self__, *,
                 blocked_input_messaging: pulumi.Input[builtins.str],
                 blocked_outputs_messaging: pulumi.Input[builtins.str],
                 content_policy_config: Optional[pulumi.Input['GuardrailContentPolicyConfigArgs']] = None,
                 contextual_grounding_policy_config: Optional[pulumi.Input['GuardrailContextualGroundingPolicyConfigArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_information_policy_config: Optional[pulumi.Input['GuardrailSensitiveInformationPolicyConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['GuardrailTimeoutsArgs']] = None,
                 topic_policy_config: Optional[pulumi.Input['GuardrailTopicPolicyConfigArgs']] = None,
                 word_policy_config: Optional[pulumi.Input['GuardrailWordPolicyConfigArgs']] = None):
        """
        The set of arguments for constructing a Guardrail resource.
        :param pulumi.Input[builtins.str] blocked_input_messaging: Message to return when the guardrail blocks a prompt.
        :param pulumi.Input[builtins.str] blocked_outputs_messaging: Message to return when the guardrail blocks a model response.
        :param pulumi.Input['GuardrailContentPolicyConfigArgs'] content_policy_config: Content policy config for a guardrail. See Content Policy Config for more information.
        :param pulumi.Input['GuardrailContextualGroundingPolicyConfigArgs'] contextual_grounding_policy_config: Contextual grounding policy config for a guardrail. See Contextual Grounding Policy Config for more information.
        :param pulumi.Input[builtins.str] description: Description of the guardrail or its version.
        :param pulumi.Input[builtins.str] kms_key_arn: The KMS key with which the guardrail was encrypted at rest.
        :param pulumi.Input[builtins.str] name: Name of the guardrail.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['GuardrailSensitiveInformationPolicyConfigArgs'] sensitive_information_policy_config: Sensitive information policy config for a guardrail. See Sensitive Information Policy Config for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['GuardrailTopicPolicyConfigArgs'] topic_policy_config: Topic policy config for a guardrail. See Topic Policy Config for more information.
        :param pulumi.Input['GuardrailWordPolicyConfigArgs'] word_policy_config: Word policy config for a guardrail. See Word Policy Config for more information.
        """
        pulumi.set(__self__, "blocked_input_messaging", blocked_input_messaging)
        pulumi.set(__self__, "blocked_outputs_messaging", blocked_outputs_messaging)
        if content_policy_config is not None:
            pulumi.set(__self__, "content_policy_config", content_policy_config)
        if contextual_grounding_policy_config is not None:
            pulumi.set(__self__, "contextual_grounding_policy_config", contextual_grounding_policy_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sensitive_information_policy_config is not None:
            pulumi.set(__self__, "sensitive_information_policy_config", sensitive_information_policy_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if topic_policy_config is not None:
            pulumi.set(__self__, "topic_policy_config", topic_policy_config)
        if word_policy_config is not None:
            pulumi.set(__self__, "word_policy_config", word_policy_config)

    @property
    @pulumi.getter(name="blockedInputMessaging")
    def blocked_input_messaging(self) -> pulumi.Input[builtins.str]:
        """
        Message to return when the guardrail blocks a prompt.
        """
        return pulumi.get(self, "blocked_input_messaging")

    @blocked_input_messaging.setter
    def blocked_input_messaging(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "blocked_input_messaging", value)

    @property
    @pulumi.getter(name="blockedOutputsMessaging")
    def blocked_outputs_messaging(self) -> pulumi.Input[builtins.str]:
        """
        Message to return when the guardrail blocks a model response.
        """
        return pulumi.get(self, "blocked_outputs_messaging")

    @blocked_outputs_messaging.setter
    def blocked_outputs_messaging(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "blocked_outputs_messaging", value)

    @property
    @pulumi.getter(name="contentPolicyConfig")
    def content_policy_config(self) -> Optional[pulumi.Input['GuardrailContentPolicyConfigArgs']]:
        """
        Content policy config for a guardrail. See Content Policy Config for more information.
        """
        return pulumi.get(self, "content_policy_config")

    @content_policy_config.setter
    def content_policy_config(self, value: Optional[pulumi.Input['GuardrailContentPolicyConfigArgs']]):
        pulumi.set(self, "content_policy_config", value)

    @property
    @pulumi.getter(name="contextualGroundingPolicyConfig")
    def contextual_grounding_policy_config(self) -> Optional[pulumi.Input['GuardrailContextualGroundingPolicyConfigArgs']]:
        """
        Contextual grounding policy config for a guardrail. See Contextual Grounding Policy Config for more information.
        """
        return pulumi.get(self, "contextual_grounding_policy_config")

    @contextual_grounding_policy_config.setter
    def contextual_grounding_policy_config(self, value: Optional[pulumi.Input['GuardrailContextualGroundingPolicyConfigArgs']]):
        pulumi.set(self, "contextual_grounding_policy_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the guardrail or its version.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The KMS key with which the guardrail was encrypted at rest.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the guardrail.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sensitiveInformationPolicyConfig")
    def sensitive_information_policy_config(self) -> Optional[pulumi.Input['GuardrailSensitiveInformationPolicyConfigArgs']]:
        """
        Sensitive information policy config for a guardrail. See Sensitive Information Policy Config for more information.
        """
        return pulumi.get(self, "sensitive_information_policy_config")

    @sensitive_information_policy_config.setter
    def sensitive_information_policy_config(self, value: Optional[pulumi.Input['GuardrailSensitiveInformationPolicyConfigArgs']]):
        pulumi.set(self, "sensitive_information_policy_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['GuardrailTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['GuardrailTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="topicPolicyConfig")
    def topic_policy_config(self) -> Optional[pulumi.Input['GuardrailTopicPolicyConfigArgs']]:
        """
        Topic policy config for a guardrail. See Topic Policy Config for more information.
        """
        return pulumi.get(self, "topic_policy_config")

    @topic_policy_config.setter
    def topic_policy_config(self, value: Optional[pulumi.Input['GuardrailTopicPolicyConfigArgs']]):
        pulumi.set(self, "topic_policy_config", value)

    @property
    @pulumi.getter(name="wordPolicyConfig")
    def word_policy_config(self) -> Optional[pulumi.Input['GuardrailWordPolicyConfigArgs']]:
        """
        Word policy config for a guardrail. See Word Policy Config for more information.
        """
        return pulumi.get(self, "word_policy_config")

    @word_policy_config.setter
    def word_policy_config(self, value: Optional[pulumi.Input['GuardrailWordPolicyConfigArgs']]):
        pulumi.set(self, "word_policy_config", value)


@pulumi.input_type
class _GuardrailState:
    def __init__(__self__, *,
                 blocked_input_messaging: Optional[pulumi.Input[builtins.str]] = None,
                 blocked_outputs_messaging: Optional[pulumi.Input[builtins.str]] = None,
                 content_policy_config: Optional[pulumi.Input['GuardrailContentPolicyConfigArgs']] = None,
                 contextual_grounding_policy_config: Optional[pulumi.Input['GuardrailContextualGroundingPolicyConfigArgs']] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 guardrail_arn: Optional[pulumi.Input[builtins.str]] = None,
                 guardrail_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_information_policy_config: Optional[pulumi.Input['GuardrailSensitiveInformationPolicyConfigArgs']] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['GuardrailTimeoutsArgs']] = None,
                 topic_policy_config: Optional[pulumi.Input['GuardrailTopicPolicyConfigArgs']] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 word_policy_config: Optional[pulumi.Input['GuardrailWordPolicyConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Guardrail resources.
        :param pulumi.Input[builtins.str] blocked_input_messaging: Message to return when the guardrail blocks a prompt.
        :param pulumi.Input[builtins.str] blocked_outputs_messaging: Message to return when the guardrail blocks a model response.
        :param pulumi.Input['GuardrailContentPolicyConfigArgs'] content_policy_config: Content policy config for a guardrail. See Content Policy Config for more information.
        :param pulumi.Input['GuardrailContextualGroundingPolicyConfigArgs'] contextual_grounding_policy_config: Contextual grounding policy config for a guardrail. See Contextual Grounding Policy Config for more information.
        :param pulumi.Input[builtins.str] created_at: Unix epoch timestamp in seconds for when the Guardrail was created.
        :param pulumi.Input[builtins.str] description: Description of the guardrail or its version.
        :param pulumi.Input[builtins.str] guardrail_arn: ARN of the Guardrail.
        :param pulumi.Input[builtins.str] guardrail_id: ID of the Guardrail.
        :param pulumi.Input[builtins.str] kms_key_arn: The KMS key with which the guardrail was encrypted at rest.
        :param pulumi.Input[builtins.str] name: Name of the guardrail.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['GuardrailSensitiveInformationPolicyConfigArgs'] sensitive_information_policy_config: Sensitive information policy config for a guardrail. See Sensitive Information Policy Config for more information.
        :param pulumi.Input[builtins.str] status: Status of the Bedrock Guardrail. One of `READY`, `FAILED`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['GuardrailTopicPolicyConfigArgs'] topic_policy_config: Topic policy config for a guardrail. See Topic Policy Config for more information.
        :param pulumi.Input[builtins.str] version: Version of the Guardrail.
        :param pulumi.Input['GuardrailWordPolicyConfigArgs'] word_policy_config: Word policy config for a guardrail. See Word Policy Config for more information.
        """
        if blocked_input_messaging is not None:
            pulumi.set(__self__, "blocked_input_messaging", blocked_input_messaging)
        if blocked_outputs_messaging is not None:
            pulumi.set(__self__, "blocked_outputs_messaging", blocked_outputs_messaging)
        if content_policy_config is not None:
            pulumi.set(__self__, "content_policy_config", content_policy_config)
        if contextual_grounding_policy_config is not None:
            pulumi.set(__self__, "contextual_grounding_policy_config", contextual_grounding_policy_config)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if guardrail_arn is not None:
            pulumi.set(__self__, "guardrail_arn", guardrail_arn)
        if guardrail_id is not None:
            pulumi.set(__self__, "guardrail_id", guardrail_id)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sensitive_information_policy_config is not None:
            pulumi.set(__self__, "sensitive_information_policy_config", sensitive_information_policy_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if topic_policy_config is not None:
            pulumi.set(__self__, "topic_policy_config", topic_policy_config)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if word_policy_config is not None:
            pulumi.set(__self__, "word_policy_config", word_policy_config)

    @property
    @pulumi.getter(name="blockedInputMessaging")
    def blocked_input_messaging(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Message to return when the guardrail blocks a prompt.
        """
        return pulumi.get(self, "blocked_input_messaging")

    @blocked_input_messaging.setter
    def blocked_input_messaging(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "blocked_input_messaging", value)

    @property
    @pulumi.getter(name="blockedOutputsMessaging")
    def blocked_outputs_messaging(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Message to return when the guardrail blocks a model response.
        """
        return pulumi.get(self, "blocked_outputs_messaging")

    @blocked_outputs_messaging.setter
    def blocked_outputs_messaging(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "blocked_outputs_messaging", value)

    @property
    @pulumi.getter(name="contentPolicyConfig")
    def content_policy_config(self) -> Optional[pulumi.Input['GuardrailContentPolicyConfigArgs']]:
        """
        Content policy config for a guardrail. See Content Policy Config for more information.
        """
        return pulumi.get(self, "content_policy_config")

    @content_policy_config.setter
    def content_policy_config(self, value: Optional[pulumi.Input['GuardrailContentPolicyConfigArgs']]):
        pulumi.set(self, "content_policy_config", value)

    @property
    @pulumi.getter(name="contextualGroundingPolicyConfig")
    def contextual_grounding_policy_config(self) -> Optional[pulumi.Input['GuardrailContextualGroundingPolicyConfigArgs']]:
        """
        Contextual grounding policy config for a guardrail. See Contextual Grounding Policy Config for more information.
        """
        return pulumi.get(self, "contextual_grounding_policy_config")

    @contextual_grounding_policy_config.setter
    def contextual_grounding_policy_config(self, value: Optional[pulumi.Input['GuardrailContextualGroundingPolicyConfigArgs']]):
        pulumi.set(self, "contextual_grounding_policy_config", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unix epoch timestamp in seconds for when the Guardrail was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the guardrail or its version.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="guardrailArn")
    def guardrail_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the Guardrail.
        """
        return pulumi.get(self, "guardrail_arn")

    @guardrail_arn.setter
    def guardrail_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "guardrail_arn", value)

    @property
    @pulumi.getter(name="guardrailId")
    def guardrail_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the Guardrail.
        """
        return pulumi.get(self, "guardrail_id")

    @guardrail_id.setter
    def guardrail_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "guardrail_id", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The KMS key with which the guardrail was encrypted at rest.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the guardrail.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sensitiveInformationPolicyConfig")
    def sensitive_information_policy_config(self) -> Optional[pulumi.Input['GuardrailSensitiveInformationPolicyConfigArgs']]:
        """
        Sensitive information policy config for a guardrail. See Sensitive Information Policy Config for more information.
        """
        return pulumi.get(self, "sensitive_information_policy_config")

    @sensitive_information_policy_config.setter
    def sensitive_information_policy_config(self, value: Optional[pulumi.Input['GuardrailSensitiveInformationPolicyConfigArgs']]):
        pulumi.set(self, "sensitive_information_policy_config", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the Bedrock Guardrail. One of `READY`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['GuardrailTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['GuardrailTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @property
    @pulumi.getter(name="topicPolicyConfig")
    def topic_policy_config(self) -> Optional[pulumi.Input['GuardrailTopicPolicyConfigArgs']]:
        """
        Topic policy config for a guardrail. See Topic Policy Config for more information.
        """
        return pulumi.get(self, "topic_policy_config")

    @topic_policy_config.setter
    def topic_policy_config(self, value: Optional[pulumi.Input['GuardrailTopicPolicyConfigArgs']]):
        pulumi.set(self, "topic_policy_config", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Version of the Guardrail.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="wordPolicyConfig")
    def word_policy_config(self) -> Optional[pulumi.Input['GuardrailWordPolicyConfigArgs']]:
        """
        Word policy config for a guardrail. See Word Policy Config for more information.
        """
        return pulumi.get(self, "word_policy_config")

    @word_policy_config.setter
    def word_policy_config(self, value: Optional[pulumi.Input['GuardrailWordPolicyConfigArgs']]):
        pulumi.set(self, "word_policy_config", value)


@pulumi.type_token("aws:bedrock/guardrail:Guardrail")
class Guardrail(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blocked_input_messaging: Optional[pulumi.Input[builtins.str]] = None,
                 blocked_outputs_messaging: Optional[pulumi.Input[builtins.str]] = None,
                 content_policy_config: Optional[pulumi.Input[Union['GuardrailContentPolicyConfigArgs', 'GuardrailContentPolicyConfigArgsDict']]] = None,
                 contextual_grounding_policy_config: Optional[pulumi.Input[Union['GuardrailContextualGroundingPolicyConfigArgs', 'GuardrailContextualGroundingPolicyConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_information_policy_config: Optional[pulumi.Input[Union['GuardrailSensitiveInformationPolicyConfigArgs', 'GuardrailSensitiveInformationPolicyConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['GuardrailTimeoutsArgs', 'GuardrailTimeoutsArgsDict']]] = None,
                 topic_policy_config: Optional[pulumi.Input[Union['GuardrailTopicPolicyConfigArgs', 'GuardrailTopicPolicyConfigArgsDict']]] = None,
                 word_policy_config: Optional[pulumi.Input[Union['GuardrailWordPolicyConfigArgs', 'GuardrailWordPolicyConfigArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon Bedrock Guardrail.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.Guardrail("example",
            name="example",
            blocked_input_messaging="example",
            blocked_outputs_messaging="example",
            description="example",
            content_policy_config={
                "filters_configs": [{
                    "input_strength": "MEDIUM",
                    "output_strength": "MEDIUM",
                    "type": "HATE",
                }],
            },
            sensitive_information_policy_config={
                "pii_entities_configs": [{
                    "action": "BLOCK",
                    "type": "NAME",
                }],
                "regexes_configs": [{
                    "action": "BLOCK",
                    "description": "example regex",
                    "name": "regex_example",
                    "pattern": "^\\\\d{3}-\\\\d{2}-\\\\d{4}$",
                }],
            },
            topic_policy_config={
                "topics_configs": [{
                    "name": "investment_topic",
                    "examples": ["Where should I invest my money ?"],
                    "type": "DENY",
                    "definition": "Investment advice refers to inquiries, guidance, or recommendations regarding the management or allocation of funds or assets with the goal of generating returns .",
                }],
            },
            word_policy_config={
                "managed_word_lists_configs": [{
                    "type": "PROFANITY",
                }],
                "words_configs": [{
                    "text": "HATE",
                }],
            })
        ```

        ## Import

        Using `pulumi import`, import Amazon Bedrock Guardrail using using a comma-delimited string of `guardrail_id` and `version`. For example:

        ```sh
        $ pulumi import aws:bedrock/guardrail:Guardrail example guardrail-id-12345678,DRAFT
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] blocked_input_messaging: Message to return when the guardrail blocks a prompt.
        :param pulumi.Input[builtins.str] blocked_outputs_messaging: Message to return when the guardrail blocks a model response.
        :param pulumi.Input[Union['GuardrailContentPolicyConfigArgs', 'GuardrailContentPolicyConfigArgsDict']] content_policy_config: Content policy config for a guardrail. See Content Policy Config for more information.
        :param pulumi.Input[Union['GuardrailContextualGroundingPolicyConfigArgs', 'GuardrailContextualGroundingPolicyConfigArgsDict']] contextual_grounding_policy_config: Contextual grounding policy config for a guardrail. See Contextual Grounding Policy Config for more information.
        :param pulumi.Input[builtins.str] description: Description of the guardrail or its version.
        :param pulumi.Input[builtins.str] kms_key_arn: The KMS key with which the guardrail was encrypted at rest.
        :param pulumi.Input[builtins.str] name: Name of the guardrail.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['GuardrailSensitiveInformationPolicyConfigArgs', 'GuardrailSensitiveInformationPolicyConfigArgsDict']] sensitive_information_policy_config: Sensitive information policy config for a guardrail. See Sensitive Information Policy Config for more information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['GuardrailTopicPolicyConfigArgs', 'GuardrailTopicPolicyConfigArgsDict']] topic_policy_config: Topic policy config for a guardrail. See Topic Policy Config for more information.
        :param pulumi.Input[Union['GuardrailWordPolicyConfigArgs', 'GuardrailWordPolicyConfigArgsDict']] word_policy_config: Word policy config for a guardrail. See Word Policy Config for more information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GuardrailArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon Bedrock Guardrail.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.Guardrail("example",
            name="example",
            blocked_input_messaging="example",
            blocked_outputs_messaging="example",
            description="example",
            content_policy_config={
                "filters_configs": [{
                    "input_strength": "MEDIUM",
                    "output_strength": "MEDIUM",
                    "type": "HATE",
                }],
            },
            sensitive_information_policy_config={
                "pii_entities_configs": [{
                    "action": "BLOCK",
                    "type": "NAME",
                }],
                "regexes_configs": [{
                    "action": "BLOCK",
                    "description": "example regex",
                    "name": "regex_example",
                    "pattern": "^\\\\d{3}-\\\\d{2}-\\\\d{4}$",
                }],
            },
            topic_policy_config={
                "topics_configs": [{
                    "name": "investment_topic",
                    "examples": ["Where should I invest my money ?"],
                    "type": "DENY",
                    "definition": "Investment advice refers to inquiries, guidance, or recommendations regarding the management or allocation of funds or assets with the goal of generating returns .",
                }],
            },
            word_policy_config={
                "managed_word_lists_configs": [{
                    "type": "PROFANITY",
                }],
                "words_configs": [{
                    "text": "HATE",
                }],
            })
        ```

        ## Import

        Using `pulumi import`, import Amazon Bedrock Guardrail using using a comma-delimited string of `guardrail_id` and `version`. For example:

        ```sh
        $ pulumi import aws:bedrock/guardrail:Guardrail example guardrail-id-12345678,DRAFT
        ```

        :param str resource_name: The name of the resource.
        :param GuardrailArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GuardrailArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blocked_input_messaging: Optional[pulumi.Input[builtins.str]] = None,
                 blocked_outputs_messaging: Optional[pulumi.Input[builtins.str]] = None,
                 content_policy_config: Optional[pulumi.Input[Union['GuardrailContentPolicyConfigArgs', 'GuardrailContentPolicyConfigArgsDict']]] = None,
                 contextual_grounding_policy_config: Optional[pulumi.Input[Union['GuardrailContextualGroundingPolicyConfigArgs', 'GuardrailContextualGroundingPolicyConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_information_policy_config: Optional[pulumi.Input[Union['GuardrailSensitiveInformationPolicyConfigArgs', 'GuardrailSensitiveInformationPolicyConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['GuardrailTimeoutsArgs', 'GuardrailTimeoutsArgsDict']]] = None,
                 topic_policy_config: Optional[pulumi.Input[Union['GuardrailTopicPolicyConfigArgs', 'GuardrailTopicPolicyConfigArgsDict']]] = None,
                 word_policy_config: Optional[pulumi.Input[Union['GuardrailWordPolicyConfigArgs', 'GuardrailWordPolicyConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GuardrailArgs.__new__(GuardrailArgs)

            if blocked_input_messaging is None and not opts.urn:
                raise TypeError("Missing required property 'blocked_input_messaging'")
            __props__.__dict__["blocked_input_messaging"] = blocked_input_messaging
            if blocked_outputs_messaging is None and not opts.urn:
                raise TypeError("Missing required property 'blocked_outputs_messaging'")
            __props__.__dict__["blocked_outputs_messaging"] = blocked_outputs_messaging
            __props__.__dict__["content_policy_config"] = content_policy_config
            __props__.__dict__["contextual_grounding_policy_config"] = contextual_grounding_policy_config
            __props__.__dict__["description"] = description
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["sensitive_information_policy_config"] = sensitive_information_policy_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["topic_policy_config"] = topic_policy_config
            __props__.__dict__["word_policy_config"] = word_policy_config
            __props__.__dict__["created_at"] = None
            __props__.__dict__["guardrail_arn"] = None
            __props__.__dict__["guardrail_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["version"] = None
        super(Guardrail, __self__).__init__(
            'aws:bedrock/guardrail:Guardrail',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            blocked_input_messaging: Optional[pulumi.Input[builtins.str]] = None,
            blocked_outputs_messaging: Optional[pulumi.Input[builtins.str]] = None,
            content_policy_config: Optional[pulumi.Input[Union['GuardrailContentPolicyConfigArgs', 'GuardrailContentPolicyConfigArgsDict']]] = None,
            contextual_grounding_policy_config: Optional[pulumi.Input[Union['GuardrailContextualGroundingPolicyConfigArgs', 'GuardrailContextualGroundingPolicyConfigArgsDict']]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            guardrail_arn: Optional[pulumi.Input[builtins.str]] = None,
            guardrail_id: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            sensitive_information_policy_config: Optional[pulumi.Input[Union['GuardrailSensitiveInformationPolicyConfigArgs', 'GuardrailSensitiveInformationPolicyConfigArgsDict']]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['GuardrailTimeoutsArgs', 'GuardrailTimeoutsArgsDict']]] = None,
            topic_policy_config: Optional[pulumi.Input[Union['GuardrailTopicPolicyConfigArgs', 'GuardrailTopicPolicyConfigArgsDict']]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            word_policy_config: Optional[pulumi.Input[Union['GuardrailWordPolicyConfigArgs', 'GuardrailWordPolicyConfigArgsDict']]] = None) -> 'Guardrail':
        """
        Get an existing Guardrail resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] blocked_input_messaging: Message to return when the guardrail blocks a prompt.
        :param pulumi.Input[builtins.str] blocked_outputs_messaging: Message to return when the guardrail blocks a model response.
        :param pulumi.Input[Union['GuardrailContentPolicyConfigArgs', 'GuardrailContentPolicyConfigArgsDict']] content_policy_config: Content policy config for a guardrail. See Content Policy Config for more information.
        :param pulumi.Input[Union['GuardrailContextualGroundingPolicyConfigArgs', 'GuardrailContextualGroundingPolicyConfigArgsDict']] contextual_grounding_policy_config: Contextual grounding policy config for a guardrail. See Contextual Grounding Policy Config for more information.
        :param pulumi.Input[builtins.str] created_at: Unix epoch timestamp in seconds for when the Guardrail was created.
        :param pulumi.Input[builtins.str] description: Description of the guardrail or its version.
        :param pulumi.Input[builtins.str] guardrail_arn: ARN of the Guardrail.
        :param pulumi.Input[builtins.str] guardrail_id: ID of the Guardrail.
        :param pulumi.Input[builtins.str] kms_key_arn: The KMS key with which the guardrail was encrypted at rest.
        :param pulumi.Input[builtins.str] name: Name of the guardrail.
               
               The following arguments are optional:
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['GuardrailSensitiveInformationPolicyConfigArgs', 'GuardrailSensitiveInformationPolicyConfigArgsDict']] sensitive_information_policy_config: Sensitive information policy config for a guardrail. See Sensitive Information Policy Config for more information.
        :param pulumi.Input[builtins.str] status: Status of the Bedrock Guardrail. One of `READY`, `FAILED`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['GuardrailTopicPolicyConfigArgs', 'GuardrailTopicPolicyConfigArgsDict']] topic_policy_config: Topic policy config for a guardrail. See Topic Policy Config for more information.
        :param pulumi.Input[builtins.str] version: Version of the Guardrail.
        :param pulumi.Input[Union['GuardrailWordPolicyConfigArgs', 'GuardrailWordPolicyConfigArgsDict']] word_policy_config: Word policy config for a guardrail. See Word Policy Config for more information.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GuardrailState.__new__(_GuardrailState)

        __props__.__dict__["blocked_input_messaging"] = blocked_input_messaging
        __props__.__dict__["blocked_outputs_messaging"] = blocked_outputs_messaging
        __props__.__dict__["content_policy_config"] = content_policy_config
        __props__.__dict__["contextual_grounding_policy_config"] = contextual_grounding_policy_config
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["guardrail_arn"] = guardrail_arn
        __props__.__dict__["guardrail_id"] = guardrail_id
        __props__.__dict__["kms_key_arn"] = kms_key_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["sensitive_information_policy_config"] = sensitive_information_policy_config
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["topic_policy_config"] = topic_policy_config
        __props__.__dict__["version"] = version
        __props__.__dict__["word_policy_config"] = word_policy_config
        return Guardrail(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="blockedInputMessaging")
    def blocked_input_messaging(self) -> pulumi.Output[builtins.str]:
        """
        Message to return when the guardrail blocks a prompt.
        """
        return pulumi.get(self, "blocked_input_messaging")

    @property
    @pulumi.getter(name="blockedOutputsMessaging")
    def blocked_outputs_messaging(self) -> pulumi.Output[builtins.str]:
        """
        Message to return when the guardrail blocks a model response.
        """
        return pulumi.get(self, "blocked_outputs_messaging")

    @property
    @pulumi.getter(name="contentPolicyConfig")
    def content_policy_config(self) -> pulumi.Output[Optional['outputs.GuardrailContentPolicyConfig']]:
        """
        Content policy config for a guardrail. See Content Policy Config for more information.
        """
        return pulumi.get(self, "content_policy_config")

    @property
    @pulumi.getter(name="contextualGroundingPolicyConfig")
    def contextual_grounding_policy_config(self) -> pulumi.Output[Optional['outputs.GuardrailContextualGroundingPolicyConfig']]:
        """
        Contextual grounding policy config for a guardrail. See Contextual Grounding Policy Config for more information.
        """
        return pulumi.get(self, "contextual_grounding_policy_config")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Unix epoch timestamp in seconds for when the Guardrail was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the guardrail or its version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="guardrailArn")
    def guardrail_arn(self) -> pulumi.Output[builtins.str]:
        """
        ARN of the Guardrail.
        """
        return pulumi.get(self, "guardrail_arn")

    @property
    @pulumi.getter(name="guardrailId")
    def guardrail_id(self) -> pulumi.Output[builtins.str]:
        """
        ID of the Guardrail.
        """
        return pulumi.get(self, "guardrail_id")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The KMS key with which the guardrail was encrypted at rest.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the guardrail.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sensitiveInformationPolicyConfig")
    def sensitive_information_policy_config(self) -> pulumi.Output[Optional['outputs.GuardrailSensitiveInformationPolicyConfig']]:
        """
        Sensitive information policy config for a guardrail. See Sensitive Information Policy Config for more information.
        """
        return pulumi.get(self, "sensitive_information_policy_config")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the Bedrock Guardrail. One of `READY`, `FAILED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.GuardrailTimeouts']]:
        return pulumi.get(self, "timeouts")

    @property
    @pulumi.getter(name="topicPolicyConfig")
    def topic_policy_config(self) -> pulumi.Output[Optional['outputs.GuardrailTopicPolicyConfig']]:
        """
        Topic policy config for a guardrail. See Topic Policy Config for more information.
        """
        return pulumi.get(self, "topic_policy_config")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Version of the Guardrail.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="wordPolicyConfig")
    def word_policy_config(self) -> pulumi.Output[Optional['outputs.GuardrailWordPolicyConfig']]:
        """
        Word policy config for a guardrail. See Word Policy Config for more information.
        """
        return pulumi.get(self, "word_policy_config")

