# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MembershipArgs', 'Membership']

@pulumi.input_type
class MembershipArgs:
    def __init__(__self__, *,
                 collaboration_id: pulumi.Input[builtins.str],
                 query_log_status: pulumi.Input[builtins.str],
                 default_result_configuration: Optional[pulumi.Input['MembershipDefaultResultConfigurationArgs']] = None,
                 payment_configuration: Optional[pulumi.Input['MembershipPaymentConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Membership resource.
        :param pulumi.Input[builtins.str] collaboration_id: The ID of the collaboration to which the member was invited.
        :param pulumi.Input[builtins.str] query_log_status: An indicator as to whether query logging has been enabled or disabled for the membership.
        :param pulumi.Input['MembershipDefaultResultConfigurationArgs'] default_result_configuration: The default configuration for a query result.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key value pairs which tag the membership.
        """
        pulumi.set(__self__, "collaboration_id", collaboration_id)
        pulumi.set(__self__, "query_log_status", query_log_status)
        if default_result_configuration is not None:
            pulumi.set(__self__, "default_result_configuration", default_result_configuration)
        if payment_configuration is not None:
            pulumi.set(__self__, "payment_configuration", payment_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="collaborationId")
    def collaboration_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the collaboration to which the member was invited.
        """
        return pulumi.get(self, "collaboration_id")

    @collaboration_id.setter
    def collaboration_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "collaboration_id", value)

    @property
    @pulumi.getter(name="queryLogStatus")
    def query_log_status(self) -> pulumi.Input[builtins.str]:
        """
        An indicator as to whether query logging has been enabled or disabled for the membership.
        """
        return pulumi.get(self, "query_log_status")

    @query_log_status.setter
    def query_log_status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "query_log_status", value)

    @property
    @pulumi.getter(name="defaultResultConfiguration")
    def default_result_configuration(self) -> Optional[pulumi.Input['MembershipDefaultResultConfigurationArgs']]:
        """
        The default configuration for a query result.
        """
        return pulumi.get(self, "default_result_configuration")

    @default_result_configuration.setter
    def default_result_configuration(self, value: Optional[pulumi.Input['MembershipDefaultResultConfigurationArgs']]):
        pulumi.set(self, "default_result_configuration", value)

    @property
    @pulumi.getter(name="paymentConfiguration")
    def payment_configuration(self) -> Optional[pulumi.Input['MembershipPaymentConfigurationArgs']]:
        return pulumi.get(self, "payment_configuration")

    @payment_configuration.setter
    def payment_configuration(self, value: Optional[pulumi.Input['MembershipPaymentConfigurationArgs']]):
        pulumi.set(self, "payment_configuration", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key value pairs which tag the membership.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _MembershipState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[builtins.str]] = None,
                 collaboration_arn: Optional[pulumi.Input[builtins.str]] = None,
                 collaboration_creator_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 collaboration_creator_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 collaboration_id: Optional[pulumi.Input[builtins.str]] = None,
                 collaboration_name: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 default_result_configuration: Optional[pulumi.Input['MembershipDefaultResultConfigurationArgs']] = None,
                 member_abilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 payment_configuration: Optional[pulumi.Input['MembershipPaymentConfigurationArgs']] = None,
                 query_log_status: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Membership resources.
        :param pulumi.Input[builtins.str] arn: The ARN of the membership.
        :param pulumi.Input[builtins.str] collaboration_arn: The ARN of the joined collaboration.
        :param pulumi.Input[builtins.str] collaboration_creator_account_id: The account ID of the collaboration's creator.
        :param pulumi.Input[builtins.str] collaboration_creator_display_name: The display name of the collaboration's creator.
        :param pulumi.Input[builtins.str] collaboration_id: The ID of the collaboration to which the member was invited.
        :param pulumi.Input[builtins.str] collaboration_name: The name of the joined collaboration.
        :param pulumi.Input[builtins.str] create_time: The date and time the membership was created.
        :param pulumi.Input['MembershipDefaultResultConfigurationArgs'] default_result_configuration: The default configuration for a query result.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] member_abilities: The list of abilities for the invited member.
        :param pulumi.Input[builtins.str] query_log_status: An indicator as to whether query logging has been enabled or disabled for the membership.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] status: The status of the membership.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key value pairs which tag the membership.
        :param pulumi.Input[builtins.str] update_time: The date and time the membership was last updated.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if collaboration_arn is not None:
            pulumi.set(__self__, "collaboration_arn", collaboration_arn)
        if collaboration_creator_account_id is not None:
            pulumi.set(__self__, "collaboration_creator_account_id", collaboration_creator_account_id)
        if collaboration_creator_display_name is not None:
            pulumi.set(__self__, "collaboration_creator_display_name", collaboration_creator_display_name)
        if collaboration_id is not None:
            pulumi.set(__self__, "collaboration_id", collaboration_id)
        if collaboration_name is not None:
            pulumi.set(__self__, "collaboration_name", collaboration_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if default_result_configuration is not None:
            pulumi.set(__self__, "default_result_configuration", default_result_configuration)
        if member_abilities is not None:
            pulumi.set(__self__, "member_abilities", member_abilities)
        if payment_configuration is not None:
            pulumi.set(__self__, "payment_configuration", payment_configuration)
        if query_log_status is not None:
            pulumi.set(__self__, "query_log_status", query_log_status)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the membership.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="collaborationArn")
    def collaboration_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the joined collaboration.
        """
        return pulumi.get(self, "collaboration_arn")

    @collaboration_arn.setter
    def collaboration_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collaboration_arn", value)

    @property
    @pulumi.getter(name="collaborationCreatorAccountId")
    def collaboration_creator_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The account ID of the collaboration's creator.
        """
        return pulumi.get(self, "collaboration_creator_account_id")

    @collaboration_creator_account_id.setter
    def collaboration_creator_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collaboration_creator_account_id", value)

    @property
    @pulumi.getter(name="collaborationCreatorDisplayName")
    def collaboration_creator_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the collaboration's creator.
        """
        return pulumi.get(self, "collaboration_creator_display_name")

    @collaboration_creator_display_name.setter
    def collaboration_creator_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collaboration_creator_display_name", value)

    @property
    @pulumi.getter(name="collaborationId")
    def collaboration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the collaboration to which the member was invited.
        """
        return pulumi.get(self, "collaboration_id")

    @collaboration_id.setter
    def collaboration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collaboration_id", value)

    @property
    @pulumi.getter(name="collaborationName")
    def collaboration_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the joined collaboration.
        """
        return pulumi.get(self, "collaboration_name")

    @collaboration_name.setter
    def collaboration_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collaboration_name", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the membership was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="defaultResultConfiguration")
    def default_result_configuration(self) -> Optional[pulumi.Input['MembershipDefaultResultConfigurationArgs']]:
        """
        The default configuration for a query result.
        """
        return pulumi.get(self, "default_result_configuration")

    @default_result_configuration.setter
    def default_result_configuration(self, value: Optional[pulumi.Input['MembershipDefaultResultConfigurationArgs']]):
        pulumi.set(self, "default_result_configuration", value)

    @property
    @pulumi.getter(name="memberAbilities")
    def member_abilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of abilities for the invited member.
        """
        return pulumi.get(self, "member_abilities")

    @member_abilities.setter
    def member_abilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "member_abilities", value)

    @property
    @pulumi.getter(name="paymentConfiguration")
    def payment_configuration(self) -> Optional[pulumi.Input['MembershipPaymentConfigurationArgs']]:
        return pulumi.get(self, "payment_configuration")

    @payment_configuration.setter
    def payment_configuration(self, value: Optional[pulumi.Input['MembershipPaymentConfigurationArgs']]):
        pulumi.set(self, "payment_configuration", value)

    @property
    @pulumi.getter(name="queryLogStatus")
    def query_log_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An indicator as to whether query logging has been enabled or disabled for the membership.
        """
        return pulumi.get(self, "query_log_status")

    @query_log_status.setter
    def query_log_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query_log_status", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the membership.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key value pairs which tag the membership.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the membership was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("aws:cleanrooms/membership:Membership")
class Membership(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collaboration_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_result_configuration: Optional[pulumi.Input[Union['MembershipDefaultResultConfigurationArgs', 'MembershipDefaultResultConfigurationArgsDict']]] = None,
                 payment_configuration: Optional[pulumi.Input[Union['MembershipPaymentConfigurationArgs', 'MembershipPaymentConfigurationArgsDict']]] = None,
                 query_log_status: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a AWS Clean Rooms membership. Memberships are used to join a Clean Rooms collaboration by the invited member.

        ## Example Usage

        ### Membership with tags

        ```python
        import pulumi
        import pulumi_aws as aws

        test_membership = aws.cleanrooms.Membership("test_membership",
            collaboration_id="1234abcd-12ab-34cd-56ef-1234567890ab",
            query_log_status="DISABLED",
            default_result_configuration={
                "role_arn": "arn:aws:iam::123456789012:role/role-name",
                "output_configuration": {
                    "s3": {
                        "bucket": "test-bucket",
                        "result_format": "PARQUET",
                        "key_prefix": "test-prefix",
                    },
                },
            },
            tags={
                "Project": "Terraform",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_cleanrooms_membership` using the `id`. For example:

        ```sh
        $ pulumi import aws:cleanrooms/membership:Membership membership 1234abcd-12ab-34cd-56ef-1234567890ab
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] collaboration_id: The ID of the collaboration to which the member was invited.
        :param pulumi.Input[Union['MembershipDefaultResultConfigurationArgs', 'MembershipDefaultResultConfigurationArgsDict']] default_result_configuration: The default configuration for a query result.
        :param pulumi.Input[builtins.str] query_log_status: An indicator as to whether query logging has been enabled or disabled for the membership.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key value pairs which tag the membership.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MembershipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a AWS Clean Rooms membership. Memberships are used to join a Clean Rooms collaboration by the invited member.

        ## Example Usage

        ### Membership with tags

        ```python
        import pulumi
        import pulumi_aws as aws

        test_membership = aws.cleanrooms.Membership("test_membership",
            collaboration_id="1234abcd-12ab-34cd-56ef-1234567890ab",
            query_log_status="DISABLED",
            default_result_configuration={
                "role_arn": "arn:aws:iam::123456789012:role/role-name",
                "output_configuration": {
                    "s3": {
                        "bucket": "test-bucket",
                        "result_format": "PARQUET",
                        "key_prefix": "test-prefix",
                    },
                },
            },
            tags={
                "Project": "Terraform",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_cleanrooms_membership` using the `id`. For example:

        ```sh
        $ pulumi import aws:cleanrooms/membership:Membership membership 1234abcd-12ab-34cd-56ef-1234567890ab
        ```

        :param str resource_name: The name of the resource.
        :param MembershipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MembershipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collaboration_id: Optional[pulumi.Input[builtins.str]] = None,
                 default_result_configuration: Optional[pulumi.Input[Union['MembershipDefaultResultConfigurationArgs', 'MembershipDefaultResultConfigurationArgsDict']]] = None,
                 payment_configuration: Optional[pulumi.Input[Union['MembershipPaymentConfigurationArgs', 'MembershipPaymentConfigurationArgsDict']]] = None,
                 query_log_status: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MembershipArgs.__new__(MembershipArgs)

            if collaboration_id is None and not opts.urn:
                raise TypeError("Missing required property 'collaboration_id'")
            __props__.__dict__["collaboration_id"] = collaboration_id
            __props__.__dict__["default_result_configuration"] = default_result_configuration
            __props__.__dict__["payment_configuration"] = payment_configuration
            if query_log_status is None and not opts.urn:
                raise TypeError("Missing required property 'query_log_status'")
            __props__.__dict__["query_log_status"] = query_log_status
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["collaboration_arn"] = None
            __props__.__dict__["collaboration_creator_account_id"] = None
            __props__.__dict__["collaboration_creator_display_name"] = None
            __props__.__dict__["collaboration_name"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["member_abilities"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["update_time"] = None
        super(Membership, __self__).__init__(
            'aws:cleanrooms/membership:Membership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[builtins.str]] = None,
            collaboration_arn: Optional[pulumi.Input[builtins.str]] = None,
            collaboration_creator_account_id: Optional[pulumi.Input[builtins.str]] = None,
            collaboration_creator_display_name: Optional[pulumi.Input[builtins.str]] = None,
            collaboration_id: Optional[pulumi.Input[builtins.str]] = None,
            collaboration_name: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            default_result_configuration: Optional[pulumi.Input[Union['MembershipDefaultResultConfigurationArgs', 'MembershipDefaultResultConfigurationArgsDict']]] = None,
            member_abilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            payment_configuration: Optional[pulumi.Input[Union['MembershipPaymentConfigurationArgs', 'MembershipPaymentConfigurationArgsDict']]] = None,
            query_log_status: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Membership':
        """
        Get an existing Membership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arn: The ARN of the membership.
        :param pulumi.Input[builtins.str] collaboration_arn: The ARN of the joined collaboration.
        :param pulumi.Input[builtins.str] collaboration_creator_account_id: The account ID of the collaboration's creator.
        :param pulumi.Input[builtins.str] collaboration_creator_display_name: The display name of the collaboration's creator.
        :param pulumi.Input[builtins.str] collaboration_id: The ID of the collaboration to which the member was invited.
        :param pulumi.Input[builtins.str] collaboration_name: The name of the joined collaboration.
        :param pulumi.Input[builtins.str] create_time: The date and time the membership was created.
        :param pulumi.Input[Union['MembershipDefaultResultConfigurationArgs', 'MembershipDefaultResultConfigurationArgsDict']] default_result_configuration: The default configuration for a query result.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] member_abilities: The list of abilities for the invited member.
        :param pulumi.Input[builtins.str] query_log_status: An indicator as to whether query logging has been enabled or disabled for the membership.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[builtins.str] status: The status of the membership.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key value pairs which tag the membership.
        :param pulumi.Input[builtins.str] update_time: The date and time the membership was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MembershipState.__new__(_MembershipState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["collaboration_arn"] = collaboration_arn
        __props__.__dict__["collaboration_creator_account_id"] = collaboration_creator_account_id
        __props__.__dict__["collaboration_creator_display_name"] = collaboration_creator_display_name
        __props__.__dict__["collaboration_id"] = collaboration_id
        __props__.__dict__["collaboration_name"] = collaboration_name
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["default_result_configuration"] = default_result_configuration
        __props__.__dict__["member_abilities"] = member_abilities
        __props__.__dict__["payment_configuration"] = payment_configuration
        __props__.__dict__["query_log_status"] = query_log_status
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["update_time"] = update_time
        return Membership(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the membership.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="collaborationArn")
    def collaboration_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the joined collaboration.
        """
        return pulumi.get(self, "collaboration_arn")

    @property
    @pulumi.getter(name="collaborationCreatorAccountId")
    def collaboration_creator_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The account ID of the collaboration's creator.
        """
        return pulumi.get(self, "collaboration_creator_account_id")

    @property
    @pulumi.getter(name="collaborationCreatorDisplayName")
    def collaboration_creator_display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the collaboration's creator.
        """
        return pulumi.get(self, "collaboration_creator_display_name")

    @property
    @pulumi.getter(name="collaborationId")
    def collaboration_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the collaboration to which the member was invited.
        """
        return pulumi.get(self, "collaboration_id")

    @property
    @pulumi.getter(name="collaborationName")
    def collaboration_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the joined collaboration.
        """
        return pulumi.get(self, "collaboration_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the membership was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="defaultResultConfiguration")
    def default_result_configuration(self) -> pulumi.Output[Optional['outputs.MembershipDefaultResultConfiguration']]:
        """
        The default configuration for a query result.
        """
        return pulumi.get(self, "default_result_configuration")

    @property
    @pulumi.getter(name="memberAbilities")
    def member_abilities(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of abilities for the invited member.
        """
        return pulumi.get(self, "member_abilities")

    @property
    @pulumi.getter(name="paymentConfiguration")
    def payment_configuration(self) -> pulumi.Output[Optional['outputs.MembershipPaymentConfiguration']]:
        return pulumi.get(self, "payment_configuration")

    @property
    @pulumi.getter(name="queryLogStatus")
    def query_log_status(self) -> pulumi.Output[builtins.str]:
        """
        An indicator as to whether query logging has been enabled or disabled for the membership.
        """
        return pulumi.get(self, "query_log_status")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the membership.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key value pairs which tag the membership.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the membership was last updated.
        """
        return pulumi.get(self, "update_time")

