# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StackArgs', 'Stack']

@pulumi.input_type
class StackArgs:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 disable_rollback: Optional[pulumi.Input[builtins.bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 on_failure: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 policy_body: Optional[pulumi.Input[builtins.str]] = None,
                 policy_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template_body: Optional[pulumi.Input[builtins.str]] = None,
                 template_url: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a Stack resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] capabilities: A list of capabilities.
               Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
        :param pulumi.Input[builtins.bool] disable_rollback: Set to true to disable rollback of the stack if stack creation failed.
               Conflicts with `on_failure`.
        :param pulumi.Input[builtins.str] iam_role_arn: The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
        :param pulumi.Input[builtins.str] name: Stack name.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_arns: A list of SNS topic ARNs to publish stack related events.
        :param pulumi.Input[builtins.str] on_failure: Action to be taken if stack creation fails. This must be
               one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of Parameter structures that specify input parameters for the stack.
        :param pulumi.Input[builtins.str] policy_body: Structure containing the stack policy body.
               Conflicts w/ `policy_url`.
        :param pulumi.Input[builtins.str] policy_url: Location of a file containing the stack policy.
               Conflicts w/ `policy_body`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] template_body: Structure containing the template body (max size: 51,200 bytes).
        :param pulumi.Input[builtins.str] template_url: Location of a file containing the template body (max size: 460,800 bytes).
        :param pulumi.Input[builtins.int] timeout_in_minutes: The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if disable_rollback is not None:
            pulumi.set(__self__, "disable_rollback", disable_rollback)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_arns is not None:
            pulumi.set(__self__, "notification_arns", notification_arns)
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if policy_body is not None:
            pulumi.set(__self__, "policy_body", policy_body)
        if policy_url is not None:
            pulumi.set(__self__, "policy_url", policy_url)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_body is not None:
            pulumi.set(__self__, "template_body", template_body)
        if template_url is not None:
            pulumi.set(__self__, "template_url", template_url)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of capabilities.
        Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to disable rollback of the stack if stack creation failed.
        Conflicts with `on_failure`.
        """
        return pulumi.get(self, "disable_rollback")

    @disable_rollback.setter
    def disable_rollback(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_rollback", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Stack name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationArns")
    def notification_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of SNS topic ARNs to publish stack related events.
        """
        return pulumi.get(self, "notification_arns")

    @notification_arns.setter
    def notification_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "notification_arns", value)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Action to be taken if stack creation fails. This must be
        one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
        """
        return pulumi.get(self, "on_failure")

    @on_failure.setter
    def on_failure(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_failure", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of Parameter structures that specify input parameters for the stack.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="policyBody")
    def policy_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Structure containing the stack policy body.
        Conflicts w/ `policy_url`.
        """
        return pulumi.get(self, "policy_body")

    @policy_body.setter
    def policy_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_body", value)

    @property
    @pulumi.getter(name="policyUrl")
    def policy_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of a file containing the stack policy.
        Conflicts w/ `policy_body`.
        """
        return pulumi.get(self, "policy_url")

    @policy_url.setter
    def policy_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_url", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Structure containing the template body (max size: 51,200 bytes).
        """
        return pulumi.get(self, "template_body")

    @template_body.setter
    def template_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_body", value)

    @property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of a file containing the template body (max size: 460,800 bytes).
        """
        return pulumi.get(self, "template_url")

    @template_url.setter
    def template_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_url", value)

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
        """
        return pulumi.get(self, "timeout_in_minutes")

    @timeout_in_minutes.setter
    def timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_in_minutes", value)


@pulumi.input_type
class _StackState:
    def __init__(__self__, *,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 disable_rollback: Optional[pulumi.Input[builtins.bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 on_failure: Optional[pulumi.Input[builtins.str]] = None,
                 outputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 policy_body: Optional[pulumi.Input[builtins.str]] = None,
                 policy_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template_body: Optional[pulumi.Input[builtins.str]] = None,
                 template_url: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering Stack resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] capabilities: A list of capabilities.
               Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
        :param pulumi.Input[builtins.bool] disable_rollback: Set to true to disable rollback of the stack if stack creation failed.
               Conflicts with `on_failure`.
        :param pulumi.Input[builtins.str] iam_role_arn: The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
        :param pulumi.Input[builtins.str] name: Stack name.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_arns: A list of SNS topic ARNs to publish stack related events.
        :param pulumi.Input[builtins.str] on_failure: Action to be taken if stack creation fails. This must be
               one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] outputs: A map of outputs from the stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of Parameter structures that specify input parameters for the stack.
        :param pulumi.Input[builtins.str] policy_body: Structure containing the stack policy body.
               Conflicts w/ `policy_url`.
        :param pulumi.Input[builtins.str] policy_url: Location of a file containing the stack policy.
               Conflicts w/ `policy_body`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] template_body: Structure containing the template body (max size: 51,200 bytes).
        :param pulumi.Input[builtins.str] template_url: Location of a file containing the template body (max size: 460,800 bytes).
        :param pulumi.Input[builtins.int] timeout_in_minutes: The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if disable_rollback is not None:
            pulumi.set(__self__, "disable_rollback", disable_rollback)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_arns is not None:
            pulumi.set(__self__, "notification_arns", notification_arns)
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if policy_body is not None:
            pulumi.set(__self__, "policy_body", policy_body)
        if policy_url is not None:
            pulumi.set(__self__, "policy_url", policy_url)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if template_body is not None:
            pulumi.set(__self__, "template_body", template_body)
        if template_url is not None:
            pulumi.set(__self__, "template_url", template_url)
        if timeout_in_minutes is not None:
            pulumi.set(__self__, "timeout_in_minutes", timeout_in_minutes)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of capabilities.
        Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true to disable rollback of the stack if stack creation failed.
        Conflicts with `on_failure`.
        """
        return pulumi.get(self, "disable_rollback")

    @disable_rollback.setter
    def disable_rollback(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disable_rollback", value)

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Stack name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationArns")
    def notification_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of SNS topic ARNs to publish stack related events.
        """
        return pulumi.get(self, "notification_arns")

    @notification_arns.setter
    def notification_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "notification_arns", value)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Action to be taken if stack creation fails. This must be
        one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
        """
        return pulumi.get(self, "on_failure")

    @on_failure.setter
    def on_failure(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_failure", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of outputs from the stack.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of Parameter structures that specify input parameters for the stack.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="policyBody")
    def policy_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Structure containing the stack policy body.
        Conflicts w/ `policy_url`.
        """
        return pulumi.get(self, "policy_body")

    @policy_body.setter
    def policy_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_body", value)

    @property
    @pulumi.getter(name="policyUrl")
    def policy_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of a file containing the stack policy.
        Conflicts w/ `policy_body`.
        """
        return pulumi.get(self, "policy_url")

    @policy_url.setter
    def policy_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_url", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Structure containing the template body (max size: 51,200 bytes).
        """
        return pulumi.get(self, "template_body")

    @template_body.setter
    def template_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_body", value)

    @property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of a file containing the template body (max size: 460,800 bytes).
        """
        return pulumi.get(self, "template_url")

    @template_url.setter
    def template_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_url", value)

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
        """
        return pulumi.get(self, "timeout_in_minutes")

    @timeout_in_minutes.setter
    def timeout_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_in_minutes", value)


@pulumi.type_token("aws:cloudformation/stack:Stack")
class Stack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 disable_rollback: Optional[pulumi.Input[builtins.bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 on_failure: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 policy_body: Optional[pulumi.Input[builtins.str]] = None,
                 policy_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template_body: Optional[pulumi.Input[builtins.str]] = None,
                 template_url: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Provides a CloudFormation Stack resource.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        network = aws.cloudformation.Stack("network",
            name="networking-stack",
            parameters={
                "VPCCidr": "10.0.0.0/16",
            },
            template_body=json.dumps({
                "Parameters": {
                    "VPCCidr": {
                        "Type": "String",
                        "Default": "10.0.0.0/16",
                        "Description": "Enter the CIDR block for the VPC. Default is 10.0.0.0/16.",
                    },
                },
                "Resources": {
                    "myVpc": {
                        "Type": "AWS::EC2::VPC",
                        "Properties": {
                            "CidrBlock": {
                                "Ref": "VPCCidr",
                            },
                            "Tags": [{
                                "Key": "Name",
                                "Value": "Primary_CF_VPC",
                            }],
                        },
                    },
                },
            }))
        ```

        ## Import

        Using `pulumi import`, import Cloudformation Stacks using the `name`. For example:

        ```sh
        $ pulumi import aws:cloudformation/stack:Stack stack networking-stack
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] capabilities: A list of capabilities.
               Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
        :param pulumi.Input[builtins.bool] disable_rollback: Set to true to disable rollback of the stack if stack creation failed.
               Conflicts with `on_failure`.
        :param pulumi.Input[builtins.str] iam_role_arn: The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
        :param pulumi.Input[builtins.str] name: Stack name.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_arns: A list of SNS topic ARNs to publish stack related events.
        :param pulumi.Input[builtins.str] on_failure: Action to be taken if stack creation fails. This must be
               one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of Parameter structures that specify input parameters for the stack.
        :param pulumi.Input[builtins.str] policy_body: Structure containing the stack policy body.
               Conflicts w/ `policy_url`.
        :param pulumi.Input[builtins.str] policy_url: Location of a file containing the stack policy.
               Conflicts w/ `policy_body`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[builtins.str] template_body: Structure containing the template body (max size: 51,200 bytes).
        :param pulumi.Input[builtins.str] template_url: Location of a file containing the template body (max size: 460,800 bytes).
        :param pulumi.Input[builtins.int] timeout_in_minutes: The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[StackArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudFormation Stack resource.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        network = aws.cloudformation.Stack("network",
            name="networking-stack",
            parameters={
                "VPCCidr": "10.0.0.0/16",
            },
            template_body=json.dumps({
                "Parameters": {
                    "VPCCidr": {
                        "Type": "String",
                        "Default": "10.0.0.0/16",
                        "Description": "Enter the CIDR block for the VPC. Default is 10.0.0.0/16.",
                    },
                },
                "Resources": {
                    "myVpc": {
                        "Type": "AWS::EC2::VPC",
                        "Properties": {
                            "CidrBlock": {
                                "Ref": "VPCCidr",
                            },
                            "Tags": [{
                                "Key": "Name",
                                "Value": "Primary_CF_VPC",
                            }],
                        },
                    },
                },
            }))
        ```

        ## Import

        Using `pulumi import`, import Cloudformation Stacks using the `name`. For example:

        ```sh
        $ pulumi import aws:cloudformation/stack:Stack stack networking-stack
        ```

        :param str resource_name: The name of the resource.
        :param StackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 disable_rollback: Optional[pulumi.Input[builtins.bool]] = None,
                 iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 on_failure: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 policy_body: Optional[pulumi.Input[builtins.str]] = None,
                 policy_url: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template_body: Optional[pulumi.Input[builtins.str]] = None,
                 template_url: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackArgs.__new__(StackArgs)

            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["disable_rollback"] = disable_rollback
            __props__.__dict__["iam_role_arn"] = iam_role_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_arns"] = notification_arns
            __props__.__dict__["on_failure"] = on_failure
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["policy_body"] = policy_body
            __props__.__dict__["policy_url"] = policy_url
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_body"] = template_body
            __props__.__dict__["template_url"] = template_url
            __props__.__dict__["timeout_in_minutes"] = timeout_in_minutes
            __props__.__dict__["outputs"] = None
            __props__.__dict__["tags_all"] = None
        super(Stack, __self__).__init__(
            'aws:cloudformation/stack:Stack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            disable_rollback: Optional[pulumi.Input[builtins.bool]] = None,
            iam_role_arn: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            notification_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            on_failure: Optional[pulumi.Input[builtins.str]] = None,
            outputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            policy_body: Optional[pulumi.Input[builtins.str]] = None,
            policy_url: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            template_body: Optional[pulumi.Input[builtins.str]] = None,
            template_url: Optional[pulumi.Input[builtins.str]] = None,
            timeout_in_minutes: Optional[pulumi.Input[builtins.int]] = None) -> 'Stack':
        """
        Get an existing Stack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] capabilities: A list of capabilities.
               Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
        :param pulumi.Input[builtins.bool] disable_rollback: Set to true to disable rollback of the stack if stack creation failed.
               Conflicts with `on_failure`.
        :param pulumi.Input[builtins.str] iam_role_arn: The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
        :param pulumi.Input[builtins.str] name: Stack name.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] notification_arns: A list of SNS topic ARNs to publish stack related events.
        :param pulumi.Input[builtins.str] on_failure: Action to be taken if stack creation fails. This must be
               one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] outputs: A map of outputs from the stack.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of Parameter structures that specify input parameters for the stack.
        :param pulumi.Input[builtins.str] policy_body: Structure containing the stack policy body.
               Conflicts w/ `policy_url`.
        :param pulumi.Input[builtins.str] policy_url: Location of a file containing the stack policy.
               Conflicts w/ `policy_body`.
        :param pulumi.Input[builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[builtins.str] template_body: Structure containing the template body (max size: 51,200 bytes).
        :param pulumi.Input[builtins.str] template_url: Location of a file containing the template body (max size: 460,800 bytes).
        :param pulumi.Input[builtins.int] timeout_in_minutes: The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StackState.__new__(_StackState)

        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["disable_rollback"] = disable_rollback
        __props__.__dict__["iam_role_arn"] = iam_role_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_arns"] = notification_arns
        __props__.__dict__["on_failure"] = on_failure
        __props__.__dict__["outputs"] = outputs
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["policy_body"] = policy_body
        __props__.__dict__["policy_url"] = policy_url
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["template_body"] = template_body
        __props__.__dict__["template_url"] = template_url
        __props__.__dict__["timeout_in_minutes"] = timeout_in_minutes
        return Stack(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of capabilities.
        Valid values: `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, or `CAPABILITY_AUTO_EXPAND`
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="disableRollback")
    def disable_rollback(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set to true to disable rollback of the stack if stack creation failed.
        Conflicts with `on_failure`.
        """
        return pulumi.get(self, "disable_rollback")

    @property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of an IAM role that AWS CloudFormation assumes to create the stack. If you don't specify a value, AWS CloudFormation uses the role that was previously associated with the stack. If no role is available, AWS CloudFormation uses a temporary session that is generated from your user credentials.
        """
        return pulumi.get(self, "iam_role_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Stack name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationArns")
    def notification_arns(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of SNS topic ARNs to publish stack related events.
        """
        return pulumi.get(self, "notification_arns")

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Action to be taken if stack creation fails. This must be
        one of: `DO_NOTHING`, `ROLLBACK`, or `DELETE`. Conflicts with `disable_rollback`.
        """
        return pulumi.get(self, "on_failure")

    @property
    @pulumi.getter
    def outputs(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of outputs from the stack.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of Parameter structures that specify input parameters for the stack.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="policyBody")
    def policy_body(self) -> pulumi.Output[builtins.str]:
        """
        Structure containing the stack policy body.
        Conflicts w/ `policy_url`.
        """
        return pulumi.get(self, "policy_body")

    @property
    @pulumi.getter(name="policyUrl")
    def policy_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Location of a file containing the stack policy.
        Conflicts w/ `policy_body`.
        """
        return pulumi.get(self, "policy_url")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of resource tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @property
    @pulumi.getter(name="templateBody")
    def template_body(self) -> pulumi.Output[builtins.str]:
        """
        Structure containing the template body (max size: 51,200 bytes).
        """
        return pulumi.get(self, "template_body")

    @property
    @pulumi.getter(name="templateUrl")
    def template_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Location of a file containing the template body (max size: 460,800 bytes).
        """
        return pulumi.get(self, "template_url")

    @property
    @pulumi.getter(name="timeoutInMinutes")
    def timeout_in_minutes(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The amount of time that can pass before the stack status becomes `CREATE_FAILED`.
        """
        return pulumi.get(self, "timeout_in_minutes")

